/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.mac.MacButtonListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MacButtonUI
extends BasicButtonUI {
    private static final MacButtonUI metalButtonUI = new MacButtonUI();
    private boolean defaults_initialized = false;
    protected Color selectColor;
    protected Color selectTextColor;
    protected Color disabledTextColor;

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new MacButtonListener(abstractButton);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return metalButtonUI;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getSelectTextColor() {
        return this.selectTextColor;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.selectColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "select");
            this.selectTextColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "selectText");
            this.disabledTextColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "disabledText");
            this.defaults_initialized = true;
        }
        abstractButton.setOpaque(false);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(jComponent.getBackground());
            if (((JButton)abstractButton).isDefaultCapable()) {
                graphics.fillRect(4, 4, dimension.width - 8, dimension.height - 8);
            } else {
                graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            if (((JButton)abstractButton).isDefaultCapable()) {
                graphics.fillRect(4, 4, dimension.width - 8, dimension.height - 8);
            } else {
                graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
            }
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = -1;
        if (buttonModel.isEnabled()) {
            if (buttonModel.isPressed() && buttonModel.isArmed()) {
                graphics.setColor(this.getSelectTextColor());
                BasicGraphicsUtils.drawString(graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawString(graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
            }
        } else {
            graphics.setColor(this.getDisabledTextColor());
            BasicGraphicsUtils.drawString(graphics, string, -1, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }
}

