/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls.keyexchange;

import anon.crypto.IMyPrivateKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.MyRSASignature;
import anon.crypto.tinytls.TLSException;
import anon.crypto.tinytls.keyexchange.Key_Exchange;
import anon.crypto.tinytls.util.PRF;
import anon.crypto.tinytls.util.hash;
import anon.util.ByteArrayUtil;
import java.math.BigInteger;
import java.security.SecureRandom;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHE_RSA_Key_Exchange
extends Key_Exchange {
    private static final int MAXKEYMATERIALLENGTH = 104;
    private static final byte[] CLIENTFINISHEDLABEL = "client finished".getBytes();
    private static final byte[] SERVERFINISHEDLABEL = "server finished".getBytes();
    private static final byte[] KEYEXPANSION = "key expansion".getBytes();
    private static final byte[] MASTERSECRET = "master secret".getBytes();
    private static final BigInteger SAFEPRIME = new BigInteger("00FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    private static final DHParameters DH_PARAMS = new DHParameters(SAFEPRIME, new BigInteger("2"));
    private DHParameters m_dhparams;
    private DHPublicKeyParameters m_dhserverpub;
    private byte[] m_premastersecret;
    private byte[] m_mastersecret;
    private byte[] m_clientrandom;
    private byte[] m_serverrandom;
    private DHBasicAgreement m_dhe = null;

    public byte[] generateServerKeyExchange(IMyPrivateKey iMyPrivateKey, byte[] byArray, byte[] byArray2) throws TLSException {
        byte[] byArray3;
        if (!(iMyPrivateKey instanceof MyRSAPrivateKey)) {
            throw new TLSException("wrong key type (cannot cast to MyRSAPrivateKey)");
        }
        MyRSAPrivateKey myRSAPrivateKey = (MyRSAPrivateKey)iMyPrivateKey;
        this.m_clientrandom = byArray;
        this.m_serverrandom = byArray2;
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), DH_PARAMS);
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(dHKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        this.m_dhe = new DHBasicAgreement();
        this.m_dhe.init(dHPrivateKeyParameters);
        byte[] byArray4 = dHPublicKeyParameters.getParameters().getP().toByteArray();
        byArray4 = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(byArray4.length, 2), byArray4);
        byte[] byArray5 = dHPublicKeyParameters.getParameters().getG().toByteArray();
        byArray5 = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(byArray5.length, 2), byArray5);
        byte[] byArray6 = dHPublicKeyParameters.getY().toByteArray();
        byArray6 = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(byArray6.length, 2), byArray6);
        byte[] byArray7 = ByteArrayUtil.conc(byArray4, byArray5, byArray6);
        byte[] byArray8 = ByteArrayUtil.conc(hash.md5(byArray, byArray2, byArray7), hash.sha(byArray, byArray2, byArray7));
        MyRSASignature myRSASignature = new MyRSASignature();
        try {
            myRSASignature.initSign(myRSAPrivateKey);
            byArray3 = myRSASignature.signPlain(byArray8);
        }
        catch (Exception exception) {
            throw new TLSException("cannot encrypt signature", 2, 80);
        }
        byArray7 = ByteArrayUtil.conc(byArray7, ByteArrayUtil.inttobyte(byArray3.length, 2), byArray3);
        return byArray7;
    }

    public void processServerKeyExchange(byte[] byArray, int n, int n2, byte[] byArray2, byte[] byArray3, JAPCertificate jAPCertificate) throws TLSException {
        this.m_clientrandom = byArray2;
        this.m_serverrandom = byArray3;
        int n3 = 0;
        byte[] byArray4 = ByteArrayUtil.copy(byArray, n3 + n, 2);
        int n4 = (byArray4[0] & 0xFF) << 8 | byArray4[1] & 0xFF;
        byte[] byArray5 = ByteArrayUtil.copy(byArray, (n3 += 2) + n, n4);
        BigInteger bigInteger = new BigInteger(1, byArray5);
        LogHolder.log(7, LogType.MISC, "[SERVER_KEY_EXCHANGE] DH_P = " + bigInteger.toString());
        byArray4 = ByteArrayUtil.copy(byArray, (n3 += n4) + n, 2);
        n4 = (byArray4[0] & 0xFF) << 8 | byArray4[1] & 0xFF;
        byArray5 = ByteArrayUtil.copy(byArray, (n3 += 2) + n, n4);
        BigInteger bigInteger2 = new BigInteger(1, byArray5);
        LogHolder.log(7, LogType.MISC, "[SERVER_KEY_EXCHANGE] DH_G = " + bigInteger2.toString());
        byArray4 = ByteArrayUtil.copy(byArray, (n3 += n4) + n, 2);
        n4 = (byArray4[0] & 0xFF) << 8 | byArray4[1] & 0xFF;
        byArray5 = ByteArrayUtil.copy(byArray, (n3 += 2) + n, n4);
        BigInteger bigInteger3 = new BigInteger(1, byArray5);
        LogHolder.log(7, LogType.MISC, "[SERVER_KEY_EXCHANGE] DH_Ys = " + bigInteger3.toString());
        this.m_dhparams = new DHParameters(bigInteger, bigInteger2);
        this.m_dhserverpub = new DHPublicKeyParameters(bigInteger3, this.m_dhparams);
        byte[] byArray6 = ByteArrayUtil.copy(byArray, 0 + n, n3 += n4);
        byte[] byArray7 = ByteArrayUtil.conc(hash.md5(byArray2, byArray3, byArray6), hash.sha(byArray2, byArray3, byArray6));
        try {
            MyRSASignature myRSASignature = new MyRSASignature();
            myRSASignature.initVerify(jAPCertificate.getPublicKey());
            byte[] byArray8 = ByteArrayUtil.copy(byArray, n3 + 2 + n, n2 - n3 - 2);
            if (!myRSASignature.verifyPlain(byArray7, byArray8)) {
                throw new TLSException("wrong Signature", 2, 21);
            }
        }
        catch (Exception exception) {
            throw new TLSException("Cannot decode Signature", 1, 0);
        }
        LogHolder.log(7, LogType.MISC, "[SERVER_KEY_EXCHANGE] Signature ok");
    }

    public byte[] calculateServerFinished(byte[] byArray) {
        PRF pRF = new PRF(this.m_mastersecret, SERVERFINISHEDLABEL, ByteArrayUtil.conc(hash.md5(byArray), hash.sha(byArray)));
        return pRF.calculate(12);
    }

    public void processServerFinished(byte[] byArray, int n, byte[] byArray2) throws TLSException {
        PRF pRF = new PRF(this.m_mastersecret, SERVERFINISHEDLABEL, ByteArrayUtil.conc(hash.md5(byArray2), hash.sha(byArray2)));
        byte[] byArray3 = pRF.calculate(12);
        if (byArray[0] == 20 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 12) {
            for (int i = 0; i < byArray3.length; ++i) {
                if (byArray3[i] == byArray[i + 4]) continue;
                throw new TLSException("wrong Server Finished message recieved", 2, 20);
            }
            return;
        }
        throw new TLSException("wrong Server Finished message recieved", 2, 10);
    }

    public void processClientKeyExchange(BigInteger bigInteger) {
        DHPublicKeyParameters dHPublicKeyParameters = new DHPublicKeyParameters(bigInteger, DH_PARAMS);
        this.m_premastersecret = this.m_dhe.calculateAgreement(dHPublicKeyParameters).toByteArray();
        if (this.m_premastersecret[0] == 0) {
            this.m_premastersecret = ByteArrayUtil.copy(this.m_premastersecret, 1, this.m_premastersecret.length - 1);
        }
        PRF pRF = new PRF(this.m_premastersecret, MASTERSECRET, ByteArrayUtil.conc(this.m_clientrandom, this.m_serverrandom));
        this.m_mastersecret = pRF.calculate(48);
        this.m_premastersecret = null;
    }

    public byte[] calculateClientKeyExchange() throws TLSException {
        DHKeyGenerationParameters dHKeyGenerationParameters = new DHKeyGenerationParameters(new SecureRandom(), this.m_dhparams);
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(dHKeyGenerationParameters);
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        DHPublicKeyParameters dHPublicKeyParameters = (DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        DHPrivateKeyParameters dHPrivateKeyParameters = (DHPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init(dHPrivateKeyParameters);
        this.m_premastersecret = dHBasicAgreement.calculateAgreement(this.m_dhserverpub).toByteArray();
        if (this.m_premastersecret[0] == 0) {
            this.m_premastersecret = ByteArrayUtil.copy(this.m_premastersecret, 1, this.m_premastersecret.length - 1);
        }
        PRF pRF = new PRF(this.m_premastersecret, MASTERSECRET, ByteArrayUtil.conc(this.m_clientrandom, this.m_serverrandom));
        this.m_mastersecret = pRF.calculate(48);
        this.m_premastersecret = null;
        return dHPublicKeyParameters.getY().toByteArray();
    }

    public void processClientFinished(byte[] byArray, byte[] byArray2) throws TLSException {
        PRF pRF = new PRF(this.m_mastersecret, CLIENTFINISHEDLABEL, ByteArrayUtil.conc(hash.md5(byArray2), hash.sha(byArray2)));
    }

    public byte[] calculateClientFinished(byte[] byArray) throws TLSException {
        PRF pRF = new PRF(this.m_mastersecret, CLIENTFINISHEDLABEL, ByteArrayUtil.conc(hash.md5(byArray), hash.sha(byArray)));
        return pRF.calculate(12);
    }

    public byte[] calculateKeys() {
        PRF pRF = new PRF(this.m_mastersecret, KEYEXPANSION, ByteArrayUtil.conc(this.m_serverrandom, this.m_clientrandom));
        return pRF.calculate(104);
    }
}

