/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.parser.AttributeListEx;
import com.sun.xml.tree.AttributeNode;
import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeBase;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWritable;
import com.sun.xml.tree.XmlWriteContext;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;

final class AttributeSet
implements NamedNodeMap,
XmlWritable {
    private boolean readonly;
    private Vector list;
    private ElementNode nameScope;

    AttributeSet(ElementNode elementNode) {
        this.list = new Vector(5);
        this.nameScope = elementNode;
    }

    AttributeSet(AttributeSet attributeSet, boolean bl) {
        int n = attributeSet.getLength();
        this.list = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Node node = attributeSet.item(n2);
            if (!(node instanceof AttributeNode)) {
                throw new IllegalArgumentException(((NodeBase)node).getMessage("A-003"));
            }
            node = node.cloneNode(bl);
            ((AttributeNode)node).setNameScope(null);
            this.list.addElement(node);
            ++n2;
        }
    }

    AttributeSet(AttributeList attributeList) throws DOMException {
        int n = attributeList.getLength();
        AttributeListEx attributeListEx = null;
        this.list = new Vector(n);
        if (attributeList instanceof AttributeListEx) {
            attributeListEx = (AttributeListEx)attributeList;
        }
        int n2 = 0;
        while (n2 < n) {
            this.list.addElement(new AttributeNode(attributeList.getName(n2), attributeList.getValue(n2), attributeListEx == null ? true : attributeListEx.isSpecified(n2), attributeListEx == null ? null : attributeListEx.getDefault(n2)));
            ++n2;
        }
        this.list.trimToSize();
    }

    void trimToSize() {
        this.list.trimToSize();
    }

    public void setReadonly() {
        this.readonly = true;
        int n = 0;
        while (n < this.list.size()) {
            ((AttributeNode)this.list.elementAt(n)).setReadonly(true);
            ++n;
        }
    }

    public boolean isReadonly() {
        if (this.readonly) {
            return true;
        }
        int n = 0;
        while (n < this.list.size()) {
            if (((AttributeNode)this.list.elementAt(n)).isReadonly()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setNameScope(ElementNode elementNode) {
        if (elementNode != null && this.nameScope != null) {
            throw new IllegalStateException(elementNode.getMessage("A-004"));
        }
        this.nameScope = elementNode;
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n2);
            attributeNode.setNameScope(null);
            attributeNode.setNameScope(elementNode);
            ++n2;
        }
    }

    ElementNode getNameScope() {
        return this.nameScope;
    }

    String getValue(String string) {
        Attr attr = (Attr)this.getNamedItem(string);
        if (attr == null) {
            return "";
        }
        return attr.getValue();
    }

    public Node getNamedItem(String string) {
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            Node node = this.item(n2);
            if (node.getNodeName().equals(string)) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public int getLength() {
        return this.list.size();
    }

    public Node item(int n) {
        if (n < 0 || n >= this.list.size()) {
            return null;
        }
        return (Node)this.list.elementAt(n);
    }

    public Node removeNamedItem(String string) throws DOMException {
        int n = this.list.size();
        if (this.readonly) {
            throw new DomEx(7);
        }
        int n2 = 0;
        while (n2 < n) {
            Node node = this.item(n2);
            if (node.getNodeName().equals(string)) {
                AttributeNode attributeNode = (AttributeNode)node;
                if (attributeNode.getDefaultValue() != null) {
                    attributeNode = new AttributeNode(attributeNode);
                    attributeNode.setOwnerDocument((XmlDocument)this.nameScope.getOwnerDocument());
                    this.list.setElementAt(attributeNode, n2);
                } else {
                    this.list.removeElementAt(n2);
                }
                attributeNode.setNameScope(null);
                return node;
            }
            ++n2;
        }
        throw new DomEx(8);
    }

    public Node setNamedItem(Node node) throws DOMException {
        if (this.readonly) {
            throw new DomEx(7);
        }
        if (!(node instanceof AttributeNode) || node.getOwnerDocument() != this.nameScope.getOwnerDocument()) {
            throw new DomEx(4);
        }
        AttributeNode attributeNode = (AttributeNode)node;
        if (attributeNode.getNameScope() != null) {
            throw new DomEx(10);
        }
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode2 = (AttributeNode)this.item(n2);
            if (attributeNode2.getNodeName().equals(node.getNodeName())) {
                if (attributeNode2.isReadonly()) {
                    throw new DomEx(7);
                }
                attributeNode.setNameScope(this.nameScope);
                this.list.setElementAt(node, n2);
                attributeNode2.setNameScope(null);
                return attributeNode2;
            }
            ++n2;
        }
        attributeNode.setNameScope(this.nameScope);
        this.list.addElement(node);
        return null;
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        Writer writer = xmlWriteContext.getWriter();
        int n = this.list.size();
        int n2 = 0;
        while (n2 < n) {
            AttributeNode attributeNode = (AttributeNode)this.list.elementAt(n2);
            if (attributeNode.getSpecified()) {
                writer.write(32);
                attributeNode.writeXml(xmlWriteContext);
            }
            ++n2;
        }
    }

    public void writeChildrenXml(XmlWriteContext xmlWriteContext) throws IOException {
    }

    public String toString() {
        try {
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            XmlWriteContext xmlWriteContext = new XmlWriteContext(charArrayWriter);
            this.writeXml(xmlWriteContext);
            return charArrayWriter.toString();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }
}

