/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationInfo;
import HTTPClient.CIHashtable;
import HTTPClient.Codecs;
import HTTPClient.EstablishConnection;
import HTTPClient.ExtByteArrayOutputStream;
import HTTPClient.ForbiddenIOException;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPClientModuleConstants;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpHeaderElement;
import HTTPClient.HttpOutputStream;
import HTTPClient.IdempotentSequence;
import HTTPClient.LinkedList;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.ProtocolNotSuppException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.SocksClient;
import HTTPClient.SocksException;
import HTTPClient.StreamDemultiplexor;
import HTTPClient.ThreadInterruptedIOException;
import HTTPClient.URI;
import HTTPClient.Util;
import java.applet.Applet;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Vector;

public class HTTPConnection
implements GlobalConstants,
HTTPClientModuleConstants {
    public static final String version = "RPT-HTTPClient/0.4-dev";
    private static final Object dflt_context;
    private Object Context = null;
    private int Protocol;
    int ServerProtocolVersion;
    boolean ServProtVersKnown;
    private String RequestProtocolVersion;
    private static boolean force_1_0;
    private String Host;
    private int Port;
    private String Proxy_Host = null;
    private int Proxy_Port;
    private static String Default_Proxy_Host;
    private static int Default_Proxy_Port;
    private static CIHashtable non_proxy_host_list;
    private static Vector non_proxy_dom_list;
    private static Vector non_proxy_addr_list;
    private static Vector non_proxy_mask_list;
    private String Tunnel_Host = null;
    private int Tunnel_Port;
    private static String Default_Tunnel_Host;
    private static int Default_Tunnel_Port;
    private SocksClient Socks_client = null;
    private static SocksClient Default_Socks_client;
    private StreamDemultiplexor input_demux = null;
    LinkedList DemuxList = new LinkedList();
    private LinkedList RequestList = new LinkedList();
    private boolean DoesKeepAlive = false;
    private boolean KeepAliveUnknown = true;
    private int KeepAliveReqMax = -1;
    private int KeepAliveReqLeft;
    private static boolean NeverPipeline;
    private static boolean disable_nagle;
    private static int DefaultTimeout;
    private int Timeout;
    private NVPair[] DefaultHeaders = new NVPair[0];
    private static Vector DefaultModuleList;
    private Vector ModuleList;
    private static boolean DefaultAllowUI;
    private boolean AllowUI;
    private Response early_stall = null;
    private Response late_stall = null;
    private Response prev_resp = null;
    private boolean output_finished = true;

    public HTTPConnection(Applet applet) throws ProtocolNotSuppException {
        this(applet.getCodeBase().getProtocol(), applet.getCodeBase().getHost(), applet.getCodeBase().getPort());
    }

    public HTTPConnection(String host) {
        this.Setup(0, host, 80);
    }

    public HTTPConnection(String host, int port) {
        this.Setup(0, host, port);
    }

    public HTTPConnection(String prot, String host, int port) throws ProtocolNotSuppException {
        prot = prot.trim();
        if (!prot.equalsIgnoreCase("http")) {
            throw new ProtocolNotSuppException("Unsupported protocol '" + prot + "'");
        }
        if (prot.equalsIgnoreCase("http")) {
            this.Setup(0, host, port);
        } else if (prot.equalsIgnoreCase("https")) {
            this.Setup(1, host, port);
        } else if (prot.equalsIgnoreCase("shttp")) {
            this.Setup(2, host, port);
        } else if (prot.equalsIgnoreCase("http-ng")) {
            this.Setup(3, host, port);
        }
    }

    public HTTPConnection(URL url) throws ProtocolNotSuppException {
        this(url.getProtocol(), url.getHost(), url.getPort());
    }

    public HTTPConnection(URI uri) throws ProtocolNotSuppException {
        this(uri.getScheme(), uri.getHost(), uri.getPort());
    }

    private void Setup(int prot, String host, int port) {
        this.Protocol = prot;
        this.Host = host.trim().toLowerCase();
        this.Port = port;
        if (this.Port == -1) {
            this.Port = URI.defaultPort(this.getProtocol());
        }
        if (Default_Proxy_Host != null && !this.matchNonProxy(host)) {
            this.setCurrentProxy(Default_Proxy_Host, Default_Proxy_Port);
        } else {
            this.setCurrentProxy(null, 0);
        }
        this.Socks_client = Default_Socks_client;
        this.Tunnel_Host = Default_Tunnel_Host;
        this.Tunnel_Port = Default_Tunnel_Port;
        this.Timeout = DefaultTimeout;
        this.ModuleList = (Vector)DefaultModuleList.clone();
        this.AllowUI = DefaultAllowUI;
    }

    private boolean matchNonProxy(String host) {
        InetAddress[] host_addr;
        if (non_proxy_host_list.get(host) != null) {
            return true;
        }
        for (int idx = 0; idx < non_proxy_dom_list.size(); ++idx) {
            if (!host.endsWith((String)non_proxy_dom_list.elementAt(idx))) continue;
            return true;
        }
        if (non_proxy_addr_list.size() == 0) {
            return false;
        }
        try {
            host_addr = InetAddress.getAllByName(host);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
        for (int idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            block4: for (int idx2 = 0; idx2 < host_addr.length; ++idx2) {
                byte[] raw_addr = host_addr[idx2].getAddress();
                if (raw_addr.length != addr.length) continue;
                for (int idx3 = 0; idx3 < raw_addr.length; ++idx3) {
                    if ((raw_addr[idx3] & mask[idx3]) != (addr[idx3] & mask[idx3])) continue block4;
                }
                return true;
            }
        }
        return false;
    }

    public HTTPResponse Head(String file) throws IOException, ModuleException {
        return this.Head(file, (String)null, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Head(file, form_data, null);
    }

    public HTTPResponse Head(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        String query = Codecs.nv2query(form_data);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + query;
        }
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Head(String file, String query) throws IOException, ModuleException {
        return this.Head(file, query, null);
    }

    public HTTPResponse Head(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + Codecs.URLEncode(query);
        }
        return this.setupRequest("HEAD", File2, headers, null, null);
    }

    public HTTPResponse Get(String file) throws IOException, ModuleException {
        return this.Get(file, (String)null, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data) throws IOException, ModuleException {
        return this.Get(file, form_data, null);
    }

    public HTTPResponse Get(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        String query = Codecs.nv2query(form_data);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + query;
        }
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Get(String file, String query) throws IOException, ModuleException {
        return this.Get(file, query, null);
    }

    public HTTPResponse Get(String file, String query, NVPair[] headers) throws IOException, ModuleException {
        String File2 = this.stripRef(file);
        if (query != null && query.length() > 0) {
            File2 = File2 + "?" + Codecs.URLEncode(query);
        }
        return this.setupRequest("GET", File2, headers, null, null);
    }

    public HTTPResponse Post(String file) throws IOException, ModuleException {
        return this.Post(file, (byte[])null, null);
    }

    public HTTPResponse Post(String file, NVPair[] form_data) throws IOException, ModuleException {
        NVPair[] headers = new NVPair[]{new NVPair("Content-type", "application/x-www-form-urlencoded")};
        return this.Post(file, Codecs.nv2query(form_data), headers);
    }

    public HTTPResponse Post(String file, NVPair[] form_data, NVPair[] headers) throws IOException, ModuleException {
        if (Util.getIndex(headers, "Content-Type") == -1) {
            headers = Util.addValue(headers, "Content-type", "application/x-www-form-urlencoded");
        }
        return this.Post(file, Codecs.nv2query(form_data), headers);
    }

    public HTTPResponse Post(String file, String data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null && data.length() > 0) {
            tmp = new byte[data.length()];
            data.getBytes(0, data.length(), tmp, 0);
        }
        return this.Post(file, tmp, headers);
    }

    public HTTPResponse Post(String file, byte[] data) throws IOException, ModuleException {
        return this.Post(file, data, null);
    }

    public HTTPResponse Post(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("POST", this.stripRef(file), headers, data, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Post(file, stream, null);
    }

    public HTTPResponse Post(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("POST", this.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Put(String file, String data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, String data, NVPair[] headers) throws IOException, ModuleException {
        byte[] tmp = null;
        if (data != null) {
            tmp = new byte[data.length()];
            data.getBytes(0, data.length(), tmp, 0);
        }
        return this.Put(file, tmp, headers);
    }

    public HTTPResponse Put(String file, byte[] data) throws IOException, ModuleException {
        return this.Put(file, data, null);
    }

    public HTTPResponse Put(String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        if (data == null) {
            data = new byte[]{};
        }
        return this.setupRequest("PUT", this.stripRef(file), headers, data, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream) throws IOException, ModuleException {
        return this.Put(file, stream, null);
    }

    public HTTPResponse Put(String file, HttpOutputStream stream, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("PUT", this.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Options(String file) throws IOException, ModuleException {
        return this.Options(file, null, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.Options(file, headers, (byte[])null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, byte[] data) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(file), headers, data, null);
    }

    public HTTPResponse Options(String file, NVPair[] headers, HttpOutputStream stream) throws IOException, ModuleException {
        return this.setupRequest("OPTIONS", this.stripRef(file), headers, null, stream);
    }

    public HTTPResponse Delete(String file) throws IOException, ModuleException {
        return this.Delete(file, null);
    }

    public HTTPResponse Delete(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("DELETE", this.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest("TRACE", this.stripRef(file), headers, null, null);
    }

    public HTTPResponse Trace(String file) throws IOException, ModuleException {
        return this.Trace(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket Connect() throws IOException, ModuleException, ThreadInterruptedIOException {
        Socket resultSocket = null;
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            if (this.Proxy_Host == null) {
                resultSocket = this.getSocket(this.Timeout);
            } else {
                StreamDemultiplexor oldMultiplexor = this.input_demux;
                this.input_demux = null;
                try {
                    HTTPResponse response = this.setupRequest("CONNECT", this.Host + ":" + this.Port, null, null, null);
                    if (response.getStatusCode() != 200) {
                        String reasonLine = "";
                        try {
                            reasonLine = response.getReasonLine();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        String error = "HTTPClient: Connect: CONNECT was not successful. HTTP status: " + response.getStatusCode() + " reason: " + reasonLine;
                        if (response.getStatusCode() == 403) {
                            throw new ForbiddenIOException(error);
                        }
                        throw new IOException(error);
                    }
                    resultSocket = this.input_demux.releaseSocket();
                    Object var8_8 = null;
                    if (this.input_demux != null) {
                        this.input_demux.releaseHttpConnectResources();
                    }
                    this.input_demux = oldMultiplexor;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (this.input_demux != null) {
                        this.input_demux.releaseHttpConnectResources();
                    }
                    this.input_demux = oldMultiplexor;
                    throw throwable;
                }
            }
        }
        if (resultSocket == null) {
            throw new IOException("HTTPClient: Connect: Internal error - could not get the Socket.");
        }
        return resultSocket;
    }

    public HTTPResponse ExtensionMethod(String method, String file, byte[] data, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), this.stripRef(file), headers, data, null);
    }

    public HTTPResponse ExtensionMethod(String method, String file, HttpOutputStream os, NVPair[] headers) throws IOException, ModuleException {
        return this.setupRequest(method.trim(), this.stripRef(file), headers, null, os);
    }

    public void stop() {
        Request req = (Request)this.RequestList.enumerate();
        while (req != null) {
            req.aborted = true;
            req = (Request)this.RequestList.next();
        }
        StreamDemultiplexor demux = (StreamDemultiplexor)this.DemuxList.enumerate();
        while (demux != null) {
            demux.abort();
            demux = (StreamDemultiplexor)this.DemuxList.next();
        }
    }

    public void setDefaultHeaders(NVPair[] headers) {
        int length = headers == null ? 0 : headers.length;
        this.DefaultHeaders = new NVPair[length];
        int didx = 0;
        for (int sidx = 0; sidx < length; ++sidx) {
            String name = headers[sidx].getName().trim();
            if (name.equalsIgnoreCase("Content-length") || name.equalsIgnoreCase("Host")) continue;
            this.DefaultHeaders[didx++] = headers[sidx];
        }
        if (didx < length) {
            this.DefaultHeaders = Util.resizeArray(this.DefaultHeaders, didx);
        }
    }

    public NVPair[] getDefaultHeaders() {
        NVPair[] headers = new NVPair[this.DefaultHeaders.length];
        System.arraycopy(this.DefaultHeaders, 0, headers, 0, headers.length);
        return headers;
    }

    public String getProtocol() {
        switch (this.Protocol) {
            case 0: {
                return "http";
            }
            case 1: {
                return "https";
            }
            case 2: {
                return "shttp";
            }
            case 3: {
                return "http-ng";
            }
        }
        throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
    }

    public String getHost() {
        return this.Host;
    }

    public int getPort() {
        return this.Port;
    }

    public String getProxyHost() {
        return this.Proxy_Host;
    }

    public int getProxyPort() {
        return this.Proxy_Port;
    }

    public void setRawMode(boolean raw) {
        String[] modules = new String[]{"HTTPClient.CookieModule", "HTTPClient.RedirectionModule", "HTTPClient.AuthorizationModule", "HTTPClient.DefaultModule", "HTTPClient.TransferEncodingModule", "HTTPClient.ContentMD5Module", "HTTPClient.ContentEncodingModule"};
        for (int idx = 0; idx < modules.length; ++idx) {
            try {
                if (raw) {
                    this.removeModule(Class.forName(modules[idx]));
                    continue;
                }
                this.addModule(Class.forName(modules[idx]), -1);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
    }

    public static void setDefaultTimeout(int time) {
        DefaultTimeout = time;
    }

    public static int getDefaultTimeout() {
        return DefaultTimeout;
    }

    public void setTimeout(int time) {
        this.Timeout = time;
    }

    public int getTimeout() {
        return this.Timeout;
    }

    public void setAllowUserInteraction(boolean allow) {
        this.AllowUI = allow;
    }

    public boolean getAllowUserInteraction() {
        return this.AllowUI;
    }

    public static void setDefaultAllowUserInteraction(boolean allow) {
        DefaultAllowUI = allow;
    }

    public static boolean getDefaultAllowUserInteraction() {
        return DefaultAllowUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getDefaultModules() {
        Vector vector = DefaultModuleList;
        synchronized (vector) {
            Object[] modules = new Class[DefaultModuleList.size()];
            DefaultModuleList.copyInto(modules);
            return modules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addDefaultModule(Class module, int pos) {
        try {
            HTTPClientModule tmp = (HTTPClientModule)module.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        Vector vector = DefaultModuleList;
        synchronized (vector) {
            if (DefaultModuleList.contains(module)) {
                return false;
            }
            if (pos < 0) {
                DefaultModuleList.insertElementAt(module, DefaultModuleList.size() + pos + 1);
            } else {
                DefaultModuleList.insertElementAt(module, pos);
            }
        }
        return true;
    }

    public static boolean removeDefaultModule(Class module) {
        boolean removed = DefaultModuleList.removeElement(module);
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getModules() {
        Vector vector = this.ModuleList;
        synchronized (vector) {
            Object[] modules = new Class[this.ModuleList.size()];
            this.ModuleList.copyInto(modules);
            return modules;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addModule(Class module, int pos) {
        try {
            HTTPClientModule tmp = (HTTPClientModule)module.newInstance();
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        Vector vector = this.ModuleList;
        synchronized (vector) {
            if (this.ModuleList.contains(module)) {
                return false;
            }
            if (pos < 0) {
                this.ModuleList.insertElementAt(module, this.ModuleList.size() + pos + 1);
            } else {
                this.ModuleList.insertElementAt(module, pos);
            }
        }
        return true;
    }

    public boolean removeModule(Class module) {
        if (module == null) {
            return false;
        }
        return this.ModuleList.removeElement(module);
    }

    public void setContext(Object context) {
        if (context == null) {
            throw new IllegalArgumentException("Context must be non-null");
        }
        if (this.Context != null) {
            throw new RuntimeException("Context already set");
        }
        this.Context = context;
    }

    public Object getContext() {
        if (this.Context != null) {
            return this.Context;
        }
        return dflt_context;
    }

    static Object getDefaultContext() {
        return dflt_context;
    }

    public void addDigestAuthorization(String realm, String user, String passwd) throws AuthSchemeNotImplException {
        AuthorizationInfo.addDigestAuthorization(this.Host, this.Port, realm, user, passwd, this.getContext());
    }

    public void addBasicAuthorization(String realm, String user, String passwd) throws AuthSchemeNotImplException {
        AuthorizationInfo.addBasicAuthorization(this.Host, this.Port, realm, user, passwd, this.getContext());
    }

    public static void setProxyServer(String host, int port) {
        if (host == null || host.trim().length() == 0) {
            Default_Proxy_Host = null;
        } else {
            Default_Proxy_Host = host.trim().toLowerCase();
            Default_Proxy_Port = port;
        }
    }

    public synchronized void setCurrentProxy(String host, int port) {
        if (host == null || host.trim().length() == 0) {
            this.Proxy_Host = null;
        } else {
            this.Proxy_Host = host.trim().toLowerCase();
            this.Proxy_Port = port <= 0 ? 80 : port;
        }
        switch (this.Protocol) {
            case 0: 
            case 1: {
                if (force_1_0) {
                    this.ServerProtocolVersion = 65536;
                    this.ServProtVersKnown = true;
                    this.RequestProtocolVersion = "HTTP/1.0";
                    break;
                }
                this.ServerProtocolVersion = 65537;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "HTTP/1.1";
                break;
            }
            case 3: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "";
                break;
            }
            case 2: {
                this.ServerProtocolVersion = -1;
                this.ServProtVersKnown = false;
                this.RequestProtocolVersion = "Secure-HTTP/1.3";
                break;
            }
            default: {
                throw new Error("HTTPClient Internal Error: invalid protocol " + this.Protocol);
            }
        }
        this.KeepAliveUnknown = true;
        this.DoesKeepAlive = false;
        this.input_demux = null;
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    public static void dontProxyFor(String host) throws ParseException {
        int idx;
        byte[] ip_mask;
        byte[] ip_addr;
        if ((host = host.trim().toLowerCase()).charAt(0) == '.') {
            if (!non_proxy_dom_list.contains(host)) {
                non_proxy_dom_list.addElement(host);
            }
            return;
        }
        for (int idx2 = 0; idx2 < host.length(); ++idx2) {
            if (Character.isDigit(host.charAt(idx2)) || host.charAt(idx2) == '.' || host.charAt(idx2) == '/') continue;
            non_proxy_host_list.put(host, "");
            return;
        }
        int slash = host.indexOf(47);
        if (slash != -1) {
            ip_addr = HTTPConnection.string2arr(host.substring(0, slash));
            if (ip_addr.length != (ip_mask = HTTPConnection.string2arr(host.substring(slash + 1))).length) {
                throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
            }
        } else {
            ip_addr = HTTPConnection.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block2: for (idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            if (addr.length != ip_addr.length) continue;
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2]) || mask[idx2] != ip_mask[idx2]) continue block2;
            }
            return;
        }
        non_proxy_addr_list.addElement(ip_addr);
        non_proxy_mask_list.addElement(ip_mask);
    }

    public static boolean doProxyFor(String host) throws ParseException {
        int idx;
        byte[] ip_mask;
        byte[] ip_addr;
        if ((host = host.trim().toLowerCase()).charAt(0) == '.') {
            return non_proxy_dom_list.removeElement(host);
        }
        for (int idx2 = 0; idx2 < host.length(); ++idx2) {
            if (Character.isDigit(host.charAt(idx2)) || host.charAt(idx2) == '.' || host.charAt(idx2) == '/') continue;
            return non_proxy_host_list.remove(host) != null;
        }
        int slash = host.indexOf(47);
        if (slash != -1) {
            ip_addr = HTTPConnection.string2arr(host.substring(0, slash));
            if (ip_addr.length != (ip_mask = HTTPConnection.string2arr(host.substring(slash + 1))).length) {
                throw new ParseException("length of IP-address (" + ip_addr.length + ") != length of netmask (" + ip_mask.length + ")");
            }
        } else {
            ip_addr = HTTPConnection.string2arr(host);
            ip_mask = new byte[ip_addr.length];
            for (idx = 0; idx < ip_mask.length; ++idx) {
                ip_mask[idx] = -1;
            }
        }
        block2: for (idx = 0; idx < non_proxy_addr_list.size(); ++idx) {
            byte[] addr = (byte[])non_proxy_addr_list.elementAt(idx);
            byte[] mask = (byte[])non_proxy_mask_list.elementAt(idx);
            if (addr.length != ip_addr.length) continue;
            for (int idx2 = 0; idx2 < addr.length; ++idx2) {
                if ((ip_addr[idx2] & mask[idx2]) != (addr[idx2] & mask[idx2]) || mask[idx2] != ip_mask[idx2]) continue block2;
            }
            non_proxy_addr_list.removeElementAt(idx);
            non_proxy_mask_list.removeElementAt(idx);
            return true;
        }
        return false;
    }

    private static byte[] string2arr(String ip) {
        char[] ip_char = new char[ip.length()];
        ip.getChars(0, ip_char.length, ip_char, 0);
        int cnt = 0;
        for (int idx = 0; idx < ip_char.length; ++idx) {
            if (ip_char[idx] != '.') continue;
            ++cnt;
        }
        byte[] arr = new byte[cnt + 1];
        cnt = 0;
        int pos = 0;
        for (int idx = 0; idx < ip_char.length; ++idx) {
            if (ip_char[idx] != '.') continue;
            arr[cnt] = (byte)Integer.parseInt(ip.substring(pos, idx));
            ++cnt;
            pos = idx + 1;
        }
        arr[cnt] = (byte)Integer.parseInt(ip.substring(pos));
        return arr;
    }

    public static void setSocksServer(String host) {
        HTTPConnection.setSocksServer(host, 1080);
    }

    public static void setSocksServer(String host, int port) {
        if (port <= 0) {
            port = 1080;
        }
        Default_Socks_client = host == null || host.length() == 0 ? null : new SocksClient(host, port);
    }

    public static void setSocksServer(String host, int port, int version) throws SocksException {
        if (port <= 0) {
            port = 1080;
        }
        Default_Socks_client = host == null || host.length() == 0 ? null : new SocksClient(host, port, version);
    }

    private final String stripRef(String file) {
        if (file == null) {
            return "/";
        }
        int hash = file.indexOf(35);
        if ((file = hash != -1 ? file.substring(0, hash).trim() : file.trim()).length() == 0) {
            file = "/";
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPResponse setupRequest(String method, String resource, NVPair[] headers, byte[] entity, HttpOutputStream stream) throws IOException, ModuleException {
        Request req = new Request(this, method, resource, this.mergedHeaders(headers), entity, stream, this.AllowUI);
        this.RequestList.addToEnd(req);
        try {
            HTTPResponse resp = new HTTPResponse(this.gen_mod_insts(), this.Timeout, req);
            this.handleRequest(req, resp, null, true);
            HTTPResponse hTTPResponse = resp;
            return hTTPResponse;
        }
        finally {
            this.RequestList.remove(req);
        }
    }

    private NVPair[] mergedHeaders(NVPair[] spec) {
        int spec_len = spec != null ? spec.length : 0;
        int defs_len = this.DefaultHeaders != null ? this.DefaultHeaders.length : 0;
        NVPair[] merged = new NVPair[spec_len + defs_len];
        System.arraycopy(this.DefaultHeaders, 0, merged, 0, defs_len);
        int didx = defs_len;
        for (int sidx = 0; sidx < spec_len; ++sidx) {
            int search;
            String s_name = spec[sidx].getName().trim();
            if (s_name.equalsIgnoreCase("Content-length") || s_name.equalsIgnoreCase("Host")) continue;
            for (search = 0; search < didx && !merged[search].getName().trim().equalsIgnoreCase(s_name); ++search) {
            }
            merged[search] = spec[sidx];
            if (search != didx) continue;
            ++didx;
        }
        if (didx < merged.length) {
            merged = Util.resizeArray(merged, didx);
        }
        return merged;
    }

    private HTTPClientModule[] gen_mod_insts() {
        HTTPClientModule[] mod_insts = new HTTPClientModule[this.ModuleList.size()];
        for (int idx = 0; idx < this.ModuleList.size(); ++idx) {
            Class mod = (Class)this.ModuleList.elementAt(idx);
            try {
                mod_insts[idx] = (HTTPClientModule)mod.newInstance();
                continue;
            }
            catch (Exception e) {
                throw new Error("HTTPClient Internal Error: could not create instance of " + mod.getName() + " -\n" + e);
            }
        }
        return mod_insts;
    }

    void handleRequest(Request req, HTTPResponse http_resp, Response resp, boolean usemodules) throws IOException, ModuleException {
        Response[] rsp_arr = new Response[]{resp};
        HTTPClientModule[] modules = http_resp.getModules();
        if (usemodules) {
            block10: for (int idx = 0; idx < modules.length; ++idx) {
                int sts = modules[idx].requestHandler(req, rsp_arr);
                switch (sts) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        idx = -1;
                        continue block10;
                    }
                    case 2: {
                        break block10;
                    }
                    case 3: 
                    case 4: {
                        if (rsp_arr[0] == null) {
                            throw new Error("HTTPClient Internal Error: no response returned by module " + modules[idx].getClass().getName());
                        }
                        http_resp.set(req, rsp_arr[0]);
                        if (req.getStream() != null) {
                            req.getStream().ignoreData(req);
                        }
                        if (req.internal_subrequest) {
                            return;
                        }
                        if (sts == 3) {
                            http_resp.handleResponse();
                        } else {
                            http_resp.init(rsp_arr[0]);
                        }
                        return;
                    }
                    case 5: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], true);
                        return;
                    }
                    case 6: {
                        if (req.internal_subrequest) {
                            return;
                        }
                        req.getConnection().handleRequest(req, http_resp, rsp_arr[0], false);
                        return;
                    }
                    default: {
                        throw new Error("HTTPClient Internal Error: invalid status " + sts + " returned by module " + modules[idx].getClass().getName());
                    }
                }
            }
        }
        if (req.internal_subrequest) {
            return;
        }
        if (req.getStream() != null && req.getStream().getLength() == -1) {
            if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537) {
                req.getStream().goAhead(req, null, http_resp.getTimeout());
                http_resp.set(req, req.getStream());
            } else {
                try {
                    req.setHeaders(Util.addToken(req.getHeaders(), "Transfer-Encoding", "chunked"));
                }
                catch (ParseException pe) {
                    throw new IOException(pe.toString());
                }
                http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
            }
        } else {
            http_resp.set(req, this.sendRequest(req, http_resp.getTimeout()));
        }
        if (req.aborted) {
            throw new IOException("Request aborted by user");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response sendRequest(Request req, int con_timeout) throws IOException, ModuleException {
        boolean keep_alive;
        ExtByteArrayOutputStream hdr_buf = new ExtByteArrayOutputStream(600);
        Response resp = null;
        if (this.early_stall != null) {
            try {
                Response response = this.early_stall;
                synchronized (response) {
                    try {
                        this.early_stall.getVersion();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this.early_stall = null;
                }
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
        String[] con_hdrs = this.assembleHeaders(req, hdr_buf);
        try {
            keep_alive = this.ServerProtocolVersion >= 65537 && !Util.hasToken(con_hdrs[0], "close") || this.ServerProtocolVersion == 65536 && Util.hasToken(con_hdrs[0], "keep-alive");
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
        HTTPConnection hTTPConnection = this;
        synchronized (hTTPConnection) {
            if (this.late_stall != null) {
                if (this.input_demux != null || this.KeepAliveUnknown) {
                    try {
                        this.late_stall.getVersion();
                        if (this.KeepAliveUnknown) {
                            this.determineKeepAlive(this.late_stall);
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                this.late_stall = null;
            }
            if (req.getMethod().equals("POST") && this.prev_resp != null && this.input_demux != null) {
                try {
                    this.prev_resp.getVersion();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (!this.output_finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie.toString());
                }
            }
            if (req.aborted) {
                throw new IOException("Request aborted by user");
            }
            int try_count = 3;
            while (try_count-- > 0) {
                try {
                    boolean wf_cont;
                    Socket sock;
                    if (this.input_demux == null || (sock = this.input_demux.getSocket()) == null) {
                        sock = this.getSocket(con_timeout);
                        try {
                            if (disable_nagle) {
                                sock.setTcpNoDelay(true);
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (this.Protocol == 1) {
                            if (Default_Tunnel_Host == null && this.Tunnel_Host != null) {
                                this.Proxy_Host = this.Tunnel_Host;
                            }
                            if (this.Proxy_Host != null) {
                                Socket[] sarr = new Socket[]{sock};
                                resp = this.enableSSLTunneling(sarr, req, con_timeout);
                                if (resp != null) {
                                    resp.final_resp = true;
                                    return resp;
                                }
                                sock = sarr[0];
                                this.Tunnel_Host = this.Proxy_Host;
                                this.Tunnel_Port = this.Proxy_Port;
                                this.Proxy_Host = null;
                            }
                        }
                        if (this.input_demux != null && this.input_demux.isHttpConnectCompatibilityModeUsed()) {
                            this.input_demux.releaseHttpConnectResources();
                        }
                        this.input_demux = new StreamDemultiplexor(this.Protocol, sock, this, req.getMethod().equals("CONNECT"));
                        this.DemuxList.addToEnd(this.input_demux);
                        this.KeepAliveReqLeft = this.KeepAliveReqMax;
                    }
                    if (req.aborted) {
                        throw new IOException("Request aborted by user");
                    }
                    OutputStream sock_out = sock.getOutputStream();
                    try {
                        wf_cont = Util.hasToken(con_hdrs[1], "100-continue");
                    }
                    catch (ParseException pe) {
                        throw new IOException(pe.toString());
                    }
                    if (!(req.getData() == null || req.getData().length <= 0 || req.getData().length >= 10000 || req.delay_entity != 0L || this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 && wf_cont)) {
                        hdr_buf.write(req.getData());
                        hdr_buf.writeTo(sock_out);
                    } else {
                        hdr_buf.writeTo(sock_out);
                        try {
                            if (this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 && wf_cont) {
                                resp = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                                resp.timeout = 60;
                                if (resp.getContinue() != 100) {
                                    break;
                                }
                            }
                        }
                        catch (InterruptedIOException iioe) {
                        }
                        finally {
                            if (resp != null) {
                                resp.timeout = 0;
                            }
                        }
                        if (req.getData() != null && req.getData().length > 0) {
                            if (req.delay_entity > 0L) {
                                long num_units = req.delay_entity / 100L;
                                long one_unit = req.delay_entity / num_units;
                                int idx = 0;
                                while ((long)idx < num_units && this.input_demux.available(null) == 0) {
                                    try {
                                        Thread.sleep(one_unit);
                                    }
                                    catch (InterruptedException ie) {
                                        // empty catch block
                                    }
                                    ++idx;
                                }
                                if (this.input_demux.available(null) == 0) {
                                    sock_out.write(req.getData());
                                } else {
                                    keep_alive = false;
                                }
                            } else {
                                sock_out.write(req.getData());
                            }
                        }
                    }
                    if (req.getStream() != null) {
                        req.getStream().goAhead(req, sock_out, 0);
                    } else {
                        sock_out.flush();
                    }
                    if (resp == null) {
                        resp = new Response(req, this.Proxy_Host != null && this.Protocol != 1, this.input_demux);
                    }
                    this.prev_resp = resp;
                    break;
                }
                catch (IOException ioe) {
                    this.closeDemux(ioe);
                    if (try_count != 0 && !(ioe instanceof UnknownHostException) && !(ioe instanceof InterruptedIOException) && !req.aborted) continue;
                    throw ioe;
                }
            }
            if ((!this.KeepAliveUnknown && !this.DoesKeepAlive || !keep_alive || this.KeepAliveReqMax != -1 && this.KeepAliveReqLeft-- == 0) && !req.getMethod().equals("CONNECT")) {
                this.input_demux.markForClose(resp);
                this.input_demux = null;
            } else {
                this.input_demux.restartTimer();
            }
            if (!this.ServProtVersKnown) {
                this.early_stall = resp;
                resp.markAsFirstResponse(req);
            }
            if (this.KeepAliveUnknown || !IdempotentSequence.methodIsIdempotent(req.getMethod()) || req.dont_pipeline || NeverPipeline) {
                this.late_stall = resp;
            }
            if (req.getStream() != null) {
                this.output_finished = false;
            } else {
                this.output_finished = true;
                this.notify();
            }
        }
        return resp;
    }

    private Socket getSocket(int con_timeout) throws IOException, ThreadInterruptedIOException {
        int actual_port;
        String actual_host;
        Socket sock = null;
        if (this.Tunnel_Host != null) {
            actual_host = this.Tunnel_Host;
            actual_port = this.Tunnel_Port;
        } else if (this.Proxy_Host != null) {
            actual_host = this.Proxy_Host;
            actual_port = this.Proxy_Port;
        } else {
            actual_host = this.Host;
            actual_port = this.Port;
        }
        if (con_timeout == 0) {
            if (this.Socks_client != null) {
                sock = this.Socks_client.getSocket(actual_host, actual_port);
            } else {
                InetAddress[] addr_list = InetAddress.getAllByName(actual_host);
                for (int idx = 0; idx < addr_list.length; ++idx) {
                    try {
                        sock = new Socket(addr_list[idx], actual_port);
                        break;
                    }
                    catch (SocketException se) {
                        if (idx != addr_list.length - 1) continue;
                        throw se;
                    }
                }
            }
        } else {
            EstablishConnection con = new EstablishConnection(actual_host, actual_port, this.Socks_client);
            con.start();
            try {
                con.join(con_timeout);
            }
            catch (InterruptedException ie) {
                sock = con.getSocket();
                con.forget();
                throw new ThreadInterruptedIOException("Current thread was interrupted!");
            }
            if (con.getException() != null) {
                throw con.getException();
            }
            sock = con.getSocket();
            if (sock == null) {
                con.forget();
                sock = con.getSocket();
                if (sock == null) {
                    throw new InterruptedIOException("Connection establishment timed out");
                }
            }
        }
        return sock;
    }

    private Response enableSSLTunneling(Socket[] sock, Request req, int timeout) throws IOException, ModuleException {
        Vector<NVPair> hdrs = new Vector<NVPair>();
        for (int idx = 0; idx < req.getHeaders().length; ++idx) {
            String name = req.getHeaders()[idx].getName();
            if (!name.equalsIgnoreCase("User-Agent") && !name.equalsIgnoreCase("Proxy-Authorization")) continue;
            hdrs.addElement(req.getHeaders()[idx]);
        }
        Object[] h = new NVPair[hdrs.size()];
        hdrs.copyInto(h);
        Request connect = new Request(this, "CONNECT", this.Host + ":" + this.Port, (NVPair[])h, null, null, req.allowUI());
        connect.internal_subrequest = true;
        ExtByteArrayOutputStream hdr_buf = new ExtByteArrayOutputStream(600);
        HTTPResponse r = new HTTPResponse(this.gen_mod_insts(), timeout, connect);
        Response resp = null;
        while (true) {
            this.handleRequest(connect, r, resp, true);
            hdr_buf.reset();
            this.assembleHeaders(connect, hdr_buf);
            hdr_buf.writeTo(sock[0].getOutputStream());
            resp = new Response(connect, sock[0].getInputStream());
            if (resp.getStatusCode() == 200) {
                return null;
            }
            try {
                resp.getData();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            try {
                sock[0].close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            r.set(connect, resp);
            if (!r.handleResponse()) {
                return resp;
            }
            sock[0] = this.getSocket(timeout);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String[] assembleHeaders(Request req, ExtByteArrayOutputStream hdr_buf) throws IOException {
        con_hdrs = new String[]{"", ""};
        hdrs = req.getHeaders();
        file = Util.escapeUnsafeChars(req.getRequestURI());
        if (req.getMethod().equals("CONNECT")) {
            hdr_buf.write(req.getMethod(), " ", this.Host);
            hdr_buf.write(":", Integer.toString(this.Port), "");
            hdr_buf.write(" ", this.RequestProtocolVersion, "\r\n");
        } else if (this.Proxy_Host != null && this.Protocol != 1 && !file.equals("*")) {
            hdr_buf.write(req.getMethod(), " http://", this.Host);
            hdr_buf.write(":", Integer.toString(this.Port), file);
            hdr_buf.write(" ", this.RequestProtocolVersion, "\r\n");
        } else {
            hdr_buf.write(req.getMethod(), " ", file);
            hdr_buf.write(" ", this.RequestProtocolVersion, "\r\n");
        }
        if (this.Port != 80 || req.getMethod().equals("CONNECT")) {
            hdr_buf.write("Host: ", this.Host, ":");
            hdr_buf.write(Integer.toString(this.Port), "\r\n");
        } else {
            hdr_buf.write("Host: ", this.Host, "\r\n");
        }
        ct_idx = -1;
        ua_idx = -1;
        co_idx = -1;
        pc_idx = -1;
        ka_idx = -1;
        ex_idx = -1;
        te_idx = -1;
        tc_idx = -1;
        ug_idx = -1;
        for (idx = 0; idx < hdrs.length; ++idx) {
            name = hdrs[idx].getName().trim();
            if (name.equalsIgnoreCase("Content-Type")) {
                ct_idx = idx;
                continue;
            }
            if (name.equalsIgnoreCase("User-Agent")) {
                ua_idx = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Connection")) {
                co_idx = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Proxy-Connection")) {
                pc_idx = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Keep-Alive")) {
                ka_idx = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Expect")) {
                ex_idx = idx;
                continue;
            }
            if (name.equalsIgnoreCase("TE")) {
                te_idx = idx;
                continue;
            }
            if (name.equalsIgnoreCase("Transfer-Encoding")) {
                tc_idx = idx;
                continue;
            }
            if (!name.equalsIgnoreCase("Upgrade")) continue;
            ug_idx = idx;
        }
        co_hdr = null;
        if (!this.ServProtVersKnown || this.ServerProtocolVersion < 65537 || co_idx != -1) {
            if (co_idx == -1) {
                co_hdr = "Keep-Alive";
                con_hdrs[0] = "Keep-Alive";
            } else {
                con_hdrs[0] = hdrs[co_idx].getValue().trim();
                co_hdr = con_hdrs[0];
            }
            try {
                if (ka_idx != -1 && Util.hasToken(con_hdrs[0], "keep-alive")) {
                    hdr_buf.write("Keep-Alive: ", hdrs[ka_idx].getValue().trim(), "\r\n");
                }
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
        }
        if (!(this.Proxy_Host == null || this.Protocol == 1 || this.ServProtVersKnown && this.ServerProtocolVersion >= 65537 || co_hdr == null)) {
            hdr_buf.write("Proxy-Connection: ", co_hdr, "\r\n");
            co_hdr = null;
        }
        if (co_hdr != null) {
            try {
                if (Util.hasToken(co_hdr, "TE")) ** GOTO lbl84
                co_hdr = co_hdr + ", TE";
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
        } else {
            co_hdr = "TE";
        }
lbl84:
        // 3 sources

        if (ug_idx != -1) {
            co_hdr = co_hdr + ", Upgrade";
        }
        if (co_hdr != null) {
            hdr_buf.write("Connection: ", co_hdr, "\r\n");
        }
        if (te_idx != -1) {
            hdr_buf.write("TE: ");
            try {
                pte = Util.parseHeader(hdrs[te_idx].getValue());
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
            if (!pte.contains(new HttpHeaderElement("trailers"))) {
                hdr_buf.write("trailers, ");
            }
            hdr_buf.write(hdrs[te_idx].getValue().trim(), "\r\n");
        } else {
            hdr_buf.write("TE: trailers\r\n");
        }
        if (ua_idx != -1) {
            hdr_buf.write("User-Agent: ", hdrs[ua_idx].getValue().trim(), " ");
            hdr_buf.write("RPT-HTTPClient/0.4-dev", "\r\n");
        } else {
            hdr_buf.write("User-Agent: ", "RPT-HTTPClient/0.4-dev", "\r\n");
        }
        for (idx = 0; idx < hdrs.length; ++idx) {
            if (idx == ct_idx || idx == ua_idx || idx == co_idx || idx == pc_idx || idx == ka_idx || idx == ex_idx || idx == te_idx) continue;
            hdr_buf.write(hdrs[idx].getName().trim(), ": ");
            hdr_buf.write(hdrs[idx].getValue().trim(), "\r\n");
        }
        if (req.getData() != null || req.getStream() != null) {
            if (ct_idx != -1) {
                hdr_buf.write("Content-type: ", hdrs[ct_idx].getValue().trim(), "\r\n");
            } else {
                hdr_buf.write("Content-type: application/octet-stream\r\n");
            }
            if (req.getData() != null) {
                hdr_buf.write("Content-length: ", Integer.toString(req.getData().length), "\r\n");
            } else if (req.getStream().getLength() != -1 && tc_idx == -1) {
                hdr_buf.write("Content-length: ", Integer.toString(req.getStream().getLength()), "\r\n");
            }
            if (ex_idx != -1) {
                con_hdrs[1] = hdrs[ex_idx].getValue().trim();
                hdr_buf.write("Expect: ", con_hdrs[1], "\r\n");
            }
        } else if (ex_idx != -1) {
            try {
                expect_tokens = Util.parseHeader(hdrs[ex_idx].getValue());
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
            cont = new HttpHeaderElement("100-continue");
            while (expect_tokens.removeElement(cont)) {
            }
            if (!expect_tokens.isEmpty()) {
                con_hdrs[1] = Util.assembleHeader(expect_tokens);
                hdr_buf.write("Expect: ", con_hdrs[1], "\r\n");
            }
        }
        hdr_buf.write("\r\n");
        return con_hdrs;
    }

    boolean handleFirstRequest(Request req, Response resp) throws IOException {
        this.ServerProtocolVersion = HTTPConnection.String2ProtVers(resp.getVersion());
        this.ServProtVersKnown = true;
        if (this.Proxy_Host != null && this.Protocol != 1 && resp.getHeader("Via") == null) {
            this.ServerProtocolVersion = 65536;
        }
        if (this.ServerProtocolVersion == 65536 && (resp.getStatusCode() == 400 || resp.getStatusCode() == 500)) {
            if (this.input_demux != null && this.input_demux.isHttpConnectCompatibilityModeUsed()) {
                this.input_demux.releaseHttpConnectResources();
            }
            this.input_demux.markForClose(resp);
            this.input_demux = null;
            this.RequestProtocolVersion = "HTTP/1.0";
            return false;
        }
        return true;
    }

    private void determineKeepAlive(Response resp) throws IOException {
        try {
            HttpHeaderElement max;
            String con;
            if (this.ServerProtocolVersion >= 65537 || ((this.Proxy_Host == null || this.Protocol == 1) && (con = resp.getHeader("Connection")) != null || this.Proxy_Host != null && this.Protocol != 1 && (con = resp.getHeader("Proxy-Connection")) != null) && Util.hasToken(con, "keep-alive")) {
                this.DoesKeepAlive = true;
                this.KeepAliveUnknown = false;
            } else if (resp.getStatusCode() < 400) {
                this.KeepAliveUnknown = false;
            }
            if (this.DoesKeepAlive && this.ServerProtocolVersion == 65536 && (con = resp.getHeader("Keep-Alive")) != null && (max = Util.getElement(Util.parseHeader(con), "max")) != null && max.getValue() != null) {
                this.KeepAliveReqLeft = this.KeepAliveReqMax = Integer.parseInt(max.getValue());
            }
        }
        catch (ParseException pe) {
        }
        catch (NumberFormatException nfe) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    synchronized void outputFinished() {
        this.output_finished = true;
        this.notify();
    }

    synchronized void closeDemux(IOException ioe) {
        if (this.input_demux != null) {
            this.input_demux.close(ioe, true);
        }
        this.early_stall = null;
        this.late_stall = null;
        this.prev_resp = null;
    }

    static final String ProtVers2String(int prot_vers) {
        return "HTTP/" + (prot_vers >>> 16) + "." + (prot_vers & 0xFFFF);
    }

    static final int String2ProtVers(String prot_vers) {
        String vers = prot_vers.substring(5);
        int dot = vers.indexOf(46);
        return Integer.parseInt(vers.substring(0, dot)) << 16 | Integer.parseInt(vers.substring(dot + 1));
    }

    public String toString() {
        return this.getProtocol() + "://" + this.getHost() + (this.getPort() != URI.defaultPort(this.getProtocol()) ? ":" + this.getPort() : "");
    }

    static {
        String host;
        dflt_context = new Object();
        force_1_0 = false;
        Default_Proxy_Host = null;
        non_proxy_host_list = new CIHashtable();
        non_proxy_dom_list = new Vector();
        non_proxy_addr_list = new Vector();
        non_proxy_mask_list = new Vector();
        Default_Tunnel_Host = null;
        Default_Socks_client = null;
        NeverPipeline = false;
        disable_nagle = false;
        DefaultTimeout = 0;
        DefaultAllowUI = true;
        try {
            host = System.getProperty("http.proxyHost");
            if (host == null) {
                throw new Exception();
            }
            int port = Integer.getInteger("http.proxyPort", -1);
            HTTPConnection.setProxyServer(host, port);
        }
        catch (Exception e) {
            try {
                if (Boolean.getBoolean("proxySet")) {
                    String host2 = System.getProperty("proxyHost");
                    int port = Integer.getInteger("proxyPort", -1);
                    HTTPConnection.setProxyServer(host2, port);
                }
            }
            catch (Exception ee) {
                Default_Proxy_Host = null;
            }
        }
        try {
            Default_Tunnel_Host = System.getProperty("HTTPClient.tunnelHost");
            if (Default_Tunnel_Host != null) {
                Default_Tunnel_Host = Default_Tunnel_Host.trim().toLowerCase();
            }
            Default_Tunnel_Port = Integer.getInteger("HTTPClient.tunnelPort");
        }
        catch (Exception ee) {
            Default_Tunnel_Host = null;
        }
        try {
            String hosts = System.getProperty("HTTPClient.nonProxyHosts");
            if (hosts == null) {
                hosts = System.getProperty("http.nonProxyHosts");
            }
            String[] list = Util.splitProperty(hosts);
            for (int idx = 0; idx < list.length; ++idx) {
                HTTPConnection.dontProxyFor(list[idx]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            host = System.getProperty("HTTPClient.socksHost");
            if (host != null && host.length() > 0) {
                int port = Integer.getInteger("HTTPClient.socksPort", -1);
                int version = Integer.getInteger("HTTPClient.socksVersion", -1);
                if (version == -1) {
                    HTTPConnection.setSocksServer(host, port);
                } else {
                    HTTPConnection.setSocksServer(host, port, version);
                }
            }
        }
        catch (Exception e) {
            Default_Socks_client = null;
        }
        String modules = "HTTPClient.RetryModule|HTTPClient.CookieModule|HTTPClient.RedirectionModule|HTTPClient.AuthorizationModule|HTTPClient.DefaultModule|HTTPClient.TransferEncodingModule|HTTPClient.ContentMD5Module|HTTPClient.ContentEncodingModule";
        boolean in_applet = false;
        try {
            modules = System.getProperty("HTTPClient.Modules", modules);
        }
        catch (SecurityException se) {
            in_applet = true;
        }
        DefaultModuleList = new Vector();
        String[] list = Util.splitProperty(modules);
        for (int idx = 0; idx < list.length; ++idx) {
            try {
                DefaultModuleList.addElement(Class.forName(list[idx]));
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                if (in_applet) continue;
                throw new NoClassDefFoundError(cnfe.getMessage());
            }
        }
        try {
            NeverPipeline = Boolean.getBoolean("HTTPClient.disablePipelining");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            disable_nagle = Boolean.getBoolean("HTTPClient.disableNagle");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            force_1_0 = Boolean.getBoolean("HTTPClient.forceHTTP_1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

