/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.AnonChannel;
import anon.AnonServerDescription;
import anon.AnonService;
import anon.AnonServiceEventListener;
import anon.AnonServiceFactory;
import anon.NotConnectedToMixException;
import anon.client.AnonClient;
import anon.client.TrustException;
import anon.infoservice.AbstractMixCascadeContainer;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.MixCascade;
import anon.mixminion.MixminionServiceDescription;
import anon.proxy.AbstractHTTPConnectionListener;
import anon.proxy.AnonProxyRequest;
import anon.proxy.DecompressionProxyCallback;
import anon.proxy.HTTPProxyCallback;
import anon.proxy.IProxyListener;
import anon.proxy.ProxyCallback;
import anon.proxy.ProxyCallbackHandler;
import anon.terms.TermsAndConditionConfirmation;
import anon.tor.TorAnonServerDescription;
import anon.transport.connection.IStreamConnection;
import anon.util.ObjectQueue;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class AnonProxy
implements Runnable,
AnonServiceEventListener {
    public static final int UNLIMITED_REQUESTS = Integer.MAX_VALUE;
    public static final int MIN_REQUESTS = 5;
    public static final int E_BIND = -2;
    public static final int E_MIX_PROTOCOL_NOT_SUPPORTED = -10;
    public static final int E_SIGNATURE_CHECK_FIRSTMIX_FAILED = -22;
    public static final int E_SIGNATURE_CHECK_OTHERMIX_FAILED = -23;
    private static final int RECONNECT_INTERVAL = 5000;
    private int m_maxRequests = Integer.MAX_VALUE;
    private AnonService m_Anon;
    private AnonService m_Tor;
    private AnonService m_Mixminion;
    private Vector m_anonServiceListener;
    private Thread threadRun;
    private ServerSocket m_socketListener;
    private IMutableProxyInterface m_proxyInterface = new IMutableProxyInterface.DummyMutableProxyInterface();
    private IProxyListener m_ProxyListener;
    private volatile int m_numChannels = 0;
    private boolean m_bReconnecting = false;
    private final Object THREAD_SYNC = new Object();
    private final Object SHUTDOWN_SYNC = new Object();
    private boolean bShuttingDown = false;
    private final ProxyCallbackHandler m_callbackHandler = new ProxyCallbackHandler();
    private HTTPProxyCallback m_httpProxyCallback = null;
    private DecompressionProxyCallback m_decompressionProxyCallback = null;
    private TermsAndConditionConfirmation termsConfirmation = null;
    private AbstractMixCascadeContainer m_currentMixCascade = new DummyMixCascadeContainer();
    private TorAnonServerDescription m_currentTorParams;
    private MixminionServiceDescription m_currentMixminionParams;
    private boolean m_forwardedConnection;
    private int m_maxDummyTrafficInterval = 30000;

    public AnonProxy(ServerSocket serverSocket, TermsAndConditionConfirmation termsAndConditionConfirmation) {
        this(serverSocket, null, termsAndConditionConfirmation);
    }

    public AnonProxy(ServerSocket serverSocket, IMutableProxyInterface iMutableProxyInterface, TermsAndConditionConfirmation termsAndConditionConfirmation) {
        if (serverSocket == null) {
            throw new IllegalArgumentException("Socket listener is null!");
        }
        this.m_socketListener = serverSocket;
        if (iMutableProxyInterface != null) {
            this.m_proxyInterface = iMutableProxyInterface;
        }
        this.m_Anon = AnonServiceFactory.getAnonServiceInstance("AN.ON");
        this.m_Anon.setProxy(this.m_proxyInterface);
        this.setDummyTraffic(Integer.MAX_VALUE);
        this.m_forwardedConnection = false;
        this.m_anonServiceListener = new Vector();
        this.m_Anon.removeEventListeners();
        this.m_Anon.addEventListener(this);
        this.termsConfirmation = termsAndConditionConfirmation;
    }

    public AnonProxy(ServerSocket serverSocket, IStreamConnection iStreamConnection, int n, TermsAndConditionConfirmation termsAndConditionConfirmation) {
        if (serverSocket == null) {
            throw new IllegalArgumentException("Socket listener is null!");
        }
        this.m_socketListener = serverSocket;
        this.m_Anon = new AnonClient(iStreamConnection);
        this.m_forwardedConnection = true;
        this.m_maxDummyTrafficInterval = n;
        this.setDummyTraffic(n);
        this.m_anonServiceListener = new Vector();
        this.m_Anon.removeEventListeners();
        this.m_Anon.addEventListener(this);
        this.termsConfirmation = termsAndConditionConfirmation;
    }

    public void enableProxyCallback(ProxyCallback proxyCallback) {
        if (this.m_callbackHandler == null) {
            LogHolder.log(4, LogType.NET, "No ProxyCallbackHandler activated: cannot process HTTP headers.");
            return;
        }
        this.m_callbackHandler.registerProxyCallback(proxyCallback);
    }

    public void disableProxyCallback(ProxyCallback proxyCallback) {
        if (proxyCallback != null) {
            this.m_callbackHandler.removeCallback(proxyCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHTTPHeaderProcessingEnabled(boolean bl) {
        ProxyCallbackHandler proxyCallbackHandler = this.m_callbackHandler;
        synchronized (proxyCallbackHandler) {
            if (bl) {
                if (this.m_httpProxyCallback == null) {
                    this.m_httpProxyCallback = new HTTPProxyCallback();
                }
                this.enableProxyCallback(this.m_httpProxyCallback);
            } else {
                this.disableProxyCallback(this.m_httpProxyCallback);
                this.m_httpProxyCallback = null;
            }
        }
    }

    public void setHTTPDecompressionEnabled(boolean bl) {
        if (bl) {
            if (this.m_decompressionProxyCallback == null) {
                this.m_decompressionProxyCallback = new DecompressionProxyCallback();
            }
            this.enableProxyCallback(this.m_decompressionProxyCallback);
        } else {
            this.disableProxyCallback(this.m_decompressionProxyCallback);
            this.m_decompressionProxyCallback = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeHTTPConnectionListener(AbstractHTTPConnectionListener abstractHTTPConnectionListener) {
        if (abstractHTTPConnectionListener == null) {
            return;
        }
        if (this.m_callbackHandler == null) {
            LogHolder.log(4, LogType.NET, "No Callbackhandler activated: cannot activate JonDoFox headers.");
            return;
        }
        ProxyCallbackHandler proxyCallbackHandler = this.m_callbackHandler;
        synchronized (proxyCallbackHandler) {
            if (this.m_httpProxyCallback != null) {
                this.m_httpProxyCallback.removeHTTPConnectionListener(abstractHTTPConnectionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHTTPConnectionListener(AbstractHTTPConnectionListener abstractHTTPConnectionListener) {
        if (this.m_callbackHandler == null) {
            LogHolder.log(4, LogType.NET, "No Callbackhandler activated: cannot activate JonDoFox headers.");
            return;
        }
        ProxyCallbackHandler proxyCallbackHandler = this.m_callbackHandler;
        synchronized (proxyCallbackHandler) {
            if (this.m_httpProxyCallback == null) {
                LogHolder.log(4, LogType.NET, "No HTTPProxyCallback activated: cannot activate JonDoFox headers.");
                return;
            }
            this.m_httpProxyCallback.addHTTPConnectionListener(abstractHTTPConnectionListener);
            this.enableProxyCallback(this.m_httpProxyCallback);
        }
    }

    public MixCascade getMixCascade() {
        try {
            return this.m_currentMixCascade.getCurrentCascade();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void setTorParams(TorAnonServerDescription torAnonServerDescription) {
        this.m_currentTorParams = torAnonServerDescription;
    }

    public TorAnonServerDescription getTorParams() {
        return this.m_currentTorParams;
    }

    public void setMixminionParams(MixminionServiceDescription mixminionServiceDescription) {
        this.m_currentMixminionParams = mixminionServiceDescription;
    }

    public MixminionServiceDescription getMixminionParams() {
        return this.m_currentMixminionParams;
    }

    public void setMaxConcurrentRequests(int n) {
        if (n > 5) {
            this.m_maxRequests = n;
        }
    }

    public int getMaxConcurrentRequests() {
        return this.m_maxRequests;
    }

    public void setDummyTraffic(int n) {
        try {
            if (!this.m_forwardedConnection || this.m_maxDummyTrafficInterval < 0 || n == Integer.MAX_VALUE) {
                ((AnonClient)this.m_Anon).setDummyTraffic(n);
            } else if (n >= 0) {
                ((AnonClient)this.m_Anon).setDummyTraffic(Math.min(n, this.m_maxDummyTrafficInterval));
            } else {
                ((AnonClient)this.m_Anon).setDummyTraffic(this.m_maxDummyTrafficInterval);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.SHUTDOWN_SYNC;
        synchronized (object) {
            if (this.threadRun == null) {
                this.disconnected();
                return;
            }
            this.bShuttingDown = true;
            this.m_Anon.shutdown(true);
            if (this.m_Tor != null) {
                this.m_Tor.shutdown(true);
            }
            if (this.m_Mixminion != null) {
                this.m_Mixminion.shutdown(true);
            }
            int n = 0;
            while (this.threadRun.isAlive()) {
                try {
                    this.threadRun.interrupt();
                    this.threadRun.join(500L);
                    ++n;
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_Tor = null;
            this.m_Mixminion = null;
            this.threadRun = null;
            this.packetMixed(0L);
            this.disconnected();
            this.bShuttingDown = false;
        }
    }

    public void run() {
        int n;
        block19: {
            n = 0;
            LogHolder.log(7, LogType.NET, "AnonProxy is running as Thread");
            try {
                n = this.m_socketListener.getSoTimeout();
            }
            catch (Exception exception) {
                if (!this.bShuttingDown) break block19;
                return;
            }
        }
        try {
            this.m_socketListener.setSoTimeout(2000);
        }
        catch (Exception exception) {
            LogHolder.log(7, LogType.NET, "Could not set accept time out!", exception);
        }
        if (this.bShuttingDown) {
            try {
                this.m_socketListener.setSoTimeout(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        OpenSocketRequester openSocketRequester = new OpenSocketRequester(this, this.THREAD_SYNC);
        Thread thread = new Thread((Runnable)openSocketRequester, openSocketRequester.getClass().getName());
        thread.start();
        block16: while (true) {
            try {
                while (!Thread.currentThread().isInterrupted() && !this.bShuttingDown) {
                    Socket socket = null;
                    try {
                        socket = this.m_socketListener.accept();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        continue;
                    }
                    try {
                        socket.setSoTimeout(0);
                        openSocketRequester.pushSocket(socket);
                        continue block16;
                    }
                    catch (SocketException socketException) {
                        socket = null;
                        LogHolder.log(3, LogType.NET, "Could not set non-Blocking mode for Channel-Socket!", socketException);
                    }
                }
                break;
            }
            catch (Exception exception) {
                LogHolder.log(3, LogType.NET, exception);
                break;
            }
        }
        try {
            this.m_socketListener.setSoTimeout(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        thread.interrupt();
        openSocketRequester.close();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LogHolder.log(6, LogType.NET, "JAPAnonProxyServer stopped.");
    }

    AnonChannel createChannel(int n) throws NotConnectedToMixException, Exception {
        if (n == 1) {
            if (this.m_Tor != null) {
                return this.m_Tor.createChannel(1);
            }
            if (this.getMixCascade().isSocks5Supported()) {
                return this.m_Anon.createChannel(1);
            }
            LogHolder.log(3, LogType.NET, "Received SOCKS request, but no SOCKS server is available.");
        } else {
            if (n == 0) {
                return this.m_Anon.createChannel(0);
            }
            if (n == 2 && this.m_Mixminion != null) {
                return this.m_Mixminion.createChannel(2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect() {
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            if (this.m_Anon.isConnected() || this.bShuttingDown || Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!this.m_currentMixCascade.isReconnectedAutomatically()) {
                this.stop();
                this.THREAD_SYNC.notifyAll();
                return;
            }
            if (this.m_bReconnecting) {
                return;
            }
            this.m_bReconnecting = true;
            while (this.threadRun != null && this.m_currentMixCascade.isReconnectedAutomatically() && !this.m_Anon.isConnected() && !this.bShuttingDown && !Thread.currentThread().isInterrupted()) {
                MixCascade mixCascade = this.m_currentMixCascade.getNextCascade();
                LogHolder.log(4, LogType.NET, "Try reconnect to AN.ON service. Connecting to " + mixCascade.getName() + "...");
                int n = this.m_Anon.initialize(mixCascade, this.m_currentMixCascade, this.termsConfirmation);
                if (n == 0) {
                    this.m_currentMixCascade.keepCurrentService(true);
                    break;
                }
                try {
                    this.THREAD_SYNC.wait(5000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.m_bReconnecting = false;
            if (!(this.threadRun != null && this.isConnected() || this.m_currentMixCascade.isReconnectedAutomatically())) {
                this.stop();
                this.THREAD_SYNC.notifyAll();
                return;
            }
            return;
        }
    }

    public void setProxyListener(IProxyListener iProxyListener) {
        this.m_ProxyListener = iProxyListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(AbstractMixCascadeContainer abstractMixCascadeContainer) {
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            int n;
            Object object2;
            boolean bl = false;
            boolean bl2 = false;
            AbstractMixCascadeContainer abstractMixCascadeContainer2 = abstractMixCascadeContainer == null ? new DummyMixCascadeContainer() : new EncapsulatedMixCascadeContainer(abstractMixCascadeContainer);
            if (this.getMixCascade() != abstractMixCascadeContainer2.getCurrentCascade() && this.threadRun != null) {
                bl2 = true;
                this.THREAD_SYNC.notifyAll();
                object2 = this.SHUTDOWN_SYNC;
                synchronized (object2) {
                    this.m_Anon.shutdown(false);
                    n = 0;
                    while (this.threadRun.isAlive()) {
                        try {
                            this.threadRun.interrupt();
                            this.threadRun.join(1000L);
                            if (n > 3) {
                                this.threadRun.stop();
                            }
                            ++n;
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            } else if (this.threadRun == null) {
                this.m_Anon.shutdown(true);
            }
            this.m_currentMixCascade = abstractMixCascadeContainer2;
            object2 = this.m_currentMixCascade.getNextCascade();
            LogHolder.log(5, LogType.NET, "Connecting to AN.ON service " + ((MixCascade)object2).getName() + "...");
            this.m_numChannels = 0;
            n = this.m_Anon.initialize((AnonServerDescription)object2, this.m_currentMixCascade, this.termsConfirmation);
            if (n != 0) {
                if (n == -24 || n == -32 || !this.m_currentMixCascade.isReconnectedAutomatically() || !this.m_currentMixCascade.isServiceAutoSwitched() && (n == -22 || n == -23 || n == -10 || n == -27)) {
                    return n;
                }
                bl = true;
            } else {
                this.m_currentMixCascade.keepCurrentService(true);
            }
            LogHolder.log(7, LogType.NET, "AN.ON initialized");
            if (bl2) {
                Object object3 = this.SHUTDOWN_SYNC;
                synchronized (object3) {
                    if (this.threadRun == null) {
                        LogHolder.log(5, LogType.NET, "Noticed shutdown. Stopping AN.ON...");
                        Thread.currentThread().interrupt();
                        return -24;
                    }
                }
            } else {
                if (this.m_currentTorParams != null) {
                    this.m_Tor = AnonServiceFactory.getAnonServiceInstance("TOR");
                    this.m_Tor.setProxy(this.m_proxyInterface);
                    this.m_Tor.initialize(this.m_currentTorParams, null, this.termsConfirmation);
                    LogHolder.log(7, LogType.NET, "Tor initialized");
                }
                if (this.m_currentMixminionParams != null) {
                    this.m_Mixminion = AnonServiceFactory.getAnonServiceInstance("Mixminion");
                    this.m_Mixminion.setProxy(this.m_proxyInterface);
                    this.m_Mixminion.initialize(this.m_currentMixminionParams, null, this.termsConfirmation);
                    LogHolder.log(7, LogType.NET, "Mixminion initialized");
                }
            }
            this.threadRun = new Thread((Runnable)this, "JAP - AnonProxy");
            this.threadRun.setDaemon(true);
            this.threadRun.start();
            if (bl) {
                this.connectionError();
                return n;
            }
            return 0;
        }
    }

    protected synchronized void decNumChannels() {
        --this.m_numChannels;
        if (this.m_ProxyListener != null) {
            this.m_ProxyListener.channelsChanged(this.m_numChannels);
        }
    }

    protected synchronized void incNumChannels() {
        ++this.m_numChannels;
        if (this.m_ProxyListener != null) {
            this.m_ProxyListener.channelsChanged(this.m_numChannels);
        }
    }

    protected synchronized void transferredBytes(long l, int n) {
        if (this.m_ProxyListener != null) {
            this.m_ProxyListener.transferedBytes(l, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDisconnected() {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration enumeration = this.m_anonServiceListener.elements();
            while (enumeration.hasMoreElements()) {
                ((AnonServiceEventListener)enumeration.nextElement()).disconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnecting(AnonServerDescription anonServerDescription) {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration enumeration = this.m_anonServiceListener.elements();
            while (enumeration.hasMoreElements()) {
                ((AnonServiceEventListener)enumeration.nextElement()).connecting(anonServerDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEstablished(AnonServerDescription anonServerDescription) {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration enumeration = this.m_anonServiceListener.elements();
            while (enumeration.hasMoreElements()) {
                ((AnonServiceEventListener)enumeration.nextElement()).connectionEstablished(anonServerDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionError() {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration enumeration = this.m_anonServiceListener.elements();
            while (enumeration.hasMoreElements()) {
                ((AnonServiceEventListener)enumeration.nextElement()).connectionError();
            }
        }
    }

    public void connecting(AnonServerDescription anonServerDescription) {
        LogHolder.log(6, LogType.NET, "AnonProxy received connecting.");
        this.fireConnecting(anonServerDescription);
    }

    public void connectionEstablished(AnonServerDescription anonServerDescription) {
        LogHolder.log(1, LogType.NET, "AnonProxy received connectionEstablished to '" + anonServerDescription + "'.");
        this.fireConnectionEstablished(anonServerDescription);
    }

    public void disconnected() {
        LogHolder.log(1, LogType.NET, "AnonProxy was disconnected.");
        this.fireDisconnected();
    }

    public void connectionError() {
        LogHolder.log(3, LogType.NET, "AnonProxy received connectionError", true);
        this.fireConnectionError();
        new Thread(new Runnable(){

            public void run() {
                AnonProxy.this.reconnect();
            }
        }, "Connection error reconnect thead").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEventListener(AnonServiceEventListener anonServiceEventListener) {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration enumeration = this.m_anonServiceListener.elements();
            while (enumeration.hasMoreElements()) {
                if (!anonServiceEventListener.equals(enumeration.nextElement())) continue;
                return;
            }
            this.m_anonServiceListener.addElement(anonServiceEventListener);
        }
    }

    public synchronized void removeEventListener(AnonServiceEventListener anonServiceEventListener) {
        this.m_anonServiceListener.removeElement(anonServiceEventListener);
    }

    public boolean isConnected() {
        AnonService anonService = this.m_Anon;
        return anonService != null && anonService.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packetMixed(long l) {
        if (this.isConnected() || l == 0L) {
            Vector vector = this.m_anonServiceListener;
            synchronized (vector) {
                Enumeration enumeration = this.m_anonServiceListener.elements();
                while (enumeration.hasMoreElements()) {
                    ((AnonServiceEventListener)enumeration.nextElement()).packetMixed(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChainErrorSignaled() {
        LogHolder.log(3, LogType.NET, "Proxy has been nuked");
        this.m_currentMixCascade.keepCurrentService(false);
        this.m_Anon.shutdown(false);
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration enumeration = this.m_anonServiceListener.elements();
            while (enumeration.hasMoreElements()) {
                ((AnonServiceEventListener)enumeration.nextElement()).dataChainErrorSignaled();
            }
        }
        this.reconnect();
    }

    private class EncapsulatedMixCascadeContainer
    extends AbstractMixCascadeContainer {
        private AbstractMixCascadeContainer m_mixCascadeContainer;

        public EncapsulatedMixCascadeContainer(AbstractMixCascadeContainer abstractMixCascadeContainer) {
            this.m_mixCascadeContainer = abstractMixCascadeContainer;
        }

        public void checkTrust(MixCascade mixCascade) throws TrustException, SignatureException {
            this.m_mixCascadeContainer.checkTrust(mixCascade);
        }

        public MixCascade getNextCascade() {
            return this.m_mixCascadeContainer.getNextCascade();
        }

        public MixCascade getCurrentCascade() {
            return this.m_mixCascadeContainer.getCurrentCascade();
        }

        public void keepCurrentService(boolean bl) {
            this.m_mixCascadeContainer.keepCurrentService(bl);
        }

        public boolean isServiceAutoSwitched() {
            return this.m_mixCascadeContainer.isServiceAutoSwitched();
        }

        public boolean isReconnectedAutomatically() {
            return !AnonProxy.this.m_forwardedConnection && this.m_mixCascadeContainer.isReconnectedAutomatically();
        }
    }

    private class DummyMixCascadeContainer
    extends AbstractMixCascadeContainer {
        public MixCascade getNextCascade() {
            return null;
        }

        public MixCascade getCurrentCascade() {
            return null;
        }

        public void keepCurrentService(boolean bl) {
        }

        public boolean isServiceAutoSwitched() {
            return false;
        }

        public boolean isReconnectedAutomatically() {
            return false;
        }
    }

    private class OpenSocketRequester
    implements Runnable {
        private ObjectQueue m_socketQueue = new ObjectQueue();
        private AnonProxy m_proxy;
        private Object m_syncObject;
        private boolean m_bIsClosed = false;

        public OpenSocketRequester(AnonProxy anonProxy2, Object object) {
            this.m_proxy = anonProxy2;
            this.m_syncObject = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushSocket(Socket socket) {
            ObjectQueue objectQueue = this.m_socketQueue;
            synchronized (objectQueue) {
                this.m_socketQueue.push(socket);
                this.m_socketQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_bIsClosed = true;
            ObjectQueue objectQueue = this.m_socketQueue;
            synchronized (objectQueue) {
                this.m_socketQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.currentThread().isInterrupted() && !this.m_bIsClosed) {
                if (this.m_socketQueue.getSize() > 0 && AnonProxyRequest.getNrOfRequests() < AnonProxy.this.m_maxRequests) {
                    try {
                        new AnonProxyRequest(this.m_proxy, (Socket)this.m_socketQueue.pop(), this.m_syncObject, AnonProxy.this.m_callbackHandler);
                    }
                    catch (Exception exception) {
                        LogHolder.log(3, LogType.NET, exception);
                    }
                    continue;
                }
                try {
                    ObjectQueue objectQueue = this.m_socketQueue;
                    synchronized (objectQueue) {
                        if (AnonProxyRequest.getNrOfRequests() >= AnonProxy.this.m_maxRequests) {
                            this.m_socketQueue.wait(100L);
                        } else {
                            this.m_socketQueue.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            LogHolder.log(6, LogType.NET, "Open socket thread stopped.");
        }
    }
}

