/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.IMyPublicKey;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509Extensions;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Name;

final class CertificationRequestInfo
extends DERSequence {
    private IMyPublicKey m_publicKey;
    private X509DistinguishedName m_subject;
    private X509Extensions m_extensions;

    public CertificationRequestInfo(X509DistinguishedName x509DistinguishedName, IMyPublicKey iMyPublicKey, X509Extensions x509Extensions) {
        super((DEREncodableVector)CertificationRequestInfo.createRequestInfo(new DERInteger(0), x509DistinguishedName.getX509Name(), iMyPublicKey.getAsSubjectPublicKeyInfo(), x509Extensions));
        this.m_subject = x509DistinguishedName;
        try {
            this.m_publicKey = AsymmetricCryptoKeyPair.createPublicKey(iMyPublicKey.getAsSubjectPublicKeyInfo());
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create public key: " + exception.getMessage());
        }
        this.m_extensions = x509Extensions;
    }

    CertificationRequestInfo(ASN1Sequence aSN1Sequence) {
        super((DEREncodableVector)CertificationRequestInfo.createRequestInfo(aSN1Sequence));
        try {
            this.m_publicKey = AsymmetricCryptoKeyPair.createPublicKey(SubjectPublicKeyInfo.getInstance((Object)aSN1Sequence.getObjectAt(2)));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create public key: " + exception.getMessage());
        }
        this.m_subject = new X509DistinguishedName(X509Name.getInstance((Object)this.getObjectAt(1)));
        DERObject dERObject = ((DERTaggedObject)this.getObjectAt(3)).getDERObject();
        this.m_extensions = dERObject instanceof DERSet ? new X509Extensions((DERSet)dERObject) : new X509Extensions(new DERSet());
    }

    public IMyPublicKey getPublicKey() {
        return this.m_publicKey;
    }

    public X509Extensions getExtensions() {
        return this.m_extensions;
    }

    public X509DistinguishedName getX509DistinguishedName() {
        return this.m_subject;
    }

    private static ASN1EncodableVector createRequestInfo(DERInteger dERInteger, X509Name x509Name, SubjectPublicKeyInfo subjectPublicKeyInfo, X509Extensions x509Extensions) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((DEREncodable)dERInteger);
        aSN1EncodableVector.add((DEREncodable)x509Name);
        aSN1EncodableVector.add((DEREncodable)subjectPublicKeyInfo);
        if (x509Extensions != null) {
            aSN1EncodableVector.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)x509Extensions.getBCExtensions()));
        }
        return aSN1EncodableVector;
    }

    private static ASN1EncodableVector createRequestInfo(ASN1Sequence aSN1Sequence) {
        DERInteger dERInteger = (DERInteger)aSN1Sequence.getObjectAt(0);
        X509Name x509Name = X509Name.getInstance((Object)aSN1Sequence.getObjectAt(1));
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)aSN1Sequence.getObjectAt(2));
        X509Extensions x509Extensions = null;
        if (aSN1Sequence.size() > 3) {
            x509Extensions = new X509Extensions((DERSet)ASN1Set.getInstance((ASN1TaggedObject)((DERTaggedObject)aSN1Sequence.getObjectAt(3)), (boolean)false));
        }
        return CertificationRequestInfo.createRequestInfo(dERInteger, x509Name, subjectPublicKeyInfo, x509Extensions);
    }
}

