/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools;

import anon.util.Base64;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import mixconfig.MixConfig;

public class CrimeLogProcessing
extends JAPDialog
implements Runnable {
    private JTextField m_tfLogFile;
    private JTextField m_tfOutputDir;
    private Pattern regexpLogLine;
    private JRadioButton m_radioFirstMix;
    private JRadioButton m_radioMiddleMix;
    private JRadioButton m_radioLastMix;
    private JProgressBar m_Progress;
    private DateFormat m_dateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.GERMANY);
    private DateFormat m_dateFormatLog = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss", Locale.GERMANY);
    private Hashtable<String, String> m_htDateChannels;
    private CrimeLogProcessing m_crimelogprocessingDlg = this;
    private int m_processedBytes;
    private JButton m_bttnDoIt;
    private Thread m_threadDoIt;
    private volatile boolean m_bRun;

    public CrimeLogProcessing(Frame parent) {
        super(parent, "Proccessing Tool for Law Enforcement Data", true);
        this.regexpLogLine = Pattern.compile("\\[(.+), .*\\] Crime detection: User surveillance, previous mix channel: (\\d+) - ([UpDown]+)stream Payload \\(Base64 encoded\\): (.+)$", 2);
        this.initComponents();
        this.pack();
        this.setVisible(true, false);
    }

    private void initComponents() {
        GridBagConstraints constraintsPanel = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel label = new JLabel("Logdatei:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 0;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)label, constraintsPanel);
        this.m_tfLogFile = new JTextField(30);
        constraintsPanel.gridx = 1;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 2;
        this.getContentPane().add((Component)this.m_tfLogFile, constraintsPanel);
        JButton bttn = new JButton("Select...");
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CrimeLogProcessing.this.doSelectLogFile();
            }
        });
        constraintsPanel.gridx = 2;
        constraintsPanel.gridy = 0;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 2;
        this.getContentPane().add((Component)bttn, constraintsPanel);
        label = new JLabel("Mix-Typ:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 2;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)label, constraintsPanel);
        JPanel panelButtons = new JPanel(new GridLayout(1, 3, 20, 0));
        constraintsPanel.gridx = 1;
        constraintsPanel.gridy = 2;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)panelButtons, constraintsPanel);
        ButtonGroup radioGroup = new ButtonGroup();
        this.m_radioFirstMix = new JRadioButton("erster Mix");
        this.m_radioFirstMix.setEnabled(false);
        radioGroup.add(this.m_radioFirstMix);
        panelButtons.add(this.m_radioFirstMix);
        this.m_radioMiddleMix = new JRadioButton("mittler Mix");
        radioGroup.add(this.m_radioMiddleMix);
        this.m_radioMiddleMix.setEnabled(false);
        panelButtons.add(this.m_radioMiddleMix);
        this.m_radioLastMix = new JRadioButton("letzter Mix");
        radioGroup.add(this.m_radioLastMix);
        panelButtons.add(this.m_radioLastMix);
        this.m_radioLastMix.setSelected(true);
        label = new JLabel("Ausgabeverzeichnis:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 3;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)label, constraintsPanel);
        this.m_tfOutputDir = new JTextField(30);
        constraintsPanel.gridx = 1;
        constraintsPanel.gridy = 3;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 2;
        this.getContentPane().add((Component)this.m_tfOutputDir, constraintsPanel);
        bttn = new JButton("Select...");
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CrimeLogProcessing.this.doSelectOutputDir();
            }
        });
        constraintsPanel.gridx = 2;
        constraintsPanel.gridy = 3;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        constraintsPanel.fill = 2;
        this.getContentPane().add((Component)bttn, constraintsPanel);
        label = new JLabel("Verarbeitung:");
        constraintsPanel.gridx = 0;
        constraintsPanel.gridy = 4;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 0.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)label, constraintsPanel);
        this.m_Progress = new JProgressBar();
        constraintsPanel.gridx = 1;
        constraintsPanel.gridwidth = 2;
        constraintsPanel.fill = 2;
        constraintsPanel.gridy = 4;
        constraintsPanel.anchor = 17;
        constraintsPanel.weightx = 1.0;
        constraintsPanel.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.m_Progress, constraintsPanel);
        panelButtons = new JPanel(new GridLayout(1, 2, 20, 0));
        constraintsPanel.gridy = 5;
        constraintsPanel.gridx = 0;
        constraintsPanel.weighty = 0.0;
        constraintsPanel.gridwidth = 0;
        constraintsPanel.fill = 0;
        constraintsPanel.anchor = 14;
        this.getContentPane().add((Component)panelButtons, constraintsPanel);
        this.m_bttnDoIt = new JButton("Ausf\u00fchren");
        panelButtons.add(this.m_bttnDoIt);
        this.m_bttnDoIt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CrimeLogProcessing.this.m_bttnDoIt.setEnabled(false);
                CrimeLogProcessing.this.doIt();
            }
        });
        bttn = new JButton("Beenden");
        panelButtons.add(bttn);
        bttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CrimeLogProcessing.this.m_bRun = false;
                if (CrimeLogProcessing.this.m_threadDoIt != null) {
                    try {
                        CrimeLogProcessing.this.m_threadDoIt.join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                CrimeLogProcessing.this.dispose();
            }
        });
    }

    private void doIt() {
        this.m_bRun = true;
        this.m_threadDoIt = new Thread((Runnable)this, "Thread process law enforcement data");
        this.m_threadDoIt.setDaemon(true);
        this.m_threadDoIt.start();
    }

    @Override
    public void run() {
        this.m_htDateChannels = new Hashtable();
        BufferedReader reader = null;
        boolean ret = false;
        try {
            File fileLog = new File(this.m_tfLogFile.getText());
            final long filesize = fileLog.length();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    CrimeLogProcessing.this.m_Progress.setMaximum((int)filesize);
                }
            });
            reader = new LineNumberReader(new FileReader(fileLog));
            File outputDir = new File(this.m_tfOutputDir.getText());
            String currentLine = null;
            this.m_processedBytes = 0;
            while ((currentLine = ((LineNumberReader)reader).readLine()) != null && this.m_bRun) {
                if (!this.processLine(currentLine, outputDir)) {
                    ret = false;
                    break;
                }
                this.m_processedBytes += currentLine.length();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CrimeLogProcessing.this.m_Progress.setValue(CrimeLogProcessing.this.m_processedBytes);
                    }
                });
            }
            ret = true;
        }
        catch (Throwable t) {
            ret = false;
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (!ret) {
            JAPDialog.showErrorDialog((JAPDialog)this.m_crimelogprocessingDlg, "Ein Fehler ist aufgetreten.\nBitte \u00fcberpr\u00fcfen Sie, ob die Log-Datei existiert und lesbar ist. Pr\u00fcfen Sie auch, ob das Ausgabeverzeichnis existiert und schreibbar ist.");
        } else if (this.m_bRun) {
            JAPDialog.showMessageDialog(this.m_crimelogprocessingDlg, "Verarbeitung erfolgreich beendet!");
        }
    }

    private boolean processLine(String currentLine, File outputDir) {
        if (!currentLine.contains("Crime detection: User surveillance, previous mix channel")) {
            return true;
        }
        boolean bUpstream = false;
        String strChannel = null;
        String strDate = null;
        String strPayloadBase64 = null;
        Matcher matcher = this.regexpLogLine.matcher(currentLine);
        if (!matcher.find()) {
            return true;
        }
        strDate = matcher.group(1);
        strChannel = matcher.group(2);
        bUpstream = "Up".equals(matcher.group(3));
        strPayloadBase64 = matcher.group(4);
        String strTmp = this.m_htDateChannels.get(strChannel);
        if (strTmp == null) {
            try {
                strTmp = this.m_dateFormat.format(this.m_dateFormatLog.parse(strDate));
            }
            catch (Throwable t) {
                return false;
            }
            this.m_htDateChannels.put(strChannel, strTmp);
        } else {
            try {
                Date dateCurrent = this.m_dateFormatLog.parse(strDate);
                Date dateOpen = this.m_dateFormat.parse(strTmp);
                if (dateCurrent.getTime() - dateOpen.getTime() > 3600000L) {
                    System.out.println("Problem with channel opening times for channel: " + strChannel + "Open time: " + strTmp + " Current Record Time: " + strDate);
                }
            }
            catch (Throwable t) {
                System.out.println("Something is wrong");
            }
        }
        String strFilenameForChannel = strTmp + " -- " + strChannel;
        strFilenameForChannel = bUpstream ? strFilenameForChannel + ".sent" : strFilenameForChannel + ".received";
        try {
            FileOutputStream fileOut = new FileOutputStream(outputDir + "/" + strFilenameForChannel, true);
            byte[] payload = Base64.decode(strPayloadBase64);
            fileOut.write(payload);
            fileOut.close();
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    private void doSelectLogFile() {
        File f;
        JFileChooser fileChosser = MixConfig.showFileDialog(this.getOwner(), 2, 0);
        if (fileChosser != null && (f = fileChosser.getSelectedFile()) != null) {
            this.m_tfLogFile.setText(f.getAbsolutePath());
        }
    }

    private void doSelectOutputDir() {
        File f;
        JFileChooser fileChosser = MixConfig.showFileDialog(this.getOwner(), 3, 0);
        if (fileChosser != null && (f = fileChosser.getSelectedFile()) != null) {
            this.m_tfOutputDir.setText(f.getAbsolutePath());
        }
    }
}

