/*
 * Decompiled with CFR 0.152.
 */
package gui.wizard;

import anon.util.JAPMessages;
import gui.dialog.JAPDialog;
import gui.wizard.Wizard;
import gui.wizard.WizardHost;
import gui.wizard.WizardPage;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class BasicWizardHost
implements WizardHost,
ActionListener {
    private JAPDialog m_Dialog;
    private JButton m_bttnOk;
    private JButton m_bttnCancel;
    private JButton m_bttnFinish;
    private JButton m_bttnBack;
    private JButton m_bttnNext;
    private JButton m_bttnHelp;
    private JPanel m_panelPages;
    private CardLayout m_cardlayoutPages;
    private Wizard m_Wizard;
    private static final String COMMAND_NEXT = "NEXT";
    private static final String COMMAND_BACK = "BACK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private static final String COMMAND_FINISH = "FINISH";
    private static final String COMMAND_HELP = "HELP";

    public BasicWizardHost(JAPDialog a_dialog, Wizard a_wizard) {
        this((Object)a_dialog, a_wizard);
    }

    public BasicWizardHost(Component a_dialog, Wizard a_wizard) {
        this((Object)a_dialog, a_wizard);
    }

    private BasicWizardHost(Object parent, Wizard wizard) {
        this.m_Wizard = wizard;
        this.m_Dialog = parent instanceof JAPDialog ? new JAPDialog((JAPDialog)parent, wizard.getWizardTitle(), true) : new JAPDialog((Component)parent, wizard.getWizardTitle(), true);
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.m_Dialog.setDefaultCloseOperation(0);
        this.m_Dialog.getContentPane().setLayout(gridBag);
        GridBagLayout gridBagPanel = new GridBagLayout();
        GridBagConstraints cPanel = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(gridBagPanel);
        this.m_bttnBack = new JButton(JAPMessages.getString("updateM_bttnBack"));
        this.m_bttnBack.setActionCommand(COMMAND_BACK);
        this.m_bttnBack.addActionListener(this);
        this.m_bttnNext = new JButton(JAPMessages.getString("updateM_bttnNext"));
        this.m_bttnNext.setActionCommand(COMMAND_NEXT);
        this.m_bttnNext.addActionListener(this);
        this.m_bttnHelp = new JButton(JAPMessages.getString("updateM_bttnHelp"));
        this.m_bttnCancel = new JButton(JAPMessages.getString("updateM_bttnCancel"));
        this.m_bttnCancel.setActionCommand(COMMAND_CANCEL);
        this.m_bttnCancel.addActionListener(this);
        this.m_bttnFinish = new JButton(JAPMessages.getString("updateM_bttnFinish"));
        this.m_bttnFinish.setActionCommand(COMMAND_FINISH);
        this.m_bttnFinish.addActionListener(this);
        JSeparator separator = new JSeparator();
        separator.setVisible(true);
        this.m_cardlayoutPages = new CardLayout();
        this.m_panelPages = new JPanel(this.m_cardlayoutPages);
        cPanel.gridx = 0;
        cPanel.gridy = 0;
        cPanel.fill = 0;
        cPanel.anchor = 17;
        cPanel.weightx = 0.0;
        cPanel.weighty = 1.0;
        cPanel.insets = new Insets(10, 10, 10, 10);
        panel.add((Component)this.m_bttnHelp, cPanel);
        JLabel l = new JLabel("");
        cPanel.weightx = 1.0;
        cPanel.gridx = 1;
        cPanel.fill = 2;
        panel.add((Component)l, cPanel);
        cPanel.weightx = 0.0;
        cPanel.fill = 0;
        cPanel.gridx = 2;
        cPanel.insets = new Insets(10, 10, 10, 20);
        panel.add((Component)this.m_bttnCancel, cPanel);
        cPanel.gridx = 3;
        cPanel.insets = new Insets(10, 2, 10, 2);
        panel.add((Component)this.m_bttnBack, cPanel);
        cPanel.gridx = 4;
        panel.add((Component)this.m_bttnNext, cPanel);
        cPanel.gridx = 5;
        cPanel.insets = new Insets(10, 20, 10, 10);
        panel.add((Component)this.m_bttnFinish, cPanel);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 10, 10, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        gridBag.setConstraints(this.m_panelPages, c);
        this.m_Dialog.getContentPane().add(this.m_panelPages);
        c.gridy = 1;
        c.fill = 2;
        c.weighty = 0.0;
        c.insets = new Insets(0, 10, 0, 10);
        gridBag.setConstraints(separator, c);
        this.m_Dialog.getContentPane().add(separator);
        c.gridy = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        gridBag.setConstraints(panel, c);
        this.m_Dialog.getContentPane().add(panel);
    }

    public void addWizardPage(int index, WizardPage wizardPage) {
        this.m_panelPages.add((Component)wizardPage.getPageComponent(), Integer.toString(index));
    }

    public void showWizardPage(int index) {
        if (index == 0) {
            this.m_cardlayoutPages.first(this.m_panelPages);
            this.m_Dialog.pack();
            this.m_Dialog.setVisible(true);
        } else {
            this.m_cardlayoutPages.show(this.m_panelPages, Integer.toString(index));
            this.m_Dialog.pack();
        }
    }

    public JAPDialog getDialogParent() {
        return this.m_Dialog;
    }

    public void setHelpEnabled(boolean enabled) {
        this.m_bttnHelp.setEnabled(enabled);
    }

    public void setNextEnabled(boolean enabled) {
        this.m_bttnNext.setEnabled(enabled);
    }

    public void setBackEnabled(boolean b) {
        this.m_bttnBack.setEnabled(b);
    }

    public void setCancelEnabled(boolean b) {
        this.m_bttnCancel.setEnabled(b);
    }

    public void setFinishEnabled(boolean b) {
        this.m_bttnFinish.setEnabled(b);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(COMMAND_NEXT)) {
            this.m_Wizard.next();
        } else if (command.equals(COMMAND_BACK)) {
            this.m_Wizard.back();
        } else if (command.equals(COMMAND_CANCEL)) {
            this.doCancel();
        } else if (command.equals(COMMAND_FINISH)) {
            this.m_Wizard.finish();
        } else if (command.equals(COMMAND_HELP)) {
            // empty if block
        }
    }

    public void lockDialog() {
        this.m_Dialog.setEnabled(false);
    }

    public void unlockDialog() {
        this.m_Dialog.setEnabled(true);
    }

    public void doCancel() {
        this.m_Wizard.wizardCompleted();
        this.m_Dialog.dispose();
    }
}

