/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainView;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.MinimalHTMLWriter;

public class JAPHtmlMultiLineLabel
extends JLabel {
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD = 1;
    public static final String TAG_BREAK = "<br>";
    public static final String TAG_A_OPEN = "<a href=\"\">";
    public static final String TAG_A_CLOSE = "</a>";
    public static final int UNLIMITED_LABEL_HEIGHT = 5000;
    private static final String TAG_HTML_OPEN = "<html>";
    private static final String TAG_HTML_CLOSE = "</html>";
    private static final String TAG_BODY_OPEN = "<body>";
    private static final String TAG_BODY_CLOSE = "</body>";
    private static final String TAG_HEAD_OPEN = "<head>";
    private static final String TAG_HEAD_CLOSE = "</head>";
    private static final String CLIENT_PROPERTY_HTML = "html";
    private static final String CURRENT_JAVA_VENDOR = System.getProperty("java.vendor");
    private static final String CURRENT_JAVA_VERSION = System.getProperty("java.version");
    private static final boolean HTML_COMPATIBILITY_MODE;
    private boolean m_bInitialised = false;
    private String m_rawText;

    public JAPHtmlMultiLineLabel(String a_text, Font a_defaultFont, int a_alignment) {
        super("", a_alignment);
        this.m_rawText = a_text;
        this.setFont(a_defaultFont);
    }

    public JAPHtmlMultiLineLabel(String a_text, Font a_defaultFont) {
        this(a_text, a_defaultFont, 2);
    }

    public JAPHtmlMultiLineLabel(String a_text, int a_alignment) {
        this(a_text, (Font)null, a_alignment);
    }

    public JAPHtmlMultiLineLabel(int a_alignment) {
        this((String)null, (Font)null, a_alignment);
    }

    public JAPHtmlMultiLineLabel(String a_text) {
        this(a_text, (Font)null, 2);
    }

    public JAPHtmlMultiLineLabel() {
        this("", (Font)null, 2);
    }

    public void setText(String a_newText) {
        if (!this.m_bInitialised) {
            this.m_bInitialised = true;
            super.setText(JAPHtmlMultiLineLabel.formatTextAsHTML(a_newText, this.getFont()));
        } else {
            this.m_rawText = a_newText;
            this.setFont(this.getFont());
        }
    }

    public int getHTMLDocumentLength() {
        return ((View)this.getClientProperty(CLIENT_PROPERTY_HTML)).getDocument().getLength();
    }

    public String getHTMLDocumentText() {
        String text;
        HTMLDocument document = (HTMLDocument)((View)this.getClientProperty(CLIENT_PROPERTY_HTML)).getDocument();
        try {
            text = document.getText(0, document.getLength());
            if (text.charAt(text.length() - 1) == '\n') {
                text = text.substring(0, text.length() - 1);
            }
            if (text.charAt(0) == '\n') {
                text = text.substring(1, text.length());
            }
        }
        catch (BadLocationException a_e) {
            text = null;
        }
        return text;
    }

    public void cutHTMLDocument(int a_length) {
        StringWriter writer = new StringWriter();
        HTMLDocument document = (HTMLDocument)((View)this.getClientProperty(CLIENT_PROPERTY_HTML)).getDocument();
        if (a_length > document.getLength()) {
            return;
        }
        if (a_length <= 0) {
            this.setText("");
            return;
        }
        try {
            document.remove(a_length, document.getLength() - a_length);
            MinimalHTMLWriter aw = new MinimalHTMLWriter((Writer)writer, document);
            aw.write();
            this.setText(writer.toString());
        }
        catch (Exception a_e) {
            JAPDialog.showErrorDialog((Component)this, (Throwable)a_e);
        }
    }

    public void setPreferredWidth(int a_width) {
        View htmlView = (View)this.getClientProperty(CLIENT_PROPERTY_HTML);
        float x = htmlView.getPreferredSpan(0);
        float y = htmlView.getPreferredSpan(1);
        try {
            htmlView.setSize(a_width, 5000.0f);
        }
        catch (NullPointerException a_e) {
            PlainView dummyView = new PlainView(htmlView.getElement()){

                public Container getContainer() {
                    return null;
                }
            };
            htmlView.getView(0).setParent(dummyView);
            htmlView.setSize(x, y);
            htmlView.setSize(a_width, 5000.0f);
            htmlView.getView(0).setParent(htmlView);
        }
        this.invalidate();
    }

    public void setFontStyle(int a_style) {
        this.setFont(new Font(this.getFont().getName(), a_style, this.getFont().getSize()));
    }

    public void setFont(Font a_defaultFont) {
        if (a_defaultFont == null) {
            a_defaultFont = new JLabel().getFont();
        }
        if (HTML_COMPATIBILITY_MODE && a_defaultFont.isBold() && a_defaultFont.getSize() >= 16 && a_defaultFont.getSize() <= 18) {
            Font replacedFont = new Font(a_defaultFont.getName(), 0, a_defaultFont.getSize());
            super.setFont(replacedFont);
            super.setText(JAPHtmlMultiLineLabel.formatTextAsHTML(this.m_rawText, replacedFont));
        } else {
            super.setFont(a_defaultFont);
            super.setText(JAPHtmlMultiLineLabel.formatTextAsHTML(this.m_rawText, a_defaultFont));
        }
    }

    public static String formatTextAsHTML(String a_HTMLtext, Font a_defaultFont) {
        if (a_HTMLtext == null) {
            return a_HTMLtext;
        }
        if (a_HTMLtext.trim().length() == 0) {
            return "";
        }
        if (a_defaultFont == null) {
            a_defaultFont = new JLabel().getFont();
        }
        int size = a_defaultFont.getSize();
        String strSize = "-1";
        strSize = size < 13 ? "-1" : (size < 16 ? "+0" : (size < 19 ? "+1" : (size < 26 ? "+2" : "+3")));
        String header = TAG_HTML_OPEN + TAG_BODY_OPEN.substring(0, TAG_BODY_OPEN.length() - 1) + (HTML_COMPATIBILITY_MODE ? "><font size=" + strSize + ">" : " style=\"font-size:" + size + "pt;" + "font-family:" + a_defaultFont.getFamily() + "\">");
        String trailer = "</body></html>";
        if (a_defaultFont.isBold()) {
            header = header + "<b>";
            trailer = "</b>" + trailer;
        }
        return header + JAPHtmlMultiLineLabel.removeHTMLHEADAndBODYTags(a_HTMLtext) + trailer;
    }

    public static String removeTagsAndNewLines(String a_text) {
        if (a_text == null) {
            return null;
        }
        String text = a_text;
        while (true) {
            int indexTagBegin = text.indexOf("<");
            int indexTagEnd = text.indexOf(">");
            if (indexTagBegin < 0 && indexTagEnd < 0) break;
            if (indexTagEnd >= 0 && (indexTagBegin < 0 || indexTagEnd < indexTagBegin)) {
                indexTagBegin = indexTagEnd;
            } else if (indexTagEnd < 0) {
                indexTagEnd = indexTagBegin;
            }
            if (++indexTagEnd >= text.length()) {
                text = text.substring(0, indexTagBegin);
                continue;
            }
            text = text.substring(0, indexTagBegin) + text.substring(indexTagEnd, text.length());
        }
        StringTokenizer tokenizer = new StringTokenizer(text, "\t\n\r\f");
        text = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            text = text + token;
        }
        return text.trim();
    }

    public static String removeHTMLHEADAndBODYTags(String a_HTMLtext) {
        if (a_HTMLtext == null || a_HTMLtext.trim().length() == 0) {
            return a_HTMLtext;
        }
        String HTMLText = a_HTMLtext.toLowerCase();
        int headStart = HTMLText.indexOf(TAG_HEAD_OPEN.substring(0, TAG_HEAD_OPEN.length() - 1));
        int headEnd = HTMLText.indexOf(TAG_HEAD_CLOSE);
        if (headStart >= 0 || headEnd >= 0) {
            if (headStart < 0 || headEnd < 0 || headStart >= headEnd) {
                return "";
            }
            int remainderStart = headEnd + TAG_HEAD_CLOSE.length();
            a_HTMLtext = headStart == 0 ? a_HTMLtext.substring(remainderStart, a_HTMLtext.length() - remainderStart) : (remainderStart == a_HTMLtext.length() ? a_HTMLtext.substring(0, headStart) : a_HTMLtext.substring(0, headStart) + a_HTMLtext.substring(remainderStart, a_HTMLtext.length()));
        }
        return JAPHtmlMultiLineLabel.removeTAG(JAPHtmlMultiLineLabel.removeTAG(a_HTMLtext, TAG_HTML_OPEN, TAG_HTML_CLOSE), TAG_BODY_OPEN, TAG_BODY_CLOSE);
    }

    private static String removeTAG(String a_HTMLtext, String a_openTAG, String a_closeTAG) {
        if (a_HTMLtext == null || (a_HTMLtext = a_HTMLtext.trim()).length() == 0) {
            return a_HTMLtext;
        }
        String strOpenTagWithoutBrace = a_openTAG.substring(0, a_openTAG.length() - 1);
        String strTemp = a_HTMLtext.toLowerCase();
        int start = 0;
        int stop = a_HTMLtext.length();
        if (strTemp.startsWith(strOpenTagWithoutBrace)) {
            start = strTemp.indexOf(">") + 1;
        }
        if (strTemp.endsWith(a_closeTAG)) {
            stop -= a_closeTAG.length();
        }
        if (start > 0 || stop < a_HTMLtext.length()) {
            a_HTMLtext = start < 0 || stop < 0 || start >= stop ? "" : a_HTMLtext.substring(start, stop).trim();
        }
        return a_HTMLtext;
    }

    static {
        String version = System.getProperty("java.version");
        HTML_COMPATIBILITY_MODE = version != null && version.compareTo("1.3") < 0;
    }
}

