/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.JAPMessages;
import java.util.Locale;

public abstract class AbstractISOCodeMapper {
    private final int MAX_LENGTH;
    private boolean m_bUseDefaultLocale;
    private String m_iso2;
    private Locale m_locale;

    public AbstractISOCodeMapper() {
        this(null, 0);
    }

    public AbstractISOCodeMapper(int a_maxTextLength) {
        this(null, a_maxTextLength);
    }

    public AbstractISOCodeMapper(String a_ISOCode, int a_maxTextLength) throws IllegalArgumentException {
        this(a_ISOCode, a_maxTextLength, null);
    }

    public AbstractISOCodeMapper(String a_ISOCode) throws IllegalArgumentException {
        this(a_ISOCode, 0, null);
    }

    public AbstractISOCodeMapper(String a_ISOCode, Locale a_locale) throws IllegalArgumentException {
        this(a_ISOCode, 0, a_locale);
    }

    public AbstractISOCodeMapper(String a_ISOCode, int a_maxTextLength, Locale a_locale) throws IllegalArgumentException {
        this.MAX_LENGTH = a_maxTextLength;
        if (a_ISOCode == null || a_ISOCode.trim().length() == 0) {
            a_ISOCode = "";
        }
        if (a_ISOCode.length() > 0 && a_ISOCode.length() != 2) {
            throw new IllegalArgumentException("Mapped ISO code must have a length of two characters!");
        }
        this.m_iso2 = a_ISOCode.trim().toUpperCase();
        if (a_locale == null) {
            this.m_bUseDefaultLocale = true;
            this.m_locale = JAPMessages.getLocale();
        } else {
            this.m_bUseDefaultLocale = false;
            this.m_locale = a_locale;
        }
    }

    public final String getISOCode() {
        return this.m_iso2.toLowerCase();
    }

    public final boolean equals(Object a_object) {
        if (a_object == null || !(a_object instanceof AbstractISOCodeMapper)) {
            return false;
        }
        return this.getISOCode().equals(((AbstractISOCodeMapper)a_object).getISOCode());
    }

    public final int hashCode() {
        return this.getISOCode().hashCode();
    }

    protected abstract String getChooseMessage();

    protected abstract String getJRETransaltionOfISOCode(String var1, Locale var2);

    public final String toString() {
        String strCName;
        if (this.m_iso2.length() == 0) {
            strCName = this.getChooseMessage();
        } else {
            String temp;
            Locale locale = this.m_bUseDefaultLocale ? JAPMessages.getLocale() : this.m_locale;
            strCName = this.getJRETransaltionOfISOCode(this.m_iso2, locale);
            if ((strCName == null || strCName.trim().length() == 0 || strCName.equals(this.m_iso2) || strCName.equals(this.getJRETransaltionOfISOCode("AA", locale)) && strCName.equals(this.getJRETransaltionOfISOCode("ZZ", locale))) && (strCName = JAPMessages.getString(temp = this.getClass().getName() + "_" + this.m_iso2)).equals(temp)) {
                strCName = this.m_iso2;
            }
        }
        if (this.MAX_LENGTH > 0 && strCName.length() > this.MAX_LENGTH) {
            strCName = strCName.substring(0, this.MAX_LENGTH);
        }
        if (strCName != null && strCName.length() > 1) {
            strCName = strCName.substring(0, 1).toUpperCase() + strCName.substring(1, strCName.length());
        }
        return strCName;
    }
}

