/*
 * Decompiled with CFR 0.152.
 */
package anon.transport.connection.util;

import anon.transport.connection.ConnectionException;
import anon.transport.connection.IChunkWriter;
import anon.util.ObjectQueue;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class QueuedChunkWriter
implements IChunkWriter {
    private final ObjectQueue m_writingQueue;
    private volatile boolean m_isClosed;
    private final Vector m_waitingThreads;
    private int m_timeout;

    public QueuedChunkWriter(ObjectQueue a_writingQueue, int a_timeout) {
        this.m_writingQueue = a_writingQueue;
        this.m_isClosed = false;
        this.m_waitingThreads = new Vector();
        this.m_timeout = a_timeout;
    }

    public QueuedChunkWriter(ObjectQueue a_writingQueue) {
        this.m_writingQueue = a_writingQueue;
        this.m_isClosed = false;
        this.m_waitingThreads = new Vector();
        this.m_timeout = 0;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(int a_value) {
        this.m_timeout = a_value;
    }

    public void writeChunk(byte[] a_chunk) throws ConnectionException {
        Thread caller = Thread.currentThread();
        try {
            try {
                this.m_waitingThreads.addElement(caller);
                if (this.m_isClosed) {
                    throw new ConnectionException("Writer already closed");
                }
                this.m_writingQueue.push(a_chunk);
            }
            catch (Exception e) {
                throw new ConnectionException("Interrupted while writing. Probably closed Writer.");
            }
            Object var5_3 = null;
            boolean removed = this.m_waitingThreads.removeElement(caller);
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            boolean removed = this.m_waitingThreads.removeElement(caller);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        QueuedChunkWriter queuedChunkWriter = this;
        synchronized (queuedChunkWriter) {
            if (this.m_isClosed) {
                return;
            }
            this.m_isClosed = true;
        }
        Enumeration allthreads = this.m_waitingThreads.elements();
        while (allthreads.hasMoreElements()) {
            ((Thread)allthreads.nextElement()).interrupt();
        }
    }
}

