/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLEmail
implements IXMLEncodable {
    private String m_senderName;
    private String m_replyAddress;
    private String m_bodyText;
    private String m_receiverAddress;
    private String m_subject;
    private String m_senderIdentification;
    private Document m_docTheEmail;
    public static String ms_strElemName = "Email";

    public XMLEmail(String senderName, String replyAddress, String bodyText, String senderIdentification) {
        this.m_senderName = senderName;
        this.m_replyAddress = replyAddress;
        this.m_bodyText = bodyText;
        this.m_senderIdentification = senderIdentification;
        this.setDefaultValues();
        this.m_docTheEmail = XMLUtil.createDocument();
        this.m_docTheEmail.appendChild(this.internal_toXmlElement(this.m_docTheEmail));
    }

    public XMLEmail(String senderName, String replyAddress, String bodyText, String receiverAddress, String subject, String senderIdentification) {
        this.m_senderName = senderName;
        this.m_replyAddress = replyAddress;
        this.m_bodyText = bodyText;
        this.m_receiverAddress = receiverAddress;
        this.m_subject = subject;
        this.m_senderIdentification = senderIdentification;
        this.setDefaultValues();
        this.m_docTheEmail = XMLUtil.createDocument();
        this.m_docTheEmail.appendChild(this.internal_toXmlElement(this.m_docTheEmail));
    }

    private void setDefaultValues() {
        if (this.m_receiverAddress == null || this.m_receiverAddress.equals("")) {
            this.m_receiverAddress = "jap@inf.tu-dresden.de";
        }
        if (this.m_replyAddress == null || this.m_replyAddress.equals("")) {
            this.m_replyAddress = "no return";
        }
        if (this.m_senderName == null || this.m_senderName.equals("")) {
            this.m_senderName = "Unknown Sender";
        }
        if (this.m_subject == null || this.m_subject.equals("")) {
            this.m_subject = "AN.ON support request";
        }
        if (this.m_bodyText == null || this.m_bodyText.equals("")) {
            this.m_bodyText = "message is empty";
        }
    }

    private Node internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(ms_strElemName);
        Element elem = a_doc.createElement("SenderName");
        XMLUtil.setValue((Node)elem, this.m_senderName);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("ReplyAddress");
        XMLUtil.setValue((Node)elem, this.m_replyAddress);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("ReceiverAddress");
        XMLUtil.setValue((Node)elem, this.m_receiverAddress);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Subject");
        XMLUtil.setValue((Node)elem, this.m_subject);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("BodyText");
        XMLUtil.setValue((Node)elem, this.m_bodyText);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("SenderIdentification");
        XMLUtil.setValue((Node)elem, this.m_senderIdentification);
        elemRoot.appendChild(elem);
        return elemRoot;
    }

    public XMLEmail(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheEmail = doc;
    }

    public XMLEmail(char[] xmldata) throws Exception {
        this(new String(xmldata));
    }

    public XMLEmail(byte[] xmldata) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xmldata);
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheEmail = doc;
    }

    public XMLEmail(Element xml) throws Exception {
        this.setValues(xml);
        this.m_docTheEmail = XMLUtil.createDocument();
        this.m_docTheEmail.appendChild(XMLUtil.importNode(this.m_docTheEmail, xml, true));
    }

    public XMLEmail(Document xml) throws Exception {
        Element elemRoot = xml.getDocumentElement();
        this.setValues(elemRoot);
        this.m_docTheEmail = xml;
    }

    public String getSenderName() {
        return this.m_senderName;
    }

    public String getReplyAddress() {
        return this.m_replyAddress;
    }

    public String getReceiverAddress() {
        return this.m_receiverAddress;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public String getBodyText() {
        return this.m_bodyText;
    }

    public String getSenderIdentification() {
        return this.m_senderIdentification;
    }

    private void setValues(Element xml) throws Exception {
        if (!xml.getTagName().equals("Email")) {
            throw new Exception("XMLEmail: cannot parse, wrong xml format!");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(xml, "SenderName");
        this.m_senderName = XMLUtil.parseValue((Node)elem, "");
        if (this.m_senderName.equals("")) {
            throw new Exception("XMLEmail: cannot parse the sender name");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "ReceiverAddress");
        this.m_receiverAddress = XMLUtil.parseValue((Node)elem, "");
        if (this.m_receiverAddress.equals("")) {
            throw new Exception("XMLEmail: cannot parse the receiver address");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "ReplyAddress");
        this.m_replyAddress = XMLUtil.parseValue((Node)elem, "");
        if (this.m_replyAddress.equals("")) {
            throw new Exception("XMLEmail: cannot parse the reply address");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "Subject");
        this.m_subject = XMLUtil.parseValue((Node)elem, "");
        if (this.m_subject.equals("")) {
            throw new Exception("XMLEmail: cannot parse the Subject");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "BodyText");
        this.m_bodyText = XMLUtil.parseValue((Node)elem, "");
        if (this.m_bodyText.equals("")) {
            throw new Exception("XMLEmail: cannot parse the body text");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "SenderIdentification");
        this.m_senderIdentification = XMLUtil.parseValue((Node)elem, "");
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheEmail.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }
}

