/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import HTTPClient.Codecs;
import HTTPClient.NVPair;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.util.IPasswordReader;
import anon.util.IXMLEncodable;
import anon.util.StoredPasswordReader;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class ProxyInterface
extends ListenerInterface
implements ImmutableProxyInterface,
IXMLEncodable,
Cloneable {
    private static String XML_USE_AUTHENTICATION = "UseAuthentication";
    private static String XML_USE_PROXY = "UseProxy";
    private static String XML_AUTHENTICATION_USER_ID = "AuthenticationUserID";
    private static String XML_AUTHENTICATION_PASSWORD = "AuthenticationPassword";
    private ListenerInterface m_listenerInterface;
    private String m_authenticationPassword = null;
    private String m_authenticationUserID = null;
    private boolean m_bUseAuthentication = false;
    private boolean m_bUseInterface = true;
    private IPasswordReader m_passwordReader;
    private static final long AUTH_PASS_CANCEL_WAIT_TIME = 6000L;
    private volatile long m_authPassLastCancelTime = 0L;
    private boolean m_bAuthPassDialogShown = false;

    public ProxyInterface(Element a_proxyInterfaceNode, IPasswordReader a_passwordReader) throws XMLParseException {
        super(a_proxyInterfaceNode);
        this.m_passwordReader = a_passwordReader;
        try {
            this.setAuthenticationUserID(XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_proxyInterfaceNode, XML_AUTHENTICATION_USER_ID), null));
        }
        catch (IllegalStateException a_e) {
            this.setAuthenticationUserID(null);
        }
        try {
            this.setUseAuthentication(Boolean.valueOf(XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_proxyInterfaceNode, XML_USE_AUTHENTICATION), null)));
        }
        catch (IllegalStateException a_e) {
            this.setUseAuthentication(false);
        }
        this.setUseInterface(Boolean.valueOf(XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_proxyInterfaceNode, XML_USE_PROXY), null)));
        this.m_listenerInterface = new ListenerInterface(this.getHost(), this.getPort(), this.getProtocol()){

            public String getHost() {
                return ProxyInterface.this.getHost();
            }

            public int getPort() {
                return ProxyInterface.this.getPort();
            }

            public int getProtocol() {
                return ProxyInterface.this.getProtocol();
            }
        };
    }

    public ProxyInterface(String a_hostname, int a_port, IPasswordReader a_passwordReader) throws IllegalArgumentException {
        this(a_hostname, a_port, 1, a_passwordReader);
    }

    public ProxyInterface(ListenerInterface a_proxyInterface, IPasswordReader a_passwordReader) throws IllegalArgumentException {
        this(a_proxyInterface != null ? a_proxyInterface.getHost() : null, a_proxyInterface != null ? a_proxyInterface.getPort() : -1, a_proxyInterface != null ? a_proxyInterface.getProtocol() : 1, a_passwordReader);
    }

    public ProxyInterface(String a_hostname, int a_port, int a_protocol, IPasswordReader a_passwordReader) throws IllegalArgumentException {
        this(a_hostname, a_port, a_protocol, null, a_passwordReader, false, true);
    }

    public ProxyInterface(String a_hostname, int a_port, String a_protocol, String a_authenticationUserID, IPasswordReader a_passwordReader, boolean a_bUseAuthentication, boolean a_bIsValid) throws IllegalArgumentException {
        this(a_hostname, a_port, ListenerInterface.recognizeProtocol(a_protocol), a_authenticationUserID, a_passwordReader, a_bUseAuthentication, a_bIsValid);
    }

    public ProxyInterface(String a_hostname, int a_port, int a_protocol, String a_authenticationUserID, IPasswordReader a_passwordReader, boolean a_bUseAuthentication, boolean a_bIsValid) throws IllegalArgumentException {
        super(a_hostname, a_port, a_protocol);
        this.m_passwordReader = a_passwordReader;
        this.setAuthenticationUserID(a_authenticationUserID);
        this.setUseAuthentication(a_bUseAuthentication);
        this.setUseInterface(a_bIsValid);
        this.m_listenerInterface = new ListenerInterface(this.getHost(), this.getPort(), this.getProtocol()){

            public String getHost() {
                return ProxyInterface.this.getHost();
            }

            public int getPort() {
                return ProxyInterface.this.getPort();
            }

            public int getProtocol() {
                return ProxyInterface.this.getProtocol();
            }
        };
    }

    public static String getXMLElementName() {
        return "ProxyInterface";
    }

    public static boolean isValidUserID(String a_authenticationUserID) {
        return a_authenticationUserID != null && a_authenticationUserID.trim().length() > 0;
    }

    public boolean isAuthenticationUsed() {
        return this.m_bUseAuthentication;
    }

    public boolean isAuthenticationPasswordSaveable() {
        return this.m_passwordReader instanceof StoredPasswordReader;
    }

    public boolean setUseAuthentication(boolean a_bUseAuthentication) throws IllegalStateException {
        if (!this.isAuthenticationUsed() && a_bUseAuthentication) {
            String exception = null;
            if (this.m_passwordReader == null) {
                exception = "No password reader!";
            }
            if (this.getProtocol() != 1 && this.getProtocol() != 3) {
                exception = "Wrong protocol type!";
            }
            if (!ProxyInterface.isValidUserID(this.getAuthenticationUserID())) {
                exception = "Invalid user ID!";
            }
            if (exception != null) {
                throw new IllegalStateException(": Cannot set proxy authentication! " + exception);
            }
        }
        this.m_bUseAuthentication = a_bUseAuthentication;
        return this.m_bUseAuthentication;
    }

    public ListenerInterface getListenerInterface() {
        return this.m_listenerInterface;
    }

    public String getAuthenticationPassword() throws IllegalStateException {
        return this.getAuthenticationPassword(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAuthenticationPassword(boolean skipUserInteraction) throws IllegalStateException {
        if (!(this.m_passwordReader instanceof StoredPasswordReader) && skipUserInteraction) {
            return this.m_authenticationPassword;
        }
        if (this.m_passwordReader == null) {
            throw new IllegalStateException("No password reader!");
        }
        if (this.m_authPassLastCancelTime >= System.currentTimeMillis()) {
            return this.m_authenticationPassword;
        }
        ProxyInterface proxyInterface = this;
        synchronized (proxyInterface) {
            if (this.m_bAuthPassDialogShown) {
                return this.m_authenticationPassword;
            }
            this.m_bAuthPassDialogShown = true;
        }
        if (this.m_authenticationPassword == null || this.m_authenticationPassword.length() == 0) {
            this.m_authenticationPassword = this.m_passwordReader.readPassword(this);
        }
        if (this.m_authenticationPassword == null) {
            this.m_authPassLastCancelTime = System.currentTimeMillis() + 6000L;
        }
        this.m_bAuthPassDialogShown = false;
        return this.m_authenticationPassword;
    }

    public void clearAuthenticationPassword() {
        this.m_authenticationPassword = null;
    }

    public String getAuthenticationUserID() {
        return this.m_authenticationUserID;
    }

    public void setAuthenticationUserID(String a_authenticationUserID) {
        if (a_authenticationUserID != null && a_authenticationUserID.trim().length() > 0) {
            if (this.m_authenticationUserID == null || !this.m_authenticationUserID.equals(a_authenticationUserID)) {
                this.m_authenticationUserID = a_authenticationUserID;
                this.m_authenticationPassword = null;
                if (this.isAuthenticationUsed() && this.isValid()) {
                    this.getAuthenticationPassword();
                }
            }
        } else {
            this.m_authenticationUserID = null;
            this.m_authenticationPassword = null;
            this.setUseAuthentication(false);
        }
    }

    public String getProxyAuthorizationHeaderAsString() throws IllegalStateException {
        if (!this.isAuthenticationUsed()) {
            throw new IllegalStateException("Authentication mode is not activated! Unknown state!");
        }
        return "Proxy-Authorization: Basic " + Codecs.base64Encode(this.getAuthenticationUserID() + ":" + this.getAuthenticationPassword()) + "\r\n";
    }

    public NVPair getProxyAuthorizationHeader() throws IllegalStateException {
        if (!this.isAuthenticationUsed()) {
            throw new IllegalStateException("Authentication mode is not activated! Unknown state!");
        }
        return new NVPair("Proxy-Authorization", "Basic " + Codecs.base64Encode(this.getAuthenticationUserID() + ":" + this.getAuthenticationPassword()));
    }

    public Object clone() {
        ProxyInterface proxyInterface = new ProxyInterface(this.getHost(), this.getPort(), this.getProtocol(), this.m_authenticationUserID, this.m_passwordReader, this.m_bUseAuthentication, this.m_bUseInterface);
        return proxyInterface;
    }

    public boolean equals(Object a_object) {
        ProxyInterface a_proxyInterface;
        return a_object instanceof ProxyInterface && super.equals((Object)(a_proxyInterface = (ProxyInterface)a_object)) && Util.equals(this.getAuthenticationUserID(), a_proxyInterface.getAuthenticationUserID()) && this.isAuthenticationPasswordSaveable() == a_proxyInterface.isAuthenticationPasswordSaveable() && Util.equals(this.getAuthenticationPassword(true), a_proxyInterface.getAuthenticationPassword(true)) && this.isValid() == a_proxyInterface.isValid() && this.isAuthenticationUsed() == a_proxyInterface.isAuthenticationUsed();
    }

    public Element toXmlElement(Document a_doc) {
        Element element = this.toXmlElementInternal(a_doc, ProxyInterface.getXMLElementName());
        Element authUserID = a_doc.createElement(XML_AUTHENTICATION_USER_ID);
        authUserID.appendChild(a_doc.createTextNode(this.getAuthenticationUserID()));
        Element isValid = a_doc.createElement(XML_USE_PROXY);
        XMLUtil.setValue((Node)isValid, this.isValid());
        Element useAuth = a_doc.createElement(XML_USE_AUTHENTICATION);
        XMLUtil.setValue((Node)useAuth, this.isAuthenticationUsed());
        if (this.m_passwordReader instanceof StoredPasswordReader) {
            Element authPassword = a_doc.createElement(XML_AUTHENTICATION_PASSWORD);
            XMLUtil.setValue((Node)authPassword, this.m_passwordReader.readPassword(null));
        }
        element.appendChild(authUserID);
        element.appendChild(useAuth);
        element.appendChild(isValid);
        return element;
    }

    public boolean isValid() {
        return super.isValid() && this.m_bUseInterface;
    }

    public void setUseInterface(boolean a_bUseInterface) {
        super.setUseInterface(a_bUseInterface);
        this.m_bUseInterface = a_bUseInterface;
        if (this.isValid() && this.isAuthenticationUsed() && this.m_passwordReader != null && this.m_authenticationPassword == null) {
            this.getAuthenticationPassword();
        }
    }
}

