/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.client.AbstractAutoSwitchedMixCascadeContainer;
import anon.crypto.ExpiredSignatureException;
import anon.crypto.SignatureVerifier;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.AbstractDistributableDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.IServiceContextContainer;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceHolderMessage;
import anon.infoservice.JAPMinVersion;
import anon.infoservice.JAPVersionInfo;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.infoservice.PerformanceInfo;
import anon.infoservice.StatusInfo;
import anon.pay.PaymentInstanceDBEntry;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.ClassUtil;
import anon.util.IXMLEncodable;
import anon.util.ThreadPool;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InfoServiceHolder
extends Observable
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "InfoserviceManagement";
    public static final String XML_ELEM_CHANGE_INFO_SERVICES = "ChangeInfoService";
    public static final int MAXIMUM_OF_ASKED_INFO_SERVICES = 4;
    public static final int MAXIMUM_OF_ASKED_INFO_SERVICES_FOR_PERFORMANCE = Integer.MAX_VALUE;
    public static final int DEFAULT_OF_ASKED_INFO_SERVICES = 3;
    private static final int GET_MIXCASCADES = 1;
    private static final int GET_INFOSERVICES = 2;
    private static final int GET_MIXINFO = 3;
    private static final int GET_STATUSINFO = 4;
    private static final int GET_NEWVERSIONNUMBER = 5;
    private static final int GET_JAPVERSIONINFO = 6;
    private static final int GET_TORNODESLIST = 7;
    private static final int GET_FORWARDER = 8;
    private static final int GET_PAYMENT_INSTANCES = 9;
    private static final int GET_PAYMENT_INSTANCE = 10;
    private static final int GET_MIXMINIONNODESLIST = 11;
    private static final int GET_CASCADEINFO = 12;
    private static final int GET_LATEST_JAVA = 13;
    private static final int GET_INFOSERVICE_SERIALS = 14;
    private static final int GET_MIXCASCADE_SERIALS = 15;
    private static final int GET_MESSAGES = 16;
    private static final int GET_LATEST_JAVA_SERIALS = 17;
    private static final int GET_MESSAGE_SERIALS = 18;
    private static final int GET_STATUSINFO_TIMEOUT = 19;
    private static final int GET_PERFORMANCE_INFO = 20;
    private static final int GET_TC_TEMPLATE = 21;
    private static final int GET_TCS = 22;
    private static final int GET_TC_SERIALS = 23;
    private static final int GET_EXIT_ADDRESSES = 24;
    private static final int GET_TC_TEMPLATES = 25;
    private static final int GET_MY_IP = 26;
    private static final int GET_MIXINFOS = 25;
    private static final String[] GETS;
    public static final boolean DEFAULT_INFOSERVICE_CHANGES = true;
    private static final String XML_ATTR_ASKED_INFO_SERVICES = "askInfoServices";
    private static InfoServiceHolder ms_infoServiceHolderInstance;
    private ThreadPool m_poolFetchInformation = new ThreadPool("Fetch Information Thread Pool", 6, 1);
    private InfoServiceDBEntry m_preferredInfoService = null;
    private boolean m_changeInfoServices = true;
    private int m_nrAskedInfoServices = 3;
    static /* synthetic */ Class class$anon$infoservice$InfoServiceHolder;
    static /* synthetic */ Class class$anon$infoservice$InfoServiceDBEntry;

    private InfoServiceHolder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InfoServiceHolder getInstance() {
        Class clazz = class$anon$infoservice$InfoServiceHolder == null ? (class$anon$infoservice$InfoServiceHolder = InfoServiceHolder.class$("anon.infoservice.InfoServiceHolder")) : class$anon$infoservice$InfoServiceHolder;
        synchronized (clazz) {
            if (ms_infoServiceHolderInstance == null) {
                ms_infoServiceHolderInstance = new InfoServiceHolder();
            }
        }
        return ms_infoServiceHolderInstance;
    }

    public void shutdown() {
        this.m_poolFetchInformation.shutdown();
    }

    public static String getXmlSettingsRootNodeName() {
        return XML_ELEMENT_NAME;
    }

    public synchronized void setPreferredInfoService(InfoServiceDBEntry a_preferredInfoService) {
        if (a_preferredInfoService != null) {
            this.m_preferredInfoService = a_preferredInfoService;
            this.setChanged();
            this.notifyObservers(new InfoServiceHolderMessage(1, this.m_preferredInfoService));
            LogHolder.log(6, LogType.NET, "Preferred InfoService is now: " + this.m_preferredInfoService.getName());
        }
    }

    public InfoServiceDBEntry getPreferredInfoService() {
        return this.m_preferredInfoService;
    }

    public int getNumberOfAskedInfoServices() {
        return this.m_nrAskedInfoServices;
    }

    public void setNumberOfAskedInfoServices(int a_nrAskedInfoServices) {
        if (a_nrAskedInfoServices < 1) {
            this.m_nrAskedInfoServices = 1;
        } else if (a_nrAskedInfoServices > 4) {
            a_nrAskedInfoServices = 4;
        } else {
            this.m_nrAskedInfoServices = a_nrAskedInfoServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangeInfoServices(boolean a_changeInfoServices) {
        InfoServiceHolder infoServiceHolder = this;
        synchronized (infoServiceHolder) {
            if (this.m_changeInfoServices != a_changeInfoServices) {
                this.m_changeInfoServices = a_changeInfoServices;
                this.setChanged();
                this.notifyObservers(new InfoServiceHolderMessage(2, new Boolean(this.m_changeInfoServices)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChangeInfoServices() {
        boolean r_changeInfoServices = true;
        InfoServiceHolder infoServiceHolder = this;
        synchronized (infoServiceHolder) {
            r_changeInfoServices = this.m_changeInfoServices;
        }
        return r_changeInfoServices;
    }

    public Vector getInfoservicesWithForwarderList() {
        Vector<InfoServiceDBEntry> primaryInfoServices = new Vector<InfoServiceDBEntry>();
        InfoServiceDBEntry currentPreferredInfoService = this.getPreferredInfoService();
        if (currentPreferredInfoService.hasPrimaryForwarderList()) {
            primaryInfoServices.addElement(currentPreferredInfoService);
        }
        Enumeration infoservices = Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).getEntryList().elements();
        while (infoservices.hasMoreElements()) {
            InfoServiceDBEntry currentInfoService = (InfoServiceDBEntry)infoservices.nextElement();
            if (!currentInfoService.hasPrimaryForwarderList() || currentInfoService.getId().equals(currentPreferredInfoService.getId())) continue;
            primaryInfoServices.addElement(currentInfoService);
        }
        return primaryInfoServices;
    }

    private Object fetchInformation(int functionNumber, Vector arguments) {
        InformationFetcher fetcher = new InformationFetcher(functionNumber, arguments);
        try {
            this.m_poolFetchInformation.addRequestAndWait(fetcher);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LogHolder.log(4, LogType.MISC, ex);
        }
        return fetcher.getResult();
    }

    public Hashtable getMixCascades() {
        return (Hashtable)this.fetchInformation(1, null);
    }

    public Hashtable getMixCascades(String context) {
        if (context == null) {
            Hashtable hash2 = this.getMixCascades();
            if (hash2 == null) {
                return new Hashtable();
            }
            return this.getMixCascades();
        }
        Vector<String> args = new Vector<String>();
        args.addElement(context);
        return (Hashtable)this.fetchInformation(1, args);
    }

    public Hashtable getMixCascadeSerials() {
        return (Hashtable)this.fetchInformation(15, null);
    }

    public Hashtable getMixCascadeSerials(String context) {
        if (context == null) {
            return this.getMixCascadeSerials();
        }
        Vector<String> args = new Vector<String>();
        args.addElement(context);
        return (Hashtable)this.fetchInformation(15, args);
    }

    public TermsAndConditionsTemplate getTCTemplate(String a_id) {
        return (TermsAndConditionsTemplate)this.fetchInformation(21, Util.toVector(a_id));
    }

    public Hashtable getTCTemplates() {
        return (Hashtable)this.fetchInformation(25, null);
    }

    public Hashtable getTermsAndConditions() {
        return (Hashtable)this.fetchInformation(22, null);
    }

    public Hashtable getTermsAndConditionsSerials() {
        return (Hashtable)this.fetchInformation(23, null);
    }

    public Hashtable getPerformanceInfos() {
        return (Hashtable)this.fetchInformation(20, null);
    }

    public Hashtable updateExitAddresses() {
        return (Hashtable)this.fetchInformation(24, null);
    }

    public Hashtable getPaymentInstances() {
        return (Hashtable)this.fetchInformation(9, null);
    }

    public PaymentInstanceDBEntry getPaymentInstance(String a_piID) throws Exception {
        return (PaymentInstanceDBEntry)this.fetchInformation(10, Util.toVector(a_piID));
    }

    public Hashtable getInfoServices() {
        return (Hashtable)this.fetchInformation(2, null);
    }

    public Hashtable getInfoServiceSerials() {
        return (Hashtable)this.fetchInformation(14, null);
    }

    public InetAddress getMyIP(Integer a_proxyPolicy) {
        return (InetAddress)this.fetchInformation(26, Util.toVector(a_proxyPolicy));
    }

    public MixInfo getMixInfo(String mixId) {
        if (mixId == null) {
            return null;
        }
        return (MixInfo)this.fetchInformation(3, Util.toVector(mixId));
    }

    public Hashtable getMixInfos() {
        return (Hashtable)this.fetchInformation(25, null);
    }

    public StatusInfo getStatusInfo(MixCascade a_cascade) {
        if (a_cascade == null || a_cascade == AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE) {
            return null;
        }
        return (StatusInfo)this.fetchInformation(4, Util.toVector(a_cascade));
    }

    public StatusInfo getStatusInfo(MixCascade a_cascade, long a_timeout) {
        if (a_cascade == null || a_cascade == AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE) {
            return null;
        }
        Vector<Object> args = new Vector<Object>();
        args.addElement(a_cascade);
        args.addElement(new Long(a_timeout));
        return (StatusInfo)this.fetchInformation(19, args);
    }

    public JAPMinVersion getNewVersionNumber() {
        return (JAPMinVersion)this.fetchInformation(5, null);
    }

    public Hashtable getLatestJavaVersions() {
        return (Hashtable)this.fetchInformation(13, null);
    }

    public Hashtable getLatestJavaVersionSerials() {
        return (Hashtable)this.fetchInformation(17, null);
    }

    public Hashtable getMessages() {
        return (Hashtable)this.fetchInformation(16, null);
    }

    public Hashtable getMessageSerials() {
        return (Hashtable)this.fetchInformation(18, null);
    }

    public JAPVersionInfo getJAPVersionInfo(int japVersionType) {
        return (JAPVersionInfo)this.fetchInformation(6, Util.toVector(new Integer(japVersionType)));
    }

    public byte[] getTorNodesList() {
        return (byte[])this.fetchInformation(7, null);
    }

    public MixCascade getMixCascadeInfo(String a_cascadeID) {
        if (a_cascadeID == null || a_cascadeID.equals(AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE.getId())) {
            return null;
        }
        return (MixCascade)this.fetchInformation(12, Util.toVector(a_cascadeID));
    }

    public byte[] getMixminionNodesList() {
        return (byte[])this.fetchInformation(11, null);
    }

    public Element getForwarder() {
        return (Element)this.fetchInformation(8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        Element infoServiceManagementNode = a_doc.createElement(XML_ELEMENT_NAME);
        Element infoServicesNode = Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).toXmlElement(a_doc, "InfoServices");
        Element preferredInfoServiceNode = a_doc.createElement("PreferredInfoService");
        Element changeInfoServicesNode = a_doc.createElement(XML_ELEM_CHANGE_INFO_SERVICES);
        XMLUtil.setAttribute(infoServiceManagementNode, XML_ATTR_ASKED_INFO_SERVICES, this.m_nrAskedInfoServices);
        InfoServiceHolder infoServiceHolder = this;
        synchronized (infoServiceHolder) {
            InfoServiceDBEntry preferredInfoService = this.getPreferredInfoService();
            if (preferredInfoService != null) {
                preferredInfoServiceNode.appendChild(preferredInfoService.toXmlElement(a_doc));
            }
            XMLUtil.setValue((Node)changeInfoServicesNode, this.isChangeInfoServices());
        }
        infoServiceManagementNode.appendChild(infoServicesNode);
        infoServiceManagementNode.appendChild(preferredInfoServiceNode);
        infoServiceManagementNode.appendChild(changeInfoServicesNode);
        return infoServiceManagementNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettingsFromXml(Element a_infoServiceManagementNode, boolean a_bForceISChange) throws Exception {
        int i;
        this.setNumberOfAskedInfoServices(XMLUtil.parseAttribute((Node)a_infoServiceManagementNode, XML_ATTR_ASKED_INFO_SERVICES, 3));
        Element infoServicesNode = (Element)XMLUtil.getFirstChildByName(a_infoServiceManagementNode, "InfoServices");
        if (infoServicesNode == null) {
            throw new Exception("No InfoServices node found.");
        }
        Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).loadFromXml(infoServicesNode, true);
        Element preferredInfoServiceNode = (Element)XMLUtil.getFirstChildByName(a_infoServiceManagementNode, "PreferredInfoService");
        if (preferredInfoServiceNode == null) {
            throw new Exception("No PreferredInfoService node found.");
        }
        Element infoServiceNode = (Element)XMLUtil.getFirstChildByName(preferredInfoServiceNode, "InfoService");
        InfoServiceDBEntry preferredInfoService = null;
        if (infoServiceNode != null) {
            try {
                preferredInfoService = new InfoServiceDBEntry(infoServiceNode, Long.MAX_VALUE);
            }
            catch (XMLParseException a_e) {
                // empty catch block
            }
        }
        Vector currentEntries = Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).getEntryList();
        Vector<String> bootstrapIDs = new Vector<String>();
        int nrLoadedIS = 0;
        for (i = 0; i < currentEntries.size(); ++i) {
            InfoServiceDBEntry entry = (InfoServiceDBEntry)currentEntries.elementAt(i);
            if (!(entry.isBootstrap() || entry.isUserDefined() || entry.isVerified() && entry.isValid())) {
                Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry") : class$anon$infoservice$InfoServiceDBEntry).remove(entry.getId());
                continue;
            }
            if (entry.isBootstrap()) {
                bootstrapIDs.addElement(entry.getId());
                continue;
            }
            if (entry.isUserDefined()) continue;
            ++nrLoadedIS;
        }
        if (nrLoadedIS >= 3) {
            for (i = 0; i < bootstrapIDs.size(); ++i) {
                Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry") : class$anon$infoservice$InfoServiceDBEntry).remove(bootstrapIDs.elementAt(i).toString());
            }
        }
        InfoServiceHolder infoServiceHolder = this;
        synchronized (infoServiceHolder) {
            if (preferredInfoService != null) {
                this.setPreferredInfoService(preferredInfoService);
            } else if (this.getPreferredInfoService() == null) {
                this.setPreferredInfoService((InfoServiceDBEntry)Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).getRandomEntry());
            }
            if (a_bForceISChange) {
                this.setChangeInfoServices(true);
            } else {
                Element changeInfoServicesNode = (Element)XMLUtil.getFirstChildByName(a_infoServiceManagementNode, XML_ELEM_CHANGE_INFO_SERVICES);
                this.setChangeInfoServices(XMLUtil.parseValue((Node)changeInfoServicesNode, this.isChangeInfoServices()));
            }
        }
    }

    private static void filterServiceContext(Hashtable serviceObjects, String context) {
        boolean removeEntry = false;
        if (context != null && serviceObjects != null) {
            String currentContext = null;
            try {
                Enumeration keys = serviceObjects.keys();
                while (keys.hasMoreElements()) {
                    Object currentKey = keys.nextElement();
                    IServiceContextContainer currentEntry = (IServiceContextContainer)serviceObjects.get(currentKey);
                    currentContext = currentEntry.getContext();
                    removeEntry = !(currentContext != null && currentContext.equals(context) || currentContext.startsWith("jondonym") && currentContext.equals("jondonym.premium"));
                    if (!removeEntry) continue;
                    serviceObjects.remove(currentKey);
                }
            }
            catch (ClassCastException cce) {
                LogHolder.log(3, LogType.MISC, "Wrong type for filter specified", cce);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ms_infoServiceHolderInstance = null;
        Field[] allFields = (class$anon$infoservice$InfoServiceHolder == null ? (class$anon$infoservice$InfoServiceHolder = InfoServiceHolder.class$("anon.infoservice.InfoServiceHolder")) : class$anon$infoservice$InfoServiceHolder).getDeclaredFields();
        GETS = new String[allFields.length];
        for (int i = 0; i < allFields.length; ++i) {
            if (!allFields[i].getName().startsWith("GET") || allFields[i].getType() != Integer.TYPE) continue;
            try {
                InfoServiceHolder.GETS[allFields[i].getInt(null)] = allFields[i].getName();
                continue;
            }
            catch (Exception a_e) {
                LogHolder.log(3, LogType.DB, a_e);
                break;
            }
        }
    }

    private class InformationFetcher
    implements Runnable {
        private int functionNumber;
        private Vector arguments;
        private Object m_result;

        public InformationFetcher(int a_functionNumber, Vector a_arguments) {
            this.functionNumber = a_functionNumber;
            this.arguments = a_arguments;
        }

        public Object getResult() {
            return this.m_result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InfoServiceDBEntry currentInfoService = null;
            Random random = new Random(System.currentTimeMillis());
            int askInfoServices = 1;
            currentInfoService = InfoServiceHolder.this.getPreferredInfoService();
            Vector infoServiceList = null;
            Exception exVerifyable = null;
            if (InfoServiceHolder.this.m_changeInfoServices) {
                infoServiceList = Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceHolder.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).getEntryList();
                Vector copyList = (Vector)infoServiceList.clone();
                for (int i = 0; i < copyList.size(); ++i) {
                    InfoServiceDBEntry isTemp = (InfoServiceDBEntry)copyList.elementAt(i);
                    boolean bExpired = false;
                    if ((isTemp.isBootstrap() || isTemp.isUserDefined()) && isTemp.getCertPath() == null || !SignatureVerifier.getInstance().isCheckSignatures() || isTemp.getCertPath() != null && isTemp.getCertPath().isVerified() && !(bExpired = !isTemp.isValid())) continue;
                    if (bExpired) {
                        if (exVerifyable == null || exVerifyable instanceof ExpiredSignatureException) {
                            exVerifyable = new ExpiredSignatureException("Signature expired for IS " + isTemp.getId() + ".");
                        }
                    } else {
                        exVerifyable = new SignatureException("No valid signature for IS " + isTemp.getId() + ".");
                    }
                    infoServiceList.removeElement(isTemp);
                }
            } else {
                infoServiceList = new Vector();
                if (currentInfoService != null) {
                    infoServiceList.addElement(currentInfoService);
                }
            }
            Object result = new Hashtable();
            askInfoServices = InfoServiceHolder.this.m_nrAskedInfoServices;
            if (this.functionNumber == 20) {
                askInfoServices = Integer.MAX_VALUE;
            }
            if (this.functionNumber == 4 || this.functionNumber == 19) {
                currentInfoService = null;
            }
            while (!(infoServiceList.size() <= 0 && currentInfoService == null || Thread.currentThread().isInterrupted())) {
                if (currentInfoService == null) {
                    currentInfoService = (InfoServiceDBEntry)infoServiceList.elementAt(Math.abs(random.nextInt()) % infoServiceList.size());
                }
                LogHolder.log(5, LogType.DB, "Trying InfoService: " + currentInfoService.getName(), 1);
                try {
                    Hashtable tempHashtable = null;
                    if (this.functionNumber == 1) {
                        tempHashtable = currentInfoService.getMixCascades();
                        if (this.arguments != null) {
                            String context = (String)this.arguments.firstElement();
                            InfoServiceHolder.filterServiceContext(tempHashtable, context);
                        }
                    } else if (this.functionNumber == 26) {
                        result = currentInfoService.getMyIP((Integer)this.arguments.elementAt(0));
                    } else if (this.functionNumber == 2) {
                        tempHashtable = currentInfoService.getInfoServices();
                    } else if (this.functionNumber == 25) {
                        tempHashtable = currentInfoService.getMixes(true);
                    } else if (this.functionNumber == 3) {
                        result = currentInfoService.getMixInfo((String)this.arguments.elementAt(0));
                    } else if (this.functionNumber == 13) {
                        tempHashtable = currentInfoService.getLatestJava();
                    } else if (this.functionNumber == 17) {
                        tempHashtable = currentInfoService.getLatestJavaSerials();
                    } else if (this.functionNumber == 21) {
                        result = currentInfoService.getTCTemplate((String)this.arguments.elementAt(0));
                    } else if (this.functionNumber == 20) {
                        PerformanceInfo dbEntry = currentInfoService.getPerformanceInfo();
                        tempHashtable = new Hashtable();
                        if (dbEntry != null) {
                            tempHashtable.put(((AbstractDatabaseEntry)dbEntry).getId(), dbEntry);
                        }
                    } else if (this.functionNumber == 16) {
                        tempHashtable = currentInfoService.getMessages();
                    } else if (this.functionNumber == 18) {
                        tempHashtable = currentInfoService.getMessageSerials();
                    } else if (this.functionNumber == 4) {
                        result = currentInfoService.getStatusInfo((MixCascade)this.arguments.elementAt(0));
                    } else if (this.functionNumber == 19) {
                        result = currentInfoService.getStatusInfo((MixCascade)this.arguments.elementAt(0), (Long)this.arguments.elementAt(1));
                    } else if (this.functionNumber == 15) {
                        tempHashtable = currentInfoService.getMixCascadeSerials();
                        if (this.arguments != null) {
                            String context = (String)this.arguments.firstElement();
                            InfoServiceHolder.filterServiceContext(tempHashtable, context);
                        }
                    } else if (this.functionNumber == 14) {
                        tempHashtable = currentInfoService.getInfoServiceSerials();
                    } else if (this.functionNumber == 5) {
                        result = currentInfoService.getNewVersionNumber();
                    } else if (this.functionNumber == 6) {
                        result = currentInfoService.getJAPVersionInfo((Integer)this.arguments.elementAt(0));
                    } else if (this.functionNumber == 7) {
                        result = currentInfoService.getTorNodesList();
                    } else if (this.functionNumber == 11) {
                        result = currentInfoService.getMixminionNodesList();
                    } else if (this.functionNumber == 8) {
                        result = currentInfoService.getForwarder();
                    } else if (this.functionNumber == 9) {
                        tempHashtable = currentInfoService.getPaymentInstances();
                    } else if (this.functionNumber == 10) {
                        result = currentInfoService.getPaymentInstance((String)this.arguments.firstElement());
                    } else if (this.functionNumber == 24) {
                        tempHashtable = currentInfoService.getExitAddresses();
                    } else if (this.functionNumber == 12) {
                        result = currentInfoService.getMixCascadeInfo((String)this.arguments.firstElement());
                    }
                    if (tempHashtable == null && result == null || tempHashtable != null && tempHashtable.size() == 0) {
                        LogHolder.log(6, LogType.NET, "IS " + currentInfoService.getName() + " did not have the requested info!");
                        infoServiceList.removeElement(currentInfoService);
                        currentInfoService = null;
                        continue;
                    }
                    if (tempHashtable == null) break;
                    Enumeration newEntries = tempHashtable.elements();
                    while (newEntries.hasMoreElements()) {
                        AbstractDatabaseEntry currentEntry = (AbstractDatabaseEntry)newEntries.nextElement();
                        if (((Hashtable)result).containsKey(currentEntry.getId())) {
                            AbstractDatabaseEntry hashedEntry = (AbstractDatabaseEntry)((Hashtable)result).get(currentEntry.getId());
                            if (currentEntry instanceof AbstractDistributableDatabaseEntry.SerialDBEntry && hashedEntry instanceof AbstractDistributableDatabaseEntry.SerialDBEntry) {
                                AbstractDistributableDatabaseEntry.SerialDBEntry currentSerialEntry = (AbstractDistributableDatabaseEntry.SerialDBEntry)currentEntry;
                                AbstractDistributableDatabaseEntry.SerialDBEntry hashedSerialEntry = (AbstractDistributableDatabaseEntry.SerialDBEntry)hashedEntry;
                                if (currentSerialEntry.getVersionNumber() != hashedSerialEntry.getVersionNumber()) {
                                    LogHolder.log(4, LogType.NET, "InfoServices report different serial numbers for " + currentSerialEntry.getId() + "!");
                                    currentSerialEntry = new AbstractDistributableDatabaseEntry.SerialDBEntry(currentSerialEntry.getId(), 0L, Long.MAX_VALUE, currentSerialEntry.isVerified(), currentSerialEntry.isValid(), currentSerialEntry.getContext());
                                }
                                if (currentSerialEntry.isVerified() != hashedSerialEntry.isVerified()) {
                                    LogHolder.log(4, LogType.NET, "InfoServices report different verification status for " + ClassUtil.getShortClassName(currentEntry.getClass()) + " with id " + currentSerialEntry.getId() + "!");
                                    currentSerialEntry = new AbstractDistributableDatabaseEntry.SerialDBEntry(currentSerialEntry.getId(), currentSerialEntry.getVersionNumber(), Long.MAX_VALUE, true, currentSerialEntry.isValid(), currentSerialEntry.getContext());
                                }
                                if (currentSerialEntry.isValid() != hashedSerialEntry.isValid()) {
                                    LogHolder.log(4, LogType.NET, "InfoServices report different validity status for " + currentSerialEntry.getId() + "!");
                                    currentSerialEntry = new AbstractDistributableDatabaseEntry.SerialDBEntry(currentSerialEntry.getId(), currentSerialEntry.getVersionNumber(), Long.MAX_VALUE, currentSerialEntry.isVerified(), true, currentSerialEntry.getContext());
                                }
                                currentEntry = currentSerialEntry;
                            }
                            if (hashedEntry.getLastUpdate() > currentEntry.getLastUpdate()) continue;
                        }
                        ((Hashtable)result).put(currentEntry.getId(), currentEntry);
                    }
                    if (--askInfoServices == 0) break;
                    infoServiceList.removeElement(currentInfoService);
                    currentInfoService = null;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.NET, "Contacting IS " + currentInfoService.getName() + " produced an error!", e);
                    infoServiceList.removeElement(currentInfoService);
                    currentInfoService = null;
                    if (exVerifyable == null) {
                        exVerifyable = e;
                        continue;
                    }
                    if (!(exVerifyable instanceof ExpiredSignatureException) && e instanceof ExpiredSignatureException || !(exVerifyable instanceof SignatureException) && e instanceof SignatureException) continue;
                    exVerifyable = e;
                }
            }
            if (!(result == null || result instanceof Hashtable && ((Hashtable)result).size() <= 0)) {
                this.m_result = result;
                return;
            }
            String fieldName = null;
            if (GETS.length > this.functionNumber) {
                fieldName = GETS[this.functionNumber];
            }
            if (fieldName == null) {
                fieldName = "the needed information (" + this.functionNumber + ")";
            }
            LogHolder.log(3, LogType.NET, "No InfoService with " + fieldName + " available" + (this.arguments == null || this.arguments.elementAt(0) == null ? "." : " for argument: " + this.arguments.elementAt(0)), 1);
            this.m_result = null;
            if (exVerifyable != null && exVerifyable instanceof SignatureException) {
                LogHolder.log(2, LogType.CRYPTO, "Could not contact InfoServices due to certificate problems.", exVerifyable);
                InfoServiceHolder infoServiceHolder = InfoServiceHolder.getInstance();
                synchronized (infoServiceHolder) {
                    InfoServiceHolder.this.setChanged();
                    InfoServiceHolder.this.notifyObservers(new InfoServiceHolderMessage(3, exVerifyable));
                }
            }
        }
    }
}

