/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import HTTPClient.HTTPConnection;
import HTTPClient.NVPair;
import anon.crypto.ExpiredSignatureException;
import anon.crypto.IVerifyable;
import anon.crypto.MultiCertPath;
import anon.crypto.SignatureCreator;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.AbstractDistributableCertifiedDatabaseEntry;
import anon.infoservice.AbstractDistributableDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.HTTPConnectionDescriptor;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.HttpRequestStructure;
import anon.infoservice.IBoostrapable;
import anon.infoservice.IBrowserIdentification;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.JAPMinVersion;
import anon.infoservice.JAPVersionInfo;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.MixCascadeExitAddresses;
import anon.infoservice.MixInfo;
import anon.infoservice.PerformanceInfo;
import anon.infoservice.ServiceSoftware;
import anon.infoservice.StatusInfo;
import anon.pay.PaymentInstanceDBEntry;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.ClassUtil;
import anon.util.Util;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SignatureException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InfoServiceDBEntry
extends AbstractDistributableCertifiedDatabaseEntry
implements IVerifyable,
IBoostrapable,
ListenerInterface.IListenerInterfaceGetter {
    public static final String XML_ELEMENT_CONTAINER_NAME = "InfoServices";
    public static final String XML_ELEMENT_NAME = "InfoService";
    public static final String HEADER_STATISTICS = "statistics";
    public static final int MINIMUM_GET_XML_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_GET_XML_CONNECTION_TIMEOUT = 15000;
    private static final long BLOCK_TIMEOUT = 180000L;
    private static int m_getXmlConnectionTimeout = 15000;
    private static long m_timeFirstJVMSocketError = Long.MAX_VALUE;
    private static long m_timeHandleAfterJVMSocketError = Long.MAX_VALUE;
    private static Runnable m_threadHandleAfterJVMSocketError;
    private static boolean ms_bUseStatistics;
    private static IMutableProxyInterface ms_proxyInterface;
    private static IBrowserIdentification ms_browserIdentification;
    private String m_strInfoServiceId;
    private String m_strName;
    private boolean m_bTemp = false;
    private ServiceSoftware m_infoserviceSoftware;
    private Vector m_listenerInterfaces;
    private Hashtable m_hashListenerInterfaces;
    private int m_preferedListenerInterface;
    private boolean m_bPrimaryForwarderList;
    private boolean m_neighbour;
    private Element m_xmlDescription;
    private boolean m_userDefined;
    private long m_creationTimeStamp;
    private XMLSignature m_signature;
    private long m_serial;
    private boolean m_bPerfServerEnabled;
    public static final Integer PROXY_AUTO;
    public static final Integer PROXY_FORCE_ANONYMOUS;
    public static final Integer PROXY_FORCE_DEFAULT;
    public static final Integer PROXY_FORCE_DIRECT;
    static /* synthetic */ Class class$anon$infoservice$InfoServiceDBEntry;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;
    static /* synthetic */ Class class$anon$infoservice$MixInfo;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$anon$infoservice$MessageDBEntry;
    static /* synthetic */ Class class$anon$infoservice$JavaVersionDBEntry;

    private static String generateId(ListenerInterface a_listenerInterface) {
        return a_listenerInterface.getHost() + "%3A" + a_listenerInterface.getPort();
    }

    public InfoServiceDBEntry(Element a_infoServiceNode) throws XMLParseException {
        this(a_infoServiceNode, 0L);
    }

    public InfoServiceDBEntry(Element a_infoServiceNode, long a_timeout) throws XMLParseException {
        super(a_timeout <= 0L ? System.currentTimeMillis() + 900000L : a_timeout);
        if (a_infoServiceNode == null) {
            throw new XMLParseException("##__null__##");
        }
        this.m_xmlDescription = a_infoServiceNode;
        this.m_signature = SignatureVerifier.getInstance().getVerifiedXml(a_infoServiceNode, 2);
        this.m_userDefined = XMLUtil.getFirstChildByName(a_infoServiceNode, "UserDefined") != null;
        this.m_bPerfServerEnabled = XMLUtil.getFirstChildByName(a_infoServiceNode, "PerformanceServer") != null;
        this.m_strInfoServiceId = a_infoServiceNode.getAttribute("id");
        if (!this.checkId()) {
            throw new XMLParseException("##__root__##", "Malformed InfoService ID: " + this.m_strInfoServiceId);
        }
        this.m_strName = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_infoServiceNode, "Name"), null);
        if (this.m_strName == null) {
            throw new XMLParseException("Name");
        }
        this.m_infoserviceSoftware = new ServiceSoftware((Element)XMLUtil.getFirstChildByName(a_infoServiceNode, ServiceSoftware.getXmlElementName()));
        Node networkNode = XMLUtil.getFirstChildByName(a_infoServiceNode, "Network");
        if (networkNode == null) {
            throw new XMLParseException("Network");
        }
        Element listenerInterfacesNode = (Element)XMLUtil.getFirstChildByName(networkNode, "ListenerInterfaces");
        if (networkNode == null) {
            throw new XMLParseException("ListenerInterfaces");
        }
        NodeList listenerInterfaceNodes = listenerInterfacesNode.getElementsByTagName("ListenerInterface");
        if (listenerInterfaceNodes.getLength() == 0) {
            throw new XMLParseException("ListenerInterface");
        }
        this.m_listenerInterfaces = new Vector();
        this.m_hashListenerInterfaces = new Hashtable();
        for (int i = 0; i < listenerInterfaceNodes.getLength(); ++i) {
            Element listenerInterfaceNode = (Element)listenerInterfaceNodes.item(i);
            ListenerInterface listenerInterface = new ListenerInterface(listenerInterfaceNode);
            this.m_listenerInterfaces.addElement(listenerInterface);
            this.m_hashListenerInterfaces.put(listenerInterface.getId(), listenerInterface);
        }
        ListenerInterface.blockInterfacesFromDatabase(this);
        this.m_preferedListenerInterface = 0;
        this.m_creationTimeStamp = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_infoServiceNode, "LastUpdate"), -1L);
        if (this.m_creationTimeStamp == -1L) {
            throw new XMLParseException("LastUpdate");
        }
        this.m_serial = XMLUtil.parseAttribute((Node)a_infoServiceNode, "serial", 0L);
        this.m_bPrimaryForwarderList = XMLUtil.getFirstChildByName(a_infoServiceNode, "ForwarderList") != null;
        this.m_neighbour = true;
    }

    public InfoServiceDBEntry(String a_host, int a_port) throws IllegalArgumentException {
        this(null, null, new ListenerInterface(a_host, a_port).toVector(), false, true, 0L, 0L, false, null);
        this.setUserDefined(true);
    }

    public InfoServiceDBEntry(Vector a_ListenerInterfaces) throws IllegalArgumentException {
        this(null, null, a_ListenerInterfaces, false, true, 0L, 0L, false, null);
        this.setUserDefined(true);
    }

    public InfoServiceDBEntry(String a_strName, String a_id, Vector a_listeners, boolean a_primaryForwarderList, boolean a_japClientContext, long a_creationTime, long a_serialNumber, boolean a_bPerfServerEnabled, ServiceSoftware a_software) throws IllegalArgumentException {
        super(a_japClientContext ? Long.MAX_VALUE : System.currentTimeMillis() + 900000L);
        if (a_listeners == null) {
            throw new IllegalArgumentException("No listener interfaces!");
        }
        Enumeration enumListeners = a_listeners.elements();
        this.m_listenerInterfaces = new Vector();
        this.m_hashListenerInterfaces = new Hashtable();
        while (enumListeners.hasMoreElements()) {
            ListenerInterface listenerInterface = (ListenerInterface)enumListeners.nextElement();
            this.m_listenerInterfaces.addElement(listenerInterface);
            this.m_hashListenerInterfaces.put(listenerInterface.getId(), listenerInterface);
        }
        ListenerInterface.blockInterfacesFromDatabase(this);
        this.m_strInfoServiceId = a_id == null ? InfoServiceDBEntry.generateId((ListenerInterface)this.m_listenerInterfaces.firstElement()) : a_id;
        this.m_strName = a_strName;
        if (this.m_strName == null) {
            ListenerInterface firstListenerInterface = (ListenerInterface)this.m_listenerInterfaces.firstElement();
            this.m_strName = firstListenerInterface.getHost() + ":" + Integer.toString(firstListenerInterface.getPort());
        }
        this.m_bPrimaryForwarderList = a_primaryForwarderList;
        this.m_infoserviceSoftware = a_software == null ? new ServiceSoftware("unknown") : a_software;
        this.m_preferedListenerInterface = 0;
        this.m_creationTimeStamp = a_creationTime;
        this.m_serial = a_serialNumber;
        this.m_neighbour = false;
        this.m_bPerfServerEnabled = a_bPerfServerEnabled;
        this.m_xmlDescription = this.generateXmlRepresentation();
    }

    public boolean isPersistanceDeletionAllowed() {
        return XMLUtil.getStorageMode() == 2;
    }

    public void deletePersistence() {
        if (this.isPersistanceDeletionAllowed()) {
            this.m_xmlDescription = null;
        }
    }

    public static void setUseInfoServiceStatistics(boolean a_bUseStatistics) {
        ms_bUseStatistics = a_bUseStatistics;
    }

    public static boolean isInfoServiceStatisticsUsed() {
        return ms_bUseStatistics;
    }

    public static void setConnectionTimeout(int a_timeoutMS) {
        if (a_timeoutMS >= 10000) {
            m_getXmlConnectionTimeout = a_timeoutMS;
        }
    }

    public static int getConnectionTimeout() {
        return m_getXmlConnectionTimeout;
    }

    public static void setBrowserIdentification(IBrowserIdentification a_browserIdentification) {
        if (a_browserIdentification != null) {
            ms_browserIdentification = a_browserIdentification;
        }
    }

    public static void setMutableProxyInterface(IMutableProxyInterface a_proxyInterface) {
        if (a_proxyInterface != null) {
            ms_proxyInterface = a_proxyInterface;
        }
    }

    public static void setJVMNetworkErrorHandling(Runnable a_threadRestartAfterJVMSocketError, long a_timeRestartAfterJVMSocketError) {
        if (a_timeRestartAfterJVMSocketError < 0L || a_threadRestartAfterJVMSocketError == null) {
            throw new IllegalArgumentException("Runnable: " + a_threadRestartAfterJVMSocketError + " " + "Timeout: " + a_timeRestartAfterJVMSocketError);
        }
        m_threadHandleAfterJVMSocketError = a_threadRestartAfterJVMSocketError;
        m_timeHandleAfterJVMSocketError = a_timeRestartAfterJVMSocketError;
    }

    private Element generateXmlRepresentation() {
        Document doc = XMLUtil.createDocument();
        Element infoServiceNode = doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(infoServiceNode, "id", this.m_strInfoServiceId);
        XMLUtil.setAttribute(infoServiceNode, "serial", this.m_serial);
        Element nameNode = doc.createElement("Name");
        XMLUtil.setValue((Node)nameNode, this.m_strName);
        Element networkNode = doc.createElement("Network");
        Element listenerInterfacesNode = doc.createElement("ListenerInterfaces");
        Enumeration enumer = this.m_listenerInterfaces.elements();
        while (enumer.hasMoreElements()) {
            ListenerInterface currentListenerInterface = (ListenerInterface)enumer.nextElement();
            listenerInterfacesNode.appendChild(currentListenerInterface.toXmlElement(doc));
        }
        networkNode.appendChild(listenerInterfacesNode);
        Element lastUpdateNode = doc.createElement("LastUpdate");
        XMLUtil.setValue((Node)lastUpdateNode, this.m_creationTimeStamp);
        infoServiceNode.appendChild(nameNode);
        infoServiceNode.appendChild(this.m_infoserviceSoftware.toXmlElement(doc));
        infoServiceNode.appendChild(networkNode);
        infoServiceNode.appendChild(lastUpdateNode);
        if (this.m_bPrimaryForwarderList) {
            Element forwarderListNode = doc.createElement("ForwarderList");
            infoServiceNode.appendChild(forwarderListNode);
        }
        if (this.m_userDefined) {
            Element userDefinedNode = doc.createElement("UserDefined");
            infoServiceNode.appendChild(userDefinedNode);
        }
        if (this.m_bPerfServerEnabled) {
            Element perfServerNode = doc.createElement("PerformanceServer");
            infoServiceNode.appendChild(perfServerNode);
        }
        try {
            this.m_signature = SignatureCreator.getInstance().getSignedXml(2, infoServiceNode);
        }
        catch (Exception a_e) {
            LogHolder.log(2, LogType.MISC, "Document could not be signed!");
        }
        return infoServiceNode;
    }

    public String getId() {
        return this.m_strInfoServiceId;
    }

    public Element getXmlStructure() {
        return this.m_xmlDescription;
    }

    public String getName() {
        return this.m_strName;
    }

    public boolean isVerified() {
        if (this.m_signature != null) {
            return this.m_signature.isVerified();
        }
        return false;
    }

    public boolean isValid() {
        if (this.m_signature != null && this.m_signature.getMultiCertPath() != null) {
            return this.m_signature.getMultiCertPath().isValid(new Date());
        }
        return false;
    }

    public boolean isPerfServerEnabled() {
        return this.m_bPerfServerEnabled;
    }

    public boolean checkId() {
        return this.m_userDefined || super.checkId();
    }

    public XMLSignature getSignature() {
        return this.m_signature;
    }

    public MultiCertPath getCertPath() {
        if (this.m_signature != null) {
            return this.m_signature.getMultiCertPath();
        }
        return null;
    }

    public long getLastUpdate() {
        return this.m_creationTimeStamp;
    }

    public long getVersionNumber() {
        return this.m_serial;
    }

    public boolean hasPrimaryForwarderList() {
        return this.m_bPrimaryForwarderList;
    }

    public Vector getListenerInterfaces() {
        return (Vector)this.m_listenerInterfaces.clone();
    }

    public ListenerInterface getListenerInterface(String a_id) {
        return (ListenerInterface)this.m_hashListenerInterfaces.get(a_id);
    }

    public boolean isUserDefined() {
        return this.m_userDefined;
    }

    public void setUserDefined(boolean b) {
        this.m_userDefined = b;
        this.m_infoserviceSoftware = new ServiceSoftware("unknown");
        this.m_xmlDescription = this.generateXmlRepresentation();
    }

    public void markAsBootstrap() {
        this.m_bTemp = true;
    }

    public boolean isBootstrap() {
        return this.m_bTemp;
    }

    public String toString() {
        return this.m_strName;
    }

    public boolean equals(Object a_object) {
        boolean objectEquals = false;
        if (a_object != null && a_object instanceof InfoServiceDBEntry) {
            objectEquals = this.getId().equals(((InfoServiceDBEntry)a_object).getId());
        }
        return objectEquals;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getPostFile() {
        return "/infoservice";
    }

    public boolean isNeighbour() {
        return this.m_neighbour;
    }

    public void setNeighbour(boolean a_bNeighbour) {
        this.m_neighbour = a_bNeighbour;
    }

    private HTTPConnectionDescriptor getNextConnectionDescriptor(HTTPConnectionDescriptor lastConnectionDescriptor, ImmutableProxyInterface a_proxy, int a_supportedEncodings, boolean a_bKeepDescriptor, int a_indexPreferredInterface, Integer a_proxyPolicy) {
        int nextIndex = a_indexPreferredInterface;
        if (lastConnectionDescriptor != null) {
            int lastIndex = this.m_listenerInterfaces.indexOf(lastConnectionDescriptor.getTargetInterface());
            if (lastIndex < 0) {
                LogHolder.log(1, LogType.NET, "Current target interfaces not found in list of interfaces!");
                lastIndex = 0;
            }
            nextIndex = a_bKeepDescriptor ? lastIndex : (lastIndex + 1) % this.m_listenerInterfaces.size();
        }
        ListenerInterface target = (ListenerInterface)this.m_listenerInterfaces.elementAt(nextIndex);
        Vector headers = null;
        if (ms_bUseStatistics && PROXY_FORCE_ANONYMOUS != a_proxyPolicy) {
            try {
                headers = new Vector();
                Vector<String> properties = new Vector<String>();
                properties.addElement("java.version");
                properties.addElement("java.vm.vendor");
                InfoServiceDBEntry.addPropertyHeader(properties, headers);
                properties = new Vector();
                properties.addElement("os.name");
                InfoServiceDBEntry.addPropertyHeader(properties, headers);
                InfoServiceDBEntry.addPropertyHeader("anonlib.version", "00.20.002", headers);
                String browserName = ms_browserIdentification.getBrowserName();
                if (browserName != null) {
                    InfoServiceDBEntry.addPropertyHeader("browser.name", browserName, headers);
                }
            }
            catch (Exception a_e) {
                LogHolder.log(2, LogType.NET, a_e);
            }
        }
        HTTPConnection connection = HTTPConnectionFactory.getInstance().createHTTPConnection(target, a_proxy, a_supportedEncodings, true, headers);
        return new HTTPConnectionDescriptor(connection, target);
    }

    private static void addPropertyHeader(String a_systemPropertyName, Vector a_headers) {
        InfoServiceDBEntry.addPropertyHeader(a_systemPropertyName, null, a_headers);
    }

    private static void addPropertyHeader(String a_systemPropertyName, String strVersion, Vector a_headers) {
        InfoServiceDBEntry.addPropertyHeader(Util.toVector(a_systemPropertyName), strVersion, a_headers);
    }

    private static void addPropertyHeader(Vector a_systemPropertyNames, Vector a_headers) {
        InfoServiceDBEntry.addPropertyHeader(a_systemPropertyNames, null, a_headers);
    }

    private static void addPropertyHeader(Vector a_systemPropertyNames, String strVersion, Vector a_headers) {
        if (a_systemPropertyNames == null || a_systemPropertyNames.size() == 0 || a_headers == null || a_systemPropertyNames.elementAt(0) == null) {
            return;
        }
        String propertyName = null;
        if (strVersion == null) {
            strVersion = "";
            for (int i = 0; i < a_systemPropertyNames.size(); ++i) {
                String newPropertyName;
                block15: {
                    newPropertyName = (String)a_systemPropertyNames.elementAt(i);
                    if (newPropertyName == null || newPropertyName.trim().length() == 0) continue;
                    try {
                        String propertyValue = System.getProperty(newPropertyName);
                        if (propertyValue == null || propertyValue.trim().equals("Sun Microsystems Inc.")) break block15;
                        strVersion = strVersion + propertyValue.trim();
                        if (!newPropertyName.equals("java.version")) break block15;
                        if (strVersion.indexOf("_") > 0) {
                            strVersion = strVersion.substring(0, strVersion.indexOf("_"));
                        }
                        if (strVersion.indexOf("-") <= 0) break block15;
                        strVersion = strVersion.substring(0, strVersion.indexOf("-"));
                    }
                    catch (Exception a_e) {
                        continue;
                    }
                }
                if (i + 1 < a_systemPropertyNames.size()) {
                    strVersion = strVersion + " / ";
                }
                newPropertyName = Util.replaceAll(newPropertyName, ".", "-").trim();
                if (propertyName == null) {
                    propertyName = newPropertyName;
                    continue;
                }
                while (propertyName.length() > 0 && !newPropertyName.startsWith(propertyName)) {
                    int indexCurrent = propertyName.lastIndexOf("-");
                    if (indexCurrent < 0) {
                        propertyName = "";
                        continue;
                    }
                    propertyName = propertyName.substring(0, indexCurrent);
                }
            }
            if (strVersion.trim().length() == 0) {
                return;
            }
        } else {
            propertyName = Util.replaceAll((String)a_systemPropertyNames.elementAt(0), ".", "-").trim();
        }
        if (strVersion != null) {
            StringTokenizer tokenizer = new StringTokenizer(strVersion, "\r\n");
            if (!tokenizer.hasMoreTokens()) {
                return;
            }
            strVersion = tokenizer.nextToken();
            if (propertyName.length() > 0) {
                propertyName = "-" + propertyName;
            }
            a_headers.addElement(new NVPair(HEADER_STATISTICS + propertyName, strVersion));
        }
    }

    private Document getXmlDocument(HttpRequestStructure a_httpRequest) throws Exception {
        return this.getXmlDocument(a_httpRequest, PROXY_AUTO);
    }

    private Document getXmlDocument(HttpRequestStructure a_httpRequest, Integer a_proxyPolicy) throws Exception {
        return this.getXmlDocument(a_httpRequest, 1, a_proxyPolicy);
    }

    private Document getXmlDocument(HttpRequestStructure a_httpRequest, int a_supportedEncodings) throws Exception {
        return this.getXmlDocument(a_httpRequest, a_supportedEncodings, PROXY_AUTO);
    }

    private Document getXmlDocument(HttpRequestStructure a_httpRequest, int a_supportedEncodings, Integer a_proxyPolicy) throws Exception {
        byte[] response = this.doHttpRequest(a_httpRequest, a_supportedEncodings, a_proxyPolicy);
        if (response == null) {
            return null;
        }
        return XMLUtil.toXMLDocument(response);
    }

    /*
     * Exception decompiling
     */
    private byte[] doHttpRequest(HttpRequestStructure a_httpRequest, int a_supportedEncodings, Integer a_proxyPolicy) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public MixCascade getMixCascadeInfo(String a_cascadeID) throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/cascadeinfo/" + a_cascadeID), 1);
        if (doc == null) {
            return null;
        }
        Element mixNode = doc.getDocumentElement();
        if (!SignatureVerifier.getInstance().verifyXml(mixNode, 1)) {
            throw new Exception("Cannot verify the signature for MixCascade entry: " + XMLUtil.toString(mixNode));
        }
        return new MixCascade(mixNode, Long.MAX_VALUE);
    }

    public Hashtable getMixCascades() throws Exception {
        return this.getMixCascades(true);
    }

    public Hashtable getPaymentInstances() throws Exception {
        return this.getPaymentInstances(true);
    }

    public PaymentInstanceDBEntry getPaymentInstance(String a_piID) throws Exception {
        HttpRequestStructure structure = HttpRequestStructure.createGetRequest("/paymentinstance/" + a_piID);
        Document doc = this.getXmlDocument(structure);
        if (doc == null) {
            return null;
        }
        PaymentInstanceDBEntry entry = new PaymentInstanceDBEntry(doc.getDocumentElement());
        if (!entry.isVerified()) {
            throw new SignatureException("Document could not be verified!");
        }
        return entry;
    }

    private Hashtable getEntries(EntryGetter a_getter) throws ExpiredSignatureException, SignatureException, Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest(a_getter.m_postFile), 1);
        if (doc == null) {
            return new Hashtable();
        }
        XMLSignature signature = SignatureVerifier.getInstance().getVerifiedXml(doc.getDocumentElement(), 2);
        boolean bExpired = false;
        if (SignatureVerifier.getInstance().isCheckSignatures() && (signature == null || !signature.isVerified() || (bExpired = !signature.getMultiCertPath().isValid(new Date())))) {
            if (bExpired) {
                throw new ExpiredSignatureException("Document signature validity has expired for InfoService " + this.getId() + "!");
            }
            throw new SignatureException("Document could not be verified for InfoService " + this.getId() + "!");
        }
        NodeList infoServicesNodes = doc.getElementsByTagName(XMLUtil.getXmlElementContainerName(a_getter.m_dbEntryClass));
        if (infoServicesNodes.getLength() == 0) {
            throw new XMLParseException(XMLUtil.getXmlElementContainerName(a_getter.m_dbEntryClass), "Error in XML structure.");
        }
        Element infoServicesNode = (Element)infoServicesNodes.item(0);
        NodeList infoServiceNodes = infoServicesNode.getElementsByTagName(XMLUtil.getXmlElementName(a_getter.m_dbEntryClass));
        Hashtable<String, InfoServiceDBEntry> entries = new Hashtable<String, InfoServiceDBEntry>();
        for (int i = 0; i < infoServiceNodes.getLength(); ++i) {
            Element entryNode = (Element)infoServiceNodes.item(i);
            try {
                AbstractDistributableCertifiedDatabaseEntry currentEntry = a_getter.m_dbEntryClass == (class$anon$infoservice$InfoServiceDBEntry == null ? InfoServiceDBEntry.class$("anon.infoservice.InfoServiceDBEntry") : class$anon$infoservice$InfoServiceDBEntry) ? new InfoServiceDBEntry(entryNode, a_getter.m_bJAPContext ? Long.MAX_VALUE : 0L) : (a_getter.m_dbEntryClass == (class$anon$infoservice$MixCascade == null ? InfoServiceDBEntry.class$("anon.infoservice.MixCascade") : class$anon$infoservice$MixCascade) ? (a_getter.m_bJAPContext ? new MixCascade(entryNode, Long.MAX_VALUE) : new MixCascade(entryNode)) : (a_getter.m_dbEntryClass == (class$anon$pay$PaymentInstanceDBEntry == null ? InfoServiceDBEntry.class$("anon.pay.PaymentInstanceDBEntry") : class$anon$pay$PaymentInstanceDBEntry) ? (a_getter.m_bJAPContext ? new PaymentInstanceDBEntry(entryNode, Long.MAX_VALUE) : new PaymentInstanceDBEntry(entryNode)) : (a_getter.m_bJAPContext ? new MixInfo(entryNode, Long.MAX_VALUE, false) : new MixInfo(entryNode))));
                if (((AbstractDistributableCertifiedDatabaseEntry)currentEntry).isVerified() || !SignatureVerifier.getInstance().isCheckSignatures()) {
                    entries.put(((AbstractDatabaseEntry)currentEntry).getId(), (InfoServiceDBEntry)currentEntry);
                    continue;
                }
                String strLoggedInfo = XMLUtil.parseAttribute((Node)entryNode, "id", null);
                if (strLoggedInfo == null) {
                    strLoggedInfo = XMLUtil.toString(entryNode);
                }
                LogHolder.log(4, LogType.MISC, "Cannot verify the signature for " + ClassUtil.getShortClassName(a_getter.m_dbEntryClass) + " entry: " + strLoggedInfo);
                continue;
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.MISC, "Error in " + ClassUtil.getShortClassName(a_getter.m_dbEntryClass) + " XML node!", e);
            }
        }
        return entries;
    }

    public Hashtable getInfoServices(boolean a_bJAPClientContext) throws Exception {
        EntryGetter getter = new EntryGetter();
        getter.m_bJAPContext = a_bJAPClientContext;
        getter.m_dbEntryClass = class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceDBEntry.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry;
        getter.m_postFile = "/infoservices";
        return this.getEntries(getter);
    }

    public Hashtable getMixCascades(boolean a_bJAPClientContext) throws Exception {
        EntryGetter getter = new EntryGetter();
        getter.m_bJAPContext = a_bJAPClientContext;
        getter.m_dbEntryClass = class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = InfoServiceDBEntry.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade;
        getter.m_postFile = "/cascades";
        return this.getEntries(getter);
    }

    public TermsAndConditionsTemplate getTCTemplate(String a_id) throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/tctemplate/" + a_id), 1);
        if (doc == null) {
            return null;
        }
        NodeList nodes = doc.getElementsByTagName(TermsAndConditionsTemplate.XML_ELEMENT_NAME);
        if (nodes.getLength() == 0) {
            throw new Exception("Error in XML structure for mix with ID " + a_id);
        }
        Element el = (Element)nodes.item(0);
        TermsAndConditionsTemplate framework = new TermsAndConditionsTemplate(el);
        if (!framework.isVerified()) {
            throw new Exception("Cannot verify the signature for Mix entry: " + XMLUtil.toString(el));
        }
        return framework;
    }

    public Hashtable getPaymentInstances(boolean a_bJAPClientContext) throws Exception {
        EntryGetter getter = new EntryGetter();
        getter.m_bJAPContext = a_bJAPClientContext;
        getter.m_dbEntryClass = class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = InfoServiceDBEntry.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry;
        getter.m_postFile = "/paymentinstances";
        return this.getEntries(getter);
    }

    public Hashtable getMixes(boolean a_bJAPClientContext) throws Exception {
        EntryGetter getter = new EntryGetter();
        getter.m_bJAPContext = a_bJAPClientContext;
        getter.m_dbEntryClass = class$anon$infoservice$MixInfo == null ? (class$anon$infoservice$MixInfo = InfoServiceDBEntry.class$("anon.infoservice.MixInfo")) : class$anon$infoservice$MixInfo;
        getter.m_postFile = "/mixes";
        return this.getEntries(getter);
    }

    public Hashtable getInfoServices() throws Exception {
        return this.getInfoServices(true);
    }

    public InetAddress getMyIP(Integer a_proxyPolicy) throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/echoip"), a_proxyPolicy);
        if (doc == null) {
            return null;
        }
        String inetAddr = XMLUtil.parseValue(XMLUtil.getFirstChildByName(doc.getDocumentElement(), "IP"), null);
        if (inetAddr == null) {
            throw new UnknownHostException("null");
        }
        try {
            return InetAddress.getByName(inetAddr);
        }
        catch (UnknownHostException a_e) {
            LogHolder.log(3, LogType.NET, a_e);
            throw a_e;
        }
    }

    public Hashtable getMixCascadeSerials() throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/cascadeserials"), 1);
        if (doc == null) {
            return new Hashtable();
        }
        if (!SignatureVerifier.getInstance().verifyXml(doc, 2)) {
            throw new SignatureException("Cannot verify the signature: " + XMLUtil.toString(doc));
        }
        return new AbstractDistributableDatabaseEntry.Serials(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = InfoServiceDBEntry.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).parse(doc.getDocumentElement());
    }

    public Hashtable getInfoServiceSerials() throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/infoserviceserials"), 1);
        if (doc == null) {
            return new Hashtable();
        }
        if (!SignatureVerifier.getInstance().verifyXml(doc, 2)) {
            throw new SignatureException("Cannot verify the signature: " + XMLUtil.toString(doc));
        }
        return new AbstractDistributableDatabaseEntry.Serials(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = InfoServiceDBEntry.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).parse(doc.getDocumentElement());
    }

    public MixInfo getMixInfo(String mixId) throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/mixinfo/" + mixId));
        if (doc == null) {
            return null;
        }
        NodeList mixNodes = doc.getElementsByTagName("Mix");
        if (mixNodes.getLength() == 0) {
            throw new Exception("Error in XML structure for mix with ID " + mixId);
        }
        Element mixNode = (Element)mixNodes.item(0);
        MixInfo info = new MixInfo(mixNode, Long.MAX_VALUE, false);
        if (!info.isVerified()) {
            throw new Exception("Cannot verify the signature for Mix entry: " + XMLUtil.toString(mixNode));
        }
        return info;
    }

    public StatusInfo getStatusInfo(MixCascade a_cascade) throws Exception {
        return this.getStatusInfo(a_cascade, -1L);
    }

    public Hashtable getExitAddresses() throws Exception {
        Hashtable<String, MixCascadeExitAddresses> hashAddresses = new Hashtable<String, MixCascadeExitAddresses>();
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/exitaddresses"));
        if (doc == null) {
            return null;
        }
        Element parent = doc.getDocumentElement();
        Node exitAddressesNode = XMLUtil.getFirstChildByName(parent, "ExitAddresses");
        Node currentAddress = null;
        String currentID = null;
        String currentIP = null;
        int currentDistribution = XMLUtil.parseAttribute(exitAddressesNode, "distribution", 6);
        while (exitAddressesNode != null) {
            currentID = XMLUtil.parseAttribute(exitAddressesNode, "id", "");
            if (!currentID.equals("")) {
                MixCascade cascade = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? InfoServiceDBEntry.class$("anon.infoservice.MixCascade") : class$anon$infoservice$MixCascade).getEntryById(currentID);
                if (cascade != null) {
                    currentDistribution = cascade.getDistribution();
                }
                currentAddress = XMLUtil.getFirstChildByName(exitAddressesNode, "ExitAddress");
                while (currentAddress != null) {
                    MixCascadeExitAddresses exit;
                    currentIP = XMLUtil.parseValue(currentAddress, "");
                    if (!currentIP.equals("") && (exit = MixCascadeExitAddresses.addInetAddress(currentID, InetAddress.getByName(currentIP), currentDistribution, this.getId())) != null) {
                        hashAddresses.put(exit.getId(), exit);
                    }
                    currentAddress = XMLUtil.getNextSiblingByName(currentAddress, "ExitAddress");
                }
            }
            exitAddressesNode = XMLUtil.getNextSiblingByName(exitAddressesNode, "ExitAddresses");
        }
        return hashAddresses;
    }

    public StatusInfo getStatusInfo(MixCascade a_cascade, long a_timeout) throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/mixcascadestatus/" + a_cascade.getId()));
        if (doc == null) {
            return null;
        }
        Element parent = doc.getDocumentElement();
        if (parent == null) {
            return null;
        }
        NodeList mixCascadeStatusNodes = doc.getElementsByTagName("MixCascadeStatus");
        if (mixCascadeStatusNodes.getLength() == 0) {
            if (XMLUtil.getFirstChildByName(doc, "HTML") == null) {
                throw new Exception("Error in XML structure for cascade with ID " + a_cascade.getId() + ".\n" + XMLUtil.toString(doc));
            }
            throw new Exception("No status data found for cascade with ID " + a_cascade.getId());
        }
        Element mixCascadeStatusNode = (Element)mixCascadeStatusNodes.item(0);
        StatusInfo info = a_timeout > 0L ? new StatusInfo(mixCascadeStatusNode, a_timeout) : new StatusInfo(mixCascadeStatusNode);
        if (SignatureVerifier.getInstance().isCheckSignatures() && !info.isVerified()) {
            throw new Exception("Cannot verify the signature for MixCascadeStatus entry: " + XMLUtil.toString(mixCascadeStatusNode));
        }
        return info;
    }

    public JAPMinVersion getNewVersionNumber() throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/currentjapversion"));
        if (doc == null) {
            return null;
        }
        Element japNode = (Element)XMLUtil.getFirstChildByName(doc, JAPMinVersion.getXmlElementName());
        if (!SignatureVerifier.getInstance().verifyXml(japNode, 3)) {
            throw new Exception("Cannot verify the signature for JAPMinVersion entry: " + XMLUtil.toString(japNode));
        }
        return new JAPMinVersion(japNode);
    }

    private Hashtable getUpdateEntries(Class a_distributable, boolean a_bSerials) throws Exception {
        Document doc = a_bSerials ? this.getXmlDocument(HttpRequestStructure.createGetRequest(AbstractDistributableDatabaseEntry.getHttpSerialsRequestString(a_distributable))) : this.getXmlDocument(HttpRequestStructure.createGetRequest(AbstractDistributableDatabaseEntry.getHttpRequestString(a_distributable)));
        if (doc == null) {
            return new Hashtable();
        }
        if (!SignatureVerifier.getInstance().verifyXml(doc.getDocumentElement(), 2)) {
            LogHolder.log(6, LogType.MISC, "Cannot verify the signature for " + a_distributable.getName() + " document: " + XMLUtil.toString(doc));
            return new Hashtable();
        }
        if (a_bSerials) {
            return new AbstractDistributableDatabaseEntry.Serials(a_distributable).parse(doc.getDocumentElement());
        }
        Node rootNode = XMLUtil.getFirstChildByName(doc, XMLUtil.getXmlElementContainerName(a_distributable));
        if (rootNode == null || !(rootNode instanceof Element)) {
            throw new XMLParseException(XMLUtil.getXmlElementContainerName(a_distributable), "Node missing!");
        }
        NodeList nodes = ((Element)rootNode).getElementsByTagName(XMLUtil.getXmlElementName(a_distributable));
        Hashtable<String, AbstractDistributableDatabaseEntry> versionInfos = new Hashtable<String, AbstractDistributableDatabaseEntry>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element versionNode = (Element)nodes.item(i);
            if (SignatureVerifier.getInstance().verifyXml(versionNode, 3)) {
                try {
                    AbstractDistributableDatabaseEntry currentVersionInfo = (AbstractDistributableDatabaseEntry)a_distributable.getConstructor(class$org$w3c$dom$Element == null ? InfoServiceDBEntry.class$("org.w3c.dom.Element") : class$org$w3c$dom$Element).newInstance(versionNode);
                    versionInfos.put(((AbstractDatabaseEntry)currentVersionInfo).getId(), currentVersionInfo);
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.MISC, "Error in " + a_distributable.getName() + " XML node.");
                }
                continue;
            }
            LogHolder.log(6, LogType.MISC, "Cannot verify the signature for " + a_distributable.getName() + " entry: " + XMLUtil.toString(versionNode));
        }
        return versionInfos;
    }

    public Hashtable getMessages() throws Exception {
        return this.getUpdateEntries(class$anon$infoservice$MessageDBEntry == null ? (class$anon$infoservice$MessageDBEntry = InfoServiceDBEntry.class$("anon.infoservice.MessageDBEntry")) : class$anon$infoservice$MessageDBEntry, false);
    }

    public Hashtable getMessageSerials() throws Exception {
        return this.getUpdateEntries(class$anon$infoservice$MessageDBEntry == null ? (class$anon$infoservice$MessageDBEntry = InfoServiceDBEntry.class$("anon.infoservice.MessageDBEntry")) : class$anon$infoservice$MessageDBEntry, true);
    }

    public PerformanceInfo getPerformanceInfo() throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/performanceinfo"), 1);
        if (doc == null) {
            return null;
        }
        Element nodePerf = (Element)XMLUtil.getFirstChildByName(doc, "PerformanceInfo");
        PerformanceInfo info = new PerformanceInfo(nodePerf);
        if (SignatureVerifier.getInstance().isCheckSignatures() && !info.isVerified()) {
            throw new SignatureException("Document could not be verified!");
        }
        return info;
    }

    public Hashtable getLatestJava() throws Exception {
        return this.getUpdateEntries(class$anon$infoservice$JavaVersionDBEntry == null ? (class$anon$infoservice$JavaVersionDBEntry = InfoServiceDBEntry.class$("anon.infoservice.JavaVersionDBEntry")) : class$anon$infoservice$JavaVersionDBEntry, false);
    }

    public Hashtable getLatestJavaSerials() throws Exception {
        return this.getUpdateEntries(class$anon$infoservice$JavaVersionDBEntry == null ? (class$anon$infoservice$JavaVersionDBEntry = InfoServiceDBEntry.class$("anon.infoservice.JavaVersionDBEntry")) : class$anon$infoservice$JavaVersionDBEntry, true);
    }

    public JAPVersionInfo getJAPVersionInfo(int a_japVersionType) throws Exception {
        Document doc = null;
        if (a_japVersionType == 1) {
            doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/japRelease.jnlp"));
        } else if (a_japVersionType == 2) {
            doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/japDevelopment.jnlp"));
        } else {
            throw new Exception("InfoServiceDBEntry: getJAPVersionInfo: Invalid version info requested.");
        }
        if (doc == null) {
            return null;
        }
        Element jnlpNode = (Element)XMLUtil.getFirstChildByName(doc, JAPVersionInfo.getXmlElementName());
        XMLSignature signature = SignatureVerifier.getInstance().getVerifiedXml(jnlpNode, 3);
        if (!signature.isVerified()) {
            throw new Exception("Cannot verify the signature for JAPVersionInfo entry: " + XMLUtil.toString(jnlpNode));
        }
        JAPVersionInfo info = new JAPVersionInfo(jnlpNode, a_japVersionType);
        if (!signature.getMultiCertPath().isValid(new Date())) {
            LogHolder.log(4, LogType.MISC, "Found an expired JAP/JonDo update entry for " + info.getPostFile() + "! The update verification certificate might become invalid soon.");
        }
        return info;
    }

    public byte[] getTorNodesList() throws Exception {
        byte[] list = null;
        try {
            list = this.doHttpRequest(HttpRequestStructure.createGetRequest("/tornodes"), 1, PROXY_AUTO);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (list == null) {
            try {
                list = this.doHttpRequest(HttpRequestStructure.createGetRequest("/tornodes"), 1, PROXY_AUTO);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (list == null) {
            throw new Exception("Error while parsing the TOR nodes list XML structure.");
        }
        return list;
    }

    public byte[] getMixminionNodesList() throws Exception {
        byte[] list = null;
        try {
            list = this.doHttpRequest(HttpRequestStructure.createGetRequest("/mixminionnodes"), 1, PROXY_AUTO);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (list == null) {
            throw new Exception("Error while parsing the TOR nodes list XML structure.");
        }
        return list;
    }

    public Element postNewForwarder(Element a_japForwarderNode) throws Exception {
        if (!this.hasPrimaryForwarderList()) {
            throw new Exception("InfoService: postNewForwarder: The InfoService " + this.getName() + " has no forwarder list.");
        }
        Document doc = this.getXmlDocument(HttpRequestStructure.createPostRequest("/addforwarder", a_japForwarderNode.getOwnerDocument()));
        if (doc == null) {
            return null;
        }
        NodeList japForwarderNodes = doc.getElementsByTagName("JapForwarder");
        if (japForwarderNodes.getLength() == 0) {
            throw new Exception("InfoService: postNewForwarder: Error in XML structure.");
        }
        return (Element)japForwarderNodes.item(0);
    }

    public Element postRenewForwarder(Element a_japForwarderNode) throws Exception {
        if (!this.hasPrimaryForwarderList()) {
            throw new Exception("InfoService: postRenewForwarder: The InfoService " + this.getName() + " has no forwarder list.");
        }
        Document doc = this.getXmlDocument(HttpRequestStructure.createPostRequest("/renewforwarder", a_japForwarderNode.getOwnerDocument()));
        if (doc == null) {
            return null;
        }
        NodeList japForwarderNodes = doc.getElementsByTagName("JapForwarder");
        if (japForwarderNodes.getLength() == 0) {
            throw new Exception("InfoService: postRenewForwarder: Error in XML structure.");
        }
        return (Element)japForwarderNodes.item(0);
    }

    public Element getForwarder() throws Exception {
        Document doc = this.getXmlDocument(HttpRequestStructure.createGetRequest("/getforwarder"));
        if (doc == null) {
            return null;
        }
        NodeList japForwarderNodes = doc.getElementsByTagName("JapForwarder");
        if (japForwarderNodes.getLength() == 0) {
            throw new Exception("InfoService: getForwarder: Error in XML structure.");
        }
        Element japForwarderNode = (Element)japForwarderNodes.item(0);
        NodeList errorInformationNodes = japForwarderNode.getElementsByTagName("ErrorInformation");
        if (errorInformationNodes.getLength() > 0) {
            Element errorInformationNode = (Element)errorInformationNodes.item(0);
            throw new Exception("InfoService: getForwarder: The infoservice returned error " + errorInformationNode.getAttribute("code") + ": " + errorInformationNode.getFirstChild().getNodeValue());
        }
        return japForwarderNode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ms_bUseStatistics = true;
        ms_proxyInterface = new IMutableProxyInterface.DummyMutableProxyInterface();
        ms_browserIdentification = new IBrowserIdentification(){

            public String getBrowserName() {
                return null;
            }
        };
        PROXY_AUTO = new Integer(0);
        PROXY_FORCE_ANONYMOUS = new Integer(1);
        PROXY_FORCE_DEFAULT = new Integer(2);
        PROXY_FORCE_DIRECT = new Integer(3);
    }

    private static class EntryGetter {
        String m_postFile;
        Class m_dbEntryClass;
        boolean m_bJAPContext;

        private EntryGetter() {
        }
    }
}

