/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.crypto.IASymMixCipher;
import anon.client.replay.ReplayTimestamp;

public class MixParameters {
    private String m_mixId;
    private IASymMixCipher m_mixCipher;
    private ReplayTimestamp m_replayTimestamp;
    private int m_replayOffset;
    private Object m_internalSynchronization;
    public static long m_referenceTime;

    public MixParameters(String a_mixId, IASymMixCipher a_mixCipher) {
        this.m_mixId = a_mixId;
        this.m_mixCipher = a_mixCipher;
        this.m_replayTimestamp = null;
        this.m_internalSynchronization = new Object();
        this.m_replayOffset = 0;
    }

    public String getMixId() {
        return this.m_mixId;
    }

    public IASymMixCipher getMixCipher() {
        return this.m_mixCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplayTimestamp getReplayTimestamp() {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            return this.m_replayTimestamp;
        }
    }

    public byte[] getReplayOffset() {
        byte[] r_replayOffset = new byte[3];
        this.m_replayOffset &= 0xFFFFFF;
        r_replayOffset[0] = (byte)(this.m_replayOffset >> 16);
        r_replayOffset[1] = (byte)(this.m_replayOffset >> 8 & 0xFF);
        r_replayOffset[2] = (byte)(this.m_replayOffset & 0xFF);
        return r_replayOffset;
    }

    public byte[] getCurrentReplayOffset(int diff) {
        if (this.m_replayOffset == 0) {
            return null;
        }
        byte[] r_replayOffset = new byte[3];
        int tmp_replayOffset = this.m_replayOffset + diff & 0xFFFFFF;
        r_replayOffset[0] = (byte)(tmp_replayOffset >> 16);
        r_replayOffset[1] = (byte)(tmp_replayOffset >> 8 & 0xFF);
        r_replayOffset[2] = (byte)(tmp_replayOffset & 0xFF);
        return r_replayOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplayTimestamp(ReplayTimestamp a_replayTimestamp) {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            this.m_replayTimestamp = a_replayTimestamp;
        }
    }

    public void setReplayOffset(int a_replayTimestamp) {
        this.m_replayOffset = a_replayTimestamp & 0xFFFFFF;
    }
}

