/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.FixedRatioChannelsDescription;
import anon.client.ITrustModel;
import anon.client.IllegalTCRequestPostConditionException;
import anon.client.MixPacket;
import anon.client.MixParameters;
import anon.client.crypto.ASymMixCipherPlainRSA;
import anon.client.crypto.ASymMixCipherRSAOAEP;
import anon.client.crypto.ControlChannelCipher;
import anon.client.crypto.KeyPool;
import anon.client.crypto.SymCipher;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLEncryption;
import anon.crypto.XMLSignature;
import anon.error.ServiceSignatureException;
import anon.error.TrustException;
import anon.error.UnknownProtocolVersionException;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.infoservice.ServiceOperator;
import anon.terms.TermsAndConditions;
import anon.terms.TermsAndConditionsMixInfo;
import anon.terms.TermsAndConditionsReadException;
import anon.terms.TermsAndConditionsRequest;
import anon.terms.TermsAndConditionsResponseHandler;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.Base64;
import anon.util.JAPMessages;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SignatureException;
import java.text.ParseException;
import java.util.Locale;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyExchangeManager {
    private int m_mixCascadeCertificateLock;
    private Object m_internalSynchronization;
    private boolean m_protocolWithTimestamp;
    private boolean m_protocolWithReplay;
    private boolean m_paymentRequired;
    private boolean m_bEnhancedChannelEncryption;
    private boolean m_bWithIntegrityCheck;
    private SymCipher m_firstMixSymmetricCipher;
    private ControlChannelCipher m_controlchannelCipher;
    private boolean m_chainProtocolWithFlowControl;
    private boolean m_chainProtocolWithUpstreamFlowControl;
    private int m_upstreamSendMe;
    private int m_downstreamSendMe;
    private boolean m_bDebug;
    private FixedRatioChannelsDescription m_fixedRatioChannelsDescription;
    private MixParameters[] m_mixParameters;
    private SymCipher m_multiplexerInputStreamCipher;
    private SymCipher m_multiplexerOutputStreamCipher;
    private MixCascade m_cascade;
    private TermsAndConditionsRequest m_tnCRequest;
    private TermsAndConditionsReadException tcrException;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$infoservice$MixInfo;

    public KeyExchangeManager(InputStream a_inputStream, OutputStream a_outputStream, MixCascade a_cascade, ITrustModel a_trustModel, boolean bDebug) throws XMLParseException, ServiceSignatureException, IOException, UnknownProtocolVersionException, TrustException, TermsAndConditionsReadException, IllegalTCRequestPostConditionException {
        block95: {
            this.m_bDebug = false;
            this.tcrException = null;
            this.m_bDebug = bDebug;
            try {
                int bytesRead;
                int xmlDataLength;
                this.m_mixCascadeCertificateLock = -1;
                this.m_internalSynchronization = new Object();
                DataInputStream dataStreamFromMix = new DataInputStream(a_inputStream);
                byte[] xmlData = new byte[xmlDataLength];
                for (xmlDataLength = dataStreamFromMix.readUnsignedShort(); xmlDataLength > 0; xmlDataLength -= bytesRead) {
                    bytesRead = a_inputStream.read(xmlData, xmlData.length - xmlDataLength, xmlDataLength);
                    if (bytesRead != -1) continue;
                    throw new EOFException("EOF detected while reading initial XML structure.");
                }
                Element elem = XMLUtil.toXMLDocument(xmlData).getDocumentElement();
                this.m_cascade = new MixCascade(elem, Long.MAX_VALUE, a_cascade.getId());
                boolean bUpdate = false;
                boolean bCascadeTrust = false;
                boolean bCascadeInDBTrust = false;
                TrustException excepTrust = null;
                ServiceSignatureException execSignature = null;
                if (a_cascade.isUserDefined()) {
                    this.m_cascade.setUserDefined(true, a_cascade);
                    bUpdate = true;
                    try {
                        a_trustModel.checkTrust(this.m_cascade, true);
                    }
                    catch (TrustException a_e) {
                        excepTrust = a_e;
                    }
                    catch (ServiceSignatureException a_e) {
                        execSignature = a_e;
                    }
                } else {
                    MixCascade cascadeInDB = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = KeyExchangeManager.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.m_cascade.getId());
                    if (cascadeInDB != null) {
                        if (!this.m_cascade.compareMixIDs(cascadeInDB)) {
                            bUpdate = true;
                        }
                        try {
                            a_trustModel.checkTrust(this.m_cascade, true);
                            bCascadeTrust = true;
                        }
                        catch (TrustException a_e) {
                            excepTrust = a_e;
                        }
                        catch (ServiceSignatureException a_e) {
                            execSignature = a_e;
                        }
                        try {
                            a_trustModel.checkTrust(cascadeInDB, true);
                            bCascadeInDBTrust = true;
                        }
                        catch (TrustException a_e) {
                        }
                        catch (ServiceSignatureException a_e) {
                            // empty catch block
                        }
                    }
                }
                if (execSignature != null) {
                    throw execSignature;
                }
                if (bUpdate || bCascadeTrust != bCascadeInDBTrust) {
                    Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = KeyExchangeManager.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).update(this.m_cascade);
                    if (this.m_cascade.isUserDefined()) {
                        Database.getInstance(class$anon$infoservice$MixInfo == null ? (class$anon$infoservice$MixInfo = KeyExchangeManager.class$("anon.infoservice.MixInfo")) : class$anon$infoservice$MixInfo).update(new MixInfo(this.m_cascade.getCertPath()));
                    }
                }
                if (excepTrust != null) {
                    throw excepTrust;
                }
                if (this.m_cascade.getMixProtocolVersion() == null) {
                    throw new XMLParseException("##__null__##", "MixProtocolVersion (channel) node expected in received XML structure.");
                }
                this.m_protocolWithTimestamp = false;
                this.m_protocolWithReplay = false;
                this.m_bEnhancedChannelEncryption = false;
                this.m_bWithIntegrityCheck = false;
                this.m_paymentRequired = this.m_cascade.isPayment();
                if (!this.m_cascade.isPaymentProtocolSupported()) {
                    throw new UnknownProtocolVersionException(this.m_cascade, "Payment", this.m_cascade.getPaymentProtocolVersion(), 0);
                }
                this.m_firstMixSymmetricCipher = null;
                this.m_controlchannelCipher = null;
                LogHolder.log(7, LogType.NET, "Cascade is using channel-protocol version '" + this.m_cascade.getMixProtocolVersion() + "'.");
                if (!this.m_cascade.getMixProtocolVersion().equals("0.2")) {
                    if (this.m_cascade.getMixProtocolVersion().equals("0.4")) {
                        this.m_firstMixSymmetricCipher = new SymCipher();
                    } else if (this.m_cascade.getMixProtocolVersion().equals("0.81")) {
                        this.m_protocolWithTimestamp = false;
                        this.m_protocolWithReplay = true;
                        this.m_firstMixSymmetricCipher = new SymCipher();
                    } else if (this.m_cascade.getMixProtocolVersion().equalsIgnoreCase("0.9")) {
                        this.m_firstMixSymmetricCipher = new SymCipher();
                    } else if (this.m_cascade.getMixProtocolVersion().equalsIgnoreCase("0.10")) {
                        this.m_firstMixSymmetricCipher = new SymCipher();
                        this.m_bEnhancedChannelEncryption = true;
                    } else if (this.m_cascade.getMixProtocolVersion().equalsIgnoreCase("0.11")) {
                        this.m_firstMixSymmetricCipher = new SymCipher();
                        this.m_bEnhancedChannelEncryption = true;
                        this.m_bWithIntegrityCheck = true;
                    } else if (this.m_cascade.getMixProtocolVersion().equalsIgnoreCase("0.12")) {
                        this.m_firstMixSymmetricCipher = new SymCipher();
                        this.m_bEnhancedChannelEncryption = true;
                        this.m_bWithIntegrityCheck = true;
                    } else {
                        throw new UnknownProtocolVersionException(this.m_cascade, "Mix", this.m_cascade.getMixProtocolVersion(), 0);
                    }
                }
                this.m_mixParameters = new MixParameters[this.m_cascade.getNumberOfMixes()];
                this.m_tnCRequest = new TermsAndConditionsRequest();
                for (int i = 0; i < this.m_cascade.getNumberOfMixes(); ++i) {
                    MixInfo mixinfo = this.m_cascade.getMixInfo(i);
                    if (mixinfo == null) {
                        throw new XMLParseException("Could not get MixInfo object for Mix " + i + "!");
                    }
                    if (i > 0 && SignatureVerifier.getInstance().isCheckSignatures() && !mixinfo.isVerified()) {
                        throw new ServiceSignatureException(this.m_cascade, "Received XML structure has an invalid signature for Mix " + Integer.toString(i + 1) + ".", i);
                    }
                    Element currentMixNode = mixinfo.getXmlStructure();
                    ASymMixCipherPlainRSA asymCipher = null;
                    asymCipher = this.m_bEnhancedChannelEncryption ? new ASymMixCipherRSAOAEP() : new ASymMixCipherPlainRSA();
                    this.m_mixParameters[i] = new MixParameters(mixinfo.getId(), asymCipher);
                    if (this.m_mixParameters[i].getMixCipher().setPublicKey(currentMixNode) != 0) {
                        throw new XMLParseException("Received XML structure contains an invalid public key for Mix " + Integer.toString(i) + ".");
                    }
                    if (this.m_cascade.isTermsAndConditionsConfirmationRequired()) {
                        ServiceOperator currentOperator = mixinfo.getServiceOperator();
                        TermsAndConditionsMixInfo tncInfo = mixinfo.getTermsAndConditionMixInfo();
                        if (tncInfo != null) {
                            try {
                                String templateRefID;
                                String langCode;
                                TermsAndConditions tc = TermsAndConditions.getTermsAndConditions(currentOperator);
                                if (tc == null || !tc.isMostRecent(tncInfo.getDate()) || tc.isSignatureObsolete()) {
                                    boolean previouslyAccepted = false;
                                    if (tc != null) {
                                        TermsAndConditions.removeTermsAndConditions(tc);
                                        previouslyAccepted = tc.isSignatureObsolete() ? tc.isAccepted() : false;
                                    }
                                    tc = new TermsAndConditions(currentOperator, tncInfo.getDate());
                                    if (!previouslyAccepted) {
                                        if (this.tcrException == null) {
                                            this.tcrException = new TermsAndConditionsReadException();
                                        }
                                        this.tcrException.addTermsAndConditonsToRead(tc);
                                    } else {
                                        tc.setAccepted(true);
                                    }
                                    TermsAndConditions.storeTermsAndConditions(tc);
                                } else if (!tc.isAccepted()) {
                                    if (this.tcrException == null) {
                                        this.tcrException = new TermsAndConditionsReadException();
                                    }
                                    this.tcrException.addTermsAndConditonsToRead(tc);
                                }
                                Locale currentLocale = JAPMessages.getLocale();
                                String string = langCode = tncInfo.hasTranslation(currentLocale) ? currentLocale.getLanguage().trim().toLowerCase() : tncInfo.getDefaultLanguage();
                                if (!langCode.equals(tncInfo.getDefaultLanguage()) && !tc.hasDefaultTranslation()) {
                                    this.m_tnCRequest.addCustomizedSectionsRequest(currentOperator, tncInfo.getDefaultLanguage());
                                    if (TermsAndConditionsTemplate.getById(tncInfo.getDefaultTemplateRefId(), false) == null) {
                                        this.m_tnCRequest.addTemplateRequest(currentOperator, tncInfo.getDefaultLanguage(), tncInfo.getDefaultTemplateRefId());
                                    }
                                }
                                if (TermsAndConditionsTemplate.getById(templateRefID = tncInfo.getTemplateRefId(langCode), false) == null) {
                                    this.m_tnCRequest.addTemplateRequest(currentOperator, langCode, templateRefID);
                                }
                                if (!tc.hasTranslation(langCode)) {
                                    this.m_tnCRequest.addCustomizedSectionsRequest(currentOperator, langCode);
                                }
                            }
                            catch (ParseException e) {
                                LogHolder.log(3, LogType.NET, "tc mix info " + tncInfo.getId() + " has an invalid date format: " + tncInfo.getDate());
                            }
                        } else {
                            LogHolder.log(4, LogType.NET, "Cascade requires Terms And Conditions confirmation but Mix " + mixinfo.getName() + " does not send any TC Infos!");
                        }
                    }
                    if (i == this.m_cascade.getNumberOfMixes() - 1) {
                        NodeList chainMixProtocolVersionNodes = currentMixNode.getElementsByTagName("MixProtocolVersion");
                        if (chainMixProtocolVersionNodes.getLength() == 0) {
                            throw new XMLParseException("##__null__##", "MixProtocolVersion (chain) node expected in received XML structure.");
                        }
                        Element chainMixProtocolVersionNode = (Element)chainMixProtocolVersionNodes.item(0);
                        String chainMixProtocolVersionValue = XMLUtil.parseValue((Node)chainMixProtocolVersionNode, (String)null);
                        if (chainMixProtocolVersionValue == null) {
                            throw new XMLParseException("##__null__##", "MixProtocolVersion (chain) node has no value.");
                        }
                        chainMixProtocolVersionValue = chainMixProtocolVersionValue.trim();
                        this.m_chainProtocolWithFlowControl = false;
                        this.m_chainProtocolWithUpstreamFlowControl = false;
                        this.m_fixedRatioChannelsDescription = null;
                        LogHolder.log(7, LogType.NET, "Cascade is using chain-protocol version '" + chainMixProtocolVersionValue + "'.");
                        if (chainMixProtocolVersionValue.equals("0.3")) continue;
                        if (chainMixProtocolVersionValue.equals("0.6")) {
                            this.m_chainProtocolWithFlowControl = true;
                            Node elemFlowControl = XMLUtil.getFirstChildByName(currentMixNode, "FlowControl");
                            if (elemFlowControl == null) {
                                throw new XMLParseException("##__null__##", "FlowControl node expected in received XML structure.");
                            }
                            Node elemUpstreamSendMe = XMLUtil.getFirstChildByName(elemFlowControl, "UpstreamSendMe");
                            if (elemUpstreamSendMe == null) {
                                throw new XMLParseException("##__null__##", "UpstreamSendMe node expected in received XML structure.");
                            }
                            Node elemDownstreamSendMe = XMLUtil.getFirstChildByName(elemFlowControl, "DownstreamSendMe");
                            if (elemDownstreamSendMe == null) {
                                throw new XMLParseException("##__null__##", "DownstreamSendMe node expected in received XML structure.");
                            }
                            this.m_upstreamSendMe = XMLUtil.parseValue(elemUpstreamSendMe, -1);
                            if (this.m_upstreamSendMe <= 0) {
                                throw new XMLParseException("##__null__##", "Got wrong value for UpstreamSendMe in received XML structure.");
                            }
                            this.m_downstreamSendMe = XMLUtil.parseValue(elemDownstreamSendMe, -1);
                            if (this.m_downstreamSendMe <= 0) {
                                throw new XMLParseException("##__null__##", "Got wrong value for DownstreamSendMe in received XML structure.");
                            }
                            this.m_chainProtocolWithUpstreamFlowControl = XMLUtil.parseAttribute(elemFlowControl, "withUpstreamFlowControl", false);
                            continue;
                        }
                        if (chainMixProtocolVersionValue.equals("0.5")) {
                            NodeList downstreamPacketsNodes = currentMixNode.getElementsByTagName("DownstreamPackets");
                            if (downstreamPacketsNodes.getLength() == 0) {
                                throw new XMLParseException("##__null__##", "DownstreamPackets node expected in received XML structure.");
                            }
                            Element downstreamPacketsNode = (Element)downstreamPacketsNodes.item(0);
                            int downstreamPackets = XMLUtil.parseValue((Node)downstreamPacketsNode, -1);
                            if (downstreamPackets < 1) {
                                throw new XMLParseException("DownstreamPackets", "Node has an invalid value.");
                            }
                            NodeList channelTimeoutNodes = currentMixNode.getElementsByTagName("ChannelTimeout");
                            if (channelTimeoutNodes.getLength() == 0) {
                                throw new XMLParseException("##__null__##", "ChannelTimeout node expected in received XML structure.");
                            }
                            Element channelTimeoutNode = (Element)channelTimeoutNodes.item(0);
                            long channelTimeout = XMLUtil.parseValue((Node)channelTimeoutNode, -1);
                            if (channelTimeout < 1L) {
                                throw new XMLParseException("ChannelTimeout node has an invalid value.");
                            }
                            channelTimeout = 1000L * channelTimeout;
                            NodeList chainTimeoutNodes = currentMixNode.getElementsByTagName("ChainTimeout");
                            if (chainTimeoutNodes.getLength() == 0) {
                                throw new XMLParseException("##__null__##", "ChainTimeout node expected in received XML structure.");
                            }
                            Element chainTimeoutNode = (Element)chainTimeoutNodes.item(0);
                            long chainTimeout = XMLUtil.parseValue((Node)chainTimeoutNode, -1);
                            if (chainTimeout < 1L) {
                                throw new XMLParseException("ChainTimeout", "Node has an invalid value.");
                            }
                            chainTimeout = 1000L * chainTimeout;
                            this.m_fixedRatioChannelsDescription = new FixedRatioChannelsDescription(downstreamPackets, channelTimeout, chainTimeout);
                            continue;
                        }
                        throw new UnknownProtocolVersionException(this.m_cascade, "Chain", chainMixProtocolVersionValue, i);
                    }
                    if (i != 0 || XMLUtil.getFirstChildByName(currentMixNode, "SupportsEncrypedControlChannels") == null) continue;
                    this.m_controlchannelCipher = new ControlChannelCipher();
                }
                this.m_multiplexerInputStreamCipher = new SymCipher();
                this.m_multiplexerOutputStreamCipher = new SymCipher();
                KeyPool.start(bDebug);
                LogHolder.log(7, LogType.NET, "Starting key exchange...");
                if (this.m_firstMixSymmetricCipher == null) {
                    MixPacket keyPacket = new MixPacket(0);
                    byte[] keyPacketIdentifier = "KEYPACKET".getBytes();
                    System.arraycopy(keyPacketIdentifier, 0, keyPacket.getPayloadData(), 0, keyPacketIdentifier.length);
                    byte[] keyBuffer = new byte[32];
                    KeyPool.getKey(keyBuffer, 0);
                    KeyPool.getKey(keyBuffer, 16);
                    System.arraycopy(keyBuffer, 0, keyPacket.getPayloadData(), keyPacketIdentifier.length, keyBuffer.length);
                    this.m_mixParameters[0].getMixCipher().encrypt(keyPacket.getPayloadData(), 0, keyPacket.getPayloadData(), 0);
                    a_outputStream.write(keyPacket.getRawPacket());
                    this.m_multiplexerInputStreamCipher.setEncryptionKeyAES(keyBuffer, 0, 16);
                    this.m_multiplexerOutputStreamCipher.setEncryptionKeyAES(keyBuffer, 16, 16);
                } else {
                    int bytesRead2;
                    int keySignatureXmlDataLength;
                    String strPreShardSecret;
                    Document keyDoc = XMLUtil.createDocument();
                    if (keyDoc == null) {
                        throw new XMLParseException("Cannot create XML document for key exchange.");
                    }
                    Element japKeyExchangeNode = keyDoc.createElement("JAPKeyExchange");
                    japKeyExchangeNode.setAttribute("version", "0.1");
                    Element linkEncryptionNode = keyDoc.createElement("LinkEncryption");
                    byte[] multiplexerKeys = new byte[64];
                    KeyPool.getKey(multiplexerKeys, 0);
                    KeyPool.getKey(multiplexerKeys, 16);
                    KeyPool.getKey(multiplexerKeys, 32);
                    KeyPool.getKey(multiplexerKeys, 48);
                    this.m_multiplexerOutputStreamCipher.setEncryptionKeyAES(multiplexerKeys, 0, 32);
                    this.m_multiplexerInputStreamCipher.setEncryptionKeyAES(multiplexerKeys, 32, 32);
                    XMLUtil.setValue((Node)linkEncryptionNode, Base64.encode(multiplexerKeys, true));
                    japKeyExchangeNode.appendChild(linkEncryptionNode);
                    Element mixEncryptionNode = keyDoc.createElement("MixEncryption");
                    byte[] mixKeys = new byte[32];
                    KeyPool.getKey(mixKeys, 0);
                    KeyPool.getKey(mixKeys, 16);
                    this.m_firstMixSymmetricCipher.setEncryptionKeyAES(mixKeys, 0, 32);
                    XMLUtil.setValue((Node)mixEncryptionNode, Base64.encode(mixKeys, true));
                    japKeyExchangeNode.appendChild(mixEncryptionNode);
                    if (this.m_controlchannelCipher != null) {
                        Element controlchannelEncryptionNode = keyDoc.createElement("ControlChannelEncryption");
                        byte[] controlchannelKeys = new byte[32];
                        KeyPool.getKey(controlchannelKeys, 0);
                        KeyPool.getKey(controlchannelKeys, 16);
                        this.m_controlchannelCipher.setSentKey(controlchannelKeys, 0, 16);
                        this.m_controlchannelCipher.setRecvKey(controlchannelKeys, 16, 16);
                        XMLUtil.setValue((Node)controlchannelEncryptionNode, Base64.encode(controlchannelKeys, true));
                        japKeyExchangeNode.appendChild(controlchannelEncryptionNode);
                    }
                    if ((strPreShardSecret = a_cascade.getAccessControlPreSharedSecret()) != null) {
                        Element elemPreShardSecret = keyDoc.createElement("AccessControlCredential");
                        XMLUtil.setValue((Node)elemPreShardSecret, strPreShardSecret);
                        japKeyExchangeNode.appendChild(elemPreShardSecret);
                    }
                    Element mixReplayNode = keyDoc.createElement("ReplayDetection");
                    if (this.m_protocolWithReplay) {
                        XMLUtil.setValue((Node)mixReplayNode, "true");
                    } else {
                        XMLUtil.setValue((Node)mixReplayNode, "false");
                    }
                    japKeyExchangeNode.appendChild(mixReplayNode);
                    Node elemCrypt = XMLEncryption.getEncryptedElement(japKeyExchangeNode, this.m_mixParameters[0].getMixCipher().getPublicKey());
                    keyDoc.appendChild(elemCrypt);
                    ByteArrayOutputStream keyExchangeBuffer = new ByteArrayOutputStream();
                    byte[] keyExchangeXmlData = XMLUtil.toByteArray(keyDoc);
                    DataOutputStream keyExchangeDataStream = new DataOutputStream(keyExchangeBuffer);
                    keyExchangeDataStream.writeShort(keyExchangeXmlData.length);
                    keyExchangeDataStream.flush();
                    keyExchangeBuffer.write(keyExchangeXmlData);
                    keyExchangeBuffer.flush();
                    byte[] keyExchangeData = keyExchangeBuffer.toByteArray();
                    a_outputStream.write(keyExchangeData);
                    a_outputStream.flush();
                    byte[] keySignatureXmlData = new byte[keySignatureXmlDataLength];
                    for (keySignatureXmlDataLength = dataStreamFromMix.readUnsignedShort(); keySignatureXmlDataLength > 0; keySignatureXmlDataLength -= bytesRead2) {
                        bytesRead2 = a_inputStream.read(keySignatureXmlData, keySignatureXmlData.length - keySignatureXmlDataLength, keySignatureXmlDataLength);
                        if (bytesRead2 != -1) continue;
                        throw new EOFException("EOF detected while reading symmetric key signature XML structure.");
                    }
                    Document keySignatureDoc = XMLUtil.toXMLDocument(keySignatureXmlData);
                    Element keySignatureNode = null;
                    if (this.m_protocolWithReplay) {
                        Element mixExchange = keySignatureDoc.getDocumentElement();
                        Element mixReplay = (Element)mixExchange.getFirstChild();
                        Element mixe = (Element)mixReplay.getFirstChild();
                        for (int i = 0; i < this.m_cascade.getNumberOfMixes(); ++i) {
                            for (int foo = 0; foo < this.m_cascade.getNumberOfMixes(); ++foo) {
                                if (!mixe.getAttribute("id").equals(this.m_mixParameters[foo].getMixId())) continue;
                                this.m_mixParameters[foo].setReplayOffset(Integer.parseInt(mixe.getFirstChild().getFirstChild().getNodeValue()));
                            }
                            mixe = (Element)XMLUtil.getNextSibling(mixe);
                        }
                        MixParameters.m_referenceTime = System.currentTimeMillis() / 1000L;
                        keySignatureNode = (Element)mixExchange.getLastChild();
                    } else {
                        keySignatureNode = keySignatureDoc.getDocumentElement();
                    }
                    if (keySignatureNode == null) {
                        throw new XMLParseException("##__root__##", "No document element in received symmetric key signature XML structure.");
                    }
                    keyDoc.getDocumentElement().appendChild(XMLUtil.importNode(keyDoc, keySignatureNode, true));
                    if (!XMLSignature.verifyFast((Node)keyDoc, this.m_cascade.getCertPath().getEndEntityKeys())) {
                        throw new ServiceSignatureException(this.m_cascade, "Invalid symmetric keys signature received.", 0);
                    }
                }
                if (!this.m_cascade.isTermsAndConditionsConfirmationRequired()) break block95;
                if (this.m_tnCRequest.hasResourceRequests()) {
                    Document tcRequestDoc = XMLUtil.createDocument();
                    Element tcRequestRoot = this.m_tnCRequest.toXmlElement(tcRequestDoc);
                    String tcRequest = XMLUtil.toString(tcRequestDoc);
                    if (tcRequest != null) {
                        ByteArrayOutputStream tcRequestBytesOut = new ByteArrayOutputStream();
                        DataOutputStream tcReqStream = new DataOutputStream(tcRequestBytesOut);
                        tcReqStream.writeShort(tcRequest.length());
                        tcReqStream.writeBytes(tcRequest);
                        a_outputStream.write(tcRequestBytesOut.toByteArray());
                        a_outputStream.flush();
                        int answerBytes = dataStreamFromMix.readInt();
                        byte[] answerData = new byte[answerBytes];
                        a_inputStream.read(answerData, 0, answerBytes);
                        Document answerDoc = XMLUtil.toXMLDocument(answerData);
                        if (answerDoc != null) {
                            try {
                                TermsAndConditionsResponseHandler.get().handleXMLResourceResponse(answerDoc, this.m_tnCRequest);
                            }
                            catch (SignatureException e) {
                                throw new ServiceSignatureException(this.m_cascade, "Could not verify terms and conditions signature: " + e.getMessage());
                            }
                        }
                    }
                }
                Document confirmDoc = XMLUtil.createDocument();
                Element confirmDocRoot = null;
                if (this.tcrException != null) {
                    confirmDocRoot = confirmDoc.createElement("TermsAndConditionsInterrupt");
                } else {
                    confirmDocRoot = confirmDoc.createElement("TermsAndConditionsConfirm");
                    XMLUtil.setAttribute(confirmDocRoot, "accepted", true);
                }
                confirmDoc.appendChild(confirmDocRoot);
                String acceptMsg = XMLUtil.toString(confirmDoc);
                ByteArrayOutputStream tcConfirmBytesOut = new ByteArrayOutputStream();
                DataOutputStream tcConfirmStream = new DataOutputStream(tcConfirmBytesOut);
                tcConfirmStream.writeShort(acceptMsg.length());
                tcConfirmStream.writeBytes(acceptMsg);
                a_outputStream.write(tcConfirmBytesOut.toByteArray());
                a_outputStream.flush();
                if (this.tcrException != null) {
                    throw this.tcrException;
                }
            }
            catch (ServiceSignatureException e) {
                this.removeCertificateLock();
                throw e;
            }
        }
    }

    public boolean isProtocolWithTimestamp() {
        return this.m_protocolWithTimestamp;
    }

    public boolean isPaymentRequired() {
        return this.m_paymentRequired;
    }

    public boolean isChainProtocolWithFlowControl() {
        return this.m_chainProtocolWithFlowControl;
    }

    public boolean isChainProtocolWithUpstreamFlowControl() {
        return this.m_chainProtocolWithUpstreamFlowControl;
    }

    public int getUpstreamSendMe() {
        return this.m_upstreamSendMe;
    }

    public int getDownstreamSendMe() {
        return this.m_downstreamSendMe;
    }

    public FixedRatioChannelsDescription getFixedRatioChannelsDescription() {
        return this.m_fixedRatioChannelsDescription;
    }

    public SymCipher getFirstMixSymmetricCipher() {
        return this.m_firstMixSymmetricCipher;
    }

    public SymCipher getMultiplexerInputStreamCipher() {
        return this.m_multiplexerInputStreamCipher;
    }

    public SymCipher getMultiplexerOutputStreamCipher() {
        return this.m_multiplexerOutputStreamCipher;
    }

    public MixParameters[] getMixParameters() {
        return this.m_mixParameters;
    }

    public MixCascade getConnectedCascade() {
        return this.m_cascade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCertificateLock() {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            if (this.m_mixCascadeCertificateLock != -1) {
                SignatureVerifier.getInstance().getVerificationCertificateStore().removeCertificateLock(this.m_mixCascadeCertificateLock);
                this.m_mixCascadeCertificateLock = -1;
            }
        }
    }

    public boolean isProtocolWithEnhancedChannelEncryption() {
        return this.m_bEnhancedChannelEncryption;
    }

    public boolean isProtocolWithIntegrityCheck() {
        return this.m_bWithIntegrityCheck;
    }

    public ControlChannelCipher getControlChannelCipher() {
        return this.m_controlchannelCipher;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

