/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpOutputStream;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Hashtable;

class AuthorizationModule
implements HTTPClientModule,
GlobalConstants {
    private static Hashtable proxy_cntxt_list = new Hashtable();
    private static Hashtable deferred_auth_list = new Hashtable();
    private int auth_lst_idx = 0;
    private int prxy_lst_idx = 0;
    private int auth_scm_idx = 0;
    private int prxy_scm_idx = 0;
    private AuthorizationInfo auth_sent = null;
    private AuthorizationInfo prxy_sent = null;
    private boolean auth_from_4xx = false;
    private boolean prxy_from_4xx = false;
    private int num_tries = 0;
    private Request saved_req = null;
    private Response saved_resp = null;

    AuthorizationModule() {
    }

    public int requestHandler(Request req, Response[] resp) throws IOException, AuthSchemeNotImplException {
        block18: {
            AuthorizationInfo guess;
            block20: {
                AuthorizationHandler auth_handler;
                block17: {
                    block19: {
                        Hashtable proxy_auth_list;
                        HTTPConnection con = req.getConnection();
                        auth_handler = AuthorizationInfo.getAuthHandler();
                        HttpOutputStream out = req.getStream();
                        if (out != null && deferred_auth_list.get(out) != null) {
                            this.copyFrom((AuthorizationModule)deferred_auth_list.get(out));
                            req.copyFrom(this.saved_req);
                            deferred_auth_list.remove(out);
                            if (GlobalConstants.DebugMods) {
                                Util.logLine("AuthM: Handling deferred auth challenge");
                            }
                            this.handle_auth_challenge(req, this.saved_resp);
                            if (GlobalConstants.DebugMods) {
                                if (this.auth_sent != null) {
                                    Util.logLine("AuthM: Sending request with Authorization '" + this.auth_sent + "'");
                                } else {
                                    Util.logLine("AuthM: Sending request with Proxy-Authorization '" + this.prxy_sent + "'");
                                }
                            }
                            return 1;
                        }
                        if (con.getProxyHost() == null || this.prxy_from_4xx || (guess = (AuthorizationInfo)(proxy_auth_list = Util.getList(proxy_cntxt_list, req.getConnection().getContext())).get(con.getProxyHost() + ":" + con.getProxyPort())) == null) break block17;
                        if (auth_handler == null) break block19;
                        try {
                            guess = auth_handler.fixupAuthInfo(guess, req, null, null, true);
                        }
                        catch (AuthSchemeNotImplException atnie) {
                            break block17;
                        }
                        if (guess == null) break block17;
                    }
                    req.setHeaders(Util.setValue(req.getHeaders(), "Proxy-Authorization", guess.toString()));
                    this.prxy_sent = guess;
                    this.prxy_from_4xx = false;
                    if (GlobalConstants.DebugMods) {
                        Util.logLine("AuthM: Preemptively sending Proxy-Authorization '" + guess + "'");
                    }
                }
                if (this.auth_from_4xx || (guess = AuthorizationInfo.findBest(req)) == null) break block18;
                if (auth_handler == null) break block20;
                try {
                    guess = auth_handler.fixupAuthInfo(guess, req, null, null, false);
                }
                catch (AuthSchemeNotImplException atnie) {
                    break block18;
                }
                if (guess == null) break block18;
            }
            req.setHeaders(Util.setValue(req.getHeaders(), "Authorization", guess.toString()));
            this.auth_sent = guess;
            this.auth_from_4xx = false;
            if (GlobalConstants.DebugMods) {
                Util.logLine("AuthM: Preemptively sending Authorization '" + guess + "'");
            }
        }
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) throws IOException {
        if (resp.getStatusCode() != 401 && resp.getStatusCode() != 407) {
            if (this.auth_sent != null && this.auth_from_4xx) {
                try {
                    AuthorizationInfo.getAuthorization(this.auth_sent, req, resp, false, false).addPath(req.getRequestURI());
                }
                catch (AuthSchemeNotImplException authSchemeNotImplException) {
                    // empty catch block
                }
            }
            this.num_tries = 0;
        }
        this.auth_from_4xx = false;
        this.prxy_from_4xx = false;
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException, AuthSchemeNotImplException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthHeaders(resp, req, this.auth_sent, this.prxy_sent);
        }
        int sts = resp.getStatusCode();
        switch (sts) {
            case 401: 
            case 407: {
                ++this.num_tries;
                if (this.num_tries > 10) {
                    throw new ProtocolException("Bug in authorization handling: server refused the given info 10 times");
                }
                if (req.getStream() != null) {
                    this.saved_req = (Request)req.clone();
                    this.saved_resp = (Response)resp.clone();
                    deferred_auth_list.put(req.getStream(), this);
                    req.getStream().reset();
                    resp.setRetryRequest(true);
                    if (GlobalConstants.DebugMods) {
                        Util.logLine("AuthM: Handling of status " + sts + " deferred because an output stream was" + " used");
                    }
                    return 10;
                }
                if (GlobalConstants.DebugMods) {
                    Util.logLine("AuthM: Handling status: " + sts + " " + resp.getReasonLine());
                }
                this.handle_auth_challenge(req, resp);
                if (this.auth_sent == null && this.prxy_sent == null) {
                    if (GlobalConstants.DebugMods) {
                        Util.logLine("AuthM: No Auth Info found - status " + sts + " not handled");
                    }
                    return 10;
                }
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (GlobalConstants.DebugMods) {
                    if (this.auth_sent != null) {
                        Util.logLine("AuthM: Resending request with Authorization '" + this.auth_sent + "'");
                    }
                    if (this.prxy_sent != null) {
                        Util.logLine("AuthM: Resending request with Proxy-Authorization '" + this.prxy_sent + "'");
                    }
                }
                return 13;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) throws IOException {
        AuthorizationHandler h = AuthorizationInfo.getAuthHandler();
        if (h != null) {
            h.handleAuthTrailers(resp, req, this.auth_sent, this.prxy_sent);
        }
    }

    private void handle_auth_challenge(Request req, Response resp) throws AuthSchemeNotImplException, IOException {
        int[] idx_arr = new int[]{this.auth_lst_idx, this.auth_scm_idx};
        this.auth_sent = this.setAuthHeaders(resp.getHeader("WWW-Authenticate"), req, resp, "Authorization", false, idx_arr, this.auth_sent);
        if (this.auth_sent != null) {
            this.auth_from_4xx = true;
        }
        this.auth_lst_idx = idx_arr[0];
        this.auth_scm_idx = idx_arr[1];
        idx_arr[0] = this.prxy_lst_idx;
        idx_arr[1] = this.prxy_scm_idx;
        this.prxy_sent = this.setAuthHeaders(resp.getHeader("Proxy-Authenticate"), req, resp, "Proxy-Authorization", true, idx_arr, this.prxy_sent);
        if (this.prxy_sent != null) {
            this.prxy_from_4xx = true;
        }
        this.prxy_lst_idx = idx_arr[0];
        this.prxy_scm_idx = idx_arr[1];
        if (this.prxy_sent != null) {
            HTTPConnection con = req.getConnection();
            Util.getList(proxy_cntxt_list, con.getContext()).put(con.getProxyHost() + ":" + con.getProxyPort(), this.prxy_sent);
        }
        if (this.auth_sent == null && this.prxy_sent == null && resp.getHeader("WWW-Authenticate") == null && resp.getHeader("Proxy-Authenticate") == null) {
            if (resp.getStatusCode() == 401) {
                throw new ProtocolException("Missing WWW-Authenticate header");
            }
            throw new ProtocolException("Missing Proxy-Authenticate header");
        }
    }

    /*
     * Unable to fully structure code
     */
    private AuthorizationInfo setAuthHeaders(String auth_str, Request req, RoResponse resp, String header, boolean proxy_auth, int[] idx_arr, AuthorizationInfo prev) throws ProtocolException, AuthSchemeNotImplException {
        if (auth_str == null) {
            return null;
        }
        con = req.getConnection();
        challenge = proxy_auth != false && con.getProxyHost() != null ? AuthorizationInfo.parseAuthString(auth_str, con.getProxyHost(), con.getProxyPort()) : AuthorizationInfo.parseAuthString(auth_str, con.getHost(), con.getPort());
        if (GlobalConstants.DebugMods) {
            Util.logLine("AuthM: parsed " + challenge.length + " challenges:");
            idx = 0;
            while (idx < challenge.length) {
                Util.logLine("AuthM: Challenge " + challenge[idx]);
                ++idx;
            }
        }
        if (prev != null && prev.getScheme().equalsIgnoreCase("Basic")) {
            idx = 0;
            while (idx < challenge.length) {
                if (prev.getRealm().equals(challenge[idx].getRealm()) && prev.getScheme().equalsIgnoreCase(challenge[idx].getScheme())) {
                    AuthorizationInfo.removeAuthorization(prev, con.getContext());
                }
                ++idx;
            }
        }
        credentials = null;
        auth_handler = AuthorizationInfo.getAuthHandler();
        if (auth_handler == null || (challenge = auth_handler.orderChallenges(challenge, req, resp, proxy_auth)) != null) ** GOTO lbl28
        return null;
lbl-1000:
        // 1 sources

        {
            credentials = AuthorizationInfo.getAuthorization(challenge[idx_arr[0]], req, resp, proxy_auth, false);
            if (auth_handler != null && credentials != null) {
                credentials = auth_handler.fixupAuthInfo(credentials, req, challenge[idx_arr[0]], resp, proxy_auth);
            }
            if ((idx_arr[0] = idx_arr[0] + 1) != challenge.length) continue;
            idx_arr[0] = -1;
lbl28:
            // 3 sources

            ** while (credentials == null && idx_arr[0] != -1)
        }
lbl29:
        // 1 sources

        if (credentials == null) {
            idx = 0;
            while (idx < challenge.length) {
                try {
                    credentials = AuthorizationInfo.queryAuthHandler(challenge[idx_arr[1]], req, resp, proxy_auth);
                    break;
                }
                catch (AuthSchemeNotImplException atnie) {
                    if (idx == challenge.length - 1) {
                        throw atnie;
                    }
                    ++idx;
                }
            }
            if ((idx_arr[1] = idx_arr[1] + 1) == challenge.length) {
                idx_arr[1] = 0;
            }
        }
        if (credentials == null) {
            return null;
        }
        req.setHeaders(Util.setValue(req.getHeaders(), header, credentials.toString()));
        return credentials;
    }

    private void copyFrom(AuthorizationModule other) {
        this.auth_lst_idx = other.auth_lst_idx;
        this.prxy_lst_idx = other.prxy_lst_idx;
        this.auth_scm_idx = other.auth_scm_idx;
        this.prxy_scm_idx = other.prxy_scm_idx;
        this.auth_sent = other.auth_sent;
        this.prxy_sent = other.prxy_sent;
        this.auth_from_4xx = other.auth_from_4xx;
        this.prxy_from_4xx = other.prxy_from_4xx;
        this.num_tries = other.num_tries;
        this.saved_req = other.saved_req;
        this.saved_resp = other.saved_resp;
    }
}

