/*
 * Decompiled with CFR 0.152.
 */
package misc;

import anon.proxy.DirectProxy;
import jap.JAPDebug;
import java.net.ServerSocket;
import logging.LogHolder;
import logging.LogType;

public final class JAPHTTPProxy {
    boolean runFlag;
    int port = 4008;
    ServerSocket server;

    public JAPHTTPProxy(int port) {
        this.port = port;
        LogHolder.setLogInstance(JAPDebug.getInstance());
        JAPDebug.getInstance().setLogType(LogType.NET + LogType.GUI + LogType.MISC);
        JAPDebug.getInstance().setLogLevel(7);
    }

    public void startService() {
        this.server = null;
        this.runFlag = true;
        System.out.println("Service on port " + this.port + " started.");
        try {
            this.server = new ServerSocket(this.port);
            DirectProxy c = new DirectProxy(this.server, null, null, null);
            c.start();
        }
        catch (Exception e) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LogHolder.log(2, LogType.NET, "Exception: " + e);
        }
    }

    public void stopService() {
        this.runFlag = false;
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void help() {
        System.out.println("HTTPProxy");
        System.out.println(" Options: -debug -port <port>");
    }

    public static void main(String[] args) {
        int cmdPort = 4001;
        boolean showHelp = false;
        if (args.length == 0) {
            showHelp = true;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equalsIgnoreCase("-port")) {
                    cmdPort = Integer.parseInt(args[i + 1]);
                    ++i;
                    continue;
                }
                showHelp = true;
            }
        }
        catch (Exception e) {
            showHelp = true;
        }
        if (showHelp) {
            JAPHTTPProxy.help();
        }
        JAPHTTPProxy p = new JAPHTTPProxy(cmdPort);
        p.startService();
    }
}

