/*
 * Decompiled with CFR 0.152.
 */
package misc;

import anon.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Random;

public final class GenerateUpload
implements Runnable {
    private static final int MAX_WAIT_BETWEEN_CHANNELS = 100;
    private static final int MAX_CHANNELS = 1;
    private static final int MAX_SINGLE_CALL_UPLOAD = 998;
    public int MAX_WAIT_BETWEEN_SINGLE_CALL_UPLOAD = 0;
    static int MIN_UPLOAD = 1000000;
    static int MAX_UPLOAD = 10000000;
    private static byte[] randomData;
    static Random rand;
    static int success;
    static int failed;
    int m_Port;
    private Thread t;

    public GenerateUpload(int i) {
        this.m_Port = i;
    }

    static synchronized void incFailed() {
        ++failed;
    }

    static synchronized void incSuccess() {
        ++success;
    }

    public static void main(String[] args) throws UnknownHostException, IOException {
        int i;
        boolean bTest = false;
        rand = new Random();
        randomData = new byte[256000];
        for (int i2 = 0; i2 < randomData.length; ++i2) {
            GenerateUpload.randomData[i2] = (byte)i2;
        }
        int numberOfClients = 1;
        if (args.length >= 1) {
            numberOfClients = Integer.parseInt(args[0]);
        }
        int firstPort = 4001;
        if (args.length >= 2) {
            firstPort = Integer.parseInt(args[1]);
        }
        if (args.length >= 3) {
            bTest = true;
        }
        System.out.println("Number of clients: " + numberOfClients);
        System.out.println("first Port: " + firstPort);
        System.out.println("Test first: " + bTest);
        if (bTest) {
            for (int i3 = 0; i3 < numberOfClients; ++i3) {
                int port = firstPort + i3;
                System.out.print("Testing client on port: " + port);
                GenerateUpload.doTest(port);
                System.out.println(" -- ok!");
            }
        }
        GenerateUpload[] gs = new GenerateUpload[numberOfClients];
        for (i = 0; i < numberOfClients; ++i) {
            gs[i] = new GenerateUpload(firstPort + i);
            gs[i].start();
        }
        try {
            for (i = 0; i < numberOfClients; ++i) {
                gs[i].t.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void doTest(int port) {
        while (true) {
            try {
                Socket s = new Socket("141.76.46.165", port);
                OutputStream out = s.getOutputStream();
                InputStream in = s.getInputStream();
                byte[] ar = new byte[36];
                for (int i = 0; i < ar.length; ++i) {
                    ar[i] = (byte)i;
                }
                out.write(ar);
                out.flush();
                int r = in.read();
                in.close();
                out.close();
                s.close();
                if (r == 0) {
                    return;
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                Thread.sleep(500L);
            }
            catch (Throwable throwable) {
            }
        }
    }

    void start() {
        this.t = new Thread((Runnable)this, "GenerateUpload - main");
        this.t.setDaemon(false);
        this.t.start();
    }

    public void run() {
        int i;
        Upload[] uploads = new Upload[1];
        for (i = 0; i < 1; ++i) {
            uploads[i] = new Upload(MIN_UPLOAD + rand.nextInt(MAX_UPLOAD - MIN_UPLOAD), i + 1);
            try {
                Thread.sleep(rand.nextInt(100));
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < 1; ++i) {
            uploads[i].join();
        }
        System.out.println(success + " ok / " + failed + " failed");
    }

    static {
        success = 0;
        failed = 0;
    }

    final class Upload
    implements Runnable {
        int maxLen;
        int id;
        Thread t;

        public Upload(int maxL, int ID) {
            this.id = ID;
            this.maxLen = maxL;
            this.t = new Thread((Runnable)this, "Uploadthread: " + this.id);
            this.t.setDaemon(false);
            this.t.start();
        }

        public void join() {
            try {
                this.t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void run() {
            int l = 0;
            Socket s = null;
            try {
                s = new Socket("141.76.46.165", GenerateUpload.this.m_Port);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                OutputStream out = s.getOutputStream();
                Download d = new Download(s.getInputStream(), this.maxLen, this.id);
                int currentPos = 0;
                int len = 0;
                long starttime = System.currentTimeMillis();
                while (l < this.maxLen) {
                    len = Math.min(rand.nextInt(998), randomData.length - currentPos);
                    len = Math.min(len, this.maxLen - l);
                    out.write(randomData, currentPos, len);
                    currentPos += len;
                    currentPos %= randomData.length;
                    if ((l += len) % 1000000 == 0) {
                        System.out.println("Sent: " + l / 1000000 + " MBytes");
                    }
                    try {
                        if (GenerateUpload.this.MAX_WAIT_BETWEEN_SINGLE_CALL_UPLOAD <= 0) continue;
                        Thread.sleep(rand.nextInt(GenerateUpload.this.MAX_WAIT_BETWEEN_SINGLE_CALL_UPLOAD));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long endtime = System.currentTimeMillis();
                d.setStartTime(starttime);
                long duration = endtime - starttime;
                if (duration == 0L) {
                    duration = 1L;
                }
                System.out.println("Upload: " + this.id + " Sent: " + l + " Bytes in " + duration + "ms [" + Util.formatKbitPerSecValueWithUnit((long)(l * 8) / duration) + "]");
                d.join();
                s.close();
            }
            catch (Throwable t) {
                System.out.println("Exception in Upload -- l=" + l);
                t.printStackTrace();
            }
        }

        final class Download
        implements Runnable {
            InputStream in;
            int maxLen;
            int id;
            long starttime;
            Thread t;

            Download(InputStream i, int maxL, int ID) {
                this.id = ID;
                this.in = i;
                this.maxLen = maxL;
                this.t = new Thread((Runnable)this, "Downloadthread: " + this.id);
                this.t.setDaemon(false);
                this.t.start();
            }

            public void join() {
                try {
                    this.t.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }

            public void setStartTime(long l) {
                this.starttime = l;
            }

            public void run() {
                try {
                    byte[] buff = new byte[10000];
                    int l = 0;
                    long reported = 1000000L;
                    int currentPos = 0;
                    while (l < this.maxLen) {
                        int r = Math.min(buff.length, randomData.length - currentPos);
                        r = Math.min(r, this.maxLen - l);
                        r = this.in.read(buff, 0, r);
                        for (int z = 0; z < r; ++z) {
                            if (buff[z] == randomData[currentPos + z]) continue;
                            System.out.println("Download: " + this.id + " -- Read error! -- Position: " + l + " -- Read: " + (buff[z] & 0xFF) + " -- Expected: " + (randomData[currentPos + z] & 0xFF));
                            System.out.println("AscII:");
                            System.out.println(new String(buff));
                            GenerateUpload.incFailed();
                            return;
                        }
                        currentPos += r;
                        currentPos %= randomData.length;
                        if ((long)(l += r) < reported) continue;
                        System.out.println("Read: " + (double)l / 1000000.0 + " MBytes");
                        reported += 1000000L;
                    }
                    long endtime = System.currentTimeMillis();
                    long duration = endtime - this.starttime;
                    System.out.println("Download: " + this.id + " -- Succesfully received: " + l + " Bytes in " + duration + "ms [" + Util.formatKbitPerSecValueWithUnit((long)(l * 8) / duration) + "]");
                    GenerateUpload.incSuccess();
                }
                catch (Exception e) {
                    System.out.println("Read failed!");
                }
            }
        }
    }
}

