/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class EchoServer
implements Runnable {
    private Socket m_Socket;

    public EchoServer(Socket s) {
        this.m_Socket = s;
        new Thread(this).start();
    }

    public static void main(String[] args) throws Exception {
        ServerSocket server = new ServerSocket(3128);
        while (true) {
            Socket s = server.accept();
            new EchoServer(s);
        }
    }

    public void run() {
        try {
            byte[] buff = new byte[10000];
            InputStream in = this.m_Socket.getInputStream();
            OutputStream out = this.m_Socket.getOutputStream();
            int len = 0;
            int currentPos = 0;
            while ((len = in.read(buff)) > 0) {
                for (int z = 0; z < len; ++z) {
                    int b = buff[z] & 0xFF;
                    if (b != currentPos % 256) {
                        System.out.println("EchoServer (" + this.m_Socket + ")read failure at position: " + currentPos + " -- Read: " + b + " -- Expected: " + currentPos % 256);
                    }
                    ++currentPos;
                }
                out.write(buff, 0, len);
            }
            System.out.println("EchoServer (" + this.m_Socket + ")read/write " + currentPos + " Bytes");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.m_Socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

