/*
 * Decompiled with CFR 0.152.
 */
package jarify;

import jarify.JarFileEntry;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class JarManifest
extends JarFileEntry {
    private Hashtable entries = new Hashtable();
    private Vector fileNameList = new Vector();
    protected String contentStrRaw;
    protected String newLine;

    public JarManifest(long size, InputStream stream) {
        super("META-INF/MANIFEST.MF", size, stream);
        this.init();
    }

    protected void init() {
        byte[] buffer = this.getContent();
        if (buffer == null) {
            return;
        }
        this.contentStrRaw = new String(buffer);
        this.newLine = this.contentStrRaw.indexOf("\r\n") != -1 ? "\r\n" : (this.contentStrRaw.indexOf("\r") != -1 ? "\r" : "\n");
        this.parse();
    }

    private void parse() {
        int startPos = 0;
        int newLinePos = 0;
        while ((startPos = this.contentStrRaw.indexOf(this.newLine + "Name: ", startPos)) != -1) {
            int endPos = this.contentStrRaw.indexOf(this.newLine + this.newLine, startPos += this.newLine.length());
            String rawEntry = this.contentStrRaw.substring(startPos, endPos + this.newLine.length() * 2);
            EntryData entryData = new EntryData(rawEntry.getBytes());
            int contPos = 0;
            while ((contPos = rawEntry.indexOf(this.newLine + " ")) != -1) {
                rawEntry = rawEntry.substring(0, contPos) + rawEntry.substring(contPos + this.newLine.length() + 1, rawEntry.length());
            }
            String fileName = rawEntry.substring("Name: ".length(), rawEntry.indexOf(this.newLine));
            this.fileNameList.addElement(fileName);
            this.entries.put(fileName, entryData);
            int digestStartPos = startPos = rawEntry.indexOf(this.newLine);
            while ((digestStartPos = rawEntry.indexOf("-Digest: ", digestStartPos + 1)) != -1) {
                int temp = 0;
                while ((temp = rawEntry.indexOf(this.newLine, temp + 1)) < digestStartPos) {
                    newLinePos = temp;
                }
                String digestName = rawEntry.substring(newLinePos + this.newLine.length(), digestStartPos + 7);
                String digestValue = rawEntry.substring(digestStartPos + 9, rawEntry.indexOf(this.newLine, digestStartPos));
                entryData.digests.put(digestName, digestValue);
            }
            startPos = endPos - 3;
        }
    }

    public Vector getFileNames() {
        return this.fileNameList;
    }

    public String getDigest(JarFileEntry file, String digestID) {
        return this.getDigest(file.getName(), digestID);
    }

    public String getDigest(String fileName, String digestID) {
        EntryData entry = (EntryData)this.entries.get(fileName);
        if (entry == null) {
            return null;
        }
        return (String)entry.digests.get(digestID);
    }

    public byte[] getEntry(String fileName) {
        EntryData entry = (EntryData)this.entries.get(fileName);
        if (entry == null) {
            return null;
        }
        return entry.raw;
    }

    public Vector getDigestList(String fileName) {
        EntryData entry = (EntryData)this.entries.get(fileName);
        if (entry == null) {
            return null;
        }
        Enumeration digests = entry.digests.keys();
        Vector digVector = new Vector();
        while (digests.hasMoreElements()) {
            digVector.addElement(digests.nextElement());
        }
        return digVector;
    }

    private class EntryData {
        byte[] raw;
        Hashtable digests;

        public EntryData(byte[] rawdata) {
            this.raw = rawdata;
            this.digests = new Hashtable();
        }
    }
}

