/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import anon.util.Util;
import gui.GUIUtils;
import gui.JAPHtmlMultiLineLabel;
import gui.LinkMouseListener;
import gui.dialog.JAPDialog;
import jap.JAPController;
import jap.JAPUtil;
import jap.pay.wizardnew.PaymentInfoPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import logging.LogHolder;
import logging.LogType;

public class ActivePaymentDetails
extends JAPDialog
implements ActionListener {
    private static final String MSG_HEADING = (class$jap$pay$ActivePaymentDetails == null ? (class$jap$pay$ActivePaymentDetails = ActivePaymentDetails.class$("jap.pay.ActivePaymentDetails")) : class$jap$pay$ActivePaymentDetails).getName() + "_heading";
    private static final String MSG_TITLE = (class$jap$pay$ActivePaymentDetails == null ? (class$jap$pay$ActivePaymentDetails = ActivePaymentDetails.class$("jap.pay.ActivePaymentDetails")) : class$jap$pay$ActivePaymentDetails).getName() + "_title";
    private static final String MSG_CLOSEBUTTON = (class$jap$pay$ActivePaymentDetails == null ? (class$jap$pay$ActivePaymentDetails = ActivePaymentDetails.class$("jap.pay.ActivePaymentDetails")) : class$jap$pay$ActivePaymentDetails).getName() + "_closebutton";
    public static final String MSG_COPYBUTTON = (class$jap$pay$ActivePaymentDetails == null ? (class$jap$pay$ActivePaymentDetails = ActivePaymentDetails.class$("jap.pay.ActivePaymentDetails")) : class$jap$pay$ActivePaymentDetails).getName() + "_copybutton";
    public static final String MSG_PAYBUTTON = (class$jap$pay$ActivePaymentDetails == null ? (class$jap$pay$ActivePaymentDetails = ActivePaymentDetails.class$("jap.pay.ActivePaymentDetails")) : class$jap$pay$ActivePaymentDetails).getName() + "_paybutton";
    private GridBagConstraints m_c;
    private JButton m_closeButton;
    private LinkMouseListener.ILinkCallback m_callback = new LinkMouseListener.ILinkCallback(){

        public void callback(URL a_url) {
            if (a_url == null) {
                return;
            }
            JAPController.getInstance().allowDirectProxyDomain(a_url);
        }
    };
    static /* synthetic */ Class class$jap$pay$ActivePaymentDetails;

    public ActivePaymentDetails(JAPDialog a_parent, Vector activeOptions, String a_transferNumber, long a_amount, String a_planName) {
        super(a_parent, JAPMessages.getString(MSG_TITLE));
        try {
            this.setDefaultCloseOperation(2);
            this.buildDialog(activeOptions, a_transferNumber, a_amount, a_planName);
            this.setResizable(false);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.PAY, "Could not create ActivePaymentDetails: ", e);
        }
    }

    private void buildDialog(Vector optionsToShow, String transferNumber, long amount, String planName) {
        this.m_c = new GridBagConstraints();
        this.m_c.anchor = 11;
        this.m_c.insets = new Insets(10, 30, 10, 30);
        this.m_c.gridx = 0;
        this.m_c.gridy = 0;
        this.m_c.weighty = 0.0;
        this.m_c.weightx = 0.0;
        this.getContentPane().setLayout(new GridBagLayout());
        JAPHtmlMultiLineLabel heading = new JAPHtmlMultiLineLabel("<h3>" + JAPMessages.getString(MSG_HEADING) + "</h3>");
        this.getContentPane().add((Component)heading, this.m_c);
        ++this.m_c.gridy;
        this.m_c.weightx = 0.0;
        JPanel allOptions = new JPanel();
        allOptions.setLayout(new GridBagLayout());
        Vector<JPanel> optionPanels = new Vector<JPanel>();
        Enumeration options = optionsToShow.elements();
        while (options.hasMoreElements()) {
            Hashtable curOption = (Hashtable)options.nextElement();
            ++this.m_c.gridy;
            JPanel curOptionPanel = this.buildOptionPanel(curOption, transferNumber, amount, planName);
            optionPanels.addElement(curOptionPanel);
            allOptions.add((Component)curOptionPanel, this.m_c);
        }
        Dimension largestPanel = GUIUtils.getMaxSize(optionPanels);
        GUIUtils.setEqualWidths(optionPanels, largestPanel);
        JScrollPane scrollingOptions = new JScrollPane();
        scrollingOptions.setViewportView(allOptions);
        scrollingOptions.setBorder(BorderFactory.createEmptyBorder());
        int scrollPaneWidth = new Double(largestPanel.width).intValue() + 80;
        int idealHeight = GUIUtils.getTotalSize(optionPanels).height + 80;
        Window parentWindow = GUIUtils.getParentWindow(this.getContentPane());
        int screenHeight = (int)Math.round((double)GUIUtils.getCurrentScreen(parentWindow).getHeight() * 0.8) - 100;
        int scrollPaneHeight = Math.min(idealHeight, screenHeight);
        scrollingOptions.setPreferredSize(new Dimension(scrollPaneWidth, scrollPaneHeight));
        this.getContentPane().add((Component)scrollingOptions, this.m_c);
        scrollingOptions.revalidate();
        this.m_closeButton = new JButton(JAPMessages.getString(MSG_CLOSEBUTTON));
        this.m_closeButton.addActionListener(this);
        ++this.m_c.gridy;
        this.getContentPane().add((Component)this.m_closeButton, this.m_c);
    }

    private JPanel buildOptionPanel(Hashtable optionToShow, String transferNumber, long amount, String planName) {
        JPanel optionPanel = new JPanel();
        BoxLayout verticalBoxLayout = new BoxLayout(optionPanel, 1);
        optionPanel.setLayout(verticalBoxLayout);
        String curHeading = (String)optionToShow.get("heading");
        JAPHtmlMultiLineLabel headingLabel = new JAPHtmlMultiLineLabel("<b>" + curHeading + "</b>");
        optionPanel.add(headingLabel);
        optionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        String curDetailedInfo = (String)optionToShow.get("detailedInfo");
        JAPHtmlMultiLineLabel detailsLabel = new JAPHtmlMultiLineLabel(curDetailedInfo);
        detailsLabel.setPreferredWidth(600);
        detailsLabel.setAlignmentX(0.0f);
        optionPanel.add(detailsLabel);
        optionPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        Enumeration extraInfos = ((Vector)optionToShow.get("extraInfos")).elements();
        while (extraInfos.hasMoreElements()) {
            JPanel linkButtonsPanel;
            String extraInfoString = (String)extraInfos.nextElement();
            boolean isALink = true;
            try {
                new URL(extraInfoString);
            }
            catch (MalformedURLException e) {
                isALink = false;
            }
            if (isALink) {
                extraInfoString = extraInfoString.toUpperCase().indexOf("PAYPAL") >= 0 ? PaymentInfoPane.createPaypalLink(extraInfoString, amount, planName, transferNumber) : PaymentInfoPane.createPaysafecardLink(extraInfoString, amount, transferNumber);
                final String linkToUse = extraInfoString;
                String optionName = (String)optionToShow.get("name");
                String imageFilename = PaymentInfoPane.getMethodImageFilename(optionName);
                ImageIcon methodImage = null;
                if (imageFilename != null) {
                    methodImage = GUIUtils.loadImageIcon(imageFilename, false, false);
                }
                if (methodImage != null) {
                    JPanel imagePanel = new JPanel();
                    imagePanel.setLayout(new BoxLayout(imagePanel, 0));
                    JLabel imageLabel = new JLabel(methodImage);
                    if (linkToUse != null) {
                        imageLabel.addMouseListener(new LinkMouseListener(linkToUse, this.m_callback));
                    }
                    imagePanel.add(imageLabel);
                    imagePanel.setAlignmentX(0.0f);
                    optionPanel.add(imagePanel);
                    optionPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                }
                linkButtonsPanel = new JPanel();
                JButton bttnPay = new JButton(JAPMessages.getString(MSG_PAYBUTTON));
                bttnPay.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ActivePaymentDetails.this.openURL(linkToUse);
                    }
                });
                linkButtonsPanel.add(bttnPay);
                JButton bttnCopy = new JButton(JAPMessages.getString(MSG_COPYBUTTON));
                bttnCopy.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ActivePaymentDetails.this.copyToClipboard(linkToUse, true);
                    }
                });
                linkButtonsPanel.add(bttnCopy);
                linkButtonsPanel.setAlignmentX(0.0f);
                optionPanel.add(linkButtonsPanel);
            } else {
                extraInfoString = Util.replaceAll(extraInfoString, "%t", transferNumber);
                extraInfoString = Util.replaceAll(extraInfoString, "%a", JAPUtil.formatEuroCentValue(amount, true));
                extraInfoString = Util.replaceAll(extraInfoString, "%c", "");
                JAPHtmlMultiLineLabel extraInfoLabel = new JAPHtmlMultiLineLabel(extraInfoString);
                extraInfoLabel.setAlignmentX(0.0f);
                optionPanel.add(extraInfoLabel);
                optionPanel.add(Box.createRigidArea(new Dimension(0, 5)));
                final String finalExtraInfo = extraInfoString;
                linkButtonsPanel = new JPanel();
                JButton bttnCopy = new JButton(JAPMessages.getString(MSG_COPYBUTTON));
                bttnCopy.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ActivePaymentDetails.this.copyToClipboard(finalExtraInfo, false);
                    }
                });
                linkButtonsPanel.add(bttnCopy);
                linkButtonsPanel.setAlignmentX(0.0f);
                optionPanel.add(linkButtonsPanel);
            }
            optionPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            optionPanel.setSize(optionPanel.getPreferredSize().width, optionPanel.getPreferredSize().height);
        }
        optionPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        return optionPanel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_closeButton) {
            this.setVisible(false);
        }
    }

    public void openURL(String link) {
        AbstractOS os = AbstractOS.getInstance();
        link = this.cleanupLink(link);
        try {
            URL urlToOpen = new URL(link);
            this.m_callback.callback(urlToOpen);
            os.openURL(urlToOpen);
        }
        catch (MalformedURLException me) {
            LogHolder.log(2, LogType.PAY, "Malformed URL");
        }
    }

    private void copyToClipboard(String a_info, boolean isLink) {
        Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (isLink) {
            a_info = this.cleanupLink(a_info);
            try {
                this.m_callback.callback(new URL(a_info));
            }
            catch (MalformedURLException e) {}
        } else {
            a_info = this.cleanupText(a_info);
        }
        StringSelection transfer = new StringSelection(a_info);
        sysClip.setContents(transfer, null);
    }

    private String cleanupLink(String link) {
        link = Util.replaceAll(link, "<br>", "");
        link = Util.replaceAll(link, "<p>", "");
        link = Util.replaceAll(link, "<html>", " ");
        link = Util.replaceAll(link, "</html>", " ");
        link = Util.replaceAll(link, "&nbsp;", "%20");
        link = Util.replaceAll(link, " ", "%20");
        link = Util.replaceAll(link, "<font color=blue><u>", "");
        link = Util.replaceAll(link, "</u></font>", "");
        link = link.trim();
        return link;
    }

    private String cleanupText(String a_text) {
        a_text = Util.replaceAll(a_text, "<br>", "\n");
        a_text = Util.replaceAll(a_text, "<p>", "\n\n");
        a_text = Util.replaceAll(a_text, "&uuml;", "\u00fc");
        a_text = Util.replaceAll(a_text, "&Uuml;", "\u00dc");
        a_text = Util.replaceAll(a_text, "&auml;", "\u00e4");
        a_text = Util.replaceAll(a_text, "&Auml;", "\u00c4");
        a_text = Util.replaceAll(a_text, "&ouml;", "\u00f6");
        a_text = Util.replaceAll(a_text, "&Ouml;", "\u00d6");
        a_text = Util.replaceAll(a_text, "&szlig;", "\u00df");
        a_text = Util.replaceAll(a_text, "&nbsp;", " ");
        return a_text;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

