/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.forward.ForwardUtils;
import anon.forward.LocalForwarder;
import anon.forward.client.ClientForwardException;
import anon.forward.client.DefaultClientProtocolHandler;
import anon.forward.client.ForwardConnectionDescriptor;
import anon.forward.client.ProgressCounter;
import anon.forward.server.ForwardSchedulerStatistics;
import anon.forward.server.ForwardServerManager;
import anon.forward.server.ServerSocketPropagandist;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.MixCascade;
import anon.infoservice.ProxyInterface;
import anon.proxy.AnonProxy;
import anon.proxy.DirectProxy;
import anon.terms.TermsAndConditionConfirmation;
import anon.transport.address.IAddress;
import anon.transport.address.TcpIpAddress;
import anon.transport.connection.IStreamConnection;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import jap.JAPController;
import jap.JAPModel;
import jap.forward.JAPRoutingConnectionClass;
import jap.forward.JAPRoutingConnectionClassSelector;
import jap.forward.JAPRoutingForwardingModeSelector;
import jap.forward.JAPRoutingMessage;
import jap.forward.JAPRoutingRegistrationInfoServices;
import jap.forward.JAPRoutingRegistrationStatusObserver;
import jap.forward.JAPRoutingServerStatisticsListener;
import jap.forward.JAPRoutingSettingsPropagandaThreadLock;
import jap.forward.JAPRoutingUseableMixCascades;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class JAPRoutingSettings
extends Observable
implements IXMLEncodable {
    public static final int ROUTING_MODE_DISABLED = 0;
    public static final int ROUTING_MODE_CLIENT = 1;
    public static final int ROUTING_MODE_SERVER = 2;
    public static final int REGISTRATION_NO_INFOSERVICES = 1;
    public static final int REGISTRATION_UNKNOWN_ERRORS = 2;
    public static final int REGISTRATION_INFOSERVICE_ERRORS = 3;
    public static final int REGISTRATION_VERIFY_ERRORS = 4;
    public static final int REGISTRATION_INTERRUPTED = 5;
    public static final int REGISTRATION_SUCCESS = 0;
    private int m_routingMode = 0;
    private Object m_currentServerManagerId;
    private int m_bandwidth;
    private int m_connections;
    private IStreamConnection m_forwardedConnection;
    private boolean m_forwardInfoService;
    private boolean m_connectViaForwarder;
    private boolean m_waitForShutdownCall;
    private DefaultClientProtocolHandler m_protocolHandler;
    private int m_maxDummyTrafficInterval;
    private Vector m_runningPropagandists;
    private Thread m_startPropagandaThread;
    private static JAPRoutingForwardingModeSelector m_forwardingModeSelector;
    private JAPRoutingConnectionClassSelector m_connectionClassSelector;
    private JAPRoutingRegistrationInfoServices m_registrationInfoServicesStore;
    private boolean m_propagandaStarted;
    private JAPRoutingUseableMixCascades m_useableMixCascadesStore;
    private JAPRoutingServerStatisticsListener m_serverStatisticsListener;
    private JAPRoutingRegistrationStatusObserver m_registrationStatusObserver;

    public JAPRoutingSettings() {
        m_forwardingModeSelector = new JAPRoutingForwardingModeSelector();
        this.m_connectionClassSelector = new JAPRoutingConnectionClassSelector();
        JAPRoutingConnectionClass currentConnectionClass = this.m_connectionClassSelector.getCurrentConnectionClass();
        this.m_bandwidth = currentConnectionClass.getCurrentBandwidth();
        this.m_connections = this.m_bandwidth / 4000;
        this.m_forwardedConnection = null;
        this.m_forwardInfoService = false;
        this.m_connectViaForwarder = false;
        this.m_waitForShutdownCall = false;
        this.m_protocolHandler = null;
        this.m_maxDummyTrafficInterval = -1;
        this.m_runningPropagandists = new Vector();
        this.m_startPropagandaThread = null;
        this.m_propagandaStarted = false;
        this.m_currentServerManagerId = null;
        this.m_registrationInfoServicesStore = new JAPRoutingRegistrationInfoServices();
        this.addObserver(this.m_registrationInfoServicesStore);
        this.m_useableMixCascadesStore = new JAPRoutingUseableMixCascades();
        this.addObserver(this.m_useableMixCascadesStore);
        this.m_serverStatisticsListener = new JAPRoutingServerStatisticsListener();
        this.addObserver(this.m_serverStatisticsListener);
        this.m_registrationStatusObserver = new JAPRoutingRegistrationStatusObserver();
        this.addObserver(this.m_registrationStatusObserver);
    }

    public int getRoutingMode() {
        return this.m_routingMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRoutingMode(int a_routingMode) {
        boolean success = false;
        boolean notifyObservers = false;
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (a_routingMode != this.m_routingMode) {
                if (this.m_routingMode == 2) {
                    ForwardServerManager.getInstance().shutdownForwarding();
                    this.stopPropaganda();
                    this.m_currentServerManagerId = null;
                }
                if (this.m_routingMode == 1) {
                    if (this.getForwardInfoService()) {
                        JAPController.getInstance().applyProxySettingsToInfoService(JAPModel.getInstance().isProxyAuthenticationUsed());
                    }
                    JAPController.getInstance().stop();
                    if (this.getTransportMode().isLocal()) {
                        LocalForwarder.unregisterLocalForwarder();
                    }
                    try {
                        this.m_forwardedConnection.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.m_forwardedConnection = null;
                    this.m_protocolHandler = null;
                }
                this.m_routingMode = a_routingMode;
                if (a_routingMode == 2) {
                    ForwardServerManager.getInstance().startForwarding();
                    ForwardServerManager.getInstance().setNetBandwidth(this.getBandwidth());
                    ForwardServerManager.getInstance().setMaximumNumberOfConnections(this.getAllowedConnections());
                    if (this.getTransportMode() != null) {
                        this.m_currentServerManagerId = this.getTransportMode().startServer();
                    }
                    if (this.m_currentServerManagerId == null) {
                        ForwardServerManager.getInstance().shutdownForwarding();
                        this.m_routingMode = 0;
                    } else {
                        success = true;
                    }
                }
                if (a_routingMode == 1) {
                    LogHolder.log(7, LogType.NET, "JAPRountingSettings:setRoutingMode() start the client");
                    if (JAPController.getInstance().getAnonMode()) {
                        this.m_waitForShutdownCall = true;
                        JAPController.getInstance().stop();
                        try {
                            this.wait();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        this.m_waitForShutdownCall = false;
                    }
                    if (this.getTransportMode().isLocal()) {
                        LocalForwarder.registerLocalForwarder(this.getBandwidth());
                    }
                    LogHolder.log(7, LogType.NET, "JAPRountingSettings:setRoutingMode() try to connect to forwarder");
                    this.m_forwardedConnection = ForwardUtils.getInstance().createForwardingConnection(this.getTransportMode().getAddress());
                    if (this.m_forwardedConnection != null) {
                        this.updateInfoServiceProxySettings();
                        this.m_protocolHandler = new DefaultClientProtocolHandler(this.m_forwardedConnection);
                        success = true;
                    } else {
                        this.m_routingMode = 0;
                    }
                }
                if (a_routingMode == 0) {
                    success = true;
                }
                notifyObservers = true;
            } else {
                success = true;
            }
            if (notifyObservers) {
                this.setChanged();
                this.notifyObservers(new JAPRoutingMessage(1));
            }
        }
        return success;
    }

    public static int getServerPort() {
        return JAPRoutingForwardingModeSelector.getServerPort();
    }

    public static String getApplicationName() {
        return m_forwardingModeSelector.getSkypeApplicationName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setApplicationName(String a_value) {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (JAPRoutingSettings.getApplicationName().equals(a_value)) {
                return true;
            }
            if (this.m_routingMode != 2) {
                m_forwardingModeSelector.setSkypeApplicationName(a_value);
                return true;
            }
            Object newServerID = this.getTransportMode().startServer(a_value);
            if (newServerID == null) {
                return false;
            }
            ForwardServerManager.getInstance().removeServerManager(this.m_currentServerManagerId);
            this.m_currentServerManagerId = newServerID;
            m_forwardingModeSelector.setSkypeApplicationName(a_value);
            return true;
        }
    }

    public String getSkypeForwarderAddress() {
        return m_forwardingModeSelector.getSkypeForwarderAddress();
    }

    public void setSkypeForwarderAddress(String a_newAddress) {
        this.setChanged();
        this.notifyObservers(new JAPRoutingMessage(18));
        m_forwardingModeSelector.setSkypeForwarderAddress(a_newAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setServerPort(int a_serverPort) {
        boolean success = false;
        if (a_serverPort >= 1 && a_serverPort <= 65535) {
            JAPRoutingSettings jAPRoutingSettings = this;
            synchronized (jAPRoutingSettings) {
                if (JAPRoutingSettings.getServerPort() != a_serverPort) {
                    if (this.m_routingMode != 2) {
                        m_forwardingModeSelector.setServerPort(a_serverPort);
                        success = true;
                    } else {
                        Object newServerManagerId = ForwardServerManager.getInstance().addListenSocket(a_serverPort);
                        if (newServerManagerId != null) {
                            ForwardServerManager.getInstance().removeServerManager(this.m_currentServerManagerId);
                            m_forwardingModeSelector.setServerPort(a_serverPort);
                            this.m_currentServerManagerId = newServerManagerId;
                            success = true;
                            if (this.m_propagandaStarted) {
                                this.startPropaganda(false);
                            }
                        }
                    }
                    if (success) {
                        this.setChanged();
                        this.notifyObservers(new JAPRoutingMessage(15));
                    }
                } else {
                    success = true;
                }
            }
        }
        return success;
    }

    public int getBandwidth() {
        return this.m_bandwidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBandwidth(int a_bandwidth) {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            this.m_bandwidth = a_bandwidth;
            ForwardServerManager.getInstance().setNetBandwidth(a_bandwidth);
            this.setAllowedConnections(this.getAllowedConnections());
        }
    }

    public int getBandwidthMaxConnections() {
        return this.getBandwidth() / 4000;
    }

    public int getAllowedConnections() {
        return this.m_connections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedConnections(int a_connections) {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (a_connections > this.getBandwidthMaxConnections()) {
                a_connections = this.getBandwidthMaxConnections();
            }
            this.m_connections = a_connections;
            ForwardServerManager.getInstance().setMaximumNumberOfConnections(a_connections);
        }
    }

    public void setNewProxySettings(ProxyInterface a_proxyInterface) {
        ForwardUtils.getInstance().setProxySettings(a_proxyInterface);
    }

    public void setTCPForwarder(String a_forwarderHost, int a_forwarderPort) {
        this.setForwarderAddress(new TcpIpAddress(a_forwarderHost, a_forwarderPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForwarderAddress(IAddress a_address) {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.m_routingMode != 1) {
                this.getTransportMode().setAddress(a_address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAddress nextForwarderAddress() {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            try {
                return this.getTransportMode().nextAddress();
            }
            catch (Exception e) {
                LogHolder.log(2, LogType.FORWARDING, e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAddress getForwarderAddress() {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            try {
                return this.getTransportMode().getAddress();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public IAddress getUserProvidetForwarder() {
        return m_forwardingModeSelector.getUserProvidetForwarder();
    }

    public JAPRoutingForwardingModeSelector.TransportMode getTransportMode() {
        return m_forwardingModeSelector.getCurrentForwardingMode();
    }

    public synchronized boolean setTransportMode(JAPRoutingForwardingModeSelector.TransportMode a_transportMode) {
        return this.setTransportModeInternal(m_forwardingModeSelector.setCurrentForwardingMode(a_transportMode));
    }

    public synchronized boolean setTransportMode(int a_value) {
        LogHolder.log(7, LogType.GUI, "We try to set the transport mode to " + a_value);
        return this.setTransportModeInternal(m_forwardingModeSelector.setCurrentForwardingMode(a_value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean setTransportModeInternal(boolean resultSetCurrentTransportMode) {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            LogHolder.log(7, LogType.GUI, "The transport mode is now " + this.getTransportMode());
            if (resultSetCurrentTransportMode) {
                if (this.m_routingMode == 0 || this.m_routingMode == 1) {
                    return true;
                }
                if (this.m_routingMode == 2) {
                    Object newServerID = null;
                    newServerID = this.getTransportMode().startServer();
                    if (newServerID == null) {
                        return false;
                    }
                    ForwardServerManager.getInstance().removeServerManager(this.m_currentServerManagerId);
                    this.m_currentServerManagerId = newServerID;
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForwardInfoService(boolean a_forwardInfoService) {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.m_forwardInfoService != a_forwardInfoService) {
                this.m_forwardInfoService = a_forwardInfoService;
                if (a_forwardInfoService && this.getRoutingMode() == 1) {
                    this.updateInfoServiceProxySettings();
                }
                if (!a_forwardInfoService && this.getRoutingMode() == 1) {
                    JAPController.getInstance().applyProxySettingsToInfoService(JAPModel.getInstance().isProxyAuthenticationUsed());
                }
                this.setChanged();
                this.notifyObservers(new JAPRoutingMessage(16));
            }
        }
    }

    public boolean getForwardInfoService() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectViaForwarder(boolean a_connectViaForwarder) {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.m_connectViaForwarder != a_connectViaForwarder) {
                this.m_connectViaForwarder = a_connectViaForwarder;
                this.setChanged();
                this.notifyObservers(new JAPRoutingMessage(16));
            }
        }
    }

    public boolean isConnectViaForwarder() {
        return this.m_connectViaForwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void httpListenerPortChanged() {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.getForwardInfoService() && this.getRoutingMode() == 1) {
                this.updateInfoServiceProxySettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void anonConnectionClosed() {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.getRoutingMode() == 1) {
                if (this.m_waitForShutdownCall) {
                    this.notify();
                } else {
                    this.setRoutingMode(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnonProxy getAnonProxyInstance(DirectProxy a_directProxy) {
        AnonProxy anonProxy = null;
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.getRoutingMode() == 1) {
                anonProxy = new AnonProxy(a_directProxy, this.m_forwardedConnection, this.m_protocolHandler.getSelectedService(), this.m_maxDummyTrafficInterval, new TermsAndConditionConfirmation.AlwaysAccept());
            }
        }
        return anonProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForwardConnectionDescriptor getConnectionDescriptor() throws ClientForwardException {
        ForwardConnectionDescriptor connectionDescriptor = null;
        DefaultClientProtocolHandler protocolHandler = null;
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.getRoutingMode() == 1) {
                protocolHandler = this.m_protocolHandler;
            }
        }
        if (protocolHandler != null) {
            try {
                connectionDescriptor = protocolHandler.getConnectionDescriptor();
            }
            catch (ClientForwardException e) {
                this.setRoutingMode(0);
                throw e;
            }
        } else {
            throw new ClientForwardException(255, "JAPRoutingSettings: getConnectionDescriptor: Not in client routing mode.");
        }
        jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            this.m_maxDummyTrafficInterval = connectionDescriptor.getMinDummyTrafficInterval();
        }
        return connectionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectMixCascade(MixCascade a_mixCascade) throws ClientForwardException {
        DefaultClientProtocolHandler protocolHandler = null;
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.getRoutingMode() == 1) {
                protocolHandler = this.m_protocolHandler;
            }
        }
        if (protocolHandler != null) {
            try {
                protocolHandler.selectMixCascade(a_mixCascade);
            }
            catch (ClientForwardException e) {
                this.setRoutingMode(0);
                throw e;
            }
        } else {
            throw new ClientForwardException(255, "JAPRoutingSettings: selectMixCascade: Not in client routing mode.");
        }
    }

    public ForwardSchedulerStatistics getSchedulerStatistics() {
        return ForwardServerManager.getInstance().getSchedulerStatistics();
    }

    public int getCurrentlyForwardedConnections() {
        return ForwardServerManager.getInstance().getCurrentlyForwardedConnections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startPropaganda(boolean a_blocking) {
        final JAPRoutingSettingsPropagandaThreadLock masterThreadLock = new JAPRoutingSettingsPropagandaThreadLock();
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.m_routingMode == 2) {
                Vector currentPropagandists;
                this.stopPropaganda();
                final Vector infoServiceList = this.getRegistrationInfoServicesStore().getRegistrationInfoServicesForStartup();
                this.m_runningPropagandists = currentPropagandists = new Vector();
                this.m_startPropagandaThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        JAPRoutingSettings.this.setChanged();
                        JAPRoutingSettings.this.notifyObservers(new JAPRoutingMessage(3, null));
                        Enumeration infoServices = infoServiceList.elements();
                        boolean stopRegistration = false;
                        while (infoServices.hasMoreElements() && !stopRegistration) {
                            ServerSocketPropagandist currentPropagandist = new ServerSocketPropagandist(JAPRoutingSettings.getServerPort(), (InfoServiceDBEntry)infoServices.nextElement());
                            JAPRoutingSettings jAPRoutingSettings = JAPModel.getInstance().getRoutingSettings();
                            synchronized (jAPRoutingSettings) {
                                stopRegistration = Thread.interrupted();
                                if (stopRegistration) {
                                    currentPropagandist.stopPropaganda();
                                    masterThreadLock.registrationWasInterrupted();
                                } else {
                                    currentPropagandists.addElement(currentPropagandist);
                                    masterThreadLock.updateRegistrationStatus(currentPropagandist);
                                    JAPRoutingSettings.this.setChanged();
                                    JAPRoutingSettings.this.notifyObservers(new JAPRoutingMessage(2, currentPropagandists.clone()));
                                }
                            }
                        }
                        Object object = JAPModel.getInstance().getRoutingSettings();
                        synchronized (object) {
                            JAPRoutingSettings.this.m_startPropagandaThread = null;
                            if (!Thread.interrupted() && !stopRegistration) {
                                JAPRoutingSettings.this.setChanged();
                                JAPRoutingSettings.this.notifyObservers(new JAPRoutingMessage(4, currentPropagandists.clone()));
                            }
                        }
                        object = masterThreadLock;
                        synchronized (object) {
                            masterThreadLock.propagandaThreadIsReady();
                            masterThreadLock.notify();
                        }
                    }
                });
                this.m_startPropagandaThread.setDaemon(true);
                this.m_propagandaStarted = true;
                this.m_startPropagandaThread.start();
            } else {
                masterThreadLock.propagandaThreadIsReady();
            }
        }
        int registrationStatus = 0;
        JAPRoutingSettingsPropagandaThreadLock jAPRoutingSettingsPropagandaThreadLock = masterThreadLock;
        synchronized (jAPRoutingSettingsPropagandaThreadLock) {
            if (a_blocking && !masterThreadLock.isPropagandaThreadReady()) {
                try {
                    masterThreadLock.wait();
                    registrationStatus = masterThreadLock.getRegistrationStatus();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        return registrationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPropaganda() {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.m_startPropagandaThread != null) {
                try {
                    this.m_startPropagandaThread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            while (this.m_runningPropagandists.size() > 0) {
                ((ServerSocketPropagandist)this.m_runningPropagandists.firstElement()).stopPropaganda();
                this.m_runningPropagandists.removeElementAt(0);
            }
            this.m_propagandaStarted = false;
            this.setChanged();
            this.notifyObservers(new JAPRoutingMessage(5));
        }
    }

    public void addPropagandaInstance(final InfoServiceDBEntry a_registrationInfoService) {
        Thread addPropagandistThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                boolean startNewPropagandist = false;
                int serverPort = -1;
                JAPRoutingSettings jAPRoutingSettings = JAPModel.getInstance().getRoutingSettings();
                synchronized (jAPRoutingSettings) {
                    startNewPropagandist = JAPRoutingSettings.this.m_propagandaStarted;
                    serverPort = JAPRoutingSettings.getServerPort();
                }
                ServerSocketPropagandist newPropagandist = null;
                if (startNewPropagandist) {
                    newPropagandist = new ServerSocketPropagandist(serverPort, a_registrationInfoService);
                    JAPRoutingSettings jAPRoutingSettings2 = JAPModel.getInstance().getRoutingSettings();
                    synchronized (jAPRoutingSettings2) {
                        if (JAPRoutingSettings.getServerPort() == serverPort && JAPRoutingSettings.this.m_propagandaStarted) {
                            JAPRoutingSettings.this.m_runningPropagandists.addElement(newPropagandist);
                            JAPRoutingSettings.this.setChanged();
                            JAPRoutingSettings.this.notifyObservers(new JAPRoutingMessage(2, JAPRoutingSettings.this.m_runningPropagandists.clone()));
                        } else {
                            newPropagandist.stopPropaganda();
                        }
                    }
                }
            }
        });
        addPropagandistThread.setDaemon(true);
        addPropagandistThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRunningPropagandaInstances() {
        Vector resultValue = null;
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            resultValue = (Vector)this.m_runningPropagandists.clone();
        }
        return resultValue;
    }

    public JAPRoutingForwardingModeSelector getForwardingModeSelector() {
        return m_forwardingModeSelector;
    }

    public JAPRoutingConnectionClassSelector getConnectionClassSelector() {
        return this.m_connectionClassSelector;
    }

    public JAPRoutingRegistrationInfoServices getRegistrationInfoServicesStore() {
        return this.m_registrationInfoServicesStore;
    }

    public JAPRoutingUseableMixCascades getUseableMixCascadesStore() {
        return this.m_useableMixCascadesStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        Element japForwardingSettingsNode = a_doc.createElement("JapForwardingSettings");
        Element forwardingServerNode = a_doc.createElement("ForwardingServer");
        Element serverPortNode = a_doc.createElement("ServerPort");
        Element serverRunningNode = a_doc.createElement("ServerRunning");
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            XMLUtil.setValue((Node)serverPortNode, JAPRoutingSettings.getServerPort());
            if (this.getRoutingMode() == 2) {
                XMLUtil.setValue((Node)serverRunningNode, true);
            } else {
                XMLUtil.setValue((Node)serverRunningNode, false);
            }
        }
        forwardingServerNode.appendChild(serverPortNode);
        forwardingServerNode.appendChild(serverRunningNode);
        forwardingServerNode.appendChild(this.getConnectionClassSelector().getSettingsAsXml(a_doc));
        forwardingServerNode.appendChild(this.getRegistrationInfoServicesStore().getSettingsAsXml(a_doc));
        forwardingServerNode.appendChild(this.getUseableMixCascadesStore().getSettingsAsXml(a_doc));
        japForwardingSettingsNode.appendChild(forwardingServerNode);
        Element forwardingClientNode = a_doc.createElement("ForwardingClient");
        LogHolder.log(7, LogType.MISC, "Save the transport mode : " + this.getTransportMode().getName());
        XMLUtil.setAttribute(forwardingClientNode, "type", this.getTransportMode().getName());
        Element connectViaForwarderNode = a_doc.createElement("ConnectViaForwarder");
        Element forwardInfoServiceNode = a_doc.createElement("ForwardInfoService");
        Element skypeForwarderAddress = a_doc.createElement("SkypeForwarderAddress");
        XMLUtil.setValue((Node)connectViaForwarderNode, this.isConnectViaForwarder());
        XMLUtil.setValue((Node)forwardInfoServiceNode, this.getForwardInfoService());
        XMLUtil.setValue((Node)skypeForwarderAddress, this.getSkypeForwarderAddress());
        forwardingClientNode.appendChild(connectViaForwarderNode);
        forwardingClientNode.appendChild(forwardInfoServiceNode);
        forwardingClientNode.appendChild(skypeForwarderAddress);
        japForwardingSettingsNode.appendChild(forwardingClientNode);
        return japForwardingSettingsNode;
    }

    public int loadSettingsFromXml(Element a_japForwardingSettingsNode) {
        boolean startServerIsPossible = true;
        Element forwardingServerNode = (Element)XMLUtil.getFirstChildByName(a_japForwardingSettingsNode, "ForwardingServer");
        if (forwardingServerNode == null) {
            LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (ForwardingServer node): Using default forwarding server settings.");
        } else {
            Element serverPortNode = (Element)XMLUtil.getFirstChildByName(forwardingServerNode, "ServerPort");
            if (serverPortNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (ServerPort node): Using default server port.");
                startServerIsPossible = false;
            } else {
                int serverPort = XMLUtil.parseValue((Node)serverPortNode, -1);
                if (serverPort == -1) {
                    LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Invalid server port in XML structure: Using default server port.");
                    startServerIsPossible = false;
                } else if (!this.setServerPort(serverPort)) {
                    LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error while setting the server port: Using default server port.");
                    startServerIsPossible = false;
                }
            }
            Element connectionClassSettingsNode = (Element)XMLUtil.getFirstChildByName(forwardingServerNode, "ConnectionClassSettings");
            if (connectionClassSettingsNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (ConnectionClassSettings node): Using default connection class settings.");
                startServerIsPossible = false;
            } else if (!this.getConnectionClassSelector().loadSettingsFromXml(connectionClassSettingsNode)) {
                startServerIsPossible = false;
            }
            Element infoserviceRegistrationSettingsNode = (Element)XMLUtil.getFirstChildByName(forwardingServerNode, "InfoServiceRegistrationSettings");
            if (infoserviceRegistrationSettingsNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (InfoServiceRegistrationSettings node): Using default infoservice registration settings.");
                startServerIsPossible = false;
            } else if (!this.getRegistrationInfoServicesStore().loadSettingsFromXml(infoserviceRegistrationSettingsNode)) {
                startServerIsPossible = false;
            }
            Element allowedMixCascadesSettingsNode = (Element)XMLUtil.getFirstChildByName(forwardingServerNode, "AllowedMixCascadesSettings");
            if (allowedMixCascadesSettingsNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (AllowedMixCascadesSettings node): Using default forwarding mixcascade settings.");
                startServerIsPossible = false;
            } else if (!this.getUseableMixCascadesStore().loadSettingsFromXml(allowedMixCascadesSettingsNode)) {
                startServerIsPossible = false;
            }
            Element serverRunningNode = (Element)XMLUtil.getFirstChildByName(forwardingServerNode, "ServerRunning");
            if (serverRunningNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (ServerRunning node): Server not started.");
            } else if (XMLUtil.parseValue((Node)serverRunningNode, false)) {
                if (startServerIsPossible) {
                    if (this.setRoutingMode(2)) {
                        this.startPropaganda(false);
                        LogHolder.log(6, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: According to the configuration, the forwarding server was started.");
                    } else {
                        LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error while starting the forwarding server.");
                    }
                } else {
                    LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Because of errors while loading the configuration, the forwarding server was not started.");
                }
            }
        }
        Element forwardingClientNode = (Element)XMLUtil.getFirstChildByName(a_japForwardingSettingsNode, "ForwardingClient");
        if (forwardingClientNode == null) {
            LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (ForwardingClient node): Using default forwarding client settings.");
        } else {
            Element connectViaForwarderNode = (Element)XMLUtil.getFirstChildByName(forwardingClientNode, "ConnectViaForwarder");
            if (connectViaForwarderNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (ConnectViaForwarder node): Using default value when enabling anonymity mode.");
            } else {
                String type = XMLUtil.parseAttribute((Node)forwardingClientNode, "type", this.getTransportMode().getName());
                this.setTransportMode(m_forwardingModeSelector.getIdFromIdentifier(type));
                this.setConnectViaForwarder(XMLUtil.parseValue((Node)connectViaForwarderNode, false));
            }
            Element forwardInfoServiceNode = (Element)XMLUtil.getFirstChildByName(forwardingClientNode, "ForwardInfoService");
            if (forwardInfoServiceNode == null) {
                LogHolder.log(3, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Error in XML structure (ForwardInfoService node): Using default value when creating a forwarded connection.");
            } else {
                this.setForwardInfoService(XMLUtil.parseValue((Node)forwardInfoServiceNode, false));
            }
            Element skypeForwarderAddressNode = (Element)XMLUtil.getFirstChildByName(forwardingClientNode, "SkypeForwarderAddress");
            if (skypeForwarderAddressNode == null) {
                LogHolder.log(4, LogType.MISC, "JAPRoutingSettings: loadSettingsFromXml: Skype forwarder address not found, using default value");
            } else {
                this.setSkypeForwarderAddress(XMLUtil.parseValue((Node)skypeForwarderAddressNode, m_forwardingModeSelector.getDefaultSkypeForwarderAddress()));
            }
        }
        return 0;
    }

    public JAPRoutingServerStatisticsListener getServerStatisticsListener() {
        return this.m_serverStatisticsListener;
    }

    public JAPRoutingRegistrationStatusObserver getRegistrationStatusObserver() {
        return this.m_registrationStatusObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInfoServiceProxySettings() {
        JAPRoutingSettings jAPRoutingSettings = this;
        synchronized (jAPRoutingSettings) {
            if (this.getForwardInfoService()) {
                HTTPConnectionFactory.getInstance().setNewProxySettings(new ProxyInterface("localhost", JAPModel.getHttpListenerPortNumber(), 1, null), JAPModel.getInstance().isProxyAuthenticationUsed());
            }
        }
    }

    public ProgressCounter getPacketCounter() {
        return this.m_protocolHandler.getPacketCounter();
    }
}

