/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.forward.client.ClientForwardException;
import anon.forward.client.ForwardConnectionDescriptor;
import anon.forward.client.ForwarderInformationGrabber;
import anon.forward.client.ProgressCounter;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.transport.address.Endpoint;
import anon.transport.address.IAddress;
import anon.util.JAPMessages;
import anon.util.captcha.IImageEncodedCaptcha;
import anon.util.captcha.MyImage;
import gui.JAPHtmlMultiLineLabel;
import gui.dialog.DialogContentPane;
import gui.dialog.JAPDialog;
import gui.dialog.WorkerContentPane;
import jap.JAPController;
import jap.JAPModel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.util.Observable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import logging.LogHolder;
import logging.LogType;

public class JAPRoutingEstablishForwardedConnectionDialog {
    private boolean m_bForwardingSuccessful = false;
    private Component m_parentComponent;
    private Font m_fontSetting;

    public JAPRoutingEstablishForwardedConnectionDialog(Component a_parentComponent) {
        this.m_parentComponent = a_parentComponent;
        boolean endOfDialogReached = false;
        while (!endOfDialogReached) {
            MixCascade selectedMixCascade;
            ForwardConnectionDescriptor connectionOffer;
            IImageEncodedCaptcha fetchedCaptcha = null;
            if (!JAPModel.getInstance().getRoutingSettings().getForwardInfoService()) {
                fetchedCaptcha = this.showConfigClientDialogGetForwarderInfo();
            }
            if (fetchedCaptcha == null) {
                fetchedCaptcha = this.showConfigClientDialogViaMail();
            }
            if (fetchedCaptcha == null) {
                endOfDialogReached = true;
                continue;
            }
            ListenerInterface forwarder = this.showConfigClientDialogCaptcha(fetchedCaptcha);
            if (forwarder == null) {
                endOfDialogReached = true;
                continue;
            }
            JAPModel.getInstance().getRoutingSettings().setTCPForwarder(forwarder.getHost(), forwarder.getPort());
            if (!this.showConfigClientDialogConnectToForwarder() || (connectionOffer = this.showConfigClientDialogGetOffer()) == null || (selectedMixCascade = this.showConfigClientDialogStep2(connectionOffer)) == null) continue;
            endOfDialogReached = this.m_bForwardingSuccessful = this.showConfigClientDialogAnnounceCascade(selectedMixCascade);
        }
    }

    public JAPRoutingEstablishForwardedConnectionDialog(Component a_parentComponent, IAddress a_address) {
        LogHolder.log(7, LogType.NET, "Start establishing forward connection with a given address");
        this.m_parentComponent = a_parentComponent;
        JAPModel.getInstance().getRoutingSettings().setForwarderAddress(a_address);
        if (!this.showConfigClientDialogConnectToForwarder()) {
            return;
        }
        ForwardConnectionDescriptor connectionOffer = this.showConfigClientDialogGetOffer();
        if (connectionOffer == null) {
            return;
        }
        MixCascade selectedMixCascade = JAPController.getInstance().getCurrentMixCascade();
        if (selectedMixCascade == null || !selectedMixCascade.isUserDefined()) {
            selectedMixCascade = this.showConfigClientDialogStep2(connectionOffer);
        }
        if (selectedMixCascade == null) {
            return;
        }
        this.m_bForwardingSuccessful = this.showConfigClientDialogAnnounceCascade(selectedMixCascade);
    }

    public boolean isForwardingSuccessful() {
        return this.m_bForwardingSuccessful;
    }

    private Component getRootComponent() {
        return this.m_parentComponent;
    }

    private Font getFontSetting() {
        return this.m_fontSetting;
    }

    private IImageEncodedCaptcha showConfigClientDialogGetForwarderInfo() {
        JAPDialog infoserviceDialog = new JAPDialog(this.getRootComponent(), JAPMessages.getString("settingsRoutingClientConfigDialogInfoServiceTitle"));
        infoserviceDialog.setResizable(false);
        infoserviceDialog.setDefaultCloseOperation(2);
        final Vector occuredError = new Vector();
        final Vector fetchedCaptcha = new Vector();
        Runnable infoserviceThread = new Runnable(){

            public void run() {
                ForwarderInformationGrabber grabber = new ForwarderInformationGrabber();
                Thread.interrupted();
                if (grabber.getErrorCode() == 0) {
                    fetchedCaptcha.addElement(grabber.getCaptcha());
                } else if (grabber.getErrorCode() == 1) {
                    occuredError.addElement(JAPMessages.getString("settingsRoutingClientGrabCapchtaInfoServiceError"));
                } else if (grabber.getErrorCode() == 3) {
                    occuredError.addElement(JAPMessages.getString("settingsRoutingClientGrabCapchtaImplementationError"));
                } else {
                    occuredError.addElement(JAPMessages.getString("settingsRoutingClientGrabCaptchaUnknownError"));
                }
            }
        };
        WorkerContentPane worker = new WorkerContentPane(infoserviceDialog, JAPMessages.getString("settingsRoutingClientConfigDialogInfoServiceLabel"), infoserviceThread);
        worker.updateDialog();
        infoserviceDialog.pack();
        infoserviceDialog.setVisible(true);
        IImageEncodedCaptcha returnValue = null;
        if (fetchedCaptcha.size() > 0) {
            returnValue = (IImageEncodedCaptcha)fetchedCaptcha.firstElement();
        } else if (occuredError.size() > 0) {
            LogHolder.log(3, LogType.NET, (String)occuredError.firstElement());
        }
        return returnValue;
    }

    private IImageEncodedCaptcha showConfigClientDialogViaMail() {
        final JAPDialog client1MailDialog = new JAPDialog(this.getRootComponent(), JAPMessages.getString("settingsRoutingClientConfigDialog1MailTitle"));
        final JPanel client1MailPanel = new JPanel();
        client1MailDialog.getContentPane().add(client1MailPanel);
        JAPHtmlMultiLineLabel settingsRoutingClientConfigDialog1MailInstructionsLabel = new JAPHtmlMultiLineLabel(JAPMessages.getString("settingsRoutingClientConfigDialog1MailInstructions1") + "japmailsystem@infoservice.inf.tu-dresden.de" + JAPMessages.getString("settingsRoutingClientConfigDialog1MailInstructions2"), this.getFontSetting());
        JLabel settingsRoutingClientConfigDialog1MailAnswerLabel = new JLabel(JAPMessages.getString("settingsRoutingClientConfigDialog1MailAnswerLabel"));
        settingsRoutingClientConfigDialog1MailAnswerLabel.setFont(this.getFontSetting());
        final JTextArea settingsRoutingAnswerArea = new JTextArea();
        settingsRoutingAnswerArea.setFont(this.getFontSetting());
        settingsRoutingAnswerArea.setRows(7);
        JScrollPane settingsRoutingAnswerPane = new JScrollPane(settingsRoutingAnswerArea);
        settingsRoutingAnswerArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent event) {
                this.handlePopupEvent(event);
            }

            public void mouseReleased(MouseEvent event) {
                this.handlePopupEvent(event);
            }

            private void handlePopupEvent(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    JPopupMenu rightButtonMenu = new JPopupMenu();
                    JMenuItem pasteItem = new JMenuItem(JAPMessages.getString("settingsRoutingClientConfigDialog1MailAnswerPopupPaste"));
                    pasteItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            settingsRoutingAnswerArea.paste();
                        }
                    });
                    rightButtonMenu.add(pasteItem);
                    rightButtonMenu.show(event.getComponent(), event.getX(), event.getY());
                }
            }
        });
        JButton settingsRoutingClientConfigDialog1MailInsertButton = new JButton(JAPMessages.getString("settingsRoutingClientConfigDialog1MailInsertButton"));
        settingsRoutingClientConfigDialog1MailInsertButton.setFont(this.getFontSetting());
        settingsRoutingClientConfigDialog1MailInsertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                settingsRoutingAnswerArea.setText("");
                settingsRoutingAnswerArea.paste();
            }
        });
        final Vector parsedCaptcha = new Vector();
        final JButton settingsRoutingClientConfigDialog1MailNextButton = new JButton(JAPMessages.getString("settingsRoutingClientConfigDialog1MailNextButton"));
        settingsRoutingClientConfigDialog1MailNextButton.setFont(this.getFontSetting());
        settingsRoutingClientConfigDialog1MailNextButton.setEnabled(false);
        settingsRoutingClientConfigDialog1MailNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ForwarderInformationGrabber dataParser = new ForwarderInformationGrabber(settingsRoutingAnswerArea.getText());
                if (dataParser.getErrorCode() == 0) {
                    parsedCaptcha.addElement(dataParser.getCaptcha());
                    client1MailDialog.dispose();
                }
                if (dataParser.getErrorCode() == 3) {
                    JAPDialog.showErrorDialog((Component)client1MailPanel, JAPMessages.getString("settingsRoutingClientGrabCapchtaImplementationError"));
                    client1MailDialog.dispose();
                }
                if (dataParser.getErrorCode() == 2) {
                    JAPDialog.showErrorDialog((Component)client1MailPanel, JAPMessages.getString("settingsRoutingClientConfigDialog1MailParseError"));
                    settingsRoutingAnswerArea.setText("");
                }
            }
        });
        settingsRoutingAnswerArea.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent event) {
                if (!settingsRoutingAnswerArea.getText().equals("")) {
                    settingsRoutingClientConfigDialog1MailNextButton.setEnabled(true);
                } else {
                    settingsRoutingClientConfigDialog1MailNextButton.setEnabled(false);
                }
            }
        });
        JButton settingsRoutingClientConfigDialog1MailCancelButton = new JButton(JAPMessages.getString("cancelButton"));
        settingsRoutingClientConfigDialog1MailCancelButton.setFont(this.getFontSetting());
        settingsRoutingClientConfigDialog1MailCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                client1MailDialog.dispose();
            }
        });
        TitledBorder settingsRoutingClientConfigDialog1MailBorder = new TitledBorder(JAPMessages.getString("settingsRoutingClientConfigDialog1MailBorder"));
        settingsRoutingClientConfigDialog1MailBorder.setTitleFont(this.getFontSetting());
        client1MailPanel.setBorder(settingsRoutingClientConfigDialog1MailBorder);
        GridBagLayout client1MailPanelLayout = new GridBagLayout();
        client1MailPanel.setLayout(client1MailPanelLayout);
        GridBagConstraints client1MailPanelConstraints = new GridBagConstraints();
        client1MailPanelConstraints.anchor = 18;
        client1MailPanelConstraints.fill = 2;
        client1MailPanelConstraints.weightx = 1.0;
        client1MailPanelConstraints.gridwidth = 2;
        client1MailPanelConstraints.gridx = 0;
        client1MailPanelConstraints.gridy = 0;
        client1MailPanelConstraints.insets = new Insets(5, 5, 0, 5);
        client1MailPanelLayout.setConstraints(settingsRoutingClientConfigDialog1MailInstructionsLabel, client1MailPanelConstraints);
        client1MailPanel.add(settingsRoutingClientConfigDialog1MailInstructionsLabel);
        client1MailPanelConstraints.gridx = 0;
        client1MailPanelConstraints.gridy = 1;
        client1MailPanelConstraints.insets = new Insets(15, 5, 0, 5);
        client1MailPanelLayout.setConstraints(settingsRoutingClientConfigDialog1MailAnswerLabel, client1MailPanelConstraints);
        client1MailPanel.add(settingsRoutingClientConfigDialog1MailAnswerLabel);
        client1MailPanelConstraints.gridx = 0;
        client1MailPanelConstraints.gridy = 2;
        client1MailPanelConstraints.insets = new Insets(0, 5, 2, 5);
        client1MailPanelConstraints.weighty = 1.0;
        client1MailPanelLayout.setConstraints(settingsRoutingAnswerPane, client1MailPanelConstraints);
        client1MailPanel.add(settingsRoutingAnswerPane);
        client1MailPanelConstraints.gridx = 0;
        client1MailPanelConstraints.gridy = 3;
        client1MailPanelConstraints.insets = new Insets(0, 5, 20, 5);
        client1MailPanelConstraints.weighty = 0.0;
        client1MailPanelLayout.setConstraints(settingsRoutingClientConfigDialog1MailInsertButton, client1MailPanelConstraints);
        client1MailPanel.add(settingsRoutingClientConfigDialog1MailInsertButton);
        client1MailPanelConstraints.gridx = 0;
        client1MailPanelConstraints.gridy = 4;
        client1MailPanelConstraints.gridwidth = 1;
        client1MailPanelConstraints.insets = new Insets(0, 5, 10, 5);
        client1MailPanelLayout.setConstraints(settingsRoutingClientConfigDialog1MailCancelButton, client1MailPanelConstraints);
        client1MailPanel.add(settingsRoutingClientConfigDialog1MailCancelButton);
        client1MailPanelConstraints.gridx = 1;
        client1MailPanelConstraints.gridy = 4;
        client1MailPanelConstraints.insets = new Insets(0, 5, 10, 5);
        client1MailPanelLayout.setConstraints(settingsRoutingClientConfigDialog1MailNextButton, client1MailPanelConstraints);
        client1MailPanel.add(settingsRoutingClientConfigDialog1MailNextButton);
        client1MailDialog.pack();
        client1MailDialog.setVisible(true);
        IImageEncodedCaptcha returnValue = null;
        if (parsedCaptcha.size() > 0) {
            returnValue = (IImageEncodedCaptcha)parsedCaptcha.firstElement();
        }
        return returnValue;
    }

    private ListenerInterface showConfigClientDialogCaptcha(final IImageEncodedCaptcha a_captcha) {
        final JAPDialog captchaDialog = new JAPDialog(this.getRootComponent(), JAPMessages.getString("settingsRoutingClientConfigDialogCaptchaTitle"));
        final JPanel captchaPanel = new JPanel();
        captchaDialog.getContentPane().add(captchaPanel);
        MyImage myImg = a_captcha.getImage();
        Image img = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(myImg.getWidth(), myImg.getHeight(), myImg.getPixels(), 0, myImg.getWidth()));
        JLabel captchaImageLabel = new JLabel(new ImageIcon(img));
        JLabel settingsRoutingClientConfigDialogCaptchaCharacterSetLabel = new JLabel(JAPMessages.getString("settingsRoutingClientConfigDialogCaptchaCharacterSetLabel") + " " + a_captcha.getCharacterSet());
        settingsRoutingClientConfigDialogCaptchaCharacterSetLabel.setFont(this.getFontSetting());
        JLabel settingsRoutingClientConfigDialogCaptchaCharacterNumberLabel = new JLabel(JAPMessages.getString("settingsRoutingClientConfigDialogCaptchaCharacterNumberLabel") + " " + Integer.toString(a_captcha.getCharacterNumber()));
        settingsRoutingClientConfigDialogCaptchaCharacterNumberLabel.setFont(this.getFontSetting());
        JLabel settingsRoutingClientConfigDialogCaptchaInsertCaptchaLabel = new JLabel(JAPMessages.getString("settingsRoutingClientConfigDialogCaptchaInsertCaptchaLabel"));
        settingsRoutingClientConfigDialogCaptchaInsertCaptchaLabel.setFont(this.getFontSetting());
        final JButton settingsRoutingClientConfigDialogCaptchaNextButton = new JButton(JAPMessages.getString("settingsRoutingClientConfigDialogCaptchaNextButton"));
        settingsRoutingClientConfigDialogCaptchaNextButton.setFont(this.getFontSetting());
        final CaptchaInputField captchaField = new CaptchaInputField(a_captcha);
        captchaField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent a_event) {
            }

            public void insertUpdate(DocumentEvent a_event) {
                if (a_event.getDocument().getLength() == a_captcha.getCharacterNumber()) {
                    settingsRoutingClientConfigDialogCaptchaNextButton.setEnabled(true);
                } else {
                    settingsRoutingClientConfigDialogCaptchaNextButton.setEnabled(false);
                }
            }

            public void removeUpdate(DocumentEvent a_event) {
                if (a_event.getDocument().getLength() == a_captcha.getCharacterNumber()) {
                    settingsRoutingClientConfigDialogCaptchaNextButton.setEnabled(true);
                } else {
                    settingsRoutingClientConfigDialogCaptchaNextButton.setEnabled(false);
                }
            }
        });
        captchaField.setFont(this.getFontSetting());
        final Vector forwarderInterface = new Vector();
        if (captchaField.getText().length() != a_captcha.getCharacterNumber()) {
            settingsRoutingClientConfigDialogCaptchaNextButton.setEnabled(false);
        }
        settingsRoutingClientConfigDialogCaptchaNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    byte[] test = new byte[10];
                    byte[] plainForwarderData = a_captcha.solveCaptcha(captchaField.getText().trim(), test);
                    ByteArrayInputStream ipAddressStream = new ByteArrayInputStream(plainForwarderData, 10, 4);
                    String ipAddress = Integer.toString(ipAddressStream.read());
                    for (int i = 0; i < 3; ++i) {
                        ipAddress = ipAddress + "." + Integer.toString(ipAddressStream.read());
                    }
                    ByteArrayInputStream portStream = new ByteArrayInputStream(plainForwarderData, 14, 2);
                    int port = portStream.read();
                    port = port * 256 + portStream.read();
                    ListenerInterface forwarder = new ListenerInterface(ipAddress, port);
                    forwarderInterface.addElement(forwarder);
                    captchaDialog.dispose();
                }
                catch (Exception e) {
                    JAPDialog.showErrorDialog((Component)captchaPanel, JAPMessages.getString("settingsRoutingClientConfigDialogCaptchaError"));
                    captchaField.setText("");
                }
            }
        });
        JButton settingsRoutingClientConfigDialogCaptchaCancelButton = new JButton(JAPMessages.getString("cancelButton"));
        settingsRoutingClientConfigDialogCaptchaCancelButton.setFont(this.getFontSetting());
        settingsRoutingClientConfigDialogCaptchaCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                captchaDialog.dispose();
            }
        });
        TitledBorder settingsRoutingClientConfigDialogCaptchaBorder = new TitledBorder(JAPMessages.getString("settingsRoutingClientConfigDialogCaptchaBorder"));
        settingsRoutingClientConfigDialogCaptchaBorder.setTitleFont(this.getFontSetting());
        captchaPanel.setBorder(settingsRoutingClientConfigDialogCaptchaBorder);
        GridBagLayout captchaPanelLayout = new GridBagLayout();
        captchaPanel.setLayout(captchaPanelLayout);
        GridBagConstraints captchaPanelConstraints = new GridBagConstraints();
        captchaPanelConstraints.anchor = 18;
        captchaPanelConstraints.fill = 2;
        captchaPanelConstraints.weightx = 1.0;
        captchaPanelConstraints.gridwidth = 2;
        captchaPanelConstraints.gridx = 0;
        captchaPanelConstraints.gridy = 0;
        captchaPanelConstraints.insets = new Insets(5, 5, 0, 5);
        captchaPanelLayout.setConstraints(captchaImageLabel, captchaPanelConstraints);
        captchaPanel.add(captchaImageLabel);
        captchaPanelConstraints.gridx = 0;
        captchaPanelConstraints.gridy = 1;
        captchaPanelConstraints.insets = new Insets(10, 5, 0, 5);
        captchaPanelLayout.setConstraints(settingsRoutingClientConfigDialogCaptchaCharacterSetLabel, captchaPanelConstraints);
        captchaPanel.add(settingsRoutingClientConfigDialogCaptchaCharacterSetLabel);
        captchaPanelConstraints.gridx = 0;
        captchaPanelConstraints.gridy = 2;
        captchaPanelConstraints.insets = new Insets(5, 5, 0, 5);
        captchaPanelLayout.setConstraints(settingsRoutingClientConfigDialogCaptchaCharacterNumberLabel, captchaPanelConstraints);
        captchaPanel.add(settingsRoutingClientConfigDialogCaptchaCharacterNumberLabel);
        captchaPanelConstraints.gridx = 0;
        captchaPanelConstraints.gridy = 3;
        captchaPanelConstraints.insets = new Insets(10, 5, 0, 5);
        captchaPanelLayout.setConstraints(settingsRoutingClientConfigDialogCaptchaInsertCaptchaLabel, captchaPanelConstraints);
        captchaPanel.add(settingsRoutingClientConfigDialogCaptchaInsertCaptchaLabel);
        captchaPanelConstraints.gridx = 0;
        captchaPanelConstraints.gridy = 4;
        captchaPanelConstraints.insets = new Insets(0, 5, 0, 5);
        captchaPanelLayout.setConstraints(captchaField, captchaPanelConstraints);
        captchaPanel.add(captchaField);
        captchaPanelConstraints.gridx = 0;
        captchaPanelConstraints.gridy = 5;
        captchaPanelConstraints.gridwidth = 1;
        captchaPanelConstraints.weighty = 1.0;
        captchaPanelConstraints.insets = new Insets(20, 5, 5, 5);
        captchaPanelLayout.setConstraints(settingsRoutingClientConfigDialogCaptchaCancelButton, captchaPanelConstraints);
        captchaPanel.add(settingsRoutingClientConfigDialogCaptchaCancelButton);
        captchaPanelConstraints.gridx = 1;
        captchaPanelConstraints.gridy = 5;
        captchaPanelConstraints.insets = new Insets(20, 5, 5, 5);
        captchaPanelLayout.setConstraints(settingsRoutingClientConfigDialogCaptchaNextButton, captchaPanelConstraints);
        captchaPanel.add(settingsRoutingClientConfigDialogCaptchaNextButton);
        captchaDialog.pack();
        captchaDialog.setVisible(true);
        ListenerInterface returnValue = null;
        if (forwarderInterface.size() > 0) {
            returnValue = (ListenerInterface)forwarderInterface.firstElement();
        }
        return returnValue;
    }

    private boolean showConfigClientDialogConnectToForwarder() {
        IAddress defaultForwarderAddress;
        final Vector occuredError = new Vector();
        Runnable connectThread = new Runnable(){

            public void run() {
                if (!JAPModel.getInstance().getRoutingSettings().setRoutingMode(1)) {
                    occuredError.addElement(JAPMessages.getString("settingsRoutingClientConfigConnectToForwarderError"));
                }
            }
        };
        IAddress currentForwarderAddress = defaultForwarderAddress = JAPModel.getInstance().getRoutingSettings().getForwarderAddress();
        do {
            occuredError.removeAllElements();
            String currentForwarderString = "";
            if (currentForwarderAddress != null) {
                currentForwarderString = Endpoint.toURN(currentForwarderAddress);
            }
            JAPDialog connectDialog = new JAPDialog(this.getRootComponent(), JAPMessages.getString("settingsRoutingClientConfigConnectToForwarderTitle"));
            connectDialog.setResizable(false);
            connectDialog.setDefaultCloseOperation(2);
            WorkerContentPane worker = new WorkerContentPane(connectDialog, JAPMessages.getString("settingsRoutingClientConfigDialogConnectToForwarderLabel"), JAPMessages.getString("settingsRoutingClientConfigDialogConnectToForwarderInfoLabel") + " " + currentForwarderString, connectThread);
            worker.updateDialog();
            connectDialog.pack();
            connectDialog.setVisible(true);
            if (!worker.hasValidValue() || occuredError.size() != 0) continue;
            return true;
        } while ((currentForwarderAddress = JAPModel.getInstance().getRoutingSettings().nextForwarderAddress()) != defaultForwarderAddress);
        if (occuredError.size() > 0) {
            JAPDialog.showErrorDialog(this.getRootComponent(), (String)occuredError.firstElement());
        }
        return false;
    }

    private ForwardConnectionDescriptor showConfigClientDialogGetOffer() {
        JAPDialog offerDialog = new JAPDialog(this.getRootComponent(), JAPMessages.getString("settingsRoutingClientConfigGetOfferTitle"));
        offerDialog.setResizable(false);
        offerDialog.setDefaultCloseOperation(0);
        final Vector occuredError = new Vector();
        final Vector fetchedDescriptor = new Vector();
        Runnable offerThread = new Runnable(){

            public void run() {
                try {
                    ForwardConnectionDescriptor connectionDescriptor = JAPModel.getInstance().getRoutingSettings().getConnectionDescriptor();
                    fetchedDescriptor.addElement(connectionDescriptor);
                }
                catch (ClientForwardException e) {
                    LogHolder.log(3, LogType.NET, e);
                    if (e.getErrorCode() == 1) {
                        occuredError.addElement(JAPMessages.getString("settingsRoutingClientGetOfferConnectError"));
                    }
                    if (e.getErrorCode() == 3) {
                        occuredError.addElement(JAPMessages.getString("settingsRoutingClientGetOfferVersionError"));
                    }
                    occuredError.addElement(JAPMessages.getString("settingsRoutingClientGetOfferUnknownError"));
                }
            }
        };
        ProgressCounter a_observable = JAPModel.getInstance().getRoutingSettings().getPacketCounter();
        WorkerContentPane worker = new WorkerContentPane(offerDialog, JAPMessages.getString("settingsRoutingClientConfigDialogGetOfferLabel"), offerThread, (Observable)a_observable){

            public DialogContentPane.CheckError checkCancel() {
                DialogContentPane.CheckError error = super.checkCancel();
                if (error == null) {
                    JAPModel.getInstance().getRoutingSettings().setRoutingMode(0);
                }
                return error;
            }
        };
        worker.updateDialog();
        offerDialog.pack();
        offerDialog.setVisible(true);
        offerDialog.dispose();
        ForwardConnectionDescriptor returnValue = null;
        if (fetchedDescriptor.size() > 0) {
            returnValue = (ForwardConnectionDescriptor)fetchedDescriptor.firstElement();
        } else if (occuredError.size() > 0) {
            JAPDialog.showErrorDialog(this.getRootComponent(), (String)occuredError.firstElement());
        }
        return returnValue;
    }

    private MixCascade showConfigClientDialogStep2(ForwardConnectionDescriptor a_connectionDescriptor) {
        final JAPDialog client2Dialog = new JAPDialog(this.getRootComponent(), JAPMessages.getString("settingsRoutingClientConfigDialog2Title"));
        client2Dialog.setDefaultCloseOperation(0);
        JPanel client2Panel = new JPanel();
        client2Dialog.getContentPane().add(client2Panel);
        JLabel settingsRoutingClientConfigDialog2GuaranteedBandwidthLabel = new JLabel(JAPMessages.getString("settingsRoutingClientConfigDialog2GuaranteedBandwidthLabel") + " " + Integer.toString(a_connectionDescriptor.getGuaranteedBandwidth()));
        settingsRoutingClientConfigDialog2GuaranteedBandwidthLabel.setFont(this.getFontSetting());
        JLabel settingsRoutingClientConfigDialog2MaxBandwidthLabel = new JLabel(JAPMessages.getString("settingsRoutingClientConfigDialog2MaxBandwidthLabel") + " " + Integer.toString(a_connectionDescriptor.getMaximumBandwidth()));
        settingsRoutingClientConfigDialog2MaxBandwidthLabel.setFont(this.getFontSetting());
        JLabel settingsRoutingClientConfigDialog2DummyTrafficLabel = new JLabel();
        settingsRoutingClientConfigDialog2DummyTrafficLabel.setFont(this.getFontSetting());
        if (a_connectionDescriptor.getMinDummyTrafficInterval() != -1) {
            settingsRoutingClientConfigDialog2DummyTrafficLabel.setText(JAPMessages.getString("settingsRoutingClientConfigDialog2DummyTrafficLabel") + " " + Integer.toString(a_connectionDescriptor.getMinDummyTrafficInterval() / 1000));
        } else {
            settingsRoutingClientConfigDialog2DummyTrafficLabel.setText(JAPMessages.getString("settingsRoutingClientConfigDialog2DummyTrafficLabel") + " " + JAPMessages.getString("settingsRoutingClientConfigDialog2DummyTrafficLabelNoNeed"));
        }
        final JButton settingsRoutingClientConfigDialog2FinishButton = new JButton(JAPMessages.getString("settingsRoutingClientConfigDialog2FinishButton"));
        JLabel settingsRoutingClientConfigDialog2MixCascadesLabel = new JLabel(JAPMessages.getString("settingsRoutingClientConfigDialog2MixCascadesLabel"));
        settingsRoutingClientConfigDialog2MixCascadesLabel.setFont(this.getFontSetting());
        final JList supportedCascadesList = new JList(a_connectionDescriptor.getMixCascadeList());
        supportedCascadesList.setSelectionMode(0);
        supportedCascadesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent event) {
                if (supportedCascadesList.getSelectedIndex() != -1) {
                    settingsRoutingClientConfigDialog2FinishButton.setEnabled(true);
                } else {
                    settingsRoutingClientConfigDialog2FinishButton.setEnabled(false);
                }
            }
        });
        JScrollPane supportedCascadesScrollPane = new JScrollPane(supportedCascadesList);
        supportedCascadesScrollPane.setFont(this.getFontSetting());
        final Vector selectedMixCascade = new Vector();
        settingsRoutingClientConfigDialog2FinishButton.setFont(this.getFontSetting());
        if (supportedCascadesList.getSelectedIndex() != -1) {
            settingsRoutingClientConfigDialog2FinishButton.setEnabled(true);
        } else {
            settingsRoutingClientConfigDialog2FinishButton.setEnabled(false);
        }
        settingsRoutingClientConfigDialog2FinishButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                selectedMixCascade.addElement((MixCascade)supportedCascadesList.getSelectedValue());
                client2Dialog.dispose();
            }
        });
        JButton settingsRoutingClientConfigDialog2CancelButton = new JButton(JAPMessages.getString("cancelButton"));
        settingsRoutingClientConfigDialog2CancelButton.setFont(this.getFontSetting());
        settingsRoutingClientConfigDialog2CancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPModel.getInstance().getRoutingSettings().setRoutingMode(0);
                client2Dialog.dispose();
            }
        });
        TitledBorder settingsRoutingClientConfigDialog2Border = new TitledBorder(JAPMessages.getString("settingsRoutingClientConfigDialog2Border"));
        settingsRoutingClientConfigDialog2Border.setTitleFont(this.getFontSetting());
        client2Panel.setBorder(settingsRoutingClientConfigDialog2Border);
        GridBagLayout client2PanelLayout = new GridBagLayout();
        client2Panel.setLayout(client2PanelLayout);
        GridBagConstraints client2PanelConstraints = new GridBagConstraints();
        client2PanelConstraints.anchor = 18;
        client2PanelConstraints.fill = 1;
        client2PanelConstraints.weightx = 1.0;
        client2PanelConstraints.weighty = 0.0;
        client2PanelConstraints.gridwidth = 2;
        client2PanelConstraints.gridx = 0;
        client2PanelConstraints.gridy = 0;
        client2PanelConstraints.insets = new Insets(0, 5, 10, 5);
        client2PanelLayout.setConstraints(settingsRoutingClientConfigDialog2GuaranteedBandwidthLabel, client2PanelConstraints);
        client2Panel.add(settingsRoutingClientConfigDialog2GuaranteedBandwidthLabel);
        client2PanelConstraints.gridx = 0;
        client2PanelConstraints.gridy = 1;
        client2PanelLayout.setConstraints(settingsRoutingClientConfigDialog2MaxBandwidthLabel, client2PanelConstraints);
        client2Panel.add(settingsRoutingClientConfigDialog2MaxBandwidthLabel);
        client2PanelConstraints.gridx = 0;
        client2PanelConstraints.gridy = 2;
        client2PanelLayout.setConstraints(settingsRoutingClientConfigDialog2DummyTrafficLabel, client2PanelConstraints);
        client2Panel.add(settingsRoutingClientConfigDialog2DummyTrafficLabel);
        client2PanelConstraints.gridx = 0;
        client2PanelConstraints.gridy = 3;
        client2PanelConstraints.insets = new Insets(0, 5, 0, 5);
        client2PanelLayout.setConstraints(settingsRoutingClientConfigDialog2MixCascadesLabel, client2PanelConstraints);
        client2Panel.add(settingsRoutingClientConfigDialog2MixCascadesLabel);
        client2PanelConstraints.gridx = 0;
        client2PanelConstraints.gridy = 4;
        client2PanelConstraints.weighty = 1.0;
        client2PanelConstraints.insets = new Insets(0, 5, 20, 5);
        client2PanelLayout.setConstraints(supportedCascadesScrollPane, client2PanelConstraints);
        client2Panel.add(supportedCascadesScrollPane);
        client2PanelConstraints.gridx = 0;
        client2PanelConstraints.gridy = 5;
        client2PanelConstraints.gridwidth = 1;
        client2PanelConstraints.weighty = 0.0;
        client2PanelConstraints.insets = new Insets(0, 5, 5, 5);
        client2PanelLayout.setConstraints(settingsRoutingClientConfigDialog2CancelButton, client2PanelConstraints);
        client2Panel.add(settingsRoutingClientConfigDialog2CancelButton);
        client2PanelConstraints.gridx = 1;
        client2PanelConstraints.gridy = 5;
        client2PanelConstraints.insets = new Insets(0, 5, 5, 5);
        client2PanelLayout.setConstraints(settingsRoutingClientConfigDialog2FinishButton, client2PanelConstraints);
        client2Panel.add(settingsRoutingClientConfigDialog2FinishButton);
        client2Dialog.pack();
        client2Dialog.setVisible(true);
        MixCascade returnValue = null;
        if (selectedMixCascade.size() > 0) {
            returnValue = (MixCascade)selectedMixCascade.firstElement();
        }
        return returnValue;
    }

    private boolean showConfigClientDialogAnnounceCascade(final MixCascade a_selectedMixCascade) {
        JAPDialog announceDialog = new JAPDialog(this.getRootComponent(), JAPMessages.getString("settingsRoutingClientConfigDialogAnnounceCascadeTitle"));
        announceDialog.setResizable(false);
        announceDialog.setDefaultCloseOperation(2);
        final Vector occuredError = new Vector();
        Runnable announceThread = new Runnable(){

            public void run() {
                try {
                    JAPModel.getInstance().getRoutingSettings().selectMixCascade(a_selectedMixCascade);
                }
                catch (ClientForwardException e) {
                    LogHolder.log(3, LogType.NET, "JAPConfRouting: showConfigClientDialogAnnounceCascade: " + e.toString());
                    if (e.getErrorCode() == 1) {
                        occuredError.addElement(JAPMessages.getString("settingsRoutingClientAnnounceCascadeConnectError"));
                    }
                    occuredError.addElement(JAPMessages.getString("settingsRoutingClientAnnounceCascadeUnknownError"));
                }
            }
        };
        WorkerContentPane worker = new WorkerContentPane(announceDialog, JAPMessages.getString("settingsRoutingClientConfigDialogAnnounceCascadeLabel"), announceThread){

            public DialogContentPane.CheckError checkCancel() {
                DialogContentPane.CheckError error = super.checkCancel();
                if (error == null) {
                    JAPModel.getInstance().getRoutingSettings().setRoutingMode(0);
                }
                return error;
            }
        };
        worker.updateDialog();
        announceDialog.pack();
        announceDialog.setVisible(true);
        boolean returnValue = false;
        if (occuredError.size() == 0) {
            JAPController.getInstance().setCurrentMixCascade(a_selectedMixCascade);
            JAPController.getInstance().setAnonMode(true);
            returnValue = true;
        } else if (occuredError.size() > 0) {
            JAPDialog.showErrorDialog(this.m_parentComponent, (String)occuredError.firstElement());
        }
        return returnValue;
    }

    private class CaptchaInputField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private IImageEncodedCaptcha m_captcha;

        public CaptchaInputField(IImageEncodedCaptcha a_captcha) {
            this.m_captcha = a_captcha;
        }

        protected Document createDefaultModel() {
            return new PlainDocument(){
                private static final long serialVersionUID = 1L;

                public void insertString(int a_position, String a_stringToInsert, AttributeSet a_attributes) throws BadLocationException {
                    if (this.getLength() + a_stringToInsert.length() <= CaptchaInputField.this.m_captcha.getCharacterNumber()) {
                        boolean invalidCharacters = false;
                        for (int i = 0; i < a_stringToInsert.length() && !invalidCharacters; ++i) {
                            if (CaptchaInputField.this.m_captcha.getCharacterSet().indexOf(a_stringToInsert.toUpperCase().substring(i, i + 1)) >= 0) continue;
                            invalidCharacters = true;
                        }
                        if (!invalidCharacters) {
                            super.insertString(a_position, a_stringToInsert.toUpperCase(), a_attributes);
                        }
                    }
                }
            };
        }
    }
}

