/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.transport.address.AddressParameter;
import anon.transport.address.IAddress;
import anon.util.JAPMessages;
import gui.JAPHtmlMultiLineLabel;
import jap.AbstractJAPConfModule;
import jap.JAPModel;
import jap.MessageSystem;
import jap.forward.JAPRoutingInfoServiceRegistrationTableModel;
import jap.forward.JAPRoutingMessage;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import logging.LogHolder;
import logging.LogType;

public class JAPConfForwardingState
extends AbstractJAPConfModule {
    private MessageSystem m_messageSystem;

    public JAPConfForwardingState() {
        super(null);
    }

    public String getHelpContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateRootPanel() {
        JAPConfForwardingState jAPConfForwardingState = this;
        synchronized (jAPConfForwardingState) {
            if (this.m_messageSystem == null) {
                this.m_messageSystem = new MessageSystem();
            }
        }
        JPanel rootPanel = this.getRootPanel();
        JAPConfForwardingState jAPConfForwardingState2 = this;
        synchronized (jAPConfForwardingState2) {
            rootPanel.removeAll();
            this.m_messageSystem.sendMessage();
            JPanel statePanel = this.createForwardingStatePanel();
            GridBagLayout rootPanelLayout = new GridBagLayout();
            rootPanel.setLayout(rootPanelLayout);
            GridBagConstraints rootPanelConstraints = new GridBagConstraints();
            rootPanelConstraints.anchor = 18;
            rootPanelConstraints.fill = 1;
            rootPanelConstraints.weightx = 1.0;
            rootPanelConstraints.weighty = 1.0;
            rootPanelConstraints.gridx = 0;
            rootPanelConstraints.gridy = 0;
            rootPanelLayout.setConstraints(statePanel, rootPanelConstraints);
            rootPanel.add(statePanel);
        }
    }

    public String getTabTitle() {
        return JAPMessages.getString("confTreeForwardingStateLeaf");
    }

    private JPanel createForwardingServerStatePanel() {
        final NumberFormat bandwidthFormat = NumberFormat.getInstance();
        bandwidthFormat.setMinimumFractionDigits(1);
        bandwidthFormat.setMaximumFractionDigits(1);
        bandwidthFormat.setMinimumIntegerDigits(1);
        final NumberFormat integerFormat = NumberFormat.getInstance();
        bandwidthFormat.setMinimumIntegerDigits(1);
        final JAPHtmlMultiLineLabel settingsRoutingServerStatusLabel = new JAPHtmlMultiLineLabel("");
        final JLabel settingsRoutingServerStatusRegistrationErrorLabel = new JLabel();
        final JLabel settingsRoutingServerStatusStatisticsBandwidthLabel = new JLabel();
        final JLabel settingsRoutingServerStatusStatisticsForwardedBytesLabel = new JLabel();
        JLabel settingsRoutingServerStatusStatisticsConnectionsLabel = new JLabel(JAPMessages.getString("settingsRoutingServerStatusStatisticsConnectionsLabel"));
        final JLabel settingsRoutingServerStatusStatisticsCurrentConnectionsLabel = new JLabel();
        final JLabel settingsRoutingServerStatusStatisticsAcceptedConnectionsLabel = new JLabel();
        final JLabel settingsRoutingServerStatusStatisticsRejectedConnectionsLabel = new JLabel();
        JLabel settingsRoutingServerStatusInfoServiceRegistrationsLabel = new JLabel(JAPMessages.getString("settingsRoutingServerStatusInfoServiceRegistrationsLabel"));
        final JAPRoutingInfoServiceRegistrationTableModel infoServiceRegistrationTableModel = new JAPRoutingInfoServiceRegistrationTableModel();
        JTable infoServiceRegistrationTable = new JTable(infoServiceRegistrationTableModel);
        infoServiceRegistrationTable.getColumnModel().getColumn(1).setMaxWidth(125);
        infoServiceRegistrationTable.getColumnModel().getColumn(1).setPreferredWidth(125);
        infoServiceRegistrationTable.setEnabled(false);
        infoServiceRegistrationTable.getTableHeader().setResizingAllowed(false);
        infoServiceRegistrationTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane infoServiceRegistrationTableScrollPane = new JScrollPane(infoServiceRegistrationTable);
        infoServiceRegistrationTableScrollPane.setPreferredSize(new Dimension(infoServiceRegistrationTableScrollPane.getPreferredSize().width, 50));
        Observer serverStatusObserver = new Observer(){

            public void update(Observable a_notifier, Object a_message) {
                try {
                    if (a_notifier == JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener() && ((JAPRoutingMessage)a_message).getMessageCode() == 13) {
                        settingsRoutingServerStatusStatisticsBandwidthLabel.setText(JAPMessages.getString("settingsRoutingServerStatusStatisticsBandwidthLabelPart1") + " " + bandwidthFormat.format((double)JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener().getCurrentBandwidthUsage() / 1024.0) + " " + JAPMessages.getString("settingsRoutingServerStatusStatisticsBandwidthLabelPart2"));
                        settingsRoutingServerStatusStatisticsForwardedBytesLabel.setText(JAPMessages.getString("settingsRoutingServerStatusStatisticsForwardedBytesLabel") + " " + integerFormat.format(JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener().getTransferedBytes()));
                        settingsRoutingServerStatusStatisticsCurrentConnectionsLabel.setText(JAPMessages.getString("settingsRoutingServerStatusStatisticsCurrentConnectionsLabel") + " " + integerFormat.format(JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener().getCurrentlyForwardedConnections()));
                        settingsRoutingServerStatusStatisticsAcceptedConnectionsLabel.setText(JAPMessages.getString("settingsRoutingServerStatusStatisticsAcceptedConnectionsLabel") + " " + integerFormat.format(JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener().getAcceptedConnections()));
                        settingsRoutingServerStatusStatisticsRejectedConnectionsLabel.setText(JAPMessages.getString("settingsRoutingServerStatusStatisticsRejectedConnectionsLabel") + " " + integerFormat.format(JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener().getRejectedConnections()));
                    }
                    if (a_notifier == JAPModel.getInstance().getRoutingSettings().getRegistrationStatusObserver() && ((JAPRoutingMessage)a_message).getMessageCode() == 14) {
                        int currentRegistrationState = JAPModel.getInstance().getRoutingSettings().getRegistrationStatusObserver().getCurrentState();
                        int currentErrorCode = JAPModel.getInstance().getRoutingSettings().getRegistrationStatusObserver().getCurrentErrorCode();
                        if (currentRegistrationState == 0) {
                            settingsRoutingServerStatusLabel.setText(JAPMessages.getString("settingsRoutingServerStatusLabelStateRegistrationDisabled"));
                        } else if (currentRegistrationState == 1) {
                            settingsRoutingServerStatusLabel.setText(JAPMessages.getString("settingsRoutingServerStatusLabelStateRegistrationInitiated"));
                        } else if (currentRegistrationState == 2) {
                            settingsRoutingServerStatusLabel.setText(JAPMessages.getString("settingsRoutingServerStatusLabelStateRegistrationFailed"));
                        } else if (currentRegistrationState == 3) {
                            settingsRoutingServerStatusLabel.setText(JAPMessages.getString("settingsRoutingServerStatusLabelStateRegistrationSuccessful"));
                        }
                        if (currentErrorCode == 0) {
                            settingsRoutingServerStatusRegistrationErrorLabel.setText(" ");
                        } else if (currentErrorCode == 1) {
                            settingsRoutingServerStatusRegistrationErrorLabel.setText(JAPMessages.getString("settingsRoutingServerStatusRegistrationErrorLabelNoKnownInfoServices"));
                        } else if (currentErrorCode == 2) {
                            settingsRoutingServerStatusRegistrationErrorLabel.setText(JAPMessages.getString("settingsRoutingServerStatusRegistrationErrorLabelConnectionFailed"));
                        } else if (currentErrorCode == 3) {
                            settingsRoutingServerStatusRegistrationErrorLabel.setText(JAPMessages.getString("settingsRoutingServerStatusRegistrationErrorLabelVerificationFailed"));
                        } else if (currentErrorCode == 4) {
                            settingsRoutingServerStatusRegistrationErrorLabel.setText(JAPMessages.getString("settingsRoutingServerStatusRegistrationErrorLabelUnknownReason"));
                        }
                    }
                    if (a_notifier == JAPModel.getInstance().getRoutingSettings() && ((JAPRoutingMessage)a_message).getMessageCode() == 2) {
                        infoServiceRegistrationTableModel.updatePropagandaInstancesList((Vector)((JAPRoutingMessage)a_message).getMessageData());
                    }
                    if (a_notifier == JAPConfForwardingState.this.m_messageSystem) {
                        JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener().deleteObserver(this);
                        JAPModel.getInstance().getRoutingSettings().deleteObserver(this);
                        JAPConfForwardingState.this.m_messageSystem.deleteObserver(this);
                        infoServiceRegistrationTableModel.clearPropagandaInstancesTable();
                    }
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.GUI, e);
                }
            }
        };
        this.m_messageSystem.addObserver(serverStatusObserver);
        JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener().addObserver(serverStatusObserver);
        JAPModel.getInstance().getRoutingSettings().getRegistrationStatusObserver().addObserver(serverStatusObserver);
        JAPModel.getInstance().getRoutingSettings().addObserver(serverStatusObserver);
        serverStatusObserver.update(JAPModel.getInstance().getRoutingSettings().getServerStatisticsListener(), new JAPRoutingMessage(13));
        serverStatusObserver.update(JAPModel.getInstance().getRoutingSettings().getRegistrationStatusObserver(), new JAPRoutingMessage(14));
        infoServiceRegistrationTableModel.updatePropagandaInstancesList(JAPModel.getInstance().getRoutingSettings().getRunningPropagandaInstances());
        JPanel serverStatusPanel = new JPanel();
        TitledBorder settingsRoutingServerStatusBorder = new TitledBorder(JAPMessages.getString("settingsRoutingServerStatusBorder"));
        serverStatusPanel.setBorder(settingsRoutingServerStatusBorder);
        GridBagLayout serverStatusPanelLayout = new GridBagLayout();
        serverStatusPanel.setLayout(serverStatusPanelLayout);
        GridBagConstraints serverStatusPanelConstraints = new GridBagConstraints();
        serverStatusPanelConstraints.anchor = 18;
        serverStatusPanelConstraints.fill = 0;
        serverStatusPanelConstraints.weightx = 1.0;
        serverStatusPanelConstraints.weighty = 0.0;
        serverStatusPanelConstraints.gridx = 0;
        serverStatusPanelConstraints.gridy = 0;
        serverStatusPanelConstraints.insets = new Insets(5, 5, 5, 5);
        serverStatusPanelLayout.setConstraints(settingsRoutingServerStatusLabel, serverStatusPanelConstraints);
        serverStatusPanel.add(settingsRoutingServerStatusLabel);
        serverStatusPanelConstraints.gridx = 0;
        serverStatusPanelConstraints.gridy = 1;
        serverStatusPanelConstraints.insets = new Insets(0, 5, 20, 5);
        serverStatusPanelLayout.setConstraints(settingsRoutingServerStatusRegistrationErrorLabel, serverStatusPanelConstraints);
        serverStatusPanel.add(settingsRoutingServerStatusRegistrationErrorLabel);
        serverStatusPanelConstraints.gridx = 0;
        serverStatusPanelConstraints.gridy = 2;
        serverStatusPanelConstraints.insets = new Insets(0, 5, 0, 5);
        serverStatusPanelLayout.setConstraints(settingsRoutingServerStatusInfoServiceRegistrationsLabel, serverStatusPanelConstraints);
        serverStatusPanel.add(settingsRoutingServerStatusInfoServiceRegistrationsLabel);
        serverStatusPanelConstraints.fill = 1;
        serverStatusPanelConstraints.weighty = 1.0;
        serverStatusPanelConstraints.gridx = 0;
        serverStatusPanelConstraints.gridy = 3;
        serverStatusPanelConstraints.insets = new Insets(0, 5, 5, 5);
        serverStatusPanelLayout.setConstraints(infoServiceRegistrationTableScrollPane, serverStatusPanelConstraints);
        serverStatusPanel.add(infoServiceRegistrationTableScrollPane);
        JPanel serverStatusStatisticsPanel = new JPanel();
        TitledBorder settingsRoutingServerStatusStatisticsBorder = new TitledBorder(JAPMessages.getString("settingsRoutingServerStatusStatisticsBorder"));
        serverStatusStatisticsPanel.setBorder(settingsRoutingServerStatusStatisticsBorder);
        GridBagLayout serverStatusStatisticsPanelLayout = new GridBagLayout();
        serverStatusStatisticsPanel.setLayout(serverStatusStatisticsPanelLayout);
        GridBagConstraints serverStatusStatisticsPanelConstraints = new GridBagConstraints();
        serverStatusStatisticsPanelConstraints.anchor = 18;
        serverStatusStatisticsPanelConstraints.fill = 0;
        serverStatusStatisticsPanelConstraints.weightx = 1.0;
        serverStatusStatisticsPanelConstraints.weighty = 0.0;
        serverStatusStatisticsPanelConstraints.gridx = 0;
        serverStatusStatisticsPanelConstraints.gridy = 0;
        serverStatusStatisticsPanelConstraints.gridwidth = 4;
        serverStatusStatisticsPanelConstraints.insets = new Insets(5, 5, 10, 5);
        serverStatusStatisticsPanelLayout.setConstraints(settingsRoutingServerStatusStatisticsBandwidthLabel, serverStatusStatisticsPanelConstraints);
        serverStatusStatisticsPanel.add(settingsRoutingServerStatusStatisticsBandwidthLabel);
        serverStatusStatisticsPanelConstraints.gridx = 0;
        serverStatusStatisticsPanelConstraints.gridy = 1;
        serverStatusStatisticsPanelConstraints.insets = new Insets(0, 5, 10, 5);
        serverStatusStatisticsPanelLayout.setConstraints(settingsRoutingServerStatusStatisticsForwardedBytesLabel, serverStatusStatisticsPanelConstraints);
        serverStatusStatisticsPanel.add(settingsRoutingServerStatusStatisticsForwardedBytesLabel);
        serverStatusStatisticsPanelConstraints.gridx = 0;
        serverStatusStatisticsPanelConstraints.gridy = 2;
        serverStatusStatisticsPanelConstraints.weighty = 1.0;
        serverStatusStatisticsPanelConstraints.weightx = 0.0;
        serverStatusStatisticsPanelConstraints.gridwidth = 1;
        serverStatusStatisticsPanelConstraints.insets = new Insets(0, 5, 5, 15);
        serverStatusStatisticsPanelLayout.setConstraints(settingsRoutingServerStatusStatisticsConnectionsLabel, serverStatusStatisticsPanelConstraints);
        serverStatusStatisticsPanel.add(settingsRoutingServerStatusStatisticsConnectionsLabel);
        serverStatusStatisticsPanelConstraints.gridx = 1;
        serverStatusStatisticsPanelConstraints.gridy = 2;
        serverStatusStatisticsPanelConstraints.insets = new Insets(0, 0, 5, 15);
        serverStatusStatisticsPanelLayout.setConstraints(settingsRoutingServerStatusStatisticsCurrentConnectionsLabel, serverStatusStatisticsPanelConstraints);
        serverStatusStatisticsPanel.add(settingsRoutingServerStatusStatisticsCurrentConnectionsLabel);
        serverStatusStatisticsPanelConstraints.gridx = 2;
        serverStatusStatisticsPanelConstraints.gridy = 2;
        serverStatusStatisticsPanelConstraints.insets = new Insets(0, 0, 5, 15);
        serverStatusStatisticsPanelLayout.setConstraints(settingsRoutingServerStatusStatisticsAcceptedConnectionsLabel, serverStatusStatisticsPanelConstraints);
        serverStatusStatisticsPanel.add(settingsRoutingServerStatusStatisticsAcceptedConnectionsLabel);
        serverStatusStatisticsPanelConstraints.gridx = 3;
        serverStatusStatisticsPanelConstraints.gridy = 2;
        serverStatusStatisticsPanelConstraints.weightx = 1.0;
        serverStatusStatisticsPanelConstraints.insets = new Insets(0, 0, 5, 5);
        serverStatusStatisticsPanelLayout.setConstraints(settingsRoutingServerStatusStatisticsRejectedConnectionsLabel, serverStatusStatisticsPanelConstraints);
        serverStatusStatisticsPanel.add(settingsRoutingServerStatusStatisticsRejectedConnectionsLabel);
        JPanel serverStatusAllPanel = new JPanel();
        GridBagLayout serverStatusAllPanelLayout = new GridBagLayout();
        serverStatusAllPanel.setLayout(serverStatusAllPanelLayout);
        GridBagConstraints serverStatusAllPanelConstraints = new GridBagConstraints();
        serverStatusAllPanelConstraints.anchor = 18;
        serverStatusAllPanelConstraints.fill = 1;
        serverStatusAllPanelConstraints.weightx = 1.0;
        serverStatusAllPanelConstraints.weighty = 1.0;
        serverStatusAllPanelConstraints.gridx = 0;
        serverStatusAllPanelConstraints.gridy = 0;
        serverStatusAllPanelLayout.setConstraints(serverStatusPanel, serverStatusAllPanelConstraints);
        serverStatusAllPanel.add(serverStatusPanel);
        serverStatusAllPanelConstraints.weighty = 0.0;
        serverStatusAllPanelConstraints.gridx = 0;
        serverStatusAllPanelConstraints.gridy = 1;
        serverStatusAllPanelLayout.setConstraints(serverStatusStatisticsPanel, serverStatusAllPanelConstraints);
        serverStatusAllPanel.add(serverStatusStatisticsPanel);
        return serverStatusAllPanel;
    }

    private JPanel createForwardingClientStatePanel() {
        JPanel clientStatusPanel = new JPanel();
        JLabel settingsRoutingClientStatusClientRunningLabel = new JLabel(JAPMessages.getString("settingsRoutingClientStatusClientRunningLabel"));
        JLabel settingsRoutingClientStatusConnectedViaLabel = new JLabel(JAPMessages.getString("settingsRoutingClientStatusConnectedViaLabel"));
        final JLabel settingsRoutingClientStatusForwarderInformationLabel = new JLabel();
        Observer clientStatusObserver = new Observer(){

            public void update(Observable a_notifier, Object a_message) {
                try {
                    if (a_notifier == JAPModel.getInstance().getRoutingSettings() && ((JAPRoutingMessage)a_message).getMessageCode() == 1 && JAPModel.getInstance().getRoutingSettings().getRoutingMode() == 1) {
                        IAddress currentForwarderAddress = JAPModel.getInstance().getRoutingSettings().getForwarderAddress();
                        if (currentForwarderAddress != null) {
                            AddressParameter[] paramters = currentForwarderAddress.getAllParameters();
                            settingsRoutingClientStatusForwarderInformationLabel.setText(JAPMessages.getString("settingsRoutingClientStatusForwarderInformationLabelPart1") + " " + paramters[0].getValue() + "    " + JAPMessages.getString("settingsRoutingClientStatusForwarderInformationLabelPart2") + " " + paramters[1].getValue());
                        } else {
                            settingsRoutingClientStatusForwarderInformationLabel.setText(JAPMessages.getString("settingsRoutingClientStatusForwarderInformationLabelInvalid"));
                        }
                    }
                    if (a_notifier == JAPConfForwardingState.this.m_messageSystem) {
                        JAPModel.getInstance().getRoutingSettings().deleteObserver(this);
                        JAPConfForwardingState.this.m_messageSystem.deleteObserver(this);
                    }
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.GUI, e);
                }
            }
        };
        this.m_messageSystem.addObserver(clientStatusObserver);
        JAPModel.getInstance().getRoutingSettings().addObserver(clientStatusObserver);
        clientStatusObserver.update(JAPModel.getInstance().getRoutingSettings(), new JAPRoutingMessage(1));
        TitledBorder settingsRoutingClientStatusBorder = new TitledBorder(JAPMessages.getString("settingsRoutingClientStatusBorder"));
        clientStatusPanel.setBorder(settingsRoutingClientStatusBorder);
        GridBagLayout clientStatusPanelLayout = new GridBagLayout();
        clientStatusPanel.setLayout(clientStatusPanelLayout);
        GridBagConstraints clientStatusPanelConstraints = new GridBagConstraints();
        clientStatusPanelConstraints.anchor = 18;
        clientStatusPanelConstraints.fill = 0;
        clientStatusPanelConstraints.weightx = 1.0;
        clientStatusPanelConstraints.weighty = 0.0;
        clientStatusPanelConstraints.gridx = 0;
        clientStatusPanelConstraints.gridy = 0;
        clientStatusPanelConstraints.insets = new Insets(5, 5, 10, 5);
        clientStatusPanelLayout.setConstraints(settingsRoutingClientStatusClientRunningLabel, clientStatusPanelConstraints);
        clientStatusPanel.add(settingsRoutingClientStatusClientRunningLabel);
        clientStatusPanelConstraints.gridx = 0;
        clientStatusPanelConstraints.gridy = 1;
        clientStatusPanelConstraints.insets = new Insets(0, 5, 2, 5);
        clientStatusPanelLayout.setConstraints(settingsRoutingClientStatusConnectedViaLabel, clientStatusPanelConstraints);
        clientStatusPanel.add(settingsRoutingClientStatusConnectedViaLabel);
        clientStatusPanelConstraints.gridx = 0;
        clientStatusPanelConstraints.gridy = 2;
        clientStatusPanelConstraints.weighty = 1.0;
        clientStatusPanelConstraints.insets = new Insets(0, 15, 5, 5);
        clientStatusPanelLayout.setConstraints(settingsRoutingClientStatusForwarderInformationLabel, clientStatusPanelConstraints);
        clientStatusPanel.add(settingsRoutingClientStatusForwarderInformationLabel);
        return clientStatusPanel;
    }

    private JPanel createForwardingDisabledStatePanel() {
        JPanel disabledStatusPanel = new JPanel();
        JLabel settingsRoutingDisabledStatusNothingRunningLabel = new JLabel(JAPMessages.getString("settingsRoutingDisabledStatusNothingRunningLabel"));
        TitledBorder settingsRoutingDisabledStatusBorder = new TitledBorder(JAPMessages.getString("settingsRoutingDisabledStatusBorder"));
        disabledStatusPanel.setBorder(settingsRoutingDisabledStatusBorder);
        GridBagLayout disabledStatusPanelLayout = new GridBagLayout();
        disabledStatusPanel.setLayout(disabledStatusPanelLayout);
        GridBagConstraints disabledStatusPanelConstraints = new GridBagConstraints();
        disabledStatusPanelConstraints.anchor = 18;
        disabledStatusPanelConstraints.fill = 0;
        disabledStatusPanelConstraints.weightx = 1.0;
        disabledStatusPanelConstraints.weighty = 1.0;
        disabledStatusPanelConstraints.gridx = 0;
        disabledStatusPanelConstraints.gridy = 0;
        disabledStatusPanelConstraints.insets = new Insets(5, 5, 5, 5);
        disabledStatusPanelLayout.setConstraints(settingsRoutingDisabledStatusNothingRunningLabel, disabledStatusPanelConstraints);
        disabledStatusPanel.add(settingsRoutingDisabledStatusNothingRunningLabel);
        return disabledStatusPanel;
    }

    private JPanel createForwardingStatePanel() {
        JPanel statusPanel = new JPanel();
        final JPanel serverStatusPanel = this.createForwardingServerStatePanel();
        final JPanel clientStatusPanel = this.createForwardingClientStatePanel();
        final JPanel disabledStatusPanel = this.createForwardingDisabledStatePanel();
        GridBagLayout statusPanelLayout = new GridBagLayout();
        statusPanel.setLayout(statusPanelLayout);
        GridBagConstraints statusPanelConstraints = new GridBagConstraints();
        statusPanelConstraints.anchor = 18;
        statusPanelConstraints.fill = 1;
        statusPanelConstraints.weightx = 1.0;
        statusPanelConstraints.weighty = 1.0;
        statusPanelConstraints.gridx = 0;
        statusPanelConstraints.gridy = 0;
        statusPanelLayout.setConstraints(serverStatusPanel, statusPanelConstraints);
        statusPanel.add(serverStatusPanel);
        statusPanelLayout.setConstraints(clientStatusPanel, statusPanelConstraints);
        statusPanel.add(clientStatusPanel);
        statusPanelLayout.setConstraints(disabledStatusPanel, statusPanelConstraints);
        statusPanel.add(disabledStatusPanel);
        statusPanel.setPreferredSize(statusPanel.getPreferredSize());
        Observer forwardingModeObserver = new Observer(){

            public void update(Observable a_notifier, Object a_message) {
                try {
                    if (a_notifier == JAPModel.getInstance().getRoutingSettings() && ((JAPRoutingMessage)a_message).getMessageCode() == 1) {
                        int newRoutingMode = JAPModel.getInstance().getRoutingSettings().getRoutingMode();
                        if (newRoutingMode == 1) {
                            serverStatusPanel.setVisible(false);
                            disabledStatusPanel.setVisible(false);
                            clientStatusPanel.setVisible(true);
                        }
                        if (newRoutingMode == 2) {
                            clientStatusPanel.setVisible(false);
                            disabledStatusPanel.setVisible(false);
                            serverStatusPanel.setVisible(true);
                        }
                        if (newRoutingMode == 0) {
                            serverStatusPanel.setVisible(false);
                            clientStatusPanel.setVisible(false);
                            disabledStatusPanel.setVisible(true);
                        }
                    }
                    if (a_notifier == JAPConfForwardingState.this.m_messageSystem) {
                        JAPModel.getInstance().getRoutingSettings().deleteObserver(this);
                        JAPConfForwardingState.this.m_messageSystem.deleteObserver(this);
                    }
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.GUI, e);
                }
            }
        };
        this.m_messageSystem.addObserver(forwardingModeObserver);
        JAPModel.getInstance().getRoutingSettings().addObserver(forwardingModeObserver);
        forwardingModeObserver.update(JAPModel.getInstance().getRoutingSettings(), new JAPRoutingMessage(1));
        return statusPanel;
    }
}

