/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.crypto.JAPCertificate;
import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.SimpleFileFilter;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public final class JAPUtil {
    private static final String MSG_DATE_UNIT = (class$jap$JAPUtil == null ? (class$jap$JAPUtil = JAPUtil.class$("jap.JAPUtil")) : class$jap$JAPUtil).getName() + "_";
    static /* synthetic */ Class class$jap$JAPUtil;

    public static JAPDialog.ILinkedInformation createDialogBrowserLink(String a_strUrl) {
        URL url;
        try {
            url = new URL(a_strUrl);
        }
        catch (MalformedURLException a_e) {
            return null;
        }
        final URL myUrl = url;
        return new JAPDialog.LinkedInformationAdapter(){

            public String getMessage() {
                return myUrl.toString();
            }

            public int getType() {
                return 2;
            }

            public void clicked(boolean a_bState) {
                AbstractOS.getInstance().openURL(myUrl);
            }
        };
    }

    public static String formatEuroCentValue(long centvalue, boolean a_bWithCurrency) {
        long whole = centvalue / 100L;
        long part = centvalue - whole * 100L;
        String wholeString = new Long(whole).toString();
        String partString = new Long(part).toString();
        String partFiller = part < 10L ? "0" : "";
        String language = JAPMessages.getLocale().getLanguage();
        return wholeString + JAPUtil.getCurrencyDelimiter(language) + partFiller + partString + (a_bWithCurrency ? " Euro" : "");
    }

    public static String getCurrencyDelimiter(String language) {
        if (language.equalsIgnoreCase("en")) {
            return new String(".");
        }
        return new String(",");
    }

    public static void setMnemonic(AbstractButton bt, String mn) {
        if (bt == null || mn == null || mn.equals("")) {
            return;
        }
        bt.setMnemonic(mn.charAt(0));
    }

    public static void setPerfectTableSize(JTable table, Dimension maxDimension) {
        TableModel tableModel = table.getModel();
        int perfectWidth = 0;
        int perfectHeight = 0;
        int minimunColunmHeight = 0;
        for (int i = 0; i < tableModel.getColumnCount(); ++i) {
            TableColumn column = table.getColumnModel().getColumn(i);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            int headerWidth = column.getPreferredWidth();
            int columnHeight = 0;
            if (headerRenderer != null) {
                Component component = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
                headerWidth = component.getPreferredSize().width;
                columnHeight = component.getPreferredSize().height;
            }
            if (tableModel.getRowCount() <= 0) continue;
            TableCellRenderer tableCellRenderer = table.getDefaultRenderer(tableModel.getColumnClass(i));
            int cellWidth = 0;
            for (int row = 0; row < tableModel.getRowCount(); ++row) {
                Object object = tableModel.getValueAt(row, i);
                Component component = tableCellRenderer.getTableCellRendererComponent(table, object, false, false, row, i);
                cellWidth = Math.max(cellWidth, component.getPreferredSize().width);
                columnHeight += component.getPreferredSize().height;
            }
            int preferredColumnWidth = Math.max(headerWidth, cellWidth);
            column.setPreferredWidth(preferredColumnWidth);
            perfectWidth += preferredColumnWidth;
            minimunColunmHeight = minimunColunmHeight == 0 ? columnHeight : Math.min(minimunColunmHeight, columnHeight);
        }
        perfectWidth = Math.min(maxDimension.width, perfectWidth + 30);
        perfectHeight = Math.min(maxDimension.height, minimunColunmHeight);
        table.setPreferredScrollableViewportSize(new Dimension(perfectWidth, perfectHeight));
    }

    public static JFileChooser showFileDialog(Window jf) {
        SimpleFileFilter active = null;
        JFileChooser fd2 = new JFileChooser();
        fd2.setFileSelectionMode(0);
        active = new SimpleFileFilter();
        fd2.addChoosableFileFilter(active);
        if (active != null) {
            fd2.setFileFilter(active);
        }
        fd2.setFileHidingEnabled(false);
        GUIUtils.showMonitoredFileChooser(fd2, jf, "__FILE_CHOOSER_OPEN");
        return fd2;
    }

    public static JAPCertificate openCertificate(Window jf) throws IOException {
        File file = JAPUtil.showFileDialog(jf).getSelectedFile();
        JAPCertificate t_cert = null;
        if (file != null && (t_cert = JAPCertificate.getInstance(file)) == null) {
            throw new IOException("Could not create certificate!");
        }
        return t_cert;
    }

    public static String getDuration(int duration, String durationUnit) {
        String message;
        if (durationUnit.equals("days") || durationUnit.equals("day")) {
            message = duration == 1 ? "day" : "days";
        } else if (durationUnit.equalsIgnoreCase("weeks") || durationUnit.equalsIgnoreCase("week")) {
            message = duration == 1 ? "week" : "weeks";
        } else if (durationUnit.equalsIgnoreCase("months") || durationUnit.equalsIgnoreCase("month")) {
            message = duration == 1 ? "month" : "months";
        } else if (durationUnit.equalsIgnoreCase("years") || durationUnit.equalsIgnoreCase("year")) {
            message = duration == 1 ? "year" : "years";
        } else {
            return duration + "";
        }
        return duration + " " + JAPMessages.getString(MSG_DATE_UNIT + message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

