/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.client.TrustModel;
import anon.crypto.JAPCertificate;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.IProxyInterfaceGetter;
import anon.infoservice.IServiceContextContainer;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.ProxyInterface;
import anon.mixminion.mmrdescription.MMRList;
import anon.platform.AbstractOS;
import anon.util.ClassUtil;
import anon.util.JAPMessages;
import anon.util.RecursiveFileTool;
import anon.util.ResourceLoader;
import anon.util.Util;
import gui.GUIUtils;
import gui.JAPDll;
import gui.dialog.JAPDialog;
import gui.help.AbstractHelpFileStorageManager;
import gui.help.IHelpModel;
import gui.help.LocalHelpFileStorageManager;
import jap.JAPController;
import jap.JARHelpFileStorageManager;
import jap.forward.JAPRoutingSettings;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import javax.swing.UIManager;
import logging.LogHolder;
import logging.LogType;

public final class JAPModel
extends Observable
implements IHelpModel,
IServiceContextContainer {
    public static final String MACOSX_LIB_NEEDS_UPDATE = "macOSXLibNeedsUpdate";
    public static final String DLL_VERSION_UPDATE = "dllVersionUpdate";
    public static final String DLL_VERSION_WARNING_BELOW = "dllWarningVersion";
    public static final int CONNECTION_ALLOW_ANONYMOUS = 0;
    public static final int CONNECTION_FORCE_ANONYMOUS = 1;
    public static final int CONNECTION_BLOCK_ANONYMOUS = 2;
    public static final String XML_ANONYMIZED_HTTP_HEADERS = "httpHeaderAnonymization";
    public static final String XML_DISABLE_ALL_HEADER_PROCESSING = "disableAllHeaderProcessing";
    public static final String XML_ANON_DEBUG_MODE = "enableANONDebugMode";
    public static final String XML_REMIND_OPTIONAL_UPDATE = "remindOptionalUpdate";
    public static final String XML_REMIND_JAVA_UPDATE = "remindJavaUpdate";
    public static final String XML_RESTRICT_CASCADE_AUTO_CHANGE = "restrictCascadeAutoChange";
    public static final String XML_ASK_FOR_NON_ANONYMOUS_SURFING = "askForUnprotectedSurfing";
    public static final String XML_ALLOW_NON_ANONYMOUS_SURFING = "allowUnprotectedSurfing";
    public static final String XML_ATTR_ACTIVATED = "activated";
    public static final String XML_FONT_SIZE = "fontSize";
    public static final String XML_CONFIG_WINDOW = "ConfigWindow";
    public static final String XML_SIZE = "Size";
    public static final String XML_ICONIFIED_WINDOW = "IconifiedWindow";
    public static final String XML_ATTR_ICONIFIED_ON_TOP = "alwaysOnTop";
    public static final String XML_HELP_WINDOW = "HelpWindow";
    public static final String XML_ATTR_WIDTH = "width";
    public static final String XML_ATTR_HEIGHT = "height";
    public static final String XML_ATTR_SAVE = "save";
    public static final String AUTO_CHANGE_NO_RESTRICTION = "none";
    public static final String AUTO_CHANGE_RESTRICT_TO_PAY = "pay";
    public static final String AUTO_CHANGE_RESTRICT = "restrict";
    public static final String NO_HELP_STORAGE_MANAGER = "help_internal";
    public static final int MAX_FONT_SIZE = 3;
    public static final Integer CHANGED_INFOSERVICE_AUTO_UPDATE = new Integer(0);
    public static final Integer CHANGED_ALLOW_INFOSERVICE_DIRECT_CONNECTION = new Integer(1);
    public static final Integer CHANGED_ALLOW_UPDATE_DIRECT_CONNECTION = new Integer(2);
    public static final Integer CHANGED_NOTIFY_JAP_UPDATES = new Integer(3);
    public static final Integer CHANGED_NOTIFY_JAVA_UPDATES = new Integer(4);
    public static final Integer CHANGED_AUTO_CONNECT = new Integer(5);
    public static final Integer CHANGED_AUTO_RECONNECT = new Integer(6);
    public static final Integer CHANGED_CASCADE_AUTO_CHANGE = new Integer(7);
    public static final Integer CHANGED_HELP_PATH = new Integer(9);
    public static final Integer CHANGED_DLL_UPDATE = new Integer(10);
    public static final Integer CHANGED_MACOSX_LIBRARY_UPDATE = new Integer(11);
    public static final Integer CHANGED_ANONYMIZED_HTTP_HEADERS = new Integer(12);
    public static final Integer CHANGED_CONTEXT = new Integer(13);
    public static final Integer CHANGED_SHOW_CLOSED_BUTTON = new Integer(14);
    public static final Integer CHANGED_PROXY = new Integer(15);
    public static final Integer CHANGED_CONFIG_ASSISTANT_SHOWUP = new Integer(16);
    private static final String[] MSG_CONNECTION_ANONYMOUS = new String[]{(class$jap$JAPModel == null ? (class$jap$JAPModel = JAPModel.class$("jap.JAPModel")) : class$jap$JAPModel).getName() + "_anonymousConnectionAllow", (class$jap$JAPModel == null ? (class$jap$JAPModel = JAPModel.class$("jap.JAPModel")) : class$jap$JAPModel).getName() + "_anonymousConnectionForce", (class$jap$JAPModel == null ? (class$jap$JAPModel = JAPModel.class$("jap.JAPModel")) : class$jap$JAPModel).getName() + "_anonymousConnectionBlock"};
    private static final int DIRECT_CONNECTION_INFOSERVICE = 0;
    private static final int DIRECT_CONNECTION_PAYMENT = 1;
    private static final int DIRECT_CONNECTION_UPDATE = 2;
    private int m_HttpListenerPortNumber = 4001;
    private boolean m_bHttpListenerIsLocal = true;
    private ProxyInterface m_proxyInterface = null;
    private ProxyInterface m_proxyAnon;
    private final Object SYNC_ANON_PROXY = new Object();
    private IMutableProxyInterface m_mutableProxyInterface;
    private boolean m_bAutoConnect;
    private boolean m_bAutoReConnect;
    private int m_iDummyTrafficIntervall = -1;
    private long m_msInterfaceBlockTimeout = 180000L;
    private boolean m_bSmallDisplay = false;
    private boolean m_bInfoServiceDisabled = false;
    private boolean m_bMinimizeOnStartup = false;
    private boolean m_bMoveToSystrayOnStartup = false;
    private int m_iDefaultView = 2;
    private boolean m_bSaveMainWindowPosition;
    private boolean m_bSaveConfigWindowPosition;
    private boolean m_bSaveIconifiedWindowPosition;
    private boolean m_bSaveHelpWindowPosition;
    private Point m_OldMainWindowLocation = null;
    private Point m_iconifiedWindowLocation = null;
    private Point m_configWindowLocation = null;
    private Point m_helpWindowLocation = null;
    private boolean m_bGoodByMessageNeverRemind = false;
    private int m_iPaymentAnonymousConnectionSetting;
    private int m_iInfoServiceAnonymousConnectionSetting;
    private int m_iUpdateAnonymousConnectionSetting;
    private boolean m_bAskForAnyNonAnonymousRequest;
    private boolean m_bAllowNonAnonymous = true;
    private boolean m_bRemindOptionalUpdate;
    private boolean m_bRemindJavaUpdate;
    private boolean m_bTorActivated;
    private boolean m_bMixMinionActivated;
    private boolean m_bANONDebugMode = false;
    private boolean m_bChooseCascasdeConnectionAutomatically;
    private boolean m_bChooseCascasdeAutomaticallyOnStartup;
    private boolean m_bHideAnonymityPopups = false;
    private boolean m_bHideInfoServicePopups = false;
    private boolean m_bHidePaymentPopups = false;
    private boolean m_bMiniViewOnTop;
    private String m_strLookAndFeel;
    private Vector m_vecLookAndFeels = new Vector();
    private UIManager.LookAndFeelInfo[] m_systemLookAndFeels;
    private Object LOOK_AND_FEEL_SYNC = new Object();
    private boolean m_bShowDialogFormat = false;
    private boolean m_bShowCloseButton = false;
    private boolean m_bAnonymizedHttpHeaders = false;
    private boolean m_bDisableAllHeaderProcessing = false;
    private boolean m_bShowConfigAssistant = true;
    private String m_context = "jondonym";
    private String m_strDistributorMode = "JAP/JonDo";
    private String m_strRelativeBrowserPath;
    private String m_strLauncher = null;
    private int m_fontSize = 0;
    private GUIUtils.IIconResizer m_resizer = new GUIUtils.IIconResizer(){

        public double getResizeFactor() {
            return 1.0 + (double)JAPModel.this.getFontSize() * 0.1;
        }
    };
    private static JAPModel ms_TheModel = null;
    private JAPCertificate m_certJAPCodeSigning = null;
    private int m_TorMaxConnectionsPerRoute = 1000;
    private int m_TorMaxRouteLen = 3;
    private int m_TorMinRouteLen = 2;
    private boolean m_bTorUseNoneDefaultDirServer = false;
    private int m_mixminionRouteLen = 2;
    private String m_mixminionMyEMail = "";
    private String m_mixminionPassword = null;
    private byte[] m_mixminionPasswordHash = null;
    private String m_mixminionKeyring = "";
    private Vector m_mixminionMessages = null;
    private MMRList m_mixminionRouters = null;
    private Vector m_mixminionFragments = null;
    private boolean m_bPreCreateAnonRoutes = false;
    private boolean m_bUseProxyAuthentication = false;
    private JAPController.AnonConnectionChecker m_connectionChecker;
    private boolean m_bShowSplashScreen = true;
    private boolean m_bShowSplashDisabled = false;
    private boolean m_bStartPortableFirefox = true;
    private String m_helpPath = null;
    private boolean m_bPortableHelp = false;
    private Dimension m_iconifiedSize;
    private Dimension m_configSize;
    private Dimension m_helpSize;
    private boolean m_bSaveHelpSize;
    private boolean m_bSaveConfigSize;
    private JAPRoutingSettings m_routingSettings;
    private String m_configFileName;
    private boolean m_forwardingStateModuleVisible;
    private String m_paymentPassword;
    private String m_bDllUpdatePath;
    private long m_noWarningForDllVersionBelow = 0L;
    private boolean m_bMacOSXLibraryUpdateAtStartupNeeded = false;
    private BigInteger m_iDialogVersion = new BigInteger("-1");
    private AbstractHelpFileStorageManager m_helpFileStorageManager;
    private Hashtable m_acceptedTCs = new Hashtable();
    static /* synthetic */ Class class$jap$JAPModel;

    private JAPModel() {
        try {
            this.m_certJAPCodeSigning = JAPCertificate.getInstance(ResourceLoader.loadResource("certificates/japcodesigning.cer"));
        }
        catch (Throwable t) {
            this.m_certJAPCodeSigning = null;
        }
        this.m_routingSettings = new JAPRoutingSettings();
        this.m_configFileName = null;
        this.m_forwardingStateModuleVisible = false;
        this.m_mutableProxyInterface = new IMutableProxyInterface(){

            public IProxyInterfaceGetter getProxyInterface(boolean a_bAnonInterface) {
                return new IProxyInterfaceGetter(){

                    public ImmutableProxyInterface getProxyInterface() {
                        ProxyInterface proxy = JAPModel.this.m_proxyInterface;
                        if (proxy != null && proxy.isValid()) {
                            return proxy;
                        }
                        return null;
                    }
                };
            }
        };
        this.m_helpFileStorageManager = ClassUtil.getJarFile() == null ? new LocalHelpFileStorageManager("JonDo") : new JARHelpFileStorageManager();
        this.m_bANONDebugMode = false;
    }

    public static JAPModel getInstance() {
        if (ms_TheModel == null) {
            ms_TheModel = new JAPModel();
        }
        return ms_TheModel;
    }

    public String getPortableBrowserpath() {
        return this.m_strRelativeBrowserPath;
    }

    public void setPortableBrowserpath(String a_strRelativeBrowserPath) {
        this.m_strRelativeBrowserPath = a_strRelativeBrowserPath == null || a_strRelativeBrowserPath.trim().length() <= 0 ? null : a_strRelativeBrowserPath;
    }

    public static String[] getMsgConnectionAnonymous() {
        return MSG_CONNECTION_ANONYMOUS;
    }

    public ProxyInterface getProxyInterface() {
        return this.m_proxyInterface;
    }

    public IMutableProxyInterface getMutableProxyInterface() {
        return this.m_mutableProxyInterface;
    }

    synchronized void setProxyListener(ProxyInterface a_proxyInterface) {
        if (!Util.equals(this.m_proxyInterface, a_proxyInterface)) {
            if (a_proxyInterface != null) {
                this.m_proxyInterface = a_proxyInterface;
            }
            this.setChanged();
        }
        this.notifyObservers(CHANGED_PROXY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAutoConnect(boolean b) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bAutoConnect != b) {
                this.m_bAutoConnect = b;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_AUTO_CONNECT);
        }
    }

    public static boolean isAutoConnect() {
        return JAPModel.ms_TheModel.m_bAutoConnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoReConnect(boolean b) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bAutoReConnect != b) {
                this.m_bAutoReConnect = b;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_AUTO_RECONNECT);
        }
    }

    public static boolean isAutomaticallyReconnected() {
        return JAPModel.ms_TheModel.m_bAutoReConnect;
    }

    public void setLookAndFeel(String a_strLookAndFeel) {
        this.m_strLookAndFeel = a_strLookAndFeel;
    }

    public Vector getLookAndFeelFiles() {
        return (Vector)this.m_vecLookAndFeels.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addLookAndFeelFile(File a_file) {
        if (a_file != null) {
            Vector vector = this.m_vecLookAndFeels;
            synchronized (vector) {
                if (!this.m_vecLookAndFeels.contains(a_file)) {
                    this.m_vecLookAndFeels.addElement(a_file);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean removeLookAndFeelFile(File a_file) {
        return this.m_vecLookAndFeels.removeElement(a_file);
    }

    public String getLookAndFeel() {
        return this.m_strLookAndFeel;
    }

    public boolean isTorActivated() {
        return this.m_bTorActivated;
    }

    public void setTorActivated(boolean a_bActivate) {
        this.m_bTorActivated = a_bActivate;
    }

    public void setMixMinionActivated(boolean a_bActivate) {
        this.m_bMixMinionActivated = a_bActivate;
    }

    public boolean isMixMinionActivated() {
        return this.m_bMixMinionActivated;
    }

    public boolean isANONDebugMode() {
        return this.m_bANONDebugMode;
    }

    public void setANONDebugMode(boolean bDebug) {
        this.m_bANONDebugMode = bDebug;
    }

    protected void setMinimizeOnStartup(boolean b) {
        this.m_bMinimizeOnStartup = b;
    }

    public static boolean getMinimizeOnStartup() {
        return JAPModel.ms_TheModel.m_bMinimizeOnStartup;
    }

    protected void setMoveToSystrayOnStartup(boolean b) {
        this.m_bMoveToSystrayOnStartup = b;
    }

    public static boolean getMoveToSystrayOnStartup() {
        return JAPModel.ms_TheModel.m_bMoveToSystrayOnStartup;
    }

    protected void setDefaultView(int view) {
        this.m_iDefaultView = view;
    }

    public static int getDefaultView() {
        return JAPModel.ms_TheModel.m_iDefaultView;
    }

    protected void setSaveMainWindowPosition(boolean b) {
        this.m_bSaveMainWindowPosition = b;
    }

    public void setSaveConfigWindowPosition(boolean a_bSave) {
        this.m_bSaveConfigWindowPosition = a_bSave;
    }

    public void setSaveIconifiedWindowPosition(boolean a_bSave) {
        this.m_bSaveIconifiedWindowPosition = a_bSave;
    }

    public void setSaveHelpWindowPosition(boolean a_bSave) {
        this.m_bSaveHelpWindowPosition = a_bSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSystemLookAndFeels() {
        Object object = this.LOOK_AND_FEEL_SYNC;
        synchronized (object) {
            this.m_systemLookAndFeels = UIManager.getInstalledLookAndFeels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSystemLookAndFeel(String a_LAFclassName) {
        Object object = this.LOOK_AND_FEEL_SYNC;
        synchronized (object) {
            if (this.m_systemLookAndFeels == null || a_LAFclassName == null) {
                return false;
            }
            for (int i = 0; i < this.m_systemLookAndFeels.length; ++i) {
                if (this.m_systemLookAndFeels[i] == null || !this.m_systemLookAndFeels[i].getClassName().equals(a_LAFclassName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIconifiedWindowLocationSaved() {
        return this.m_bSaveIconifiedWindowPosition;
    }

    public void setIconifiedWindowLocation(Point a_location) {
        this.m_iconifiedWindowLocation = a_location;
    }

    public Point getIconifiedWindowLocation() {
        if (this.isIconifiedWindowLocationSaved()) {
            return this.m_iconifiedWindowLocation;
        }
        return null;
    }

    public boolean isHelpWindowLocationSaved() {
        return this.m_bSaveHelpWindowPosition;
    }

    public void setHelpWindowLocation(Point a_location) {
        this.m_helpWindowLocation = a_location;
    }

    public Point getHelpWindowLocation() {
        if (this.isHelpWindowLocationSaved()) {
            return this.m_helpWindowLocation;
        }
        return null;
    }

    public boolean isConfigWindowLocationSaved() {
        return this.m_bSaveConfigWindowPosition;
    }

    public void setConfigWindowLocation(Point a_location) {
        this.m_configWindowLocation = a_location;
    }

    public Point getConfigWindowLocation() {
        if (this.isConfigWindowLocationSaved()) {
            return this.m_configWindowLocation;
        }
        return null;
    }

    public static boolean isMainWindowLocationSaved() {
        return JAPModel.ms_TheModel.m_bSaveMainWindowPosition;
    }

    protected void setMainWindowLocation(Point location) {
        this.m_OldMainWindowLocation = location;
    }

    public static Point getMainWindowLocation() {
        if (JAPModel.isMainWindowLocationSaved()) {
            return JAPModel.ms_TheModel.m_OldMainWindowLocation;
        }
        return null;
    }

    public boolean isDialogFormatShown() {
        return this.m_bShowDialogFormat;
    }

    public void setDialogFormatShown(boolean a_bShow) {
        this.m_bShowDialogFormat = a_bShow;
    }

    protected void setDummyTraffic(int msIntervall) {
        this.m_iDummyTrafficIntervall = msIntervall;
    }

    public static int getDummyTraffic() {
        return JAPModel.ms_TheModel.m_iDummyTrafficIntervall;
    }

    protected void setInterfaceBlockTimeout(long msTimeout) {
        this.m_msInterfaceBlockTimeout = msTimeout;
    }

    public static long getInterfaceBlockTimeout() {
        return JAPModel.ms_TheModel.m_msInterfaceBlockTimeout;
    }

    protected void setHttpListenerPortNumber(int p) {
        this.m_HttpListenerPortNumber = p;
    }

    public void setAnonConnectionChecker(JAPController.AnonConnectionChecker a_connectionChecker) {
        this.m_connectionChecker = a_connectionChecker;
    }

    public boolean isReminderForOptionalUpdateActivated() {
        return this.m_bRemindOptionalUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReminderForOptionalUpdate(boolean a_bRemind) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bRemindOptionalUpdate != a_bRemind) {
                this.m_bRemindOptionalUpdate = a_bRemind;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_NOTIFY_JAP_UPDATES);
        }
    }

    public boolean isReminderForJavaUpdateActivated() {
        return this.m_bRemindJavaUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReminderForJavaUpdate(boolean a_bRemind) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bRemindJavaUpdate != a_bRemind) {
                this.m_bRemindJavaUpdate = a_bRemind;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_NOTIFY_JAVA_UPDATES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCascadeAutoSwitch(boolean a_bChooseCascasdeConnectionAutomatically) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bChooseCascasdeConnectionAutomatically != a_bChooseCascasdeConnectionAutomatically) {
                this.m_bChooseCascasdeConnectionAutomatically = a_bChooseCascasdeConnectionAutomatically;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_CASCADE_AUTO_CHANGE);
        }
    }

    public boolean isCascadeAutoSwitched() {
        return this.m_bChooseCascasdeConnectionAutomatically;
    }

    public void setAutoChooseCascadeOnStartup(boolean a_bChooseCascasdeAutomaticallyOnStartup) {
        this.m_bChooseCascasdeAutomaticallyOnStartup = false;
    }

    public boolean isCascadeAutoChosenOnStartup() {
        return this.m_bChooseCascasdeAutomaticallyOnStartup;
    }

    public boolean isAnonConnected() {
        return this.m_connectionChecker.checkAnonConnected();
    }

    public boolean isNonAnonymousAllowed() {
        return this.m_bAllowNonAnonymous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNonAnonymousAllowed(boolean a_bAllow) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bAllowNonAnonymous != a_bAllow) {
                this.m_bAllowNonAnonymous = a_bAllow;
                this.setChanged();
            }
            this.notifyObservers("RulesChanged");
        }
    }

    public boolean isAnonymityPopupsHidden() {
        return this.m_bHideAnonymityPopups;
    }

    public void setHideAnonymityPopups(boolean a_bHide) {
        this.m_bHideAnonymityPopups = a_bHide;
    }

    public boolean isPaymentPopupsHidden() {
        return this.m_bHidePaymentPopups;
    }

    public void setHidePaymentPopups(boolean a_bHide) {
        this.m_bHidePaymentPopups = a_bHide;
    }

    public void setHideInfoServicePopups(boolean a_bHide) {
        this.m_bHideInfoServicePopups = a_bHide;
    }

    public boolean isInfoServicePopupsHidden() {
        return this.m_bHideInfoServicePopups;
    }

    public boolean isAskForAnyNonAnonymousRequest() {
        return this.m_bAskForAnyNonAnonymousRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAskForAnyNonAnonymousRequest(boolean a_bAskForAnyNonAnonymousRequest) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bAskForAnyNonAnonymousRequest != a_bAskForAnyNonAnonymousRequest) {
                this.m_bAskForAnyNonAnonymousRequest = a_bAskForAnyNonAnonymousRequest;
                this.setChanged();
            }
            this.notifyObservers("RulesChanged");
        }
    }

    public int getPaymentAnonymousConnectionSetting() {
        return this.m_iPaymentAnonymousConnectionSetting;
    }

    public int getUpdateAnonymousConnectionSetting() {
        return this.m_iUpdateAnonymousConnectionSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateAnonymousConnectionSetting(int a_iUpdateAnonymousConnectionSetting) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_iUpdateAnonymousConnectionSetting != a_iUpdateAnonymousConnectionSetting) {
                this.m_iUpdateAnonymousConnectionSetting = a_iUpdateAnonymousConnectionSetting;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_ALLOW_UPDATE_DIRECT_CONNECTION);
        }
    }

    public int getInfoServiceAnonymousConnectionSetting() {
        return this.m_iInfoServiceAnonymousConnectionSetting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInfoServiceAnonymousConnectionSetting(int a_iInfoServiceAnonymousConnectionSetting) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_iInfoServiceAnonymousConnectionSetting != a_iInfoServiceAnonymousConnectionSetting) {
                this.m_iInfoServiceAnonymousConnectionSetting = a_iInfoServiceAnonymousConnectionSetting;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_ALLOW_INFOSERVICE_DIRECT_CONNECTION);
        }
    }

    public void setPaymentAnonymousConnectionSetting(int a_iPaymentAnonymousConnectionSetting) {
        this.m_iPaymentAnonymousConnectionSetting = a_iPaymentAnonymousConnectionSetting;
    }

    public IMutableProxyInterface getInfoServiceProxyInterface() {
        return new IMutableProxyInterface(){

            public IProxyInterfaceGetter getProxyInterface(boolean a_bAnonInterface) {
                return JAPModel.getInstance().getProxyInterface(0, a_bAnonInterface);
            }
        };
    }

    public IMutableProxyInterface getPaymentProxyInterface() {
        return new IMutableProxyInterface(){

            public IProxyInterfaceGetter getProxyInterface(boolean a_bAnonInterface) {
                return JAPModel.getInstance().getProxyInterface(1, a_bAnonInterface);
            }
        };
    }

    public IMutableProxyInterface getUpdateProxyInterface() {
        return new IMutableProxyInterface(){

            public IProxyInterfaceGetter getProxyInterface(boolean a_bAnonInterface) {
                return JAPModel.getInstance().getProxyInterface(2, a_bAnonInterface);
            }
        };
    }

    public ImmutableProxyInterface getTorProxyInterface() {
        return new ProxyInterface("localhost", JAPModel.getHttpListenerPortNumber(), 3, null);
    }

    public static int getHttpListenerPortNumber() {
        return JAPModel.ms_TheModel.m_HttpListenerPortNumber;
    }

    protected void setHttpListenerIsLocal(boolean b) {
        this.m_bHttpListenerIsLocal = b;
    }

    public static boolean isHttpListenerLocal() {
        return JAPModel.ms_TheModel.m_bHttpListenerIsLocal;
    }

    public void setSmallDisplay(boolean b) {
        this.m_bSmallDisplay = b;
    }

    public static boolean isSmallDisplay() {
        return JAPModel.ms_TheModel.m_bSmallDisplay;
    }

    public boolean isCloseButtonShown() {
        return this.m_bShowCloseButton;
    }

    public void setShowCloseButton(boolean a_bShowCloseButton) {
        if (this.m_bShowCloseButton != a_bShowCloseButton) {
            this.m_bShowCloseButton = a_bShowCloseButton;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_SHOW_CLOSED_BUTTON);
    }

    public boolean isNeverRemindGoodbye() {
        return this.m_bGoodByMessageNeverRemind;
    }

    public void setNeverRemindGoodbye(boolean a_bGoodByMessageNeverRemind) {
        this.m_bGoodByMessageNeverRemind = a_bGoodByMessageNeverRemind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInfoServiceDisabled(boolean b) {
        JAPModel jAPModel = this;
        synchronized (jAPModel) {
            if (this.m_bInfoServiceDisabled != b) {
                this.m_bInfoServiceDisabled = b;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_INFOSERVICE_AUTO_UPDATE);
        }
    }

    public static boolean isInfoServiceDisabled() {
        return JAPModel.ms_TheModel.m_bInfoServiceDisabled;
    }

    public boolean isMiniViewOnTop() {
        return this.m_bMiniViewOnTop;
    }

    public void setMiniViewOnTop(boolean a_bMiniViewOnTop) {
        this.m_bMiniViewOnTop = a_bMiniViewOnTop;
    }

    public GUIUtils.IIconResizer getIconResizer() {
        return this.m_resizer;
    }

    public int getFontSize() {
        return this.m_fontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFontSize(int a_fontSize) {
        if (a_fontSize < 0) {
            a_fontSize = 0;
        } else if (a_fontSize > 3) {
            a_fontSize = 3;
        }
        if (this.m_fontSize != a_fontSize) {
            JAPModel jAPModel = this;
            synchronized (jAPModel) {
                FontResize resize = new FontResize(this.m_fontSize, a_fontSize);
                if (!JAPDialog.isConsoleOnly()) {
                    GUIUtils.resizeAllFonts(1.0f / (1.0f + 0.1f * (float)resize.getOldSize()));
                    GUIUtils.resizeAllFonts(1.0f + 0.1f * (float)resize.getNewSize());
                }
                this.m_fontSize = a_fontSize;
                this.setChanged();
                this.notifyObservers(resize);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(2048);
        buff.append("Configuration for JAP Version ");
        buff.append("00.20.010");
        buff.append("\n");
        String s = JAPDll.getDllVersion();
        if (s != null) {
            buff.append("Using JAPDll Version: ");
            buff.append(s);
            buff.append("\n");
        }
        if ((s = JAPDll.getDllFileName()) != null) {
            buff.append("Using JAPDll File: ");
            buff.append(s);
            buff.append("\n");
        }
        buff.append("Config path: ");
        buff.append(this.getConfigFile());
        buff.append("\n");
        buff.append("Help path: ");
        buff.append(this.getHelpPath());
        buff.append("\n");
        if (this.m_bDllUpdatePath != null) {
            buff.append("DLL update path: ");
            buff.append(this.m_bDllUpdatePath);
            buff.append("\n");
        }
        buff.append("Command line arguments: '");
        String[] argv = JAPController.getInstance().getCommandlineArgs();
        for (int i = 0; i < argv.length; ++i) {
            buff.append(argv[i]);
            if (i >= argv.length - 1) continue;
            buff.append(" ");
        }
        buff.append("'\n");
        buff.append("HttpListenerPortNumber: ");
        buff.append(this.m_HttpListenerPortNumber);
        buff.append("\n");
        buff.append("HttpListenerIsLocal: ");
        buff.append(this.m_bHttpListenerIsLocal);
        buff.append("\n");
        buff.append("UseFirewall: ");
        boolean bFirewall = this.m_proxyInterface != null && this.m_proxyInterface.isValid();
        buff.append(bFirewall);
        buff.append("\n");
        if (bFirewall) {
            buff.append("FirewallType: ");
            buff.append(this.m_proxyInterface.getProtocol());
            buff.append("\n");
            buff.append("FirewallHost: ");
            buff.append(this.m_proxyInterface.getHost());
            buff.append("\n");
            buff.append("FirewallPort: ");
            buff.append(this.m_proxyInterface.getPort());
            buff.append("\n");
        }
        buff.append("AutoConnect: ");
        buff.append(this.m_bAutoConnect);
        buff.append("\n");
        buff.append("AutoReConnect: ");
        buff.append(this.m_bAutoReConnect);
        buff.append("\n");
        buff.append("Launcher: ");
        buff.append(this.m_strLauncher);
        buff.append("\n");
        return buff.toString();
    }

    public static boolean isPreCreateAnonRoutesEnabled() {
        return JAPModel.ms_TheModel.m_bPreCreateAnonRoutes;
    }

    void setPreCreateAnonRoutes(boolean b) {
        this.m_bPreCreateAnonRoutes = b;
    }

    public static JAPCertificate getJAPCodeSigningCert() {
        return JAPModel.ms_TheModel.m_certJAPCodeSigning;
    }

    public void setConfigFile(String a_configFileName) {
        this.m_configFileName = a_configFileName;
    }

    public void setIconifiedSize(Dimension a_size) {
        this.m_iconifiedSize = a_size;
    }

    public Dimension getIconifiedSize() {
        return this.m_iconifiedSize;
    }

    public void setHelpWindowSize(Dimension a_size) {
        this.m_helpSize = a_size;
    }

    public Dimension getHelpWindowSize() {
        return this.m_helpSize;
    }

    public boolean isHelpWindowSizeSaved() {
        return this.m_bSaveHelpSize;
    }

    public void setSaveHelpWindowSize(boolean a_bSave) {
        this.m_bSaveHelpSize = a_bSave;
    }

    public void setSaveConfigWindowSize(boolean a_bSave) {
        this.m_bSaveConfigSize = a_bSave;
    }

    public boolean isConfigWindowSizeSaved() {
        return this.m_bSaveConfigSize;
    }

    public void setConfigSize(Dimension a_size) {
        this.m_configSize = a_size;
    }

    public Dimension getConfigSize() {
        return this.m_configSize;
    }

    public String getConfigFile() {
        return this.m_configFileName;
    }

    public JAPRoutingSettings getRoutingSettings() {
        return this.m_routingSettings;
    }

    public void setForwardingStateModuleVisible(boolean a_moduleVisible) {
        this.m_forwardingStateModuleVisible = a_moduleVisible;
    }

    public boolean isForwardingStateModuleVisible() {
        return this.m_forwardingStateModuleVisible;
    }

    public static int getTorMaxConnectionsPerRoute() {
        return JAPModel.ms_TheModel.m_TorMaxConnectionsPerRoute;
    }

    protected void setTorMaxConnectionsPerRoute(int i) {
        this.m_TorMaxConnectionsPerRoute = i;
    }

    public static int getTorMaxRouteLen() {
        return JAPModel.ms_TheModel.m_TorMaxRouteLen;
    }

    protected void setTorMaxRouteLen(int i) {
        this.m_TorMaxRouteLen = i;
    }

    public static int getTorMinRouteLen() {
        return JAPModel.ms_TheModel.m_TorMinRouteLen;
    }

    protected void setTorMinRouteLen(int i) {
        this.m_TorMinRouteLen = i;
    }

    public static boolean isTorNoneDefaultDirServerEnabled() {
        return JAPModel.ms_TheModel.m_bTorUseNoneDefaultDirServer;
    }

    protected void setTorUseNoneDefaultDirServer(boolean b) {
        this.m_bTorUseNoneDefaultDirServer = b;
    }

    protected void setMixminionRouteLen(int i) {
        this.m_mixminionRouteLen = i;
    }

    public static int getMixminionRouteLen() {
        return JAPModel.ms_TheModel.m_mixminionRouteLen;
    }

    protected void setMixminionMyEMail(String address) {
        this.m_mixminionMyEMail = address;
    }

    public static String getMixminionMyEMail() {
        return JAPModel.ms_TheModel.m_mixminionMyEMail;
    }

    protected void setMixMinionPassword(String pw) {
        this.m_mixminionPassword = pw;
    }

    public static String getMixMinionPassword() {
        return JAPModel.ms_TheModel.m_mixminionPassword;
    }

    protected void setMixinionPasswordHash(byte[] hash2) {
        this.m_mixminionPasswordHash = hash2;
    }

    public static byte[] getMixMinionPasswordHash() {
        return JAPModel.ms_TheModel.m_mixminionPasswordHash;
    }

    protected void resetMixMinionKeyringandPw() {
        this.m_mixminionPasswordHash = null;
        this.m_mixminionPassword = null;
        this.m_mixminionKeyring = "";
    }

    protected void setMixminionMessages(Vector m) {
        this.m_mixminionMessages = m;
    }

    public static Vector getMixminionMessages() {
        return JAPModel.ms_TheModel.m_mixminionMessages;
    }

    protected void setMixminionKeyring(String kr) {
        this.m_mixminionKeyring = kr;
    }

    public static String getMixminionKeyring() {
        return JAPModel.ms_TheModel.m_mixminionKeyring;
    }

    protected void setMixminionMMRList(MMRList m) {
        this.m_mixminionRouters = m;
    }

    public static MMRList getMixminionMMRlist() {
        return JAPModel.ms_TheModel.m_mixminionRouters;
    }

    protected void setMixminionFragments(Vector f) {
        this.m_mixminionFragments = f;
    }

    public static Vector getMixminionFragments() {
        return JAPModel.ms_TheModel.m_mixminionFragments;
    }

    protected void setUseProxyAuthentication(boolean a_bUseAuth) {
        this.m_bUseProxyAuthentication = a_bUseAuth;
    }

    public boolean isProxyAuthenticationUsed() {
        return this.m_bUseProxyAuthentication;
    }

    public void setPaymentPassword(String a_password) {
        this.m_paymentPassword = a_password;
    }

    public String getPaymentPassword() {
        return this.m_paymentPassword;
    }

    public synchronized String getHelpPath() {
        return this.m_helpPath != null || this.m_bPortableHelp ? this.m_helpPath : AbstractOS.getInstance().getDefaultHelpPath("JonDo");
    }

    public synchronized URL getHelpURL(String a_startDoc) {
        URL helpURL = null;
        if (a_startDoc != null && this.isHelpPathDefined() && this.m_helpFileStorageManager.ensureMostRecentVersion(this.m_helpPath)) {
            try {
                if (new File(this.m_helpPath + File.separator + this.m_helpFileStorageManager.getLocalisedHelpDir() + File.separator + a_startDoc).exists()) {
                    helpURL = new URL("file://" + this.m_helpPath + "/" + this.m_helpFileStorageManager.getLocalisedHelpDir() + "/" + a_startDoc);
                }
            }
            catch (SecurityException a_e) {
                LogHolder.log(4, LogType.MISC, a_e);
            }
            catch (MalformedURLException e) {
                LogHolder.log(4, LogType.MISC, e);
            }
        }
        return helpURL;
    }

    public URL getHelpURL() {
        return this.getHelpURL("index.html");
    }

    synchronized void initHelpPath(String helpPath) {
        String initPathValidity;
        if (this.m_bPortableHelp) {
            return;
        }
        String blockedPath = AbstractOS.getInstance().getenv("ALLUSERSPROFILE");
        if (blockedPath != null && helpPath != null && helpPath.startsWith(blockedPath)) {
            if (helpPath.indexOf("JonDo") >= 0) {
                RecursiveFileTool.deleteRecursion(new File(helpPath));
            }
            helpPath = null;
        }
        this.m_helpPath = (initPathValidity = this.helpPathValidityCheck(helpPath)).equals("HELP_IS_VALID") || initPathValidity.equals("helpJonDoExists") || initPathValidity.equals(NO_HELP_STORAGE_MANAGER) ? helpPath : this.m_helpFileStorageManager.getInitPath();
    }

    public synchronized void setHelpPath(File hpFile) {
        this.setHelpPath(hpFile, false);
    }

    public synchronized void setHelpPath(File hpFile, boolean a_bPortable) {
        if (this.m_bPortableHelp && !a_bPortable) {
            return;
        }
        if (hpFile == null) {
            this.resetHelpPath();
        } else {
            hpFile = new File(hpFile.getAbsolutePath());
            if (a_bPortable) {
                this.m_bPortableHelp = true;
                if (hpFile.isFile()) {
                    String tmp;
                    int index = hpFile.getPath().toUpperCase().indexOf(("help" + File.pathSeparator + "de" + File.pathSeparator + "help").toUpperCase());
                    hpFile = index >= 0 || (index = hpFile.getPath().toUpperCase().indexOf(("help" + File.pathSeparator + "en" + File.pathSeparator + "help").toUpperCase())) >= 0 ? (index > 0 ? new File(hpFile.getPath().substring(0, index)) : null) : ((tmp = hpFile.getParent()) != null ? new File(tmp) : null);
                }
                if (hpFile != null && hpFile.isDirectory()) {
                    String strCheck = this.m_helpFileStorageManager.helpPathValidityCheck(hpFile.getPath(), true);
                    if (strCheck.equals("HELP_IS_VALID") || strCheck.equals("helpJonDoExists")) {
                        if (this.m_helpFileStorageManager.handleHelpPathChanged(this.m_helpPath, hpFile.getPath(), true)) {
                            if (this.m_helpPath == null || !this.m_helpPath.equals(hpFile.getPath())) {
                                this.m_helpPath = hpFile.getPath();
                                this.setChanged();
                            }
                        } else {
                            this.resetHelpPath();
                            LogHolder.log(4, LogType.GUI, "Help path resetted because we could not change it.");
                        }
                    } else {
                        this.resetHelpPath();
                        LogHolder.log(4, LogType.GUI, "Help path resetted because it was invalid.");
                    }
                } else {
                    this.resetHelpPath();
                    LogHolder.log(4, LogType.GUI, "Help path resetted because it was no directory.");
                }
            } else {
                File file;
                if (hpFile.getPath().toUpperCase().endsWith("help".toUpperCase()) && hpFile.getParent() != null && (file = new File(hpFile.getParent())).isDirectory()) {
                    hpFile = file;
                }
                this.setHelpPath(hpFile.getPath());
            }
        }
        this.notifyObservers(CHANGED_HELP_PATH);
    }

    private synchronized void setHelpPath(String newHelpPath) {
        if (newHelpPath == null) {
            this.resetHelpPath();
            return;
        }
        if (newHelpPath.equals("")) {
            this.resetHelpPath();
            return;
        }
        String strCheck = this.helpPathValidityCheck(newHelpPath);
        if (strCheck.equals("HELP_IS_VALID") || strCheck.equals("helpJonDoExists")) {
            boolean helpPathChanged;
            String oldHelpPath = this.m_helpPath;
            boolean bl = this.isHelpPathDefined() ? !this.m_helpPath.equals(newHelpPath) : (helpPathChanged = true);
            if (helpPathChanged) {
                boolean storageLayerChanged = true;
                storageLayerChanged = this.m_helpFileStorageManager.handleHelpPathChanged(oldHelpPath, newHelpPath, false);
                if (storageLayerChanged) {
                    this.m_helpPath = newHelpPath;
                    this.setChanged();
                }
            }
        }
    }

    public boolean extractHelpFiles(String a_extractionPath) {
        return this.m_helpFileStorageManager.extractHelpFiles(a_extractionPath);
    }

    protected synchronized void resetHelpPath() {
        String oldHelpPath = this.m_helpPath;
        if (oldHelpPath != null && !this.m_bPortableHelp) {
            this.m_helpFileStorageManager.handleHelpPathChanged(oldHelpPath, null, false);
            this.setChanged();
            this.m_helpPath = null;
        }
    }

    public synchronized String helpPathValidityCheck(String helpPath) {
        return this.m_helpFileStorageManager.helpPathValidityCheck(helpPath, false);
    }

    public synchronized String helpPathValidityCheck(File hpFile) {
        if (hpFile == null) {
            return JAPMessages.getString("invalidHelpPathNull");
        }
        return this.helpPathValidityCheck(hpFile.getPath());
    }

    public boolean isHelpPathChangeable() {
        if (this.m_helpFileStorageManager instanceof LocalHelpFileStorageManager) {
            return false;
        }
        return !this.m_bPortableHelp;
    }

    public synchronized boolean isHelpPathDefined() {
        boolean helpInstallationExists;
        boolean helpPathExists = this.m_helpPath != null;
        String strInstallationValid = null;
        boolean bInstallationExists = this.m_helpFileStorageManager.helpInstallationExists(this.m_helpPath);
        boolean bl = helpInstallationExists = bInstallationExists && (strInstallationValid = this.helpPathValidityCheck(this.m_helpPath)).equals("helpJonDoExists");
        if (helpPathExists && !helpInstallationExists) {
            LogHolder.log(4, LogType.MISC, "Help path " + this.m_helpPath + " configured but no valid help could be found! Exists: " + bInstallationExists + " Valid: " + strInstallationValid);
            this.m_helpPath = null;
            this.setChanged();
        }
        if (!this.m_bPortableHelp && this.m_helpPath == null && this.m_helpFileStorageManager.helpInstallationExists(AbstractOS.getInstance().getDefaultHelpPath("JonDo")) && this.helpPathValidityCheck(AbstractOS.getInstance().getDefaultHelpPath("JonDo")).equals("helpJonDoExists")) {
            this.m_helpPath = AbstractOS.getInstance().getDefaultHelpPath("JonDo");
            helpInstallationExists = true;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_HELP_PATH);
        return helpInstallationExists;
    }

    public Observable getHelpFileStorageObservable() {
        return this.m_helpFileStorageManager.getStorageObservable();
    }

    public synchronized void setDLLupdate(String a_dllUpdatePath) {
        if (!(a_dllUpdatePath == null || this.m_bDllUpdatePath != null && this.m_bDllUpdatePath.equals(a_dllUpdatePath))) {
            File file = new File(a_dllUpdatePath);
            if (file.exists() && file.isDirectory()) {
                this.m_bDllUpdatePath = file.getAbsolutePath();
                this.setChanged();
            }
        } else if (a_dllUpdatePath == null && this.m_bDllUpdatePath != null) {
            this.m_bDllUpdatePath = null;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_DLL_UPDATE);
    }

    public synchronized void setMacOSXLibraryUpdateAtStartupNeeded(boolean a_update) {
        if (this.m_bMacOSXLibraryUpdateAtStartupNeeded != a_update) {
            this.m_bMacOSXLibraryUpdateAtStartupNeeded = a_update;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_MACOSX_LIBRARY_UPDATE);
    }

    public synchronized void setShowConfigAssistantAutomatically(boolean a_update) {
        if (this.m_bShowConfigAssistant != a_update) {
            this.m_bShowConfigAssistant = a_update;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_CONFIG_ASSISTANT_SHOWUP);
    }

    public boolean isConfigAssistantAutomaticallyShown() {
        return this.m_bShowConfigAssistant;
    }

    public synchronized void setAnonymizedHttpHeaders(boolean a_update) {
        if (this.m_bAnonymizedHttpHeaders != a_update) {
            this.m_bAnonymizedHttpHeaders = a_update;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_ANONYMIZED_HTTP_HEADERS);
    }

    public boolean isAnonymizedHttpHeaders() {
        return this.m_bAnonymizedHttpHeaders;
    }

    public boolean isHeaderProcessingDisabled() {
        return this.m_bDisableAllHeaderProcessing;
    }

    public void setDiableAllHeaderProcessing(boolean a_bDisable) {
        this.m_bDisableAllHeaderProcessing = a_bDisable;
    }

    public boolean isMacOSXLibraryUpdateAtStartupNeeded() {
        return this.m_bMacOSXLibraryUpdateAtStartupNeeded;
    }

    public String getDllUpdatePath() {
        return this.m_bDllUpdatePath;
    }

    public synchronized void setDllWarning(boolean a_bWarn) {
        String version = "00.04.009";
        long newValue = this.m_noWarningForDllVersionBelow;
        if (a_bWarn) {
            newValue = 0L;
        } else if (version != null) {
            newValue = Util.convertVersionStringToNumber(version);
        }
        if (this.m_noWarningForDllVersionBelow != newValue) {
            this.m_noWarningForDllVersionBelow = newValue;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_DLL_UPDATE);
    }

    protected synchronized void setDllWarningVersion(long a_noWarningForDllVersionBelow) {
        if (this.m_noWarningForDllVersionBelow != a_noWarningForDllVersionBelow) {
            this.m_noWarningForDllVersionBelow = a_noWarningForDllVersionBelow;
            this.setChanged();
        }
        this.notifyObservers(CHANGED_DLL_UPDATE);
    }

    protected long getDLLWarningVersion() {
        return this.m_noWarningForDllVersionBelow;
    }

    public boolean isDLLWarningActive() {
        long currentVersion = Util.convertVersionStringToNumber("00.04.009");
        return this.m_noWarningForDllVersionBelow != currentVersion;
    }

    public void setShowSplashScreen(boolean a_bHide) {
        this.m_bShowSplashScreen = a_bHide;
    }

    public boolean getShowSplashScreen() {
        return this.m_bShowSplashScreen;
    }

    public void setShowSplashDisabled(boolean a_bDisabled) {
        this.m_bShowSplashDisabled = a_bDisabled;
    }

    public boolean getShowSplashDisabled() {
        return this.m_bShowSplashDisabled;
    }

    public void setStartPortableFirefox(boolean a_bStart) {
        this.m_bStartPortableFirefox = a_bStart;
    }

    public boolean getStartPortableFirefox() {
        return this.m_bStartPortableFirefox;
    }

    public boolean isShuttingDown() {
        return JAPController.getInstance().isShuttingDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableProxyInterface getAnonymityProxy() {
        Object object = this.SYNC_ANON_PROXY;
        synchronized (object) {
            InetAddress proxyListenerAddress;
            if ((this.m_proxyAnon == null || this.m_proxyAnon.getPort() != JAPModel.getHttpListenerPortNumber()) && (proxyListenerAddress = JAPController.getInstance().getListenerInetAddress()) != null) {
                String hostAddress = proxyListenerAddress.getHostAddress();
                if (proxyListenerAddress.getHostAddress().equals("0.0.0.0")) {
                    try {
                        hostAddress = InetAddress.getLocalHost().getHostAddress();
                    }
                    catch (UnknownHostException e) {
                        hostAddress = "127.0.0.1";
                    }
                }
                this.m_proxyAnon = new ProxyInterface(hostAddress, JAPModel.getHttpListenerPortNumber(), null);
            }
        }
        return this.m_proxyAnon;
    }

    private IProxyInterfaceGetter getProxyInterface(int a_component, boolean a_bAnonInterface) {
        if (this.isShuttingDown()) {
            return null;
        }
        IProxyInterfaceGetter proxyDirect = new IProxyInterfaceGetter(){

            public ImmutableProxyInterface getProxyInterface() {
                return JAPModel.getInstance().getProxyInterface();
            }
        };
        IProxyInterfaceGetter proxyAnon = new IProxyInterfaceGetter(){

            public ImmutableProxyInterface getProxyInterface() {
                if (JAPController.getInstance().isAnonConnected()) {
                    return JAPModel.this.getAnonymityProxy();
                }
                return null;
            }
        };
        if (1 == a_component && this.m_iPaymentAnonymousConnectionSetting == 1 || 0 == a_component && this.m_iInfoServiceAnonymousConnectionSetting == 1 || 2 == a_component && this.m_iUpdateAnonymousConnectionSetting == 1) {
            if (a_bAnonInterface) {
                return proxyAnon;
            }
            return null;
        }
        if (!this.m_connectionChecker.checkAnonConnected()) {
            if (a_bAnonInterface) {
                return null;
            }
            return proxyDirect;
        }
        if (a_bAnonInterface) {
            if (1 == a_component && 2 == this.m_iPaymentAnonymousConnectionSetting || 0 == a_component && 2 == this.m_iInfoServiceAnonymousConnectionSetting || 2 == a_component && 2 == this.m_iUpdateAnonymousConnectionSetting) {
                return null;
            }
            return proxyAnon;
        }
        return proxyDirect;
    }

    public BigInteger getDialogVersion() {
        return this.m_iDialogVersion;
    }

    public void setDialogVersion(BigInteger dialogVersion) {
        this.m_iDialogVersion = dialogVersion;
    }

    public Hashtable getAcceptedTCs() {
        return this.m_acceptedTCs;
    }

    public String getContext() {
        return this.m_context;
    }

    public String getProgramName() {
        return this.m_strDistributorMode;
    }

    public void setProgramName(String a_programName) {
        if (a_programName != null && (a_programName.equals("JAP") || a_programName.equals("JonDo"))) {
            this.m_strDistributorMode = a_programName;
        }
    }

    public synchronized void setContext(String context) {
        TrustModel.updateContext(context);
    }

    void setLauncher(String a_strPathToLauchner) {
        this.m_strLauncher = a_strPathToLauchner;
    }

    String getLauncher() {
        return this.m_strLauncher;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FontResize {
        private int m_oldSize;
        private int m_newSize;

        public FontResize(int a_oldSize, int a_newSize) {
            this.m_oldSize = a_oldSize;
            this.m_newSize = a_newSize;
        }

        public int getOldSize() {
            return this.m_oldSize;
        }

        public int getNewSize() {
            return this.m_newSize;
        }
    }
}

