/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.tor.ordescription.InfoServiceORListFetcher;
import anon.tor.ordescription.ORDescriptor;
import anon.tor.ordescription.ORList;
import anon.tor.ordescription.PlainORListFetcher;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.JAPJIntField;
import gui.dialog.JAPDialog;
import jap.AbstractJAPConfModule;
import jap.JAPController;
import jap.JAPModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;

final class JAPConfTor
extends AbstractJAPConfModule
implements ActionListener {
    public static final String MSG_ACTIVATE = (class$jap$JAPConfTor == null ? (class$jap$JAPConfTor = JAPConfTor.class$("jap.JAPConfTor")) : class$jap$JAPConfTor).getName() + "_activate";
    private static final int MIN_CON_PER_PATH = 1;
    private static final int MAX_CON_PER_PATH = 5;
    private JCheckBox m_cbxActive;
    private JTable m_tableRouters;
    private JSlider m_sliderMaxPathLen;
    private JSlider m_sliderMinPathLen;
    private JSlider m_sliderConnectionsPerPath;
    private JButton m_bttnFetchRouters;
    private JLabel m_labelAvailableRouters;
    private JCheckBox m_cbPreCreateRoutes;
    private JCheckBox m_cbNoDefaultTorServer;
    private JTextField m_tfTorDirServerHostName;
    private JAPJIntField m_jintfieldTorDirServerPort;
    private JLabel m_lblMaxPathLen;
    private JLabel m_lblMinPathLen;
    private JLabel m_lblPathSwitchTime;
    private JScrollPane m_scrollPane;
    private JPanel m_panelSlider;
    private TitledBorder m_border;
    private DateFormat ms_dateFormat = DateFormat.getDateTimeInstance(2, 3);
    static /* synthetic */ Class class$jap$JAPConfTor;

    public JAPConfTor() {
        super(null);
    }

    public void recreateRootPanel() {
        JPanel panelRoot = this.getRootPanel();
        panelRoot.removeAll();
        GridBagLayout l = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 5, 5, 5);
        c.anchor = 18;
        panelRoot.setLayout(l);
        c.gridwidth = 5;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        this.m_cbxActive = new JCheckBox(JAPMessages.getString(MSG_ACTIVATE), true);
        this.m_cbxActive.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent a_event) {
                int i;
                JAPConfTor.this.m_labelAvailableRouters.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_tableRouters.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_bttnFetchRouters.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_sliderMinPathLen.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_sliderMaxPathLen.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_sliderConnectionsPerPath.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_cbPreCreateRoutes.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_lblMinPathLen.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_lblMaxPathLen.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_scrollPane.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_lblPathSwitchTime.setEnabled(JAPConfTor.this.m_cbxActive.isSelected());
                JAPConfTor.this.m_border = new TitledBorder(JAPConfTor.this.m_border.getTitle());
                if (JAPConfTor.this.m_cbxActive.isSelected()) {
                    JAPConfTor.this.m_bttnFetchRouters.setDisabledIcon(GUIUtils.loadImageIcon("reloaddisabled_anim.gif", true, false));
                } else {
                    JAPConfTor.this.m_border.setTitleColor(Color.gray);
                    JAPConfTor.this.m_bttnFetchRouters.setDisabledIcon(GUIUtils.loadImageIcon("reloadrollover.gif", true, false));
                }
                JAPConfTor.this.m_panelSlider.setBorder(JAPConfTor.this.m_border);
                Dictionary d = JAPConfTor.this.m_sliderMaxPathLen.getLabelTable();
                for (i = 2; i <= 5; ++i) {
                    ((JLabel)d.get(new Integer(i))).setEnabled(JAPConfTor.this.m_sliderMaxPathLen.isEnabled());
                }
                d = JAPConfTor.this.m_sliderMinPathLen.getLabelTable();
                for (i = 2; i <= 5; ++i) {
                    ((JLabel)d.get(new Integer(i))).setEnabled(JAPConfTor.this.m_sliderMinPathLen.isEnabled());
                }
                d = JAPConfTor.this.m_sliderConnectionsPerPath.getLabelTable();
                for (i = 1; i <= 5; ++i) {
                    ((JLabel)d.get(new Integer(i))).setEnabled(JAPConfTor.this.m_sliderConnectionsPerPath.isEnabled());
                }
            }
        });
        panelRoot.add((Component)this.m_cbxActive, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 2;
        GridBagLayout g2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel p = new JPanel(g2);
        this.m_labelAvailableRouters = new JLabel(JAPMessages.getString("torBorderAvailableRouters") + ":");
        c2.fill = 2;
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        p.add((Component)this.m_labelAvailableRouters, c2);
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn(JAPMessages.getString("torRouterName"));
        model.addColumn(JAPMessages.getString("torRouterAdr"));
        model.addColumn(JAPMessages.getString("torRouterPort"));
        model.addColumn(JAPMessages.getString("torRouterSoftware"));
        model.setNumRows(3);
        this.m_tableRouters = new MyJTable(model);
        this.m_tableRouters.setPreferredScrollableViewportSize(new Dimension(70, this.m_tableRouters.getRowHeight() * 5));
        this.m_tableRouters.setCellSelectionEnabled(false);
        this.m_tableRouters.setColumnSelectionAllowed(false);
        this.m_tableRouters.setRowSelectionAllowed(true);
        this.m_tableRouters.setSelectionMode(0);
        this.m_scrollPane = new JScrollPane(this.m_tableRouters);
        this.m_scrollPane.setAutoscrolls(true);
        c2.fill = 1;
        c2.gridy = 1;
        c2.weightx = 1.0;
        c2.weighty = 1.0;
        c2.gridwidth = 2;
        p.add((Component)this.m_scrollPane, c2);
        this.m_bttnFetchRouters = new JButton(JAPMessages.getString("torBttnFetchRouters"));
        this.m_bttnFetchRouters.setIcon(GUIUtils.loadImageIcon("reload.gif", true, false));
        this.m_bttnFetchRouters.setDisabledIcon(GUIUtils.loadImageIcon("reloaddisabled_anim.gif", true, false));
        this.m_bttnFetchRouters.setPressedIcon(GUIUtils.loadImageIcon("reloadrollover.gif", true, false));
        this.m_bttnFetchRouters.setActionCommand("fetchRouters");
        this.m_bttnFetchRouters.addActionListener(this);
        c2.fill = 0;
        c2.weighty = 0.0;
        c2.gridy = 0;
        c2.gridwidth = 1;
        c2.gridx = 1;
        c2.anchor = 13;
        c2.insets = new Insets(5, 5, 5, 0);
        p.add((Component)this.m_bttnFetchRouters, c2);
        panelRoot.add((Component)p, c);
        p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder(JAPMessages.getString("torBorderTorDirServer")));
        GridBagConstraints c4 = new GridBagConstraints();
        this.m_cbNoDefaultTorServer = new JCheckBox(JAPMessages.getString("torCheckBoxNoDefaultDirServer"));
        p.add((Component)this.m_cbNoDefaultTorServer, c4);
        c4.gridx = 1;
        p.add((Component)new JLabel(JAPMessages.getString("torDirServerHostName")), c4);
        this.m_tfTorDirServerHostName = new JTextField();
        c4.gridx = 2;
        p.add((Component)this.m_tfTorDirServerHostName, c4);
        this.m_jintfieldTorDirServerPort = new JAPJIntField(65535);
        c4.gridx = 3;
        p.add((Component)this.m_jintfieldTorDirServerPort, c4);
        c4.gridx = 4;
        p.add((Component)new JLabel(JAPMessages.getString("torDirServerPort")), c4);
        c.gridy = 3;
        c.weighty = 0.0;
        c.fill = 2;
        panelRoot.add((Component)p, c);
        p = new JPanel(new GridBagLayout());
        GridBagConstraints c3 = new GridBagConstraints();
        c3.anchor = 18;
        c3.insets = new Insets(2, 5, 2, 5);
        c3.fill = 0;
        this.m_lblMinPathLen = new JLabel(JAPMessages.getString("torPrefMinPathLen"));
        p.add((Component)this.m_lblMinPathLen, c3);
        this.m_sliderMinPathLen = new JSlider();
        this.m_sliderMinPathLen.setPaintLabels(true);
        this.m_sliderMinPathLen.setPaintTicks(true);
        this.m_sliderMinPathLen.setMajorTickSpacing(1);
        this.m_sliderMinPathLen.setSnapToTicks(true);
        this.m_sliderMinPathLen.setMinimum(2);
        this.m_sliderMinPathLen.setMaximum(5);
        this.m_sliderMinPathLen.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (JAPConfTor.this.m_sliderMaxPathLen.getValue() < JAPConfTor.this.m_sliderMinPathLen.getValue()) {
                    JAPConfTor.this.m_sliderMaxPathLen.setValue(JAPConfTor.this.m_sliderMinPathLen.getValue());
                }
            }
        });
        c3.gridx = 1;
        c3.fill = 2;
        p.add((Component)this.m_sliderMinPathLen, c3);
        c3.gridx = 0;
        c3.gridy = 1;
        c3.fill = 0;
        this.m_lblMaxPathLen = new JLabel(JAPMessages.getString("torPrefMaxPathLen"));
        p.add((Component)this.m_lblMaxPathLen, c3);
        this.m_sliderMaxPathLen = new JSlider();
        this.m_sliderMaxPathLen.setMinimum(2);
        this.m_sliderMaxPathLen.setMaximum(5);
        this.m_sliderMaxPathLen.setPaintLabels(true);
        this.m_sliderMaxPathLen.setPaintTicks(true);
        this.m_sliderMaxPathLen.setMajorTickSpacing(1);
        this.m_sliderMaxPathLen.setMinorTickSpacing(1);
        this.m_sliderMaxPathLen.setSnapToTicks(true);
        this.m_sliderMaxPathLen.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (JAPConfTor.this.m_sliderMaxPathLen.getValue() < JAPConfTor.this.m_sliderMinPathLen.getValue()) {
                    JAPConfTor.this.m_sliderMinPathLen.setValue(JAPConfTor.this.m_sliderMaxPathLen.getValue());
                }
            }
        });
        c3.gridx = 1;
        c3.fill = 2;
        p.add((Component)this.m_sliderMaxPathLen, c3);
        c3.gridx = 0;
        c3.gridy = 2;
        c3.fill = 0;
        this.m_lblPathSwitchTime = new JLabel(JAPMessages.getString("torPrefPathSwitchTime"));
        p.add((Component)this.m_lblPathSwitchTime, c3);
        this.m_sliderConnectionsPerPath = new JSlider();
        Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
        sliderLabels.put(new Integer(1), new JLabel("10"));
        sliderLabels.put(new Integer(2), new JLabel("50"));
        sliderLabels.put(new Integer(3), new JLabel("100"));
        sliderLabels.put(new Integer(4), new JLabel("500"));
        sliderLabels.put(new Integer(5), new JLabel("1000"));
        this.m_sliderConnectionsPerPath.setLabelTable(sliderLabels);
        this.m_sliderConnectionsPerPath.setMinimum(1);
        this.m_sliderConnectionsPerPath.setMaximum(5);
        this.m_sliderConnectionsPerPath.setMajorTickSpacing(1);
        this.m_sliderConnectionsPerPath.setMinorTickSpacing(1);
        this.m_sliderConnectionsPerPath.setSnapToTicks(true);
        this.m_sliderConnectionsPerPath.setPaintLabels(true);
        this.m_sliderConnectionsPerPath.setPaintTicks(true);
        c3.gridx = 1;
        c3.weightx = 1.0;
        c3.fill = 2;
        p.add((Component)this.m_sliderConnectionsPerPath, c3);
        this.m_cbPreCreateRoutes = new JCheckBox(JAPMessages.getString("ngConfAnonGeneralPreCreateRoutes"));
        ++c3.gridy;
        c3.gridx = 0;
        c3.gridwidth = 2;
        p.add((Component)this.m_cbPreCreateRoutes, c3);
        this.m_border = new TitledBorder(JAPMessages.getString("torBorderPreferences"));
        p.setBorder(this.m_border);
        this.m_panelSlider = p;
        c.gridy = 4;
        c.weighty = 0.0;
        c.fill = 2;
        panelRoot.add((Component)p, c);
    }

    public String getTabTitle() {
        return "Tor";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("enableTor")) {
            this.updateGuiOutput();
        } else if (actionEvent.getActionCommand().equals("fetchRouters")) {
            this.fetchRoutersAsync(true);
        }
    }

    protected boolean onOkPressed() {
        JAPModel.getInstance().setTorActivated(this.m_cbxActive.isSelected());
        int i = this.m_sliderConnectionsPerPath.getValue();
        int[] ar = new int[]{10, 50, 100, 500, 1000};
        JAPController.setTorMaxConnectionsPerRoute(ar[i - 1]);
        JAPController.setTorRouteLen(this.m_sliderMinPathLen.getValue(), this.m_sliderMaxPathLen.getValue());
        JAPController.setPreCreateAnonRoutes(this.m_cbPreCreateRoutes.isSelected());
        JAPController.setTorUseNoneDefaultDirServer(this.m_cbNoDefaultTorServer.isSelected());
        return true;
    }

    protected void onUpdateValues() {
        this.updateGuiOutput();
    }

    public String getHelpContext() {
        return "services_tor";
    }

    private void updateGuiOutput() {
        int i = JAPModel.getTorMaxConnectionsPerRoute();
        i = i < 25 ? 1 : (i < 75 ? 2 : (i < 250 ? 3 : (i < 750 ? 4 : 5)));
        this.m_sliderConnectionsPerPath.setValue(i);
        this.m_sliderMaxPathLen.setValue(JAPModel.getTorMaxRouteLen());
        this.m_sliderMinPathLen.setValue(JAPModel.getTorMinRouteLen());
        this.m_cbPreCreateRoutes.setSelected(JAPModel.isPreCreateAnonRoutesEnabled());
        this.m_cbxActive.setSelected(JAPModel.getInstance().isTorActivated());
        this.m_cbNoDefaultTorServer.setSelected(JAPModel.isTorNoneDefaultDirServerEnabled());
    }

    private void fetchRoutersAsync(final boolean bShowError) {
        this.m_bttnFetchRouters.setEnabled(false);
        Runnable doIt = new Runnable(){

            public void run() {
                ORList ol = null;
                ol = JAPModel.isTorNoneDefaultDirServerEnabled() ? new ORList(new PlainORListFetcher("141.76.45.45", 9030)) : new ORList(new InfoServiceORListFetcher());
                if (!ol.updateList()) {
                    if (bShowError) {
                        JAPDialog.showErrorDialog((Component)JAPConfTor.this.getRootPanel(), JAPMessages.getString("torErrorFetchRouters"));
                    }
                    JAPConfTor.this.m_bttnFetchRouters.setEnabled(true);
                    return;
                }
                DefaultTableModel m = (DefaultTableModel)JAPConfTor.this.m_tableRouters.getModel();
                Vector ors = ol.getList();
                m.setNumRows(ors.size());
                for (int i = 0; i < ors.size(); ++i) {
                    ORDescriptor ord = (ORDescriptor)ors.elementAt(i);
                    JAPConfTor.this.m_tableRouters.setValueAt(ord.getName(), i, 0);
                    JAPConfTor.this.m_tableRouters.setValueAt(ord.getAddress(), i, 1);
                    JAPConfTor.this.m_tableRouters.setValueAt(new Integer(ord.getPort()), i, 2);
                    JAPConfTor.this.m_tableRouters.setValueAt(ord.getSoftware(), i, 3);
                    JAPConfTor.this.m_tableRouters.invalidate();
                }
                Date published = ol.getPublished();
                String strPublished = JAPMessages.getString("unknown");
                if (published != null) {
                    strPublished = JAPConfTor.this.ms_dateFormat.format(published);
                }
                JAPConfTor.this.m_labelAvailableRouters.setText(JAPMessages.getString("torBorderAvailableRouters") + " (" + strPublished + "):");
                JAPConfTor.this.m_labelAvailableRouters.invalidate();
                JAPConfTor.this.getRootPanel().validate();
                JAPConfTor.this.m_bttnFetchRouters.setEnabled(true);
            }
        };
        Thread t = new Thread(doIt);
        t.start();
    }

    public void onResetToDefaultsPressed() {
        this.m_cbPreCreateRoutes.setSelected(false);
        this.m_sliderMaxPathLen.setValue(3);
        this.m_sliderMinPathLen.setValue(2);
        this.m_sliderConnectionsPerPath.setValue(1000);
        this.m_cbxActive.setSelected(false);
        this.m_cbNoDefaultTorServer.setSelected(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyJTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public MyJTable(DefaultTableModel m) {
            super(m);
        }

        public boolean isCellEditable(int i, int j) {
            return false;
        }
    }
}

