/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.infoservice.DataRetentionInformation;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.infoservice.ServiceLocation;
import anon.infoservice.ServiceOperator;
import anon.platform.AbstractOS;
import anon.util.CountryMapper;
import anon.util.JAPMessages;
import gui.DataRetentionDialog;
import gui.GUIUtils;
import gui.MultiCertOverview;
import gui.dialog.JAPDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import logging.LogHolder;
import logging.LogType;

public class MixDetailsDialog
extends JAPDialog {
    public static final String MSG_NOT_VERIFIED = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_notVerified";
    public static final String MSG_INVALID = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_invalid";
    public static final String MSG_VALID = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_valid";
    public static final String MSG_INDEPENDENT_CERTIFICATIONS = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_independentCertifications";
    public static final String MSG_MIX_X_OF_Y = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_mixXOfY";
    public static String MSG_MIX_NAME = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_mixName";
    public static String MSG_LOCATION = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_mixLocation";
    public static String MSG_HOMEPAGE = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_operatorHomepage";
    public static String MSG_E_MAIL = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_email";
    public static String MSG_CERTIFICATES = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_certificates";
    public static String MSG_BTN_DATA_RETENTION = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_btnDataRetention";
    private static String MSG_TITLE = (class$gui$MixDetailsDialog == null ? (class$gui$MixDetailsDialog = MixDetailsDialog.class$("gui.MixDetailsDialog")) : class$gui$MixDetailsDialog).getName() + "_title";
    private MixCascade m_mixCascade;
    private MixInfo m_mixInfo;
    private int m_mixPosition;
    private ActionListener m_buttonListener;
    private JButton m_btnHomepage;
    private JButton m_btnEMail;
    private JButton m_btnCertificates;
    private JButton m_btnDataRetention;
    static /* synthetic */ Class class$gui$MixDetailsDialog;

    public MixDetailsDialog(Component a_parent, MixCascade a_mixCascade, int a_mixPosition, int a_totalMixes) {
        super(a_parent, JAPMessages.getString(MSG_TITLE));
        DataRetentionInformation drInfo;
        this.m_mixCascade = a_mixCascade;
        this.m_mixPosition = a_mixPosition;
        GridBagConstraints c = new GridBagConstraints();
        JPanel p = (JPanel)this.getContentPane();
        JPanel pnlButtons = new JPanel(new FlowLayout());
        p.setLayout(new GridBagLayout());
        if (this.m_mixCascade == null || a_mixCascade.getMixInfo(a_mixPosition) == null) {
            return;
        }
        this.m_mixInfo = a_totalMixes == 1 ? a_mixCascade.getMixInfo(a_mixCascade.getNumberOfMixes() - 1) : a_mixCascade.getMixInfo(a_mixPosition);
        ServiceOperator op = this.m_mixInfo.getServiceOperator();
        ServiceLocation loc = this.m_mixInfo.getServiceLocation();
        if (op == null || loc == null) {
            return;
        }
        JLabel lbl = new JLabel(JAPMessages.getString(MSG_MIX_NAME) + ":");
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(15, 15, 10, 15);
        c.anchor = 17;
        p.add((Component)lbl, c);
        lbl = new JLabel(this.m_mixInfo.getName());
        c.gridx = 1;
        p.add((Component)lbl, c);
        lbl = new JLabel(JAPMessages.getString(MSG_LOCATION) + ":");
        c.gridy = 1;
        c.gridx = 0;
        c.insets = new Insets(0, 15, 10, 15);
        p.add((Component)lbl, c);
        lbl = new JLabel(GUIUtils.getCountryFromServiceLocation(loc));
        c.gridy = 1;
        ++c.gridx;
        lbl.setIcon(GUIUtils.loadImageIcon("flags/" + loc.getCountryCode() + ".png"));
        p.add((Component)lbl, c);
        lbl = new JLabel(JAPMessages.getString("mixOperator"));
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        p.add((Component)lbl, c);
        String strText = op.getOrganization();
        lbl = new JLabel();
        if (op.getCountryCode() != null) {
            strText = strText + "  (" + new CountryMapper(op.getCountryCode(), JAPMessages.getLocale()).toString() + ")";
            lbl.setIcon(GUIUtils.loadImageIcon("flags/" + op.getCountryCode() + ".png"));
        }
        lbl.setText(strText);
        c.gridx = 1;
        p.add((Component)lbl, c);
        this.m_buttonListener = new MyButtonListener();
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        p.add((Component)pnlButtons, c);
        if (this.m_mixInfo.getCertPath() != null) {
            this.m_btnCertificates = new JButton(JAPMessages.getString(MSG_CERTIFICATES));
            this.m_btnCertificates.addActionListener(this.m_buttonListener);
            if (!this.m_mixInfo.getCertPath().isVerified()) {
                this.m_btnCertificates.setIcon(GUIUtils.loadImageIcon("certs/not_trusted.png"));
                this.m_btnCertificates.setToolTipText(JAPMessages.getString(MSG_NOT_VERIFIED));
                this.m_btnCertificates.setForeground(Color.red);
            } else if (!this.m_mixInfo.getCertPath().isValid(new Date())) {
                this.m_btnCertificates.setIcon(GUIUtils.loadImageIcon("certs/invalid.png"));
                this.m_btnCertificates.setToolTipText(JAPMessages.getString(MSG_INVALID));
            } else if (this.m_mixInfo.getCertPath().countVerifiedAndValidPaths() > 1) {
                this.m_btnCertificates.setToolTipText(JAPMessages.getString(MSG_INDEPENDENT_CERTIFICATIONS, "" + this.m_mixInfo.getCertPath().countVerifiedAndValidPaths()));
                if (this.m_mixInfo.getCertPath().countVerifiedAndValidPaths() > 2) {
                    this.m_btnCertificates.setIcon(GUIUtils.loadImageIcon("certs/trusted_green.png"));
                } else {
                    this.m_btnCertificates.setIcon(GUIUtils.loadImageIcon("certs/trusted_blue.png"));
                }
            } else {
                this.m_btnCertificates.setToolTipText(JAPMessages.getString(MSG_VALID));
                this.m_btnCertificates.setIcon(GUIUtils.loadImageIcon("certs/trusted_black.png"));
            }
            pnlButtons.add((Component)this.m_btnCertificates, c);
        }
        if (op.getEMail() != null) {
            this.m_btnEMail = new JButton(JAPMessages.getString(MSG_E_MAIL));
            this.m_btnEMail.setToolTipText(op.getEMail());
            this.m_btnEMail.addActionListener(this.m_buttonListener);
            pnlButtons.add((Component)this.m_btnEMail, c);
        }
        if (op.getUrl() != null) {
            this.m_btnHomepage = new JButton(JAPMessages.getString(MSG_HOMEPAGE));
            this.m_btnHomepage.setToolTipText(op.getUrl());
            this.m_btnHomepage.addActionListener(this.m_buttonListener);
            pnlButtons.add((Component)this.m_btnHomepage, c);
        }
        if ((drInfo = this.m_mixInfo.getDataRetentionInformation()) != null) {
            this.m_btnDataRetention = new JButton(JAPMessages.getString(MSG_BTN_DATA_RETENTION), GUIUtils.loadImageIcon("certs/invalid.png"));
            this.m_btnDataRetention.setToolTipText(JAPMessages.getString(DataRetentionDialog.MSG_DATA_RETENTION_MIX_EXPLAIN_SHORT));
            this.m_btnDataRetention.addActionListener(this.m_buttonListener);
            pnlButtons.add((Component)this.m_btnDataRetention, c);
        }
        this.pack();
        this.setResizable(false);
        p.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MyButtonListener
    implements ActionListener {
        private MyButtonListener() {
        }

        public void actionPerformed(ActionEvent a_event) {
            if (a_event.getSource() == MixDetailsDialog.this.m_btnHomepage) {
                String url = ((JButton)a_event.getSource()).getToolTipText();
                if (url == null) {
                    return;
                }
                AbstractOS os = AbstractOS.getInstance();
                try {
                    os.openURL(new URL(url));
                }
                catch (Exception a_e) {
                    LogHolder.log(3, LogType.MISC, "Error opening URL in browser");
                }
            } else if (a_event.getSource() == MixDetailsDialog.this.m_btnDataRetention) {
                DataRetentionDialog.show(MixDetailsDialog.this.getContentPane(), MixDetailsDialog.this.m_mixCascade, MixDetailsDialog.this.m_mixPosition);
            } else if (a_event.getSource() == MixDetailsDialog.this.m_btnEMail) {
                String url = MixDetailsDialog.this.m_btnEMail.getToolTipText();
                if (url == null) {
                    return;
                }
                AbstractOS os = AbstractOS.getInstance();
                try {
                    os.openEMail(url);
                }
                catch (Exception a_e) {
                    LogHolder.log(3, LogType.MISC, "Error creating E-Mail!");
                }
            } else if (a_event.getSource() == MixDetailsDialog.this.m_btnCertificates) {
                new MultiCertOverview(MixDetailsDialog.this.getContentPane(), MixDetailsDialog.this.m_mixInfo.getCertPath(), MixDetailsDialog.this.m_mixInfo.getName(), false);
            }
        }
    }
}

