/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.util.JAPMessages;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import logging.LogHolder;
import logging.LogType;

public class MapBox
extends JAPDialog
implements ChangeListener {
    private static final String MSG_ERROR_WHILE_LOADING = (class$gui$MapBox == null ? (class$gui$MapBox = MapBox.class$("gui.MapBox")) : class$gui$MapBox).getName() + "_errorLoading";
    private static final String MSG_PLEASE_WAIT = (class$gui$MapBox == null ? (class$gui$MapBox = MapBox.class$("gui.MapBox")) : class$gui$MapBox).getName() + "_pleaseWait";
    private static final String MSG_CLOSE = (class$gui$MapBox == null ? (class$gui$MapBox = MapBox.class$("gui.MapBox")) : class$gui$MapBox).getName() + "_close";
    private static final String MSG_TITLE = (class$gui$MapBox == null ? (class$gui$MapBox = MapBox.class$("gui.MapBox")) : class$gui$MapBox).getName() + "_title";
    private static final String MSG_ZOOM = (class$gui$MapBox == null ? (class$gui$MapBox = MapBox.class$("gui.MapBox")) : class$gui$MapBox).getName() + "_zoom";
    private JLabel m_lblMap;
    private JSlider m_sldZoom;
    private JButton m_btnClose;
    private String m_sImageURL;
    private static final String KEY = "ABQIAAAAvDhPn6b_F550GDisnEZpIxQrda7TSvuNFYSGo_31R-LaV_0iCRRJ7r3yduvtz_ZgBJjj2VOFap_JoQ";
    private String m_sLatitude;
    private String m_sLongitude;
    private String m_sImageSize = "550x550";
    static /* synthetic */ Class class$gui$MapBox;

    public MapBox(Component parent, String lat, String lon, int level) {
        super(parent, "");
        this.m_sLongitude = lon;
        this.m_sLatitude = lat;
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(layout);
        c.anchor = 18;
        c.insets = new Insets(10, 10, 10, 10);
        this.m_lblMap = new JLabel();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 2;
        layout.setConstraints(this.m_lblMap, c);
        this.getContentPane().add(this.m_lblMap);
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(20, 10, 5, 10);
        JLabel l = new JLabel(JAPMessages.getString(MSG_ZOOM));
        layout.setConstraints(l, c);
        this.getContentPane().add(l);
        this.m_sldZoom = new JSlider(1, 0, 15, level);
        this.m_sldZoom.setPaintTicks(true);
        this.m_sldZoom.setMajorTickSpacing(1);
        this.m_sldZoom.setMinorTickSpacing(1);
        this.m_sldZoom.setSnapToTicks(true);
        this.m_sldZoom.setPaintLabels(true);
        this.m_sldZoom.setRequestFocusEnabled(false);
        this.m_sldZoom.addChangeListener(this);
        c.insets = new Insets(5, 10, 20, 10);
        c.gridx = 2;
        c.gridy = 1;
        c.fill = 3;
        layout.setConstraints(this.m_sldZoom, c);
        this.getContentPane().add(this.m_sldZoom);
        this.m_btnClose = new JButton(JAPMessages.getString(MSG_CLOSE));
        this.m_btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent a_event) {
                MapBox.this.dispose();
            }
        });
        c.gridx = 2;
        c.gridy = 2;
        layout.setConstraints(this.m_btnClose, c);
        this.getContentPane().add(this.m_btnClose);
        this.refresh();
        this.pack();
        this.setResizable(false);
    }

    public void setGeo(String a_latitude, String a_longitude) throws IOException {
        this.m_sLongitude = a_longitude;
        this.m_sLatitude = a_latitude;
        this.refresh();
    }

    public void setVisible(boolean a_bVisible) {
        super.setVisible(a_bVisible);
    }

    public void stateChanged(ChangeEvent e) {
        JSlider s1 = (JSlider)e.getSource();
        if (!s1.getValueIsAdjusting()) {
            this.refresh();
        }
    }

    private void refresh() {
        this.m_lblMap.setIcon(null);
        this.m_lblMap.setText(JAPMessages.getString(MSG_PLEASE_WAIT) + "...");
        this.m_lblMap.repaint();
        this.m_sImageURL = "http://maps.google.com/staticmap?markers=" + this.m_sLatitude + "," + this.m_sLongitude + "&zoom=" + (this.m_sldZoom.getValue() + 2) + "&size=" + this.m_sImageSize + "&key=" + KEY;
        LogHolder.log(7, LogType.MISC, "Getting map: " + this.m_sImageURL);
        String sTitle = JAPMessages.getString(MSG_TITLE, new String[]{this.m_sLatitude, this.m_sLongitude});
        this.setTitle(sTitle);
        try {
            ImageIcon map = new ImageIcon(new URL(this.m_sImageURL));
            if (map.getIconHeight() == -1) {
                this.dispose();
                JAPDialog.showErrorDialog(this.getParentComponent(), JAPMessages.getString(MSG_ERROR_WHILE_LOADING));
            } else {
                this.m_lblMap.setText("");
                this.m_lblMap.setIcon(map);
            }
        }
        catch (MalformedURLException e) {
            this.dispose();
            JAPDialog.showErrorDialog(this.getParentComponent(), e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SiteParser
    extends HTMLEditorKit.ParserCallback {
        private SiteParser() {
        }

        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            this.handleStartTag(t, a, pos);
        }

        public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
            if (t == HTML.Tag.IMG) {
                try {
                    if (a.getAttribute(HTML.Attribute.ID).toString().equals("map")) {
                        LogHolder.log(7, LogType.MISC, "Map image found: " + a.getAttribute(HTML.Attribute.SRC).toString());
                        MapBox.this.m_sImageURL = a.getAttribute(HTML.Attribute.SRC).toString();
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }
}

