/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class JAPProgressBar
extends JProgressBar {
    private static final long serialVersionUID = 1L;
    private final MyProgressBarUI m_ui = new MyProgressBarUI(true);

    public JAPProgressBar() {
        this.m_ui.setFilledBarColor(Color.blue);
        super.setUI(this.m_ui);
    }

    public void setUI(ProgressBarUI a_ui) {
    }

    public ProgressBarUI getUI() {
        return this.m_ui;
    }

    public void setFilledBarColor(Color a_color) {
        this.m_ui.setFilledBarColor(a_color);
    }

    public Color getFilledbarColor() {
        return this.m_ui.getFilledBarColor();
    }

    private final class MyProgressBarUI
    extends BasicProgressBarUI {
        static final int ms_dx = 13;
        static final int ms_width = 9;
        private boolean m_bOneBarPerValue = false;
        private Color m_colFilledBar;

        public MyProgressBarUI(boolean bOneBarPerValue) {
            this.m_bOneBarPerValue = bOneBarPerValue;
            this.m_colFilledBar = null;
        }

        public void paint(Graphics g, JComponent c) {
            int i;
            JProgressBar pb = (JProgressBar)c;
            int max = pb.getMaximum();
            int anz = pb.getWidth() / 13;
            int value = pb.getValue() * anz / max;
            int x = 0;
            int y = 0;
            int height = c.getHeight() - 1;
            Color col = g.getColor();
            if (this.m_colFilledBar != null) {
                g.setColor(this.m_colFilledBar);
            }
            for (i = 0; i < value; ++i) {
                g.fill3DRect(x, y, 9, height + 1, false);
                x += 13;
            }
            g.setColor(col);
            for (i = value; i < anz; ++i) {
                g.draw3DRect(x, y, 9, height, false);
                x += 13;
            }
        }

        public void setFilledBarColor(Color col) {
            this.m_colFilledBar = col;
        }

        public Color getFilledBarColor() {
            return this.m_colFilledBar;
        }

        public Dimension getPreferredSize(JComponent c) {
            if (!this.m_bOneBarPerValue) {
                return super.getPreferredSize(c);
            }
            JProgressBar pb = (JProgressBar)c;
            return new Dimension(13 * pb.getMaximum(), 12);
        }

        public Dimension getMinimumSize(JComponent c) {
            if (!this.m_bOneBarPerValue) {
                return super.getMinimumSize(c);
            }
            return this.getPreferredSize(c);
        }

        public Dimension getMaximumSize(JComponent c) {
            if (!this.m_bOneBarPerValue) {
                return super.getMaximumSize(c);
            }
            return this.getPreferredSize(c);
        }
    }
}

