/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.platform.AbstractOS;
import anon.util.ClassUtil;
import anon.util.JAPMessages;
import anon.util.RecursiveFileTool;
import anon.util.ResourceLoader;
import anon.util.Util;
import gui.GUIUtils;
import gui.dialog.JAPDialog;
import jap.JAPController;
import jap.JAPModel;
import jap.SystrayPopupMenu;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import logging.LogHolder;
import logging.LogType;

public final class JAPDll {
    public static final String MSG_IGNORE_UPDATE = (class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll).getName() + "_ignoreUpdate";
    public static final String JAP_DLL_REQUIRED_VERSION = "00.04.009";
    public static final String START_PARAMETER_ADMIN = "--dllAdminUpdate";
    private static final String UPDATE_PATH;
    private static final String DLL_LIBRARY_NAME = "japdll";
    private static final String DLL_LIBRARY_NAME_32bit = "japdll";
    private static final String DLL_LIBRARY_NAME_64bit = "japdll_x64";
    private static final String JAP_DLL = "japdll.dll";
    private static final String JAP_DLL_NEW_32bit = "japdll.dll.00.04.009";
    private static final String JAP_DLL_NEW_64bit = "japdll.dll.00.04.009";
    private static final String JAP_DLL_OLD = "japdll.old";
    private static final String MSG_DLL_UPDATE;
    private static final String MSG_DLL_UPDATE_SUCCESS_ADMIN;
    private static final String MSG_DLL_UPDATE_FAILED;
    private static final String MSG_CONFIRM_OVERWRITE;
    private static final String MSG_PERMISSION_PROBLEM;
    private static final String MSG_COULD_NOT_SAVE;
    private static Hashtable ms_hashOnTop;
    private static boolean ms_bInTaskbar;
    private static final Object SYNC_POPUP;
    private static SystrayPopupMenu ms_popupMenu;
    private static Window ms_popupWindow;
    private static boolean m_sbHasOnTraffic;
    private static boolean m_bStartedAsAdmin;
    private static final String STR_HIDDEN_WINDOW;
    static /* synthetic */ Class class$gui$JAPDll;

    private static void loadDll() {
        String strDataModel;
        try {
            strDataModel = System.getProperty("sun.arch.data.model");
        }
        catch (SecurityException a_e) {
            strDataModel = null;
        }
        if (strDataModel != null && strDataModel.equals("64")) {
            try {
                System.loadLibrary(DLL_LIBRARY_NAME_64bit);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            try {
                System.loadLibrary("japdll");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void init(boolean a_bStartedAsAdmin, String a_username, Window a_window) {
        block11: {
            String strOSName = System.getProperty("os.name", "");
            m_bStartedAsAdmin = a_bStartedAsAdmin;
            try {
                File fileVirtual;
                File filePhysical;
                if (strOSName != null && strOSName.toLowerCase().indexOf("win") <= -1) break block11;
                GUIUtils.setNativeGUILibrary(new GUIUtils.NativeGUILibrary(){

                    public boolean setAlwaysOnTop(Window a_window, boolean a_bOnTop) {
                        return JAPDll.setWindowOnTop(a_window, a_bOnTop);
                    }

                    public boolean isAlwaysOnTop(Window a_window) {
                        return JAPDll.isWindowOnTop(a_window);
                    }
                });
                try {
                    File tempFile;
                    String tempDir = AbstractOS.getInstance().getTempPath();
                    if (tempDir != null && (tempFile = new File(tempDir + "japdll")).exists() && !RecursiveFileTool.deleteRecursion(tempFile)) {
                        throw new Exception("Delete recursive");
                    }
                }
                catch (Throwable a_e) {
                    LogHolder.log(2, LogType.MISC, "Could not delete temporary DLL!", a_e);
                }
                boolean bUpdateDone = false;
                if (JAPDll.getUpdatePath() != null && JAPModel.getInstance().getDllUpdatePath() != null) {
                    JAPDll.update(a_window);
                    bUpdateDone = true;
                }
                JAPDll.loadDll();
                if (JAPDll.getUpdatePath() == null) {
                    LogHolder.log(3, LogType.GUI, "Could not get DLL update path. Maybe Java Webstart?");
                    return;
                }
                String version = JAPDll.getDllVersion();
                if (bUpdateDone && (version == null || version.compareTo(JAP_DLL_REQUIRED_VERSION) < 0)) {
                    JAPModel.getInstance().setDLLupdate(JAPDll.getUpdatePath());
                    JAPController.getInstance().saveConfigFile();
                } else {
                    JAPModel.getInstance().setDLLupdate(null);
                }
                JAPController.getInstance().addProgramExitListener(new JAPController.ProgramExitListener(){

                    public void programExiting() {
                        try {
                            if (JAPDll.getDllVersion() != null) {
                                JAPDll.hideSystray_dll();
                            }
                        }
                        catch (Throwable a_e) {
                            LogHolder.log(2, LogType.GUI, a_e);
                        }
                    }
                });
                if (m_bStartedAsAdmin && a_username != null && (filePhysical = ClassUtil.getClassDirectory(class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll)) != null && filePhysical.getPath().endsWith(".jar") && (fileVirtual = new File(a_username + "\\AppData\\Local\\VirtualStore" + filePhysical.getPath().substring(2, filePhysical.getPath().length()))).exists() && !fileVirtual.equals(filePhysical)) {
                    String pathToJava = AbstractOS.getInstance().getProperty("java.home") + File.separator + "bin" + File.separator + "javaw -jar ";
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(pathToJava + "\"" + fileVirtual.getPath() + "\" --version").getInputStream()));
                    String line1 = reader.readLine();
                    reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(pathToJava + "\"" + filePhysical.getPath() + "\" --version").getInputStream()));
                    String line2 = reader.readLine();
                    if (line1 != null && line2 != null && !line1.equals(line2)) {
                        Util.copyStream(new FileInputStream(fileVirtual), new FileOutputStream(filePhysical));
                        final JAPController.IRestarter origRestarter = JAPController.getInstance().getRestarter();
                        JAPController.getInstance().setRestarter(new JAPController.IRestarter(){

                            public void exec(String[] a_args) throws IOException {
                                origRestarter.exec(a_args);
                            }

                            public boolean isConfigFileSaved() {
                                return false;
                            }

                            public boolean hideWarnings() {
                                return true;
                            }
                        });
                        JAPController.goodBye(false);
                    }
                }
            }
            catch (Throwable a_t) {
                LogHolder.log(2, LogType.GUI, a_t);
            }
        }
    }

    public static void checkDllVersion(boolean a_bShowDialogAndCloseOnUpdate) {
        if (System.getProperty("os.name", "").toLowerCase().indexOf("win") < 0) {
            return;
        }
        LogHolder.log(6, LogType.GUI, "Existing japdll.dll version: " + JAPDll.getDllVersion());
        LogHolder.log(6, LogType.GUI, "Required japdll.dll version: 00.04.009");
        if (JAPDll.getDllVersion() != null && JAPDll.getDllVersion().compareTo(JAP_DLL_REQUIRED_VERSION) < 0 && ResourceLoader.getResourceURL("japdll.dll.00.04.009") != null && JAPDll.getUpdatePath() != null) {
            File file = new File(JAPDll.getDllFileName());
            if (!file.exists()) {
                JAPDll.askUserWhatToDo();
                return;
            }
            if (JAPModel.getInstance().getDllUpdatePath() != null) {
                if (a_bShowDialogAndCloseOnUpdate) {
                    JAPDll.askUserWhatToDo();
                }
                return;
            }
            if (JAPDll.update(JAPController.getInstance().getCurrentView()) && JAPDll.getDllVersion() != null && JAPDll.getDllVersion().compareTo(JAP_DLL_REQUIRED_VERSION) < 0) {
                LogHolder.log(6, LogType.GUI, "Update successful, existing japdll.dll version: " + JAPDll.getDllVersion());
                JAPDll.loadDll();
                if (JAPDll.getDllVersion().compareTo(JAP_DLL_REQUIRED_VERSION) < 0) {
                    a_bShowDialogAndCloseOnUpdate = true;
                } else {
                    return;
                }
            }
            JAPModel.getInstance().setDLLupdate(JAPDll.getUpdatePath());
            JAPController.getInstance().saveConfigFile();
            if (a_bShowDialogAndCloseOnUpdate) {
                JAPDll.informUserAboutJapRestart();
            }
        } else if (JAPModel.getInstance().getDllUpdatePath() != null) {
            JAPModel.getInstance().setDLLupdate(null);
            JAPController.getInstance().saveConfigFile();
        }
    }

    private static boolean update(Component a_window) {
        if (JAPDll.renameDLL(JAP_DLL, JAP_DLL_OLD) && JAPDll.extractDLL(new File(JAPDll.getDllFileName()))) {
            JAPModel.getInstance().setDLLupdate(null);
            JAPController.getInstance().saveConfigFile();
            if (m_bStartedAsAdmin) {
                if (a_window != null) {
                    JAPDialog.showMessageDialog(a_window, JAPMessages.getString(MSG_DLL_UPDATE_SUCCESS_ADMIN));
                }
                final JAPController.IRestarter origRestarter = JAPController.getInstance().getRestarter();
                JAPController.getInstance().setRestarter(new JAPController.IRestarter(){

                    public void exec(String[] a_args) throws IOException {
                        origRestarter.exec(a_args);
                    }

                    public boolean isConfigFileSaved() {
                        return true;
                    }

                    public boolean hideWarnings() {
                        return true;
                    }
                });
                JAPController.goodBye(true);
            }
            return true;
        }
        JAPDll.renameDLL(JAP_DLL_OLD, JAP_DLL);
        return false;
    }

    private static boolean renameDLL(String a_oldName, String a_newName) {
        try {
            File file = new File(JAPDll.getUpdatePath() + File.separator + a_oldName);
            if (file.exists()) {
                file.renameTo(new File(JAPDll.getUpdatePath() + File.separator + a_newName));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.GUI, "Unable to copy " + JAPDll.getUpdatePath() + File.separator + a_oldName + ".", e);
            return false;
        }
    }

    private static boolean extractDLL(File a_file) {
        boolean bSuccess = false;
        InputStream streamOne = null;
        FileOutputStream streamTwo = null;
        LogHolder.log(7, LogType.GUI, "Extracting japdll.dll.00.04.009 from jar-file to: " + a_file);
        try {
            streamOne = ResourceLoader.loadResourceAsStream("japdll.dll.00.04.009");
            streamTwo = new FileOutputStream(a_file);
            Util.copyStream(streamOne, streamTwo);
            bSuccess = true;
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.MISC, e);
        }
        Util.closeStream(streamOne);
        Util.closeStream(streamTwo);
        return bSuccess;
    }

    private static void askUserWhatToDo() {
        if (!JAPModel.getInstance().isDLLWarningActive()) {
            return;
        }
        JAPDialog.LinkedCheckBox checkbox = new JAPDialog.LinkedCheckBox(JAPMessages.getString(MSG_IGNORE_UPDATE), false);
        Object[] args = new String[]{JAP_DLL, JAPDll.getUpdatePath()};
        int answer = JAPDialog.showConfirmDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString(MSG_DLL_UPDATE_FAILED, args) + "<br>&nbsp;", JAPMessages.getString(JAPDialog.MSG_TITLE_ERROR), 2, 2, (JAPDialog.ILinkedInformation)checkbox);
        JAPModel.getInstance().setDllWarning(!checkbox.getState());
        if (answer == 0) {
            JAPController.getInstance().setRestarter(new JAPController.IRestarter(){

                public boolean isConfigFileSaved() {
                    return true;
                }

                public boolean hideWarnings() {
                    return false;
                }

                public void exec(String[] a_args) throws IOException {
                    String command = null;
                    String parameters = "";
                    String userhome = AbstractOS.getInstance().getProperty("user.home");
                    if (a_args != null && a_args.length > 1) {
                        command = "\"" + a_args[0] + "\"";
                        for (int i = 1; i < a_args.length; ++i) {
                            parameters = new StringTokenizer(a_args[i]).countTokens() > 1 ? parameters + " \"" + a_args[i] + "\"" : parameters + " " + a_args[i];
                        }
                        if (!m_bStartedAsAdmin) {
                            parameters = parameters + " --dllAdminUpdate";
                            if (userhome != null) {
                                parameters = parameters + " " + userhome;
                            }
                        }
                    }
                    if (command == null || !JAPDll.shellExecute(command, parameters, true)) {
                        this.showExplorerFiles();
                    }
                }

                private void showExplorerFiles() {
                    boolean bTmpDirCreated = false;
                    String tempDir = AbstractOS.getInstance().getTempPath();
                    if (tempDir == null) {
                        tempDir = AbstractOS.getInstance().getConfigPath("JonDo", true);
                    }
                    tempDir = tempDir + "japdll" + File.separator;
                    try {
                        File tempDirFile = new File(tempDir);
                        if (tempDirFile.exists() && !tempDirFile.isDirectory()) {
                            tempDirFile.delete();
                        }
                        bTmpDirCreated = !tempDirFile.exists() ? new File(tempDir).mkdir() : true;
                    }
                    catch (SecurityException a_e) {
                        LogHolder.log(2, LogType.MISC, "Could not create temporary directory!", a_e);
                    }
                    if (bTmpDirCreated && JAPDll.extractDLL(new File(tempDir + JAPDll.JAP_DLL))) {
                        try {
                            Runtime.getRuntime().exec(new String[]{"CMD", "/C", "EXPLORER.EXE", tempDir});
                            Runtime.getRuntime().exec(new String[]{"CMD", "/C", "EXPLORER.EXE", JAPDll.getUpdatePath()});
                        }
                        catch (IOException e) {
                            LogHolder.log(2, LogType.MISC, e);
                        }
                    }
                }
            });
            JAPController.goodBye(false);
        }
    }

    private static void informUserAboutJapRestart() {
        JAPDialog.showMessageDialog(JAPController.getInstance().getCurrentView(), JAPMessages.getString(MSG_DLL_UPDATE, "'japdll.dll'"));
        JAPController.goodBye(false);
    }

    private static boolean isWindowOnTop(Window a_window) {
        if (a_window == null) {
            return false;
        }
        return ms_hashOnTop.contains(a_window.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setWindowOnTop(Window theWindow, boolean onTop) {
        if (theWindow == null) {
            return false;
        }
        String caption = theWindow.getName();
        if (caption == null) {
            return false;
        }
        try {
            Hashtable hashtable = ms_hashOnTop;
            synchronized (hashtable) {
                JAPDll.setWindowOnTop_dll(caption, onTop);
                if (onTop) {
                    ms_hashOnTop.put(caption, caption);
                } else {
                    ms_hashOnTop.remove(caption);
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static synchronized boolean showWindowFromTaskbar() {
        try {
            if (ms_bInTaskbar) {
                ms_bInTaskbar = false;
                boolean value = JAPDll.showWindowFromTaskbar_dll();
                JAPDll.showMainWindow();
                ms_bInTaskbar = !value;
                return value;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static synchronized boolean hideWindowInTaskbar(String caption) {
        try {
            boolean bHidden = JAPDll.hideWindowInTaskbar_dll(caption);
            if (!ms_bInTaskbar) {
                ms_bInTaskbar = bHidden;
            }
            return bHidden;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean setWindowIcon(String caption) {
        try {
            return JAPDll.setWindowIcon_dll(caption);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean onTraffic() {
        if (m_sbHasOnTraffic) {
            try {
                JAPDll.onTraffic_dll();
                return true;
            }
            catch (Throwable t) {
                m_sbHasOnTraffic = false;
                return false;
            }
        }
        return false;
    }

    public static boolean xcopy(File a_file, File a_directory, boolean a_asAdmin) {
        if (a_file == null || a_directory == null || !a_directory.isDirectory()) {
            return false;
        }
        String dirSwitch = "";
        if (a_file.isDirectory()) {
            dirSwitch = "/E ";
        }
        String parameters = " /Y /R /Q /I /H " + dirSwitch + "\"" + a_file + "\" \"" + a_directory + "\"";
        LogHolder.log(5, LogType.MISC, "Doing xcopy: " + parameters);
        return JAPDll.shellExecute("xcopy", parameters, a_asAdmin);
    }

    public static String getDllVersion() {
        String version = null;
        try {
            version = JAPDll.getDllVersion_dll();
            StringTokenizer tokenizer = new StringTokenizer(version, ",");
            if (tokenizer.countTokens() > 1) {
                version = "";
                int number = Integer.parseInt(tokenizer.nextToken());
                if (number < 10) {
                    version = version + "0";
                }
                version = version + number + ".";
                number = Integer.parseInt(tokenizer.nextToken());
                if (number < 10) {
                    version = version + "0";
                }
                version = version + number + ".";
                number = Integer.parseInt(tokenizer.nextToken());
                if (number < 10) {
                    version = version + "0";
                }
                if (number < 100) {
                    version = version + "0";
                }
                version = version + number;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    private static String getUpdatePath() {
        String fileDLL = JAPDll.getDllFileName();
        if (fileDLL != null) {
            fileDLL = new File(fileDLL).getParent();
        }
        return fileDLL;
    }

    public static String getDllFileName() {
        String strFileName = JAPModel.getInstance().getDllUpdatePath();
        if (strFileName == null) {
            try {
                String s = JAPDll.getDllFileName_dll();
                if (s == null || s.length() == 0) {
                    return null;
                }
                return s;
            }
            catch (Throwable throwable) {
                strFileName = UPDATE_PATH;
            }
        }
        if (strFileName != null) {
            strFileName = !strFileName.endsWith(File.separator) ? strFileName + File.separator + JAP_DLL : strFileName + JAP_DLL;
        }
        return strFileName;
    }

    public static long showMainWindow() {
        Window view = JAPController.getInstance().getViewWindow();
        view.setVisible(true);
        view.toFront();
        view.repaint();
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long closePopupMenu() {
        Object object = SYNC_POPUP;
        synchronized (object) {
            if (ms_popupMenu != null) {
                Runnable run = new Runnable(){

                    public void run() {
                        ms_popupMenu.setVisible(false);
                        ms_popupWindow.setVisible(false);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long showPopupMenu(long a_x, long a_y) {
        Object object = SYNC_POPUP;
        synchronized (object) {
            if (ms_popupWindow == null) {
                ms_popupWindow = new JDialog(new Frame(STR_HIDDEN_WINDOW), false);
                ms_popupWindow.setName(STR_HIDDEN_WINDOW);
                ms_popupWindow.pack();
                ms_popupWindow.setLocation(20000, 20000);
            }
            Point mousePoint = new Point((int)a_x, (int)a_y);
            ms_popupMenu = new SystrayPopupMenu(new SystrayPopupMenu.MainWindowListener(){

                public void onShowMainWindow() {
                    JAPDll.showWindowFromTaskbar();
                }

                public void onShowHelp() {
                }

                public void onShowSettings(final String card, final Object a_value) {
                    new Thread(new Runnable(){

                        public void run() {
                            JAPController.getInstance().showConfigDialog(card, a_value);
                        }
                    }).start();
                }
            });
            GUIUtils.setAlwaysOnTop(ms_popupWindow, true);
            ms_popupWindow.setVisible(true);
            ms_popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    JAPDll.popupClosed_dll();
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            Point preferredLocation = new Point(mousePoint.x, mousePoint.y - ms_popupMenu.getHeight());
            ms_popupMenu.show(ms_popupWindow, preferredLocation);
            ms_popupMenu.repaint();
            return 0L;
        }
    }

    public static void setSystrayTooltip(String a_strTooltipText) {
        if (a_strTooltipText == null) {
            return;
        }
        if (a_strTooltipText.length() >= 60) {
            a_strTooltipText = a_strTooltipText.substring(0, 60);
        }
        if ((a_strTooltipText = a_strTooltipText.trim()).length() == 0) {
            return;
        }
        try {
            JAPDll.setTooltipText_dll(a_strTooltipText);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean shellExecute(String a_command, String a_parameters, boolean a_bAsAdmin) {
        boolean result;
        try {
            result = JAPDll.shellExecute_dll(a_command, a_parameters, a_bAsAdmin);
        }
        catch (Throwable a_e) {
            LogHolder.log(2, LogType.GUI, a_e);
            result = false;
        }
        return result;
    }

    private static native void setWindowOnTop_dll(String var0, boolean var1);

    private static native boolean hideWindowInTaskbar_dll(String var0);

    private static native boolean showWindowFromTaskbar_dll();

    private static native boolean setTooltipText_dll(String var0);

    private static native boolean setWindowIcon_dll(String var0);

    private static native void onTraffic_dll();

    private static native void popupClosed_dll();

    private static native void hideSystray_dll();

    private static native String getDllVersion_dll();

    private static native String getDllFileName_dll();

    private static native boolean shellExecute_dll(String var0, String var1, boolean var2);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MSG_DLL_UPDATE = (class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll).getName() + "_updateRestartMessage";
        MSG_DLL_UPDATE_SUCCESS_ADMIN = (class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll).getName() + "_dllUpdateSuccessAdmin";
        MSG_DLL_UPDATE_FAILED = (class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll).getName() + "_updateFailed";
        MSG_CONFIRM_OVERWRITE = (class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll).getName() + "_confirmOverwrite";
        MSG_PERMISSION_PROBLEM = (class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll).getName() + "_permissionProblem";
        MSG_COULD_NOT_SAVE = (class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll).getName() + "_couldNotSave";
        ms_hashOnTop = new Hashtable();
        ms_bInTaskbar = false;
        SYNC_POPUP = new Object();
        m_sbHasOnTraffic = true;
        m_bStartedAsAdmin = false;
        File japdir = ClassUtil.getClassDirectory(class$gui$JAPDll == null ? (class$gui$JAPDll = JAPDll.class$("gui.JAPDll")) : class$gui$JAPDll);
        if (japdir == null) {
            String strUpdatePath = null;
            try {
                strUpdatePath = System.getProperty("user.dir", null);
            }
            catch (Throwable a_e) {
                a_e.printStackTrace();
            }
            UPDATE_PATH = strUpdatePath;
        } else {
            UPDATE_PATH = japdir.getParent();
        }
        STR_HIDDEN_WINDOW = Double.toString(Math.random());
    }

    private static class MyFileFilter
    extends FileFilter {
        public static final String DLL_EXTENSION = ".dll";
        private final String ACCOUNT_DESCRIPTION = "JAP dll file (*.dll)";
        private int filterType;

        private MyFileFilter() {
        }

        public int getFilterType() {
            return this.filterType;
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(DLL_EXTENSION);
        }

        public String getDescription() {
            return "JAP dll file (*.dll)";
        }
    }
}

