/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JEditorPane;

public final class JAPAboutAutoScroller
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 1L;
    private Image m_imgOffScreen;
    private Image m_imgBackground;
    private Image m_imgDoubleBuffer;
    private Image m_imgBackgroundPicture;
    private int m_iScrollAreaWidth;
    private int m_iScrollAreaHeight;
    private int m_iScrollAreaX;
    private int m_iScrollAreaY;
    private int m_iaktY;
    private int m_iTextHeight;
    private int m_iWidth;
    private int m_iHeight;
    private JEditorPane m_textArea;
    private Thread m_Thread;
    private int m_msSleep;
    private volatile boolean m_bRun;
    private Object oSync = new Object();
    private boolean isPainting = false;
    private JButton m_bttnOk;

    public JAPAboutAutoScroller(int width, int height, Image background, int scrollareax, int scrollareay, int scrollareawidth, int scrollareaheight, String htmlText) {
        this.m_iScrollAreaWidth = scrollareawidth;
        this.m_iScrollAreaHeight = scrollareaheight;
        this.m_iScrollAreaX = scrollareax;
        this.m_iScrollAreaY = scrollareay;
        this.m_iWidth = width;
        this.m_iHeight = height;
        this.setSize(width, height);
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (JAPAboutAutoScroller.this.m_bttnOk.getBounds().contains(e.getPoint())) {
                    JAPAboutAutoScroller.this.m_bttnOk.doClick();
                }
            }
        });
        this.m_imgBackgroundPicture = background;
        this.m_textArea = new JEditorPane();
        this.m_textArea.setEditable(false);
        this.m_textArea.setDoubleBuffered(false);
        this.m_textArea.setBackground(new Color(204, 204, 204));
        this.m_textArea.setSize(this.m_iScrollAreaWidth, 10000);
        this.m_textArea.setContentType("text/html");
        this.m_textArea.setText(htmlText.trim());
        this.m_iTextHeight = this.m_textArea.getPreferredSize().height;
        this.m_bttnOk = new JButton("Ok");
        this.m_bttnOk.setMnemonic('O');
        this.m_bttnOk.setOpaque(false);
        this.m_bttnOk.setSelected(true);
        Dimension d = this.m_bttnOk.getPreferredSize();
        if (d.width > 76) {
            d.width = 76;
        }
        this.m_bttnOk.setSize(d);
        this.m_Thread = new Thread((Runnable)this, "JAP - AboutScroller");
        this.m_bRun = false;
    }

    public void addActionListener(ActionListener l) {
        this.m_bttnOk.addActionListener(l);
    }

    public synchronized void startScrolling(int msScrollTime) {
        if (this.m_bRun) {
            return;
        }
        this.m_msSleep = msScrollTime;
        this.m_Thread.start();
    }

    public synchronized void stopScrolling() {
        this.m_bRun = false;
        try {
            this.m_Thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g1) {
        if (g1 == null) {
            return;
        }
        Object object = this.oSync;
        synchronized (object) {
            if (this.isPainting) {
                return;
            }
            this.isPainting = true;
        }
        if (this.m_imgOffScreen == null) {
            this.m_imgOffScreen = this.createImage(this.m_iScrollAreaWidth, this.m_iTextHeight + 2 * this.m_iScrollAreaHeight);
            Graphics graphicsOffScreen = this.m_imgOffScreen.getGraphics();
            try {
                this.m_textArea.paint(graphicsOffScreen);
            }
            catch (Exception e) {
                this.m_imgOffScreen = null;
            }
            if (graphicsOffScreen != null) {
                graphicsOffScreen.dispose();
            }
        }
        if (this.m_imgBackground == null) {
            this.m_imgBackground = this.createImage(this.m_iWidth, this.m_iHeight);
            Graphics g2 = this.m_imgBackground.getGraphics();
            g2.drawImage(this.m_imgBackgroundPicture, 0, 0, null);
            int x = this.m_iWidth - 5 - this.m_bttnOk.getSize().width;
            int y = this.m_iHeight - 5 - this.m_bttnOk.getSize().height;
            this.m_bttnOk.setLocation(x, y);
            Font f = new Font("Sans", 0, 9);
            g2.setFont(f);
            g2.setColor(Color.black);
            FontMetrics fm = g2.getFontMetrics();
            int w = fm.stringWidth("Version:");
            g2.drawString("Version", x - 5 - w, y);
            w = fm.stringWidth("00.20.010");
            g2.drawString("00.20.010", x - 5 - w, this.m_iHeight - 5 - fm.getHeight());
            g2.translate(x, y);
            this.m_bttnOk.paint(g2);
            g2.dispose();
            this.m_imgDoubleBuffer = this.createImage(this.m_iWidth, this.m_iHeight);
        }
        Graphics g = this.m_imgDoubleBuffer.getGraphics();
        g.drawImage(this.m_imgBackground, 0, 0, null);
        if (this.m_imgOffScreen != null) {
            ++this.m_iaktY;
            if (this.m_iaktY <= this.m_iScrollAreaHeight) {
                g.drawImage(this.m_imgOffScreen, this.m_iScrollAreaX, this.m_iScrollAreaY + this.m_iScrollAreaHeight - this.m_iaktY, this.m_iScrollAreaX + this.m_iScrollAreaWidth, this.m_iScrollAreaY + this.m_iScrollAreaHeight, 0, 0, this.m_iScrollAreaWidth, this.m_iaktY, null);
            } else {
                g.drawImage(this.m_imgOffScreen, this.m_iScrollAreaX, this.m_iScrollAreaY, this.m_iScrollAreaWidth + this.m_iScrollAreaX, this.m_iScrollAreaHeight + this.m_iScrollAreaY, 0, this.m_iaktY - this.m_iScrollAreaHeight, this.m_iScrollAreaWidth, this.m_iaktY, null);
            }
        }
        g.dispose();
        g1.drawImage(this.m_imgDoubleBuffer, 0, 0, null);
        this.isPainting = false;
    }

    public void run() {
        this.m_iaktY = 0;
        this.m_bRun = true;
        while (this.m_bRun) {
            this.paint(this.getGraphics());
            try {
                Thread.sleep(this.m_msSleep);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_iaktY <= this.m_iTextHeight + this.m_iScrollAreaHeight) continue;
            this.m_iaktY = 0;
        }
    }
}

