/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.ClassUtil;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public abstract class Updater
implements Observer {
    private static final long MIN_WAITING_TIME_MS = 20000L;
    private IUpdateInterval m_updateInterval;
    private Thread m_updateThread;
    private boolean m_bAutoUpdateChanged = false;
    private boolean m_bInitialRun = true;
    private boolean m_interrupted = false;
    private boolean m_bUpdating = false;
    private Object UPDATE_SYNC = new Object();
    private ObservableInfo m_observable;
    private Vector m_queueUpdatersToCall = new Vector();

    public Updater(IUpdateInterval a_updateInterval, ObservableInfo a_observable) {
        if (a_updateInterval == null) {
            throw new IllegalArgumentException("No update interval specified!");
        }
        if (a_observable == null) {
            throw new IllegalArgumentException("No ObservableInfo specified!");
        }
        this.m_observable = a_observable;
        this.m_updateInterval = a_updateInterval;
        this.init();
    }

    private final void init() {
        this.m_observable.getObservable().addObserver(this);
        this.m_updateThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                long lastUpdate = System.currentTimeMillis();
                LogHolder.log(6, LogType.DB, Updater.this.getUpdatedClassName() + "update thread started.");
                while (!Thread.currentThread().isInterrupted() && !Updater.this.m_interrupted) {
                    Object object = Thread.currentThread();
                    synchronized (object) {
                        Updater.this.m_bAutoUpdateChanged = true;
                        while (Updater.this.m_bAutoUpdateChanged) {
                            Updater.this.m_bAutoUpdateChanged = false;
                            try {
                                Thread.currentThread().notify();
                                if (Updater.this.m_observable.isUpdateDisabled() || Updater.this.m_bInitialRun) {
                                    Thread.currentThread().wait();
                                } else {
                                    long waitingTime = Math.max(Updater.this.m_updateInterval.getUpdateInterval() - (System.currentTimeMillis() - lastUpdate), 20000L);
                                    LogHolder.log(5, LogType.DB, "Update waiting time for " + Updater.this.getUpdatedClass().getName() + ": " + waitingTime);
                                    Thread.currentThread().wait(waitingTime);
                                }
                            }
                            catch (InterruptedException a_e) {
                                Thread.currentThread().notifyAll();
                                break;
                            }
                            if (Thread.currentThread().isInterrupted()) {
                                Thread.currentThread().notifyAll();
                                break;
                            }
                            if (!Updater.this.m_interrupted) continue;
                        }
                    }
                    if (Thread.currentThread().isInterrupted() || Updater.this.m_interrupted || Updater.this.isUpdatePaused()) continue;
                    LogHolder.log(6, LogType.DB, "Updating " + Updater.this.getUpdatedClassName() + "list.");
                    lastUpdate = System.currentTimeMillis();
                    Updater.this.updateInternal();
                    object = Updater.this.m_queueUpdatersToCall;
                    synchronized (object) {
                        if (Updater.this.m_queueUpdatersToCall.size() > 0) {
                            Updater nextUpdater = (Updater)Updater.this.m_queueUpdatersToCall.elementAt(0);
                            Updater.this.m_queueUpdatersToCall.removeElementAt(0);
                            nextUpdater.update(true, (Vector)Updater.this.m_queueUpdatersToCall.clone());
                            Updater.this.m_queueUpdatersToCall.removeAllElements();
                        }
                    }
                }
                LogHolder.log(6, LogType.DB, Updater.this.getUpdatedClassName() + "update thread stopped.");
            }
        }, this.getUpdatedClassName() + "Update Thread");
        this.m_updateThread.setPriority(1);
        this.m_updateThread.setDaemon(true);
        this.m_updateThread.start();
    }

    protected ObservableInfo getObservableInfo() {
        return this.m_observable;
    }

    public void update(Observable a_observable, Object a_argument) {
        if (!(a_argument instanceof Integer) || !((Integer)a_argument).equals(this.m_observable.getUpdateChanged())) {
            return;
        }
        final Updater updater = this;
        if (!this.m_observable.isUpdateDisabled()) {
            new Thread(new Runnable(){

                public void run() {
                    if (Updater.this.m_observable.updateImmediately()) {
                        updater.update(false, null);
                    } else {
                        updater.start(false);
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(boolean a_bSynchronized) {
        Object object = this.UPDATE_SYNC;
        synchronized (object) {
            if (this.m_bUpdating) {
                return;
            }
            this.m_bUpdating = true;
        }
        object = this;
        synchronized (object) {
            Thread thread = this.m_updateThread;
            synchronized (thread) {
                this.m_bAutoUpdateChanged = true;
                this.m_bInitialRun = false;
                this.m_updateThread.notifyAll();
                if (a_bSynchronized) {
                    try {
                        this.m_updateThread.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
            }
        }
        object = this.UPDATE_SYNC;
        synchronized (object) {
            this.m_bUpdating = false;
        }
    }

    public final boolean update() {
        return this.update(true, null);
    }

    public final boolean update(Vector a_queueUpdatersToUpdate) {
        return this.update(true, a_queueUpdatersToUpdate);
    }

    public final void updateAsync(final Vector a_queueUpdatersToUpdate) {
        Thread run = new Thread(new Runnable(){

            public void run() {
                Updater.this.update(false, a_queueUpdatersToUpdate);
            }
        });
        run.setDaemon(true);
        run.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean update(boolean a_bSynchronized, Vector a_queueUpdatersToUpdate) {
        Object object;
        Object object2;
        if (this.m_bInitialRun) {
            this.start(true);
        }
        if (a_queueUpdatersToUpdate != null) {
            object2 = a_queueUpdatersToUpdate;
            synchronized (object2) {
                object = this.m_queueUpdatersToCall;
                synchronized (object) {
                    for (int i = 0; i < a_queueUpdatersToUpdate.size(); ++i) {
                        if (a_queueUpdatersToUpdate.elementAt(i) == null || !(a_queueUpdatersToUpdate.elementAt(i) instanceof Updater)) continue;
                        this.m_queueUpdatersToCall.addElement(a_queueUpdatersToUpdate.elementAt(i));
                    }
                }
            }
        }
        object2 = this;
        synchronized (object2) {
            object = this.m_updateThread;
            synchronized (object) {
                if (this.m_updateThread.isInterrupted() || this.m_interrupted) {
                    return false;
                }
                this.m_bAutoUpdateChanged = false;
                this.m_updateThread.notifyAll();
                if (a_bSynchronized) {
                    try {
                        this.m_updateThread.wait();
                    }
                    catch (InterruptedException a_e) {
                        LogHolder.log(3, LogType.NET, a_e);
                        return false;
                    }
                    return this.wasUpdateSuccessful();
                }
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        this.m_observable.getObservable().deleteObserver(this);
        if (this.m_updateThread == null) {
            return;
        }
        while (this.m_updateThread.isAlive()) {
            this.m_updateThread.interrupt();
            Thread thread = this.m_updateThread;
            synchronized (thread) {
                this.m_bAutoUpdateChanged = false;
                this.m_bInitialRun = false;
                this.m_interrupted = true;
                this.m_updateThread.notifyAll();
                this.m_updateThread.interrupt();
            }
            try {
                this.m_updateThread.join(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final IUpdateInterval getUpdateInterval() {
        return this.m_updateInterval;
    }

    public abstract Class getUpdatedClass();

    protected abstract boolean wasUpdateSuccessful();

    public abstract long getLastUpdate();

    public boolean needsUpdate() {
        return !this.isFirstUpdateDone() || System.currentTimeMillis() < this.getLastUpdate() || System.currentTimeMillis() - this.getLastUpdate() > this.m_updateInterval.getUpdateInterval();
    }

    public final boolean isFirstUpdateDone() {
        return this.getLastUpdate() <= System.currentTimeMillis();
    }

    protected abstract void updateInternal();

    protected boolean isUpdatePaused() {
        return false;
    }

    protected final String getUpdatedClassName() {
        return ClassUtil.getShortClassName(this.getUpdatedClass()) + " ";
    }

    protected static interface IUpdateInterval {
        public long getUpdateInterval();
    }

    protected static final class ConstantUpdateInterval
    implements IUpdateInterval {
        private long m_updateInterval;

        public ConstantUpdateInterval(long a_updateInterval) {
            this.m_updateInterval = a_updateInterval;
        }

        public long getUpdateInterval() {
            return this.m_updateInterval;
        }
    }

    protected static class DynamicUpdateInterval
    implements IUpdateInterval {
        private long m_updateInterval;

        public DynamicUpdateInterval(long a_updateInterval) {
            this.setUpdateInterval(a_updateInterval);
        }

        public void setUpdateInterval(long a_updateInterval) {
            this.m_updateInterval = a_updateInterval;
        }

        public long getUpdateInterval() {
            return this.m_updateInterval;
        }
    }

    public static class ObservableInfoContainer
    extends ObservableInfo {
        private ObservableInfo m_observableInfo;

        public ObservableInfoContainer(ObservableInfo a_observableInfo) {
            super(a_observableInfo.getObservable());
            this.m_observableInfo = a_observableInfo;
        }

        public void notifyAdditionalObserversOnUpdate(Class a_updatedClass) {
            this.m_observableInfo.notifyAdditionalObserversOnUpdate(a_updatedClass);
        }

        public boolean updateImmediately() {
            return this.m_observableInfo.updateImmediately();
        }

        public Integer getUpdateChanged() {
            return this.m_observableInfo.getUpdateChanged();
        }

        public boolean isUpdateDisabled() {
            return this.m_observableInfo.isUpdateDisabled();
        }
    }

    public static abstract class ObservableInfo {
        private Observable m_observable;

        public ObservableInfo(Observable a_observable) {
            if (a_observable == null) {
                throw new IllegalArgumentException("No Observable specified!");
            }
            this.m_observable = a_observable;
        }

        public void notifyAdditionalObserversOnUpdate(Class a_updatedClass) {
        }

        public boolean updateImmediately() {
            return false;
        }

        public final Observable getObservable() {
            return this.m_observable;
        }

        public abstract Integer getUpdateChanged();

        public abstract boolean isUpdateDisabled();
    }
}

