/*
 * Decompiled with CFR 0.152.
 */
package anon.tor.ordescription;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.ListenerInterface;
import anon.tor.ordescription.ORListFetcher;
import logging.LogHolder;
import logging.LogType;

public final class PlainORListFetcher
implements ORListFetcher {
    private String m_ORListServer;
    private int m_ORListPort;

    public PlainORListFetcher(String addr, int port) {
        this.m_ORListServer = addr;
        this.m_ORListPort = port;
    }

    public byte[] getRouterStatus() {
        return this.getDocument("/tor/server/authority.z");
    }

    public byte[] getDescriptor(String digest) {
        return this.getDocument("/tor/server/d/" + digest + ".z");
    }

    public byte[] getDescriptorByFingerprint(String fingerprint) {
        return this.getDocument("/tor/server/fp/" + fingerprint + ".z");
    }

    public byte[] getAllDescriptors() {
        return this.getDocument("/tor/server/all.z");
    }

    public byte[] getStatus(String fingerprint) {
        return this.getDocument("/tor/server/fp/" + fingerprint + ".z");
    }

    private byte[] getDocument(String path) {
        try {
            LogHolder.log(7, LogType.TOR, "fetching " + path + " from directory server");
            HTTPConnection http = HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(this.m_ORListServer, this.m_ORListPort), 1, true);
            HTTPResponse resp = http.Get(path);
            if (resp.getStatusCode() != 200) {
                return null;
            }
            byte[] doc = resp.getData();
            if (doc.length <= 0) {
                return null;
            }
            return doc;
        }
        catch (Throwable t) {
            LogHolder.log(7, LogType.TOR, "error while fetching " + path + " from directory server: " + t.getMessage());
            return null;
        }
    }
}

