/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.shared.AbstractAnonChannel;
import anon.tor.Circuit;
import anon.tor.cells.RelayCell;
import anon.util.ByteArrayUtil;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;

public class TorChannel
extends AbstractAnonChannel {
    private static final int MAX_CELL_DATA = 498;
    protected Circuit m_circuit;
    private volatile int m_recvcellcounter;
    private volatile int m_sendcellcounter;
    private volatile int m_iSendRelayCellsWaitingForDelivery = 0;
    private volatile boolean m_bChannelCreated;
    private volatile boolean m_bCreateError;
    private Object m_oWaitForOpen = new Object();
    private Object m_oSyncSendCellCounter = new Object();
    private Object m_oSyncSend = new Object();
    private Object m_oSyncSendRelayCellsWaitingForDelivery = new Object();
    private volatile boolean m_bDoNotCloseChannelOnError = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSendCellCounter(int value) {
        Object object = this.m_oSyncSendCellCounter;
        synchronized (object) {
            this.m_sendcellcounter += value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decreaseSendRelayCellsWaitingForDelivery() {
        Object object = this.m_oSyncSendRelayCellsWaitingForDelivery;
        synchronized (object) {
            --this.m_iSendRelayCellsWaitingForDelivery;
        }
    }

    protected void setStreamID(int id) {
        this.m_id = id;
    }

    protected void setCircuit(Circuit c) {
        this.m_circuit = c;
    }

    public int getOutputBlockSize() {
        return 498;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void send(byte[] arg0, int len) throws IOException {
        if (this.m_bIsClosed || this.m_bIsClosedByPeer) {
            throw new IOException("Tor channel is closed");
        }
        Object object = this.m_oSyncSend;
        synchronized (object) {
            byte[] b = arg0;
            while (len != 0 && !this.m_bIsClosed) {
                RelayCell cell;
                if (len > 498) {
                    cell = new RelayCell(this.m_circuit.getCircID(), 2, this.m_id, ByteArrayUtil.copy(b, 0, 498));
                    b = ByteArrayUtil.copy(b, 498, len - 498);
                    len -= 498;
                } else {
                    cell = new RelayCell(this.m_circuit.getCircID(), 2, this.m_id, ByteArrayUtil.copy(b, 0, len));
                    len = 0;
                }
                try {
                    while (!(this.m_sendcellcounter > 0 && this.m_iSendRelayCellsWaitingForDelivery <= 10 || this.m_bIsClosed || this.m_bIsClosedByPeer)) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e) {}
                    }
                    Object e = this.m_oSyncSendRelayCellsWaitingForDelivery;
                    synchronized (e) {
                        ++this.m_iSendRelayCellsWaitingForDelivery;
                    }
                    this.m_circuit.send(cell);
                }
                catch (Throwable t) {
                    throw new IOException("TorChannel send - error in sending a cell!");
                }
                this.addToSendCellCounter(-1);
            }
        }
    }

    private void internalClose() {
        this.m_bCreateError = true;
        if (!this.m_bDoNotCloseChannelOnError) {
            this.close();
        } else {
            byte[] reason = new byte[]{6};
            RelayCell cell = new RelayCell(this.m_circuit.getCircID(), 3, this.m_id, reason);
            try {
                this.m_circuit.sendUrgent(cell);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.m_bCreateError = true;
        super.close();
        Object object = this.m_oWaitForOpen;
        synchronized (object) {
            this.m_oWaitForOpen.notify();
        }
    }

    public boolean isClosed() {
        return this.m_bCreateError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedByPeer() {
        this.m_bCreateError = true;
        if (!this.m_bDoNotCloseChannelOnError) {
            super.closedByPeer();
        }
        Object object = this.m_oWaitForOpen;
        synchronized (object) {
            this.m_oWaitForOpen.notify();
        }
    }

    protected void close_impl() {
        try {
            if (!this.m_bIsClosed) {
                this.m_circuit.close(this.m_id);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setDoNotCloseChannelOnErrorDuringConnect(boolean b) {
        this.m_bDoNotCloseChannelOnError = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean connect(String addr, int port) {
        try {
            if (this.m_bIsClosed || this.m_bIsClosedByPeer) {
                return false;
            }
            this.m_recvcellcounter = 500;
            this.m_sendcellcounter = 500;
            byte[] data = (addr + ":" + Integer.toString(port)).getBytes();
            data = ByteArrayUtil.conc(data, new byte[1]);
            RelayCell cell = new RelayCell(this.m_circuit.getCircID(), 1, this.m_id, data);
            this.m_bChannelCreated = false;
            this.m_bCreateError = false;
            this.m_circuit.sendUrgent(cell);
            Object object = this.m_oWaitForOpen;
            synchronized (object) {
                long currTime = System.currentTimeMillis();
                int waitTime = 60000;
                while (waitTime > 0) {
                    try {
                        this.m_oWaitForOpen.wait(waitTime);
                    }
                    catch (InterruptedException e) {
                        LogHolder.log(7, LogType.TOR, "InterruptedException in TorChannel:connect()");
                    }
                    if (this.m_bCreateError) {
                        LogHolder.log(7, LogType.TOR, "TorChannel - connect() - establishing channel over circuit NOT successful. Channel was closed before!");
                        return false;
                    }
                    if (this.m_bChannelCreated) {
                        this.m_bDoNotCloseChannelOnError = false;
                        LogHolder.log(7, LogType.TOR, "TorChannel - connect() - establishing channel over circuit successful. Time needed [ms]: " + Long.toString(System.currentTimeMillis() - currTime));
                        return true;
                    }
                    long diffTime = System.currentTimeMillis() - currTime;
                    if (diffTime < 0L) {
                        return false;
                    }
                    waitTime = (int)((long)waitTime - diffTime);
                }
            }
            LogHolder.log(7, LogType.TOR, "TorChannel - connect() - establishing channel over circuit NOT successful. Timed out!");
            this.internalClose();
            return false;
        }
        catch (Throwable t) {
            LogHolder.log(7, LogType.TOR, "Exception in TorChannel:connect()");
            this.internalClose();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchCell(RelayCell cell) {
        int ret = 0;
        switch (cell.getRelayCommand()) {
            case 4: {
                this.m_bChannelCreated = true;
                this.m_bDoNotCloseChannelOnError = false;
                Object object = this.m_oWaitForOpen;
                synchronized (object) {
                    this.m_oWaitForOpen.notify();
                    break;
                }
            }
            case 5: {
                this.addToSendCellCounter(50);
                break;
            }
            case 2: {
                --this.m_recvcellcounter;
                if (this.m_recvcellcounter < 250) {
                    RelayCell rc = new RelayCell(this.m_circuit.getCircID(), 5, this.m_id, null);
                    try {
                        this.m_circuit.sendUrgent(rc);
                    }
                    catch (Throwable t) {
                        this.closedByPeer();
                        return ret;
                    }
                    this.m_recvcellcounter += 50;
                }
                try {
                    byte[] buffer = cell.getRelayPayload();
                    this.recv(buffer, 0, buffer.length);
                    break;
                }
                catch (Exception ex) {
                    this.closedByPeer();
                    return ret;
                }
            }
            case 3: {
                byte reason = cell.getPayload()[0];
                LogHolder.log(7, LogType.TOR, "RELAY_END: Relay stream closed with reason: " + reason);
                if (reason == 1) {
                    ret = -1;
                }
                this.closedByPeer();
                break;
            }
            default: {
                this.closedByPeer();
            }
        }
        return ret;
    }

    public boolean isClosedByPeer() {
        return this.m_bIsClosedByPeer;
    }
}

