/*
 * Decompiled with CFR 0.152.
 */
package anon.terms;

import anon.crypto.MultiCertPath;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.Database;
import anon.infoservice.OperatorAddress;
import anon.infoservice.ServiceOperator;
import anon.terms.TCComponent;
import anon.terms.TCComposite;
import anon.terms.TermsAndConditionsTranslation;
import anon.terms.template.Section;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.IXMLEncodable;
import anon.util.JAPMessages;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.security.SignatureException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TermsAndConditions
implements IXMLEncodable {
    public static final String XML_ATTR_ACCEPTED = "accepted";
    public static final String XML_ATTR_DATE = "date";
    private static final String MSG_DISPLAY_ERROR = (class$anon$terms$TermsAndConditions == null ? (class$anon$terms$TermsAndConditions = TermsAndConditions.class$("anon.terms.TermsAndConditions")) : class$anon$terms$TermsAndConditions).getName() + "_displayError";
    public static final String XML_ELEMENT_CONTAINER_NAME = "TermsAndConditionsList";
    public static final String XML_ELEMENT_NAME = "TermsAndConditions";
    public static final String XML_ELEMENT_TRANSLATION_NAME = "TCTranslation";
    public static final String DATE_FORMAT = "yyyyMMdd";
    private ServiceOperator operator;
    private Date m_date;
    private Hashtable translations;
    private Translation defaultTl = null;
    private boolean accepted;
    private static final Hashtable tcHashtable = new Hashtable();
    static /* synthetic */ Class class$anon$terms$TermsAndConditions;
    static /* synthetic */ Class class$anon$infoservice$ServiceOperator;

    public TermsAndConditions(ServiceOperator operator, String date) throws ParseException {
        this(operator, new SimpleDateFormat(DATE_FORMAT).parse(date));
    }

    public TermsAndConditions(ServiceOperator operator, Date date) throws ParseException {
        if (operator == null) {
            throw new NullPointerException("Operator of terms and conditions must not be null!");
        }
        this.operator = operator;
        if (date == null) {
            throw new NullPointerException("Date of terms and conditions must not be null!");
        }
        this.m_date = date;
        if (this.m_date == null) {
            throw new IllegalArgumentException("Date has not the valid format yyyyMMdd");
        }
        this.translations = new Hashtable();
        this.accepted = false;
    }

    public TermsAndConditions(Element termsAndConditionRoot) throws XMLParseException, ParseException, SignatureException {
        this(termsAndConditionRoot, null, true);
    }

    public TermsAndConditions(Element termsAndConditionRoot, ServiceOperator operator, boolean withSignatureCheck) throws XMLParseException, ParseException, SignatureException {
        if (operator != null) {
            this.operator = operator;
        } else {
            String opSki = XMLUtil.parseAttribute((Node)termsAndConditionRoot, "id", null);
            if (opSki == null) {
                throw new XMLParseException("attribute 'id' of TermsAndConditions must not be null!");
            }
            opSki = opSki.toUpperCase();
            this.operator = (ServiceOperator)Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = TermsAndConditions.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntryById(opSki);
            if (this.operator == null) {
                throw new XMLParseException("invalid  id " + opSki + ": no operator found with this subject key identifier");
            }
        }
        String dateStr = XMLUtil.parseAttribute((Node)termsAndConditionRoot, XML_ATTR_DATE, null);
        if (dateStr == null) {
            throw new XMLParseException("attribute 'date' must not be null!");
        }
        this.m_date = new SimpleDateFormat(DATE_FORMAT).parse(dateStr);
        this.translations = new Hashtable();
        Element currentTranslation = (Element)XMLUtil.getFirstChildByName(termsAndConditionRoot, XML_ELEMENT_TRANSLATION_NAME);
        while (currentTranslation != null) {
            this.addTranslation(new Translation(currentTranslation), withSignatureCheck);
            currentTranslation = (Element)XMLUtil.getNextSiblingByName(currentTranslation, XML_ELEMENT_TRANSLATION_NAME);
        }
        this.accepted = XMLUtil.parseAttribute((Node)termsAndConditionRoot, XML_ATTR_ACCEPTED, false);
    }

    public String getDateString() {
        return new SimpleDateFormat(DATE_FORMAT).format(this.m_date);
    }

    public void addTranslation(Element translationRoot) throws XMLParseException, SignatureException {
        this.addTranslation(new Translation(translationRoot), true);
    }

    public Translation removeTranslation(String locale) {
        Translation removedTranslation = (Translation)this.translations.remove(locale.trim().toLowerCase());
        if (this.defaultTl == removedTranslation) {
            this.defaultTl = null;
        }
        return removedTranslation;
    }

    public Translation removeTranslation(Locale locale) {
        return this.removeTranslation(locale.getLanguage());
    }

    public Translation initializeEmptyTranslation(String locale) {
        Translation t = new Translation();
        t.setLocale(locale.trim().toLowerCase());
        try {
            this.addTranslation(t, false);
        }
        catch (SignatureException signatureException) {
            // empty catch block
        }
        return t;
    }

    public Translation initializeEmptyTranslation(Locale locale) {
        return this.initializeEmptyTranslation(locale.getLanguage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addTranslation(Translation t, boolean withSignatureCheck) throws SignatureException {
        if (withSignatureCheck) {
            if (!t.isVerified()) {
                throw new SignatureException("Translation [" + t.getLocale() + "] of " + this.operator.getOrganization() + " is not verified");
            }
            if (!t.checkId()) {
                throw new SignatureException("Translation [" + t.getLocale() + "] is not signed by its operator '" + this.operator.getOrganization() + "'");
            }
        }
        TermsAndConditions termsAndConditions = this;
        synchronized (termsAndConditions) {
            if (t.isDefaultTranslation()) {
                this.defaultTl = t;
            }
        }
        this.translations.put(t.getLocale(), t);
    }

    public synchronized Translation getDefaultTranslation() {
        return this.defaultTl;
    }

    public Translation getTranslation(Locale locale) {
        return this.getTranslation(locale.getLanguage());
    }

    public Translation getTranslation(String locale) {
        return (Translation)this.translations.get(locale.trim().toLowerCase());
    }

    public Enumeration getAllTranslations() {
        return this.translations.elements();
    }

    public String getTemplateReferenceId(String locale) {
        Translation t = (Translation)this.translations.get(locale.trim().toLowerCase());
        return t != null ? t.getTemplateReferenceId() : null;
    }

    public boolean hasTranslation(String locale) {
        return this.translations.containsKey(locale.trim().toLowerCase());
    }

    public boolean hasTranslation(Locale locale) {
        return this.hasTranslation(locale.getLanguage());
    }

    public boolean hasTranslations() {
        return !this.translations.isEmpty();
    }

    public synchronized boolean hasDefaultTranslation() {
        return this.defaultTl != null;
    }

    public ServiceOperator getOperator() {
        return this.operator;
    }

    public void setDate(Date date) {
        this.m_date = date;
    }

    public Date getDate() {
        return this.m_date;
    }

    public synchronized void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public static void storeTermsAndConditions(TermsAndConditions tc) {
        tcHashtable.put(tc.operator, tc);
    }

    public static TermsAndConditions getTermsAndConditions(ServiceOperator operator) {
        return (TermsAndConditions)tcHashtable.get(operator);
    }

    public static void removeTermsAndConditions(TermsAndConditions tc) {
        tcHashtable.remove(tc.operator);
    }

    public static void removeTermsAndConditions(ServiceOperator operator) {
        tcHashtable.remove(operator);
    }

    public static Element getAllTermsAndConditionsAsXMLElement(Document ownerDoc) {
        Enumeration allTermsAndConditions = null;
        Element listRoot = ownerDoc.createElement(XML_ELEMENT_CONTAINER_NAME);
        allTermsAndConditions = tcHashtable.elements();
        TermsAndConditions currentTC = null;
        while (allTermsAndConditions.hasMoreElements()) {
            currentTC = (TermsAndConditions)allTermsAndConditions.nextElement();
            if (!currentTC.hasTranslations()) continue;
            listRoot.appendChild(currentTC.toXmlElement(ownerDoc));
        }
        return listRoot;
    }

    public static void loadTermsAndConditionsFromXMLElement(Element listRoot) {
        if (listRoot == null) {
            LogHolder.log(4, LogType.MISC, "TC list root is null!");
            return;
        }
        Element currentTCNode = (Element)XMLUtil.getFirstChildByName(listRoot, XML_ELEMENT_NAME);
        while (currentTCNode != null) {
            try {
                TermsAndConditions.storeTermsAndConditions(new TermsAndConditions(currentTCNode));
            }
            catch (XMLParseException xpe) {
                LogHolder.log(4, LogType.MISC, "XML error occured while parsing the TC node:", xpe);
            }
            catch (ParseException pe) {
                LogHolder.log(4, LogType.MISC, "Could not parse the TC node:", pe);
            }
            catch (SignatureException se) {
                LogHolder.log(4, LogType.MISC, "Terms and Condition cannot be loaded due to a wrong signature:", se);
            }
            currentTCNode = (Element)XMLUtil.getNextSiblingByName(currentTCNode, XML_ELEMENT_NAME);
        }
    }

    public String getHTMLText(Locale locale) {
        return this.getHTMLText(locale.getLanguage());
    }

    public String getHTMLText(String language) {
        Translation translation = this.getTranslation(language);
        if (translation == null) {
            translation = this.getDefaultTranslation();
        }
        return TermsAndConditions.getHTMLText(translation);
    }

    public static String getHTMLText(Translation translation) {
        try {
            if (translation == null) {
                throw new NullPointerException("Translation is null!)");
            }
            TermsAndConditionsTemplate displayTemplate = TermsAndConditionsTemplate.getById(translation.getTemplateReferenceId(), false);
            if (displayTemplate == null) {
                throw new NullPointerException("Associated template '" + translation.getTemplateReferenceId() + "' for" + " translation [" + translation.getLocale() + "] of terms and conditions for operator '" + translation.getOperator().getOrganization() + "' not found.");
            }
            return displayTemplate.transform(translation);
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.MISC, e);
            StringBuffer htmlErrorTextBuffer = new StringBuffer();
            htmlErrorTextBuffer.append("<html><head><title>");
            htmlErrorTextBuffer.append(JAPMessages.getString("error"));
            htmlErrorTextBuffer.append("</title></head><body><head><h1>");
            htmlErrorTextBuffer.append(JAPMessages.getString("error"));
            htmlErrorTextBuffer.append("</h1><h2>");
            htmlErrorTextBuffer.append(JAPMessages.getString(MSG_DISPLAY_ERROR));
            htmlErrorTextBuffer.append("</h2><p>");
            htmlErrorTextBuffer.append(e);
            htmlErrorTextBuffer.append("</p></body></html>");
            return htmlErrorTextBuffer.toString();
        }
    }

    public boolean isSignatureObsolete() {
        return false;
    }

    public boolean equals(Object anotherTC) {
        return this.operator.equals(((TermsAndConditions)anotherTC).operator);
    }

    public int compareTo(Object o) {
        TermsAndConditions otherTc = (TermsAndConditions)o;
        return this.m_date.equals(otherTc.getDate()) ? 0 : (this.m_date.before(otherTc.getDate()) ? -1 : 1);
    }

    public boolean isMostRecent(String toWhichDate) throws ParseException {
        return this.isMostRecent(new SimpleDateFormat(DATE_FORMAT).parse(toWhichDate));
    }

    public boolean isMostRecent(Date toWhichDate) {
        return this.m_date.equals(toWhichDate) || this.m_date.after(toWhichDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element xmlOut(Document doc, boolean signedTranslations) {
        Element tcRoot = this.createTCRoot(doc);
        Enumeration allTranslations = null;
        TermsAndConditions termsAndConditions = this;
        synchronized (termsAndConditions) {
            if (this.accepted) {
                XMLUtil.setAttribute(tcRoot, XML_ATTR_ACCEPTED, this.accepted);
            }
            allTranslations = this.translations.elements();
        }
        while (allTranslations.hasMoreElements()) {
            tcRoot.appendChild(signedTranslations ? ((Translation)allTranslations.nextElement()).toXmlElement(doc) : ((Translation)allTranslations.nextElement()).createXMLOutput(doc));
        }
        return tcRoot;
    }

    public Element createTCRoot(Document doc) {
        Element tcRoot = doc.createElement(XML_ELEMENT_NAME);
        XMLUtil.setAttribute(tcRoot, "id", this.operator.getId());
        XMLUtil.setAttribute(tcRoot, XML_ATTR_DATE, this.getDateString());
        return tcRoot;
    }

    public Element toXmlElement(Document doc) {
        return this.xmlOut(doc, true);
    }

    public Element createXMLOutput(Document doc) {
        return this.xmlOut(doc, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Translation
    implements IXMLEncodable {
        public static final String XML_ELEMENT_NAME = "TCTranslation";
        public static final String XML_ELEMENT_CONTAINER_NAME = "TermsAndConditions";
        public static final String XML_ELEMENT_PRIVACY_POLICY = "PrivacyPolicyUrl";
        public static final String XML_ELEMENT_LEGAL_OPINIONS = "LegalOpinionsUrl";
        public static final String XML_ELEMENT_OPERATIONAL_AGREEMENT = "OperationalAgreementUrl";
        public static final String XML_ATTR_LOCALE = "locale";
        public static final String XML_ATTR_DEFAULT_LOCALE = "default";
        public static final String XML_ATTR_REFERENCE_ID = "referenceId";
        public static final String PROPERTY_NAME_PRIVACY_POLICY = "privacyPolicyUrl";
        public static final String PROPERTY_NAME_LEGAL_OPINIONS = "legalOpinionsUrl";
        public static final String PROPERTY_NAME_OPERATIONAL_AGREEMENT = "operationalAgreementUrl";
        public static final String PROPERTY_NAME_TEMPLATE_REFERENCE_ID = "templateReferenceId";
        private String templateReferenceId;
        private String locale;
        private boolean defaultTranslation;
        private Element translationElement;
        private String privacyPolicyUrl;
        private String legalOpinionsUrl;
        private String operationalAgreementUrl;
        private OperatorAddress operatorAddress;
        private XMLSignature signature = null;
        private MultiCertPath certPath = null;
        private TCComposite sections = new TCComposite();

        public Translation(Element translationElement) throws XMLParseException {
            this(translationElement, true);
        }

        private Translation() {
        }

        public Translation(Element translationElement, boolean withAttributeCheck) throws XMLParseException {
            this.templateReferenceId = XMLUtil.parseAttribute((Node)translationElement, XML_ATTR_REFERENCE_ID, "");
            if (withAttributeCheck && this.templateReferenceId.equals("")) {
                LogHolder.log(4, LogType.MISC, "TC translation must refer to a valid TC template");
            }
            this.locale = XMLUtil.parseAttribute((Node)translationElement, XML_ATTR_LOCALE, "");
            if (withAttributeCheck && this.locale.equals("")) {
                throw new XMLParseException("TC translation must set attribute 'locale'");
            }
            this.locale = this.locale.trim().toLowerCase();
            this.setDefaultTranslation(XMLUtil.parseAttribute((Node)translationElement, XML_ATTR_DEFAULT_LOCALE, false));
            this.privacyPolicyUrl = XMLUtil.parseValue(XMLUtil.getFirstChildByName(translationElement, XML_ELEMENT_PRIVACY_POLICY), "");
            this.legalOpinionsUrl = XMLUtil.parseValue(XMLUtil.getFirstChildByName(translationElement, XML_ELEMENT_LEGAL_OPINIONS), "");
            this.operationalAgreementUrl = XMLUtil.parseValue(XMLUtil.getFirstChildByName(translationElement, XML_ELEMENT_OPERATIONAL_AGREEMENT), "");
            Element operatorElement = (Element)XMLUtil.getFirstChildByName(translationElement, "Operator");
            this.operatorAddress = operatorElement != null ? new OperatorAddress(operatorElement) : null;
            this.translationElement = translationElement;
            this.signature = SignatureVerifier.getInstance().getVerifiedXml(translationElement, 1);
            if (this.signature != null) {
                this.certPath = this.signature.getMultiCertPath();
            }
            NodeList nl = translationElement.getElementsByTagName(Section.XML_ELEMENT_NAME);
            Section currentSection = null;
            for (int i = 0; i < nl.getLength(); ++i) {
                currentSection = new Section(nl.item(i));
                this.sections.addTCComponent(currentSection);
            }
        }

        public boolean hasContent() {
            return this.sections.hasContent();
        }

        public void setTemplateReferenceId(String templateReferenceId) {
            this.templateReferenceId = templateReferenceId;
        }

        public String getTemplateReferenceId() {
            return this.templateReferenceId;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public String getLocale() {
            return this.locale;
        }

        public boolean isDefaultTranslation() {
            return this.defaultTranslation;
        }

        public void setDefaultTranslation(boolean defaultTranslation) {
            this.defaultTranslation = defaultTranslation;
            if (defaultTranslation) {
                if (TermsAndConditions.this.defaultTl != null) {
                    TermsAndConditions.this.defaultTl.setDefaultTranslation(false);
                }
                TermsAndConditions.this.defaultTl = this;
            }
        }

        public Element getTranslationElement() {
            return this.translationElement != null ? (Element)this.translationElement.cloneNode(true) : null;
        }

        public XMLSignature getSignature() {
            return this.signature;
        }

        public MultiCertPath getCertPath() {
            return this.certPath;
        }

        public boolean isVerified() {
            return this.signature != null ? this.signature.isVerified() : false;
        }

        public boolean isValid() {
            return this.certPath != null ? this.certPath.isValid(new Date()) : false;
        }

        public boolean checkId() {
            return this.certPath != null ? this.certPath.getPath().getSecondCertificate().getSubjectKeyIdentifierConcatenated().equals(this.getOperator().getId()) : false;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TermsAndConditionsTranslation)) {
                return false;
            }
            return this.locale.equals(((Translation)obj).locale);
        }

        public Element toXmlElement(Document a_doc) {
            if (a_doc.equals(this.translationElement.getOwnerDocument())) {
                return this.translationElement;
            }
            try {
                return (Element)XMLUtil.importNode(a_doc, this.translationElement, true);
            }
            catch (XMLParseException a_e) {
                return null;
            }
        }

        public Element createXMLOutput(Document doc) {
            Element root = doc.createElement("TCTranslation");
            root.setAttribute(XML_ATTR_REFERENCE_ID, this.templateReferenceId);
            root.setAttribute(XML_ATTR_LOCALE, this.locale);
            if (this.defaultTranslation) {
                root.setAttribute(XML_ATTR_DEFAULT_LOCALE, "true");
            }
            if (this.privacyPolicyUrl != null && !this.privacyPolicyUrl.equals("")) {
                XMLUtil.createChildElementWithValue(root, XML_ELEMENT_PRIVACY_POLICY, this.privacyPolicyUrl);
            }
            if (this.legalOpinionsUrl != null && !this.legalOpinionsUrl.equals("")) {
                XMLUtil.createChildElementWithValue(root, XML_ELEMENT_LEGAL_OPINIONS, this.legalOpinionsUrl);
            }
            if (this.operationalAgreementUrl != null && !this.operationalAgreementUrl.equals("")) {
                XMLUtil.createChildElementWithValue(root, XML_ELEMENT_OPERATIONAL_AGREEMENT, this.operationalAgreementUrl);
            }
            if (this.operatorAddress != null) {
                Enumeration e = this.operatorAddress.getAddressAsNodeList(doc);
                Element operatorAddressRoot = null;
                if (e.hasMoreElements()) {
                    operatorAddressRoot = doc.createElement("Operator");
                    root.appendChild(operatorAddressRoot);
                }
                while (e.hasMoreElements()) {
                    operatorAddressRoot.appendChild((Element)e.nextElement());
                }
            }
            if (this.sections != null) {
                TCComponent[] allSects = this.sections.getTCComponents();
                Element currentSectionElement = null;
                for (int i = 0; i < allSects.length; ++i) {
                    currentSectionElement = ((Section)allSects[i]).toXmlElement(doc, true);
                    if (currentSectionElement == null) continue;
                    root.appendChild(currentSectionElement);
                }
            }
            return root;
        }

        public void setOperatorAddress(OperatorAddress operatorAddress) {
            this.operatorAddress = operatorAddress;
        }

        public OperatorAddress getOperatorAddress() {
            return this.operatorAddress;
        }

        public String toString() {
            return new Locale(this.locale, "").getDisplayLanguage(JAPMessages.getLocale()) + (this.defaultTranslation ? " (default)" : "");
        }

        public Date getDate() {
            return TermsAndConditions.this.getDate();
        }

        public ServiceOperator getOperator() {
            return TermsAndConditions.this.operator;
        }

        public String getPrivacyPolicyUrl() {
            return this.privacyPolicyUrl;
        }

        public void setPrivacyPolicyUrl(String privacyPolicyUrl) {
            this.privacyPolicyUrl = privacyPolicyUrl;
        }

        public String getLegalOpinionsUrl() {
            return this.legalOpinionsUrl;
        }

        public void setLegalOpinionsUrl(String legalOpinionsUrl) {
            this.legalOpinionsUrl = legalOpinionsUrl;
        }

        public String getOperationalAgreementUrl() {
            return this.operationalAgreementUrl;
        }

        public void setOperationalAgreementUrl(String operationalAgreementUrl) {
            this.operationalAgreementUrl = operationalAgreementUrl;
        }

        public void setSections(TCComposite sections) {
            this.sections = sections;
        }

        public TCComposite getSections() {
            return (TCComposite)this.sections.clone();
        }
    }
}

