/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.ListenerInterface;
import anon.proxy.DirectProxy;
import anon.proxy.DirectProxyResponse;
import anon.shared.ProxyConnection;
import anon.util.Util;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import logging.LogHolder;
import logging.LogType;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

final class DirectProxyConnection {
    private Socket m_clientSocket;
    private InputStream m_socketInputStream;
    private int m_threadNumber;
    private static int m_threadCount;
    private InputStream m_inputStream = null;
    private String m_requestLine = null;
    private String m_strMethod = "";
    private String m_strURI = "";
    private String m_strProtocol = "";
    private String m_strVersion = "";
    private String m_strHost = "";
    private String m_strFile = "";
    private int m_iPort = -1;
    private static DateFormat m_DateFormat;
    private static NumberFormat m_NumberFormat;
    private DirectProxy m_parentProxy;
    private static final Object SYNC_SINGLE_CONNECTION;

    public DirectProxyConnection(Socket a_clientSocket, InputStream a_socketInputStream, DirectProxy a_parentProxy) {
        this.m_parentProxy = a_parentProxy;
        this.m_clientSocket = a_clientSocket;
        this.m_socketInputStream = a_socketInputStream;
        this.handleRequest(null);
    }

    private static String readLine(InputStream inputStream, byte[] r_bytesRead, int[] len) throws Exception {
        String returnString = "";
        len[0] = 0;
        int byteRead = inputStream.read();
        if (r_bytesRead.length > len[0]) {
            r_bytesRead[len[0]] = (byte)byteRead;
            len[0] = len[0] + 1;
        }
        while (byteRead != 10 && byteRead != -1) {
            if (byteRead != 13) {
                returnString = returnString + (char)byteRead;
            }
            if (inputStream.available() <= 0) {
                return null;
            }
            byteRead = inputStream.read();
            if (r_bytesRead.length <= len[0]) continue;
            r_bytesRead[len[0]] = (byte)byteRead;
            len[0] = len[0] + 1;
        }
        return returnString;
    }

    public static String readLine(InputStream inputStream) throws Exception {
        String returnString = "";
        int byteRead = inputStream.read();
        while (byteRead != 10 && byteRead != -1) {
            if (byteRead != 13) {
                returnString = returnString + (char)byteRead;
            }
            byteRead = inputStream.read();
        }
        return returnString;
    }

    public static DirectProxy.RequestInfo getURI(PushbackInputStream a_inputStream, int a_bufferLength) {
        if (a_inputStream == null) {
            return null;
        }
        DirectProxy.RequestInfo info = null;
        DataInputStream inputStream = new DataInputStream(a_inputStream);
        byte[] buffer = new byte[a_bufferLength];
        int[] len = new int[]{0};
        try {
            String requestLine = DirectProxyConnection.readLine(inputStream, buffer, len);
            if (requestLine == null) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(requestLine);
            String strMethod = st.nextToken();
            info = DirectProxy.parseDomain(st.nextToken(), true, strMethod);
        }
        catch (Exception ex) {
            LogHolder.log(3, LogType.NET, ex);
            return null;
        }
        if (len[0] > 0) {
            try {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream dataOut = new DataOutputStream(outBytes);
                dataOut.write(buffer, 0, len[0]);
                dataOut.flush();
                a_inputStream.unread(outBytes.toByteArray());
            }
            catch (Exception ex1) {
                LogHolder.log(2, LogType.NET, "Could not unread request line!", ex1);
            }
        }
        return info;
    }

    private void handleRequest(InputStream a_inputStream) {
        this.m_threadNumber = this.getThreadNumber();
        LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - New connection handler started.");
        try {
            this.m_inputStream = a_inputStream != null ? a_inputStream : (this.m_socketInputStream != null ? new DataInputStream(this.m_socketInputStream) : new DataInputStream(this.m_clientSocket.getInputStream()));
            this.m_requestLine = DirectProxyConnection.readLine(this.m_inputStream);
            LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - RequestLine: >" + this.m_requestLine + "<");
            StringTokenizer st = new StringTokenizer(this.m_requestLine);
            this.m_strMethod = st.nextToken();
            this.m_strURI = st.nextToken();
            if (st.hasMoreTokens()) {
                this.m_strVersion = st.nextToken();
            }
        }
        catch (Exception e) {
            this.badRequest();
            return;
        }
        try {
            if (this.m_strMethod.equalsIgnoreCase("CONNECT")) {
                int idx = this.m_strURI.indexOf(58);
                if (idx > 0) {
                    this.m_strHost = this.m_strURI.substring(0, idx);
                    this.m_iPort = Integer.parseInt(this.m_strURI.substring(idx + 1));
                    this.handleCONNECT();
                } else {
                    this.badRequest();
                }
            } else if (this.m_strMethod.equalsIgnoreCase("GET") || this.m_strMethod.equalsIgnoreCase("POST") || this.m_strMethod.equalsIgnoreCase("PUT") || this.m_strMethod.equalsIgnoreCase("DELETE") || this.m_strMethod.equalsIgnoreCase("TRACE") || this.m_strMethod.equalsIgnoreCase("OPTIONS") || this.m_strMethod.equalsIgnoreCase("HEAD")) {
                URL url = new URL(this.m_strURI);
                this.m_strProtocol = url.getProtocol();
                this.m_strHost = url.getHost();
                this.m_iPort = url.getPort();
                if (this.m_iPort == -1) {
                    this.m_iPort = 80;
                }
                this.m_strFile = url.getFile();
                if (this.m_strProtocol.equalsIgnoreCase("http")) {
                    this.handleHTTP(this.m_strMethod.equalsIgnoreCase("POST"));
                } else if (this.m_strProtocol.equalsIgnoreCase("ftp")) {
                    this.handleFTP();
                } else {
                    this.unknownProtocol();
                }
            } else {
                this.badRequest();
            }
        }
        catch (UnknownHostException uho) {
            this.cannotConnect();
        }
        catch (Exception ioe) {
            LogHolder.log(5, LogType.NET, "C(" + this.m_threadNumber + ")", ioe);
            this.badRequest();
        }
        try {
            this.m_clientSocket.close();
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.NET, "C(" + this.m_threadNumber + ") - Exception while closing socket: " + e);
        }
    }

    private void responseTemplate(String error, String message) {
        try {
            BufferedWriter toClient = new BufferedWriter(new OutputStreamWriter(this.m_clientSocket.getOutputStream()));
            toClient.write("HTTP/1.0 " + error + "\r\n");
            toClient.write("Content-type: text/html\r\n");
            toClient.write("Pragma: no-cache\r\n");
            toClient.write("Cache-Control: no-cache\r\n\r\n");
            toClient.write("<HTML><TITLE>" + message + "</TITLE>");
            toClient.write("<H1>" + error + "</H1>");
            toClient.write("<P>" + message + "</P>");
            toClient.write("</HTML>\n");
            toClient.flush();
            toClient.close();
        }
        catch (SocketException a_e) {
            LogHolder.log(6, LogType.NET, "C(" + this.m_threadNumber + ") - Exception: ", a_e);
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.NET, "C(" + this.m_threadNumber + ") - Exception: ", e);
        }
    }

    private void cannotConnect() {
        this.responseTemplate("404 Connection error", "Cannot connect to " + this.m_strHost + ":" + this.m_iPort + ".");
    }

    private void unknownProtocol() {
        this.responseTemplate("501 Not implemented", "Protocol <B>" + this.m_strProtocol + "</B> not implemented, supported or unknown.");
    }

    private void badRequest() {
        this.responseTemplate("400 Bad Request", "Bad request: " + this.m_requestLine);
    }

    private void handleCONNECT() throws Exception {
        int len;
        ProxyConnection proxyConnection = new ProxyConnection(HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(this.m_strHost, this.m_iPort), this.m_parentProxy.getProxyInterface()).Connect());
        Socket serverSocket = proxyConnection.getSocket();
        String nextLine = DirectProxyConnection.readLine(this.m_inputStream);
        LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - Header: >" + nextLine + "<");
        while (nextLine.length() != 0) {
            nextLine = DirectProxyConnection.readLine(this.m_inputStream);
            LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - Header: >" + nextLine + "<");
        }
        OutputStream outputStream = serverSocket.getOutputStream();
        BufferedWriter toClient = new BufferedWriter(new OutputStreamWriter(this.m_clientSocket.getOutputStream()));
        toClient.write("HTTP/1.0 200 Connection established\r\n\r\n");
        toClient.flush();
        DirectProxyResponse pr = new DirectProxyResponse(serverSocket.getInputStream(), this.m_clientSocket.getOutputStream());
        Thread prt = new Thread((Runnable)pr, "JAP - DirectProxyResponse");
        prt.setDaemon(true);
        prt.start();
        byte[] buff = new byte[1000];
        while ((len = this.m_inputStream.read(buff)) != -1) {
            if (len <= 0) continue;
            outputStream.write(buff, 0, len);
            outputStream.flush();
        }
        LogHolder.log(7, LogType.NET, "\n");
        LogHolder.log(7, LogType.MISC, "C(" + this.m_threadNumber + ") - Waiting for resonse thread...");
        prt.join();
        LogHolder.log(7, LogType.MISC, "C(" + this.m_threadNumber + ") -                           ...finished!");
        toClient.close();
        outputStream.close();
        this.m_inputStream.close();
        serverSocket.close();
    }

    private void handleHTTP(boolean a_bPost) throws Exception {
        Exception ex = null;
        Socket serverSocket = null;
        OutputStream outputStream = null;
        boolean bKeepStream = false;
        try {
            ProxyConnection proxyConnection = null;
            proxyConnection = new ProxyConnection(HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(this.m_strHost, this.m_iPort), this.m_parentProxy.getProxyInterface()).Connect());
            serverSocket = proxyConnection.getSocket();
            outputStream = serverSocket.getOutputStream();
            String protocolString = "";
            protocolString = protocolString + this.m_strMethod + " " + this.m_strFile + " " + "HTTP/1.0";
            LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - ProtocolString: >" + protocolString + "<");
            outputStream.write((protocolString + "\r\n").getBytes());
            String nextLine = DirectProxyConnection.readLine(this.m_inputStream);
            LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - Header: >" + nextLine + "<");
            long lPostContentLength = 0L;
            int i = 0;
            while (nextLine.length() != 0) {
                ++i;
                if (!this.filter(nextLine)) {
                    if (a_bPost && nextLine.toLowerCase().indexOf("content-length:") >= 0) {
                        StringTokenizer tokenizer = new StringTokenizer(nextLine, ":");
                        tokenizer.nextToken();
                        if (tokenizer.hasMoreTokens()) {
                            try {
                                lPostContentLength = Long.parseLong(tokenizer.nextToken().trim());
                            }
                            catch (Exception a_e) {
                                LogHolder.log(2, LogType.NET, "Could not parse post content length!", a_e);
                            }
                        }
                    }
                    outputStream.write((nextLine.trim() + "\r\n").getBytes());
                } else {
                    LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - Header " + nextLine + " filtered");
                }
                nextLine = DirectProxyConnection.readLine(this.m_inputStream);
                LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - Header: >" + nextLine + "<");
            }
            outputStream.write("\r\n".getBytes());
            outputStream.flush();
            DirectProxyResponse pr = new DirectProxyResponse(serverSocket.getInputStream(), this.m_clientSocket.getOutputStream());
            Thread prt = new Thread((Runnable)pr, "JAP - DirectProxyResponse");
            prt.start();
            LogHolder.log(7, LogType.NET, "C(" + this.m_threadNumber + ") - Headers sent, POST data may follow");
            byte[] buff = new byte[1000];
            final PushbackInputStream isPushback = new PushbackInputStream(this.m_inputStream, 1000);
            try {
                int len;
                while ((len = isPushback.read(buff)) != -1) {
                    int writeLen = len;
                    if (lPostContentLength > 0L) {
                        if ((long)len <= lPostContentLength) {
                            lPostContentLength -= (long)len;
                        } else {
                            writeLen = (int)lPostContentLength;
                            LogHolder.log(4, LogType.NET, "Overbuffered POST: " + (len - writeLen));
                            isPushback.unread(buff, writeLen, len - writeLen);
                            lPostContentLength = 0L;
                        }
                    } else {
                        String strPossibleRequest = new String(buff, 0, len).toUpperCase();
                        if (strPossibleRequest.startsWith("GET") || strPossibleRequest.startsWith("POST") || strPossibleRequest.startsWith("HEAD") || strPossibleRequest.startsWith("PUT") || strPossibleRequest.startsWith("DELETE") || strPossibleRequest.startsWith("TRACE") || strPossibleRequest.startsWith("OPTIONS") || strPossibleRequest.startsWith("CONNECT")) {
                            isPushback.unread(buff, 0, len);
                            Thread thread = new Thread(new Runnable(){

                                public void run() {
                                    DirectProxyConnection.this.handleRequest(isPushback);
                                }
                            });
                            thread.start();
                            bKeepStream = true;
                            break;
                        }
                    }
                    if (writeLen <= 0) continue;
                    outputStream.write(buff, 0, writeLen);
                    outputStream.flush();
                }
            }
            catch (SocketException a_e) {
                LogHolder.log(7, LogType.NET, "Socket seams to be closed.");
            }
            LogHolder.log(7, LogType.MISC, "C(" + this.m_threadNumber + ") - Waiting for resonse thread...");
            prt.join();
            LogHolder.log(7, LogType.MISC, "C(" + this.m_threadNumber + ") -                  ...finished!");
        }
        catch (Exception e) {
            ex = e;
        }
        Util.closeStream(outputStream);
        if (!bKeepStream) {
            Util.closeStream(this.m_inputStream);
        }
        try {
            serverSocket.close();
        }
        catch (Exception a_e) {
            // empty catch block
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void handleFTP() {
        FTPClient ftpClient = null;
        OutputStream os = null;
        try {
            String end = "</pre></body></html>";
            String endInfo = "</pre></h4><hr><pre>";
            os = this.m_clientSocket.getOutputStream();
            ftpClient = new FTPClient();
            ftpClient.setDefaultTimeout(30000);
            ftpClient.connect(this.m_strHost);
            ftpClient.setSoTimeout(30000);
            ftpClient.setDataTimeout(30000);
            ftpClient.login("anonymous", "JAP@xxx.com");
            ftpClient.enterLocalPassiveMode();
            if (ftpClient.changeWorkingDirectory(this.m_strFile)) {
                ftpClient.changeToParentDirectory();
                String parentDir = ftpClient.printWorkingDirectory();
                String URL2 = this.m_strURI;
                if (!URL2.endsWith("/")) {
                    URL2 = URL2 + "/";
                }
                os.write("HTTP/1.0 200 Ok\n\rContent-Type: text/html\r\n\r\n<html><head><title>FTP directory at ".getBytes());
                os.write(URL2.getBytes());
                os.write("</title></head><body><h2>FTP directory at ".getBytes());
                os.write(URL2.getBytes());
                os.write(("</h2><hr><pre> DIR  | <A HREF=\"" + parentDir + "\">..</A>\n").getBytes());
                FTPFile[] remoteFiles = ftpClient.listFiles(this.m_strFile);
                if (remoteFiles == null) {
                    os.write(("No files in Directory!\nServer replied:\n" + ftpClient.getReplyString()).getBytes());
                } else {
                    int iMaxFileNameLen = 0;
                    for (int i = 0; i < remoteFiles.length; ++i) {
                        if (remoteFiles[i].getName().length() > iMaxFileNameLen) {
                            iMaxFileNameLen = remoteFiles[i].getName().length();
                        }
                        for (int j = i + 1; j < remoteFiles.length; ++j) {
                            if (!remoteFiles[i].isFile() || remoteFiles[j].isFile()) continue;
                            FTPFile tmp = remoteFiles[i];
                            remoteFiles[i] = remoteFiles[j];
                            remoteFiles[j] = tmp;
                        }
                    }
                    StringBuffer help = new StringBuffer(256);
                    for (int i = 0; i < remoteFiles.length; ++i) {
                        String strName = remoteFiles[i].getName();
                        if (strName.equals(".") || strName.equals("..")) continue;
                        String strLen = m_NumberFormat.format(remoteFiles[i].getSize());
                        strLen = "            " + strLen;
                        strLen = strLen.substring(strLen.length() - 12);
                        strName = remoteFiles[i].getName() + "</A>                                        ";
                        strName = strName.substring(0, Math.min(iMaxFileNameLen + 5, strName.length() - 1));
                        if (remoteFiles[i].isDirectory() || remoteFiles[i].isSymbolicLink()) {
                            help.append(" DIR  | ");
                            help.append("<a href=\"");
                            help.append(URL2);
                            if (remoteFiles[i].isSymbolicLink()) {
                                help.append(remoteFiles[i].getLink());
                            } else {
                                help.append(remoteFiles[i].getName());
                            }
                            help.append("/\"><b>");
                            help.append(strName);
                            help.append("</b></a>\n");
                        } else {
                            help.append(" FILE | ");
                            help.append("<a href=\"");
                            help.append(URL2);
                            help.append(remoteFiles[i].getName());
                            help.append("\">");
                            help.append(strName);
                            help.append(" | ");
                            help.append(strLen + " | " + m_DateFormat.format(remoteFiles[i].getTimestamp().getTime()) + "\n");
                        }
                        os.write(help.toString().getBytes());
                        help.setLength(0);
                    }
                }
                os.write(end.getBytes());
            } else {
                ftpClient.setFileType(2);
                FTPFile[] currentResponses = ftpClient.listFiles(this.m_strFile);
                long len = currentResponses[0].getSize();
                os.write(("HTTP/1.0 200 Ok\r\nContent-Type: application/octet-stream\r\nContent-Length: " + Long.toString(len) + "\r\n\r\n").getBytes());
                ftpClient.retrieveFile(this.m_strFile, os);
            }
            os.flush();
            ftpClient.disconnect();
            os.close();
            os = null;
        }
        catch (Exception e) {
            LogHolder.log(5, LogType.NET, "C(" + this.m_threadNumber + ") - Exception in handleFTP()!", e);
            try {
                ftpClient.disconnect();
                os.flush();
                os.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private boolean filter(String l) {
        String[] cmp = new String[]{"Proxy-Connection", "Pragma", "Connection"};
        for (int i = 0; i < cmp.length; ++i) {
            if (!l.regionMatches(true, 0, cmp[i], 0, cmp[i].length())) continue;
            return true;
        }
        return false;
    }

    private synchronized int getThreadNumber() {
        return m_threadCount++;
    }

    static {
        m_DateFormat = DateFormat.getDateTimeInstance();
        m_NumberFormat = NumberFormat.getInstance();
        SYNC_SINGLE_CONNECTION = new Object();
    }
}

