/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.infoservice.IBrowserIdentification;
import anon.infoservice.InfoServiceDBEntry;
import anon.proxy.AbstractJonDoFoxHeaders;
import anon.proxy.HTTPConnectionEvent;
import anon.proxy.HTTPProxyCallback;

public class BrowserIdentification
extends AbstractJonDoFoxHeaders
implements IBrowserIdentification {
    private static final int BROWSER_RECOGNITION_UNINITIALISED = -1;
    private static final int BROWSER_UNKNOWN = 0;
    private static final int BROWSER_TORBUTTON = 1;
    private static final int BROWSER_JONDOFOX = 2;
    private static final int BROWSER_INTERNET_EXPLORER = 3;
    private static final int BROWSER_FIREFOX = 4;
    private static final int BROWSER_OPERA = 5;
    private static final int BROWSER_SAFARI = 6;
    private static final int BROWSER_KONQUEROR = 7;
    private static final int BROWSER_CHROME = 8;
    private static final long[] BROWSER_OCCURENCE = new long[9];
    private static final String[] BROWSER_NAME = new String[]{"other", "Tor", "JonDoFox", "Internet Explorer", "Firefox", "Opera", "Safari", "Konqueror", "Chrome"};
    private static boolean ms_bTestShown = false;
    private static boolean ms_bDetectedBrowser = false;

    public BrowserIdentification(int a_priority) {
        super(a_priority);
        InfoServiceDBEntry.setBrowserIdentification(this);
    }

    public boolean isBlockable() {
        return false;
    }

    public int getMostFrequentBrowser() {
        int iBrowser = -1;
        long iOccurence = 0L;
        for (int i = 0; i < BROWSER_OCCURENCE.length; ++i) {
            if (BROWSER_OCCURENCE[i] <= iOccurence) continue;
            iOccurence = BROWSER_OCCURENCE[i];
            iBrowser = i;
        }
        return iBrowser;
    }

    public String getBrowserName() {
        int browser = this.getMostFrequentBrowser();
        if (browser == -1) {
            return null;
        }
        return BROWSER_NAME[browser];
    }

    public boolean isJonDoFoxDetected() {
        return BROWSER_OCCURENCE[2] > 0L;
    }

    public void responseHeadersReceived(HTTPConnectionEvent event) {
    }

    public void downstreamContentBytesReceived(HTTPConnectionEvent event) {
    }

    public void upstreamContentBytesReceived(HTTPConnectionEvent event) {
    }

    public void requestHeadersReceived(HTTPConnectionEvent event) {
        if (event == null) {
            return;
        }
        HTTPProxyCallback.HTTPConnectionHeader connHeader = event.getConnectionHeader();
        if (connHeader != null) {
            if (connHeader.getRequestLine().startsWith("CONNECT")) {
                return;
            }
            this.countBrowserType(event, this.checkJonDoFox(event));
        }
    }

    private void countBrowserType(HTTPConnectionEvent event, boolean a_bJonDoFox) {
        if (a_bJonDoFox) {
            BrowserIdentification.BROWSER_OCCURENCE[2] = 1L;
            ms_bDetectedBrowser = true;
            return;
        }
        if (ms_bDetectedBrowser && !ms_bTestShown && HTTPProxyCallback.isAnonymityTestDomain(event.getConnectionHeader())) {
            ms_bTestShown = true;
        }
        if (!ms_bTestShown && BROWSER_OCCURENCE[2] == 0L && !event.getConnectionHeader().getRequestLine().startsWith("CONNECT")) {
            int detectedBrowser = -1;
            String[] ua = event.getConnectionHeader().getRequestHeader("User-Agent");
            if (ua != null && ua.length > 0) {
                String strUA = ua[0].toLowerCase();
                if (strUA.indexOf("firefox") >= 0) {
                    detectedBrowser = ua[0].equals("Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.3) Gecko/20100401 Firefox/3.6.3") || ua[0].equals("Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.0.7) Gecko/2009021910 Firefox/3.0.7") ? 1 : 4;
                } else if (strUA.indexOf("msie") >= 0) {
                    detectedBrowser = 3;
                } else if (strUA.indexOf("opera") >= 0) {
                    detectedBrowser = 5;
                } else if (strUA.indexOf("chrome") >= 0) {
                    detectedBrowser = 8;
                } else if (strUA.indexOf("konqueror") >= 0) {
                    detectedBrowser = 7;
                } else if (strUA.indexOf("safari") >= 0) {
                    detectedBrowser = 6;
                } else if (strUA.indexOf("httpclient") < 0) {
                    detectedBrowser = 0;
                }
                if (detectedBrowser > -1) {
                    ms_bDetectedBrowser = true;
                    int n = detectedBrowser;
                    BROWSER_OCCURENCE[n] = BROWSER_OCCURENCE[n] + 1L;
                }
            }
            if (detectedBrowser > 2 && BROWSER_OCCURENCE[detectedBrowser] > 40L) {
                event.getAnonRequest().showBrowserWarning(true);
            }
        }
    }
}

