/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import HTTPClient.ForbiddenIOException;
import anon.AnonServerDescription;
import anon.crypto.ByteSignature;
import anon.crypto.IMyPrivateKey;
import anon.crypto.XMLSignature;
import anon.crypto.tinytls.TinyTLS;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.IProxyInterfaceGetter;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.pay.HttpClient;
import anon.pay.IBIConnectionListener;
import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLAccountCertificate;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLChallenge;
import anon.pay.xml.XMLErrorMessage;
import anon.pay.xml.XMLGenericStrings;
import anon.pay.xml.XMLGenericText;
import anon.pay.xml.XMLJapPublicKey;
import anon.pay.xml.XMLPassivePayment;
import anon.pay.xml.XMLPaymentOptions;
import anon.pay.xml.XMLPaymentSettings;
import anon.pay.xml.XMLResponse;
import anon.pay.xml.XMLTransCert;
import anon.pay.xml.XMLTransactionOverview;
import anon.pay.xml.XMLVolumePlans;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import anon.util.captcha.ICaptchaSender;
import anon.util.captcha.IImageEncodedCaptcha;
import anon.util.captcha.ZipBinaryImageCaptchaClient;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BIConnection
implements ICaptchaSender {
    public static final int TIMEOUT_DEFAULT = 40000;
    public static final int TIMEOUT_MAX = 100000;
    public static final int TIMEOUT_MIN = 1000;
    public static final String XML_ATTR_CONNECTION_TIMEOUT = "timeout";
    private static int ms_connectionTimeout = 40000;
    private PaymentInstanceDBEntry m_theBI;
    private Socket m_socket;
    private HttpClient m_httpClient;
    private Vector m_biConnectionListeners;
    private byte[] m_captchaSolution;
    private boolean m_bSendNewCaptcha;
    private boolean m_bFirstCaptcha = true;
    private static IMutableProxyInterface ms_proxyInterface = new IMutableProxyInterface.DummyMutableProxyInterface();

    public BIConnection(PaymentInstanceDBEntry theBI) {
        if (theBI == null) {
            throw new IllegalArgumentException("PI is null! No connection is possibble.");
        }
        this.m_theBI = theBI;
        this.m_biConnectionListeners = new Vector();
    }

    public static void setConnectionTimeout(int a_timeout) {
        ms_connectionTimeout = a_timeout > 1000 ? (a_timeout > 100000 ? 100000 : a_timeout) : 1000;
    }

    public static int getConnectionTimeout() {
        return ms_connectionTimeout;
    }

    public static void setMutableProxyInterface(IMutableProxyInterface a_proxyInterface) {
        if (a_proxyInterface != null) {
            ms_proxyInterface = a_proxyInterface;
        }
    }

    public void connect() throws IOException {
        this.connect(ms_connectionTimeout);
    }

    public void connect(int a_connectionTimeout) throws IOException {
        IOException exception = new IOException("No valid proxy available");
        boolean bAnonProxy = false;
        for (int i = 0; i < 2 && !Thread.currentThread().isInterrupted(); ++i) {
            IProxyInterfaceGetter proxyInterfaceGetter;
            if (i == 1) {
                bAnonProxy = true;
            }
            if ((proxyInterfaceGetter = ms_proxyInterface.getProxyInterface(bAnonProxy)) == null) continue;
            ImmutableProxyInterface proxyInterface = proxyInterfaceGetter.getProxyInterface();
            if (bAnonProxy && proxyInterface == null) continue;
            try {
                this.connect_internal(proxyInterface, a_connectionTimeout);
                return;
            }
            catch (IOException a_t) {
                exception = a_t;
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException("Thread interrupted while connecting to payment instance.");
        }
        throw exception;
    }

    private void connect_internal(ImmutableProxyInterface a_proxy, int a_connectionTimeout) throws IOException {
        boolean bForbidden = false;
        TinyTLS tls = null;
        ListenerInterface li = null;
        boolean connected = false;
        Enumeration listeners = this.m_theBI.getListenerInterfaces();
        while (listeners.hasMoreElements()) {
            li = (ListenerInterface)listeners.nextElement();
            LogHolder.log(7, LogType.PAY, "Trying to connect to Payment Instance at " + li.getHost() + ":" + li.getPort() + ".");
            try {
                if (a_proxy == null || !a_proxy.isValid()) {
                    tls = new TinyTLS(li.getHost(), li.getPort());
                } else {
                    LogHolder.log(6, LogType.PAY, "Using proxy at " + a_proxy.getHost() + ":" + a_proxy.getPort());
                    tls = new TinyTLS(li.getHost(), li.getPort(), a_proxy);
                }
                this.m_socket = tls;
                if (a_connectionTimeout < 1000 || a_connectionTimeout > 100000) {
                    tls.setSoTimeout(ms_connectionTimeout);
                } else {
                    tls.setSoTimeout(a_connectionTimeout);
                }
                if (this.m_theBI.getCertPath().getFirstVerifiedPath() == null) {
                    // empty if block
                }
                tls.setRootKey(this.m_theBI.getCertPath().getFirstVerifiedPath().getFirstCertificate().getPublicKey());
                tls.startHandshake();
                this.m_httpClient = new HttpClient(this.m_socket);
                connected = true;
                break;
            }
            catch (Exception e) {
                if (this.m_httpClient != null) {
                    try {
                        this.m_httpClient.close();
                    }
                    catch (Exception ex) {
                        LogHolder.log(3, LogType.NET, ex);
                    }
                } else if (this.m_socket != null) {
                    try {
                        this.m_socket.close();
                    }
                    catch (IOException a_e) {
                        LogHolder.log(3, LogType.NET, a_e);
                    }
                }
                if (e instanceof ForbiddenIOException) {
                    bForbidden = true;
                }
                if (listeners.hasMoreElements()) {
                    LogHolder.log(3, LogType.NET, "Could not connect to Payment Instance at " + li.getHost() + ":" + li.getPort() + ". Trying next interface...", e);
                    continue;
                }
                LogHolder.log(2, LogType.NET, "Could not connect to Payment Instance at " + li.getHost() + ":" + li.getPort() + ". No more interfaces left.", e);
            }
        }
        if (!connected) {
            String error = "Could not connect to Payment Instance";
            if (bForbidden) {
                throw new ForbiddenIOException(error);
            }
            throw new IOException(error);
        }
        LogHolder.log(6, LogType.PAY, "Connected to Payment Instance at " + li.getHost() + ":" + li.getPort() + ".", 1);
    }

    public void disconnect() {
        try {
            if (this.m_httpClient != null) {
                this.m_httpClient.close();
            }
        }
        catch (Exception a_e) {
            LogHolder.log(3, LogType.PAY, a_e);
        }
    }

    public XMLTransCert charge(XMLGenericStrings parameters) throws Exception {
        this.m_httpClient.writeRequest("POST", "charge", XMLUtil.toString(parameters.toXmlElement(XMLUtil.createDocument())));
        Document doc = this.m_httpClient.readAnswer();
        XMLTransCert cert = new XMLTransCert(doc);
        if (!XMLSignature.verifyFast((Node)doc, this.m_theBI.getCertPath().getEndEntityKeys())) {
            throw new Exception("The BI's signature under the transfer certificate is invalid");
        }
        cert.setReceivedDate(new Date());
        return cert;
    }

    public XMLErrorMessage buyFlatrate(PayAccount a_account) throws Exception {
        this.m_httpClient.writeRequest("POST", "buyflat", new Long(a_account.getAccountNumber()).toString());
        Document doc = this.m_httpClient.readAnswer();
        XMLErrorMessage messageReturned = new XMLErrorMessage(doc, a_account, (AnonServerDescription)null);
        return messageReturned;
    }

    public XMLAccountInfo getAccountInfo(PayAccount a_account) throws Exception {
        this.m_httpClient.writeRequest("GET", "balance", null);
        return this.getAccountInfo(this.m_httpClient.readAnswer(), a_account);
    }

    private XMLAccountInfo getAccountInfo(Document doc, PayAccount a_account) throws Exception {
        if (doc.getDocumentElement().getTagName().equals("ErrorMessage")) {
            XMLErrorMessage error = new XMLErrorMessage(doc, a_account, (AnonServerDescription)null);
            if (error.getErrorCode() == 4) {
                // empty if block
            }
            throw error;
        }
        XMLAccountInfo info = new XMLAccountInfo(doc);
        XMLBalance bal = info.getBalance();
        if (!XMLSignature.verifyFast((Node)XMLUtil.toXMLDocument(bal), this.m_theBI.getCertPath().getEndEntityKeys())) {
            throw new Exception("The BI's signature under the balance certificate is Invalid!");
        }
        return info;
    }

    protected XMLAccountInfo requestMonthlyOverusage(double a_dOverusageFactor, PayAccount a_account) throws Exception {
        this.m_httpClient.writeRequest("GET", "overusage/" + a_dOverusageFactor + "/time/" + System.currentTimeMillis(), null);
        return this.getAccountInfo(this.m_httpClient.readAnswer(), a_account);
    }

    public XMLPaymentOptions getPaymentOptions() throws Exception {
        this.m_httpClient.writeRequest("GET", "paymentoptions", null);
        Document doc = this.m_httpClient.readAnswer();
        XMLPaymentOptions options = new XMLPaymentOptions(doc);
        return options;
    }

    public XMLVolumePlans getVolumePlans() throws Exception {
        this.m_httpClient.writeRequest("GET", "volumeplans", null);
        Document doc = this.m_httpClient.readAnswer();
        XMLVolumePlans plans = new XMLVolumePlans(doc);
        return plans;
    }

    public XMLGenericText getTerms(String lang) throws Exception {
        XMLGenericText terms;
        this.m_httpClient.writeRequest("POST", "terms", lang);
        Document doc = this.m_httpClient.readAnswer();
        try {
            terms = new XMLGenericText(doc);
        }
        catch (Exception e) {
            return null;
        }
        return terms;
    }

    public XMLGenericText getCancellationPolicy(String lang) throws Exception {
        XMLGenericText policy;
        this.m_httpClient.writeRequest("POST", "cancellationpolicy", lang);
        Document doc = this.m_httpClient.readAnswer();
        try {
            policy = new XMLGenericText(doc);
        }
        catch (Exception e) {
            return null;
        }
        return policy;
    }

    public XMLPaymentSettings getPaymentSettings() throws Exception {
        this.m_httpClient.writeRequest("GET", "paymentsettings", null);
        Document doc = this.m_httpClient.readAnswer();
        return new XMLPaymentSettings(doc);
    }

    public void authenticate(PayAccount a_account) throws Exception {
        XMLAccountCertificate accountCert = a_account.getAccountCertificate();
        IMyPrivateKey a_privateKey = a_account.getPrivateKey();
        String StrAccountCert = XMLUtil.toString(XMLUtil.toXMLDocument(accountCert));
        this.m_httpClient.writeRequest("POST", "authenticate", StrAccountCert);
        Document doc = this.m_httpClient.readAnswer();
        String tagname = doc.getDocumentElement().getTagName();
        if (tagname.equals("Challenge")) {
            XMLChallenge xmlchallenge = new XMLChallenge(doc);
            if (xmlchallenge.getType() == null || !xmlchallenge.getType().equals("PaymentInstance") || xmlchallenge.getId() == null || !xmlchallenge.getId().equals(this.m_theBI.getId())) {
                throw new Exception("Challenge is invalid! Type: " + xmlchallenge.getType() + " ID: " + xmlchallenge.getId() + " (Expected: " + "PaymentInstance" + ", " + this.m_theBI.getId());
            }
            byte[] challenge = xmlchallenge.getChallengeForSigning();
            byte[] response = ByteSignature.sign(challenge, a_privateKey);
            XMLResponse xmlResponse = new XMLResponse(response, PayAccountsFile.getInstance().getAffiliate(this.m_theBI.getId(), false));
            String strResponse = XMLUtil.toString(XMLUtil.toXMLDocument(xmlResponse));
            this.m_httpClient.writeRequest("POST", "response", strResponse);
            doc = this.m_httpClient.readAnswer();
            XMLErrorMessage message = new XMLErrorMessage(doc, a_account, (AnonServerDescription)null);
            if (message.getXmlErrorCode() >= 0 && message.getXmlErrorCode() != 0) {
                throw message;
            }
        } else if (tagname.equals("ErrorMessage")) {
            throw new Exception("The BI sent an errormessage: " + new XMLErrorMessage(doc, a_account, (AnonServerDescription)null).getMessage());
        }
    }

    public XMLAccountCertificate registerNewAccount(XMLJapPublicKey pubKey, IMyPrivateKey a_privateKey) throws Exception {
        Document doc;
        byte[] challenge = null;
        this.m_bSendNewCaptcha = true;
        while (this.m_bSendNewCaptcha) {
            if (!this.m_bFirstCaptcha) {
                try {
                    this.disconnect();
                }
                catch (Exception e) {
                    LogHolder.log(6, LogType.PAY, "Not connected to payment instance while trying to disconnect");
                }
                this.connect();
            }
            this.m_httpClient.writeRequest("POST", "register", XMLUtil.toString(XMLUtil.toXMLDocument(pubKey)));
            doc = this.m_httpClient.readAnswer();
            try {
                XMLChallenge xmlchallenge = new XMLChallenge(doc.getDocumentElement());
                if (xmlchallenge.getType() == null || !xmlchallenge.getType().equals("PaymentInstance") || xmlchallenge.getId() == null || !xmlchallenge.getId().equals(this.m_theBI.getId())) {
                    throw new Exception("Challenge is invalid! Type: " + xmlchallenge.getType() + " ID: " + xmlchallenge.getId() + " (Expected: " + "PaymentInstance" + ", " + this.m_theBI.getId());
                }
                challenge = xmlchallenge.getChallengeForSigning();
                this.m_bSendNewCaptcha = false;
                break;
            }
            catch (Exception a_e) {
                LogHolder.log(4, LogType.PAY, "No challenge sent directly while registering account, trying capchta...", a_e);
                ZipBinaryImageCaptchaClient captcha = new ZipBinaryImageCaptchaClient(doc.getDocumentElement());
                this.m_bSendNewCaptcha = false;
                this.fireGotCaptcha(captcha);
            }
        }
        if (this.m_captchaSolution != null) {
            String challengeString = new String(this.m_captchaSolution);
            int pos = challengeString.lastIndexOf(">");
            challengeString = challengeString.substring(0, pos + 1);
            int pos1 = challengeString.indexOf(">") + 1;
            int pos2 = challengeString.lastIndexOf("<");
            challengeString = challengeString.substring(pos1, pos2);
            challengeString = "<DontPanic>" + challengeString + "</DontPanic>";
            challenge = challengeString.getBytes();
        } else if (challenge == null) {
            throw new Exception("CAPTCHA");
        }
        XMLAccountCertificate xmlCert = null;
        byte[] response = ByteSignature.sign(challenge, a_privateKey);
        XMLResponse xmlResponse = new XMLResponse(response, PayAccountsFile.getInstance().getAffiliate(this.m_theBI.getId(), false));
        String strResponse = XMLUtil.toString(XMLUtil.toXMLDocument(xmlResponse));
        this.m_httpClient.writeRequest("POST", "response", strResponse);
        doc = this.m_httpClient.readAnswer();
        if (doc.getDocumentElement().getTagName().equals("ErrorMessage")) {
            XMLErrorMessage error = new XMLErrorMessage(doc.getDocumentElement(), null, null);
            LogHolder.log(3, LogType.PAY, error.getMessage());
            throw error;
        }
        if (!XMLSignature.verifyFast((Node)doc, this.m_theBI.getCertPath().getEndEntityKeys())) {
            throw new Exception("AccountCertificate: Wrong signature!");
        }
        xmlCert = new XMLAccountCertificate(doc.getDocumentElement());
        if (!xmlCert.getPublicKey().equals(pubKey.getPublicKey())) {
            throw new Exception("The JPI is evil (sent a valid certificate, but with a wrong publickey)");
        }
        return xmlCert;
    }

    public XMLPaymentOptions fetchPaymentOptions() throws Exception {
        this.m_httpClient.writeRequest("GET", "paymentoptions", null);
        Document doc = this.m_httpClient.readAnswer();
        XMLPaymentOptions paymentoptions = new XMLPaymentOptions(doc.getDocumentElement());
        return paymentoptions;
    }

    public IXMLEncodable fetchPaymentData(String transfernumber, PayAccount a_account) throws Exception {
        this.m_httpClient.writeRequest("POST", "paymentdata", transfernumber);
        Document doc = this.m_httpClient.readAnswer();
        if (doc == null) {
            return null;
        }
        IXMLEncodable paymentData = doc.getDocumentElement().getTagName().equalsIgnoreCase("PassivePayment") ? new XMLPassivePayment(doc.getDocumentElement()) : new XMLErrorMessage(doc.getDocumentElement(), a_account, (AnonServerDescription)null);
        return paymentData;
    }

    public XMLTransactionOverview fetchTransactionOverview(XMLTransactionOverview a_overview) throws Exception {
        String theOverview = XMLUtil.toString(a_overview.toXmlElement(XMLUtil.createDocument()));
        this.m_httpClient.writeRequest("POST", "transactionoverview", theOverview);
        Document doc = this.m_httpClient.readAnswer();
        Element rootElem = doc.getDocumentElement();
        if (rootElem.getTagName().equalsIgnoreCase("ErrorMessage")) {
            return null;
        }
        XMLTransactionOverview overview = new XMLTransactionOverview(doc.getDocumentElement());
        return overview;
    }

    public boolean sendPassivePayment(XMLPassivePayment a_passivePayment, PayAccount a_account) {
        try {
            String passivePaymentString = XMLUtil.toString(a_passivePayment.toXmlElement(XMLUtil.createDocument()));
            a_account.setStatusUnknown(true);
            this.m_httpClient.writeRequest("POST", "passivepayment", passivePaymentString);
            Document doc = this.m_httpClient.readAnswer();
            XMLErrorMessage err = new XMLErrorMessage(doc.getDocumentElement(), a_account, (AnonServerDescription)null);
            a_account.setStatusUnknown(false);
            if (err.getXmlErrorCode() == 0) {
                if (err.getMessageObject() != null && err.getMessageObject() instanceof XMLAccountInfo) {
                    a_account.setAccountInfo((XMLAccountInfo)err.getMessageObject());
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.PAY, "Could not send PassivePayment to payment instance: " + e);
            return false;
        }
    }

    public boolean checkCouponCode(String couponCode, PayAccount a_account) {
        try {
            this.m_httpClient.writeRequest("POST", "coupon", couponCode);
            Document doc = this.m_httpClient.readAnswer();
            XMLErrorMessage err = new XMLErrorMessage(doc.getDocumentElement(), a_account, (AnonServerDescription)null);
            if (err.getXmlErrorCode() == 0) {
                return true;
            }
            LogHolder.log(3, LogType.PAY, "User entered an invalid coupon, reply from jpi was: " + err.getMessage());
            return false;
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.PAY, "BIConnection.checkCouponCode: Could not check coupon validity due to: " + e + " so I'll return false");
            return false;
        }
    }

    public void addConnectionListener(IBIConnectionListener a_listener) {
        if (!this.m_biConnectionListeners.contains(a_listener)) {
            this.m_biConnectionListeners.addElement(a_listener);
        }
    }

    private void fireGotCaptcha(IImageEncodedCaptcha a_captcha) {
        for (int i = 0; i < this.m_biConnectionListeners.size(); ++i) {
            ((IBIConnectionListener)this.m_biConnectionListeners.elementAt(i)).gotCaptcha(this, a_captcha);
        }
    }

    public void setCaptchaSolution(byte[] a_solution) {
        this.m_captchaSolution = a_solution;
    }

    public void getNewCaptcha() {
        this.m_bSendNewCaptcha = true;
        this.m_bFirstCaptcha = false;
    }
}

