/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.message.MixMinionCryptoUtil;
import anon.util.Base64;
import anon.util.ByteArrayUtil;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class Keyring {
    final int KEY_LEN = 16;
    static final long KEY_LIFETIME = 7776000L;
    private Vector m_mykeys = new Vector();
    private Vector m_expiring = new Vector();
    private String m_password;
    private int m_today;

    public Keyring(String password) {
        this.m_password = password;
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int day = cal.get(6);
        int year = cal.get(1);
        this.m_today = ((year - 1970 - 1) * 365 + day) * 24 * 60 * 60;
        String keyring = null;
        if (keyring != null) {
            try {
                this.unpackKeyRing(keyring);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Vector getUserSecrets() {
        return this.m_mykeys;
    }

    public byte[] getNewSecret() {
        return this.makeNewKey();
    }

    private String packKeyring() {
        byte[] itemdata = new byte[]{};
        for (int i = 0; i < this.m_mykeys.size(); ++i) {
            byte[] name = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};
            byte[] expires = (byte[])this.m_expiring.elementAt(i);
            if ((long)this.byteToInt(expires, 0) + 7776000L <= (long)this.m_today) continue;
            byte[] item = ByteArrayUtil.conc(expires, name, (byte[])this.m_mykeys.elementAt(i));
            item = ByteArrayUtil.conc(new byte[1], ByteArrayUtil.inttobyte(item.length, 2), item);
            itemdata = ByteArrayUtil.conc(itemdata, item);
        }
        String packedRing = null;
        byte[] magic = "KEYRING2".getBytes();
        byte[] salt = new byte[]{18, 8, 32, 16, 52, 86, 7, 19};
        byte[] padding = MixMinionCryptoUtil.randomArray(1024 * this.myceil(itemdata.length, 1024.0) - itemdata.length);
        byte[] data2 = ByteArrayUtil.conc(ByteArrayUtil.inttobyte(itemdata.length, 4), itemdata, padding);
        byte[] hash2 = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(data2, salt, magic));
        byte[] key = ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(salt, this.m_password.getBytes(), salt)), 0, 16);
        byte[] encdata = MixMinionCryptoUtil.Encrypt(key, ByteArrayUtil.conc(data2, hash2));
        packedRing = "-----BEGIN TYPE III KEYRING-----\nVersion: 0.1\n\n" + Base64.encodeBytes(encdata) + "\n-----END TYPE III KEYRING-----";
        return packedRing;
    }

    private void unpackKeyRing(String encodeddata) throws IOException {
        byte[] mine;
        byte[] hash2;
        String enc = "";
        LineNumberReader reader = new LineNumberReader(new StringReader(encodeddata));
        reader.readLine();
        reader.readLine();
        reader.readLine();
        String aktLine = reader.readLine();
        while (!aktLine.startsWith("-----END")) {
            enc = enc + aktLine;
            aktLine = reader.readLine();
        }
        byte[] data = Base64.decode(enc);
        byte[] salt = new byte[]{18, 8, 32, 16, 52, 86, 7, 19};
        byte[] magic = "KEYRING2".getBytes();
        byte[] key = ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(salt, this.m_password.getBytes(), salt)), 0, 16);
        data = MixMinionCryptoUtil.Encrypt(key, data);
        byte[] hash3 = ByteArrayUtil.copy(data, data.length - 20, 20);
        if (!ByteArrayUtil.equal(hash3, hash2 = MixMinionCryptoUtil.hash(mine = ByteArrayUtil.conc(data = ByteArrayUtil.copy(data, 0, data.length - 20), salt, magic)))) {
            System.out.println("falsches Passwort!");
        }
        byte[] l = ByteArrayUtil.copy(data, 0, 4);
        int datalength = this.byteToInt(l, 0);
        data = ByteArrayUtil.copy(data, 4, datalength);
        int counter = 0;
        while (counter < data.length) {
            if (data[counter] != 0) continue;
            byte[] expires = ByteArrayUtil.copy(data, counter + 3, 4);
            this.m_expiring.addElement(expires);
            byte[] actsecret = ByteArrayUtil.copy(data, counter + 17, 20);
            this.m_mykeys.addElement(actsecret);
            counter += 37;
        }
    }

    private byte[] makeNewKey() {
        byte[] newsecret = MixMinionCryptoUtil.randomArray(20);
        byte[] expires = ByteArrayUtil.inttobyte((long)this.m_today + 7776000L, 4);
        this.m_mykeys.addElement(newsecret);
        this.m_expiring.addElement(expires);
        this.saveKeyRing();
        return newsecret;
    }

    public void changeKeyringPW(String newpw) {
        this.m_password = newpw;
        this.saveKeyRing();
    }

    private void saveKeyRing() {
    }

    private int byteToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < b.length; ++i) {
            int shift = (b.length - 1 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    private int myceil(double a, double b) {
        int c = (int)Math.ceil(a / b);
        if (c == 0) {
            return 1;
        }
        return c;
    }
}

