/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.mixminion.message.FragmentContainer;
import anon.mixminion.message.Keyring;
import anon.mixminion.message.Message;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.util.Base64;
import anon.util.ByteArrayUtil;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Vector;

public class Decoder {
    private final int KEY_LEN = 16;
    private final int MAXHOPS = 20;
    private final int PACKETSIZE = Message.BLOCK_SIZE - 47;
    private final int TYPE_SINGLETON = 1;
    private final int TYPE_FRAGMENTED = 2;
    private final int TYPE_UNKNOWN = 0;
    private String m_message;
    private String m_password;

    public Decoder(String message, String password) {
        this.m_message = message;
        this.m_password = password;
    }

    public String decode() throws IOException {
        Vector mykeys = new Keyring(this.m_password).getUserSecrets();
        byte[] tag = new byte[]{};
        String encrypted = "";
        String plaintext = "";
        boolean success = false;
        boolean fragment = false;
        LineNumberReader reader = new LineNumberReader(new StringReader(this.m_message));
        String aktLine = reader.readLine();
        while (!aktLine.startsWith("-----BEGIN TYPE III ANONYMOUS MESSAGE-----")) {
            aktLine = reader.readLine();
            if (aktLine.intern() != ".") continue;
            return null;
        }
        aktLine = reader.readLine();
        if (!(aktLine = aktLine.substring(14)).equals("encrypted")) {
            return null;
        }
        aktLine = reader.readLine();
        tag = Base64.decode(aktLine.substring(17));
        aktLine = reader.readLine();
        aktLine = reader.readLine();
        while (!aktLine.startsWith("-----END TYPE III ANONYMOUS MESSAGE-----")) {
            encrypted = encrypted + aktLine + "\n";
            aktLine = reader.readLine();
        }
        byte[] enc_bytes = Base64.decode(encrypted);
        block2: for (int i = 0; i < mykeys.size(); ++i) {
            byte[] aktkey = (byte[])mykeys.elementAt(i);
            byte[] tempkey = ByteArrayUtil.conc(tag, aktkey, "Validate".getBytes());
            if (MixMinionCryptoUtil.hash(tempkey)[19] != 0) continue;
            byte[] key = ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(tag, aktkey, "Generate".getBytes())), 0, 16);
            byte[] stream = MixMinionCryptoUtil.createPRNG(key, 320);
            byte[] temppayload = enc_bytes;
            for (int j = 0; j < 20; ++j) {
                byte[] streamkey = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(ByteArrayUtil.copy(stream, j * 16, 16), "PAYLOAD ENCRYPT".getBytes()));
                temppayload = MixMinionCryptoUtil.SPRP_Encrypt(streamkey, temppayload);
                if (this.testPayload(temppayload) == 1) {
                    int l = this.byteToInt(ByteArrayUtil.copy(temppayload, 0, 2), 0);
                    temppayload = ByteArrayUtil.copy(temppayload, 22, l);
                    temppayload = MixMinionCryptoUtil.decompressData(temppayload);
                    plaintext = new String(temppayload);
                    success = true;
                    continue block2;
                }
                if (this.testPayload(temppayload) != 2) continue;
                System.out.println("Fragment");
                fragment = true;
                plaintext = this.trytoReassemble(temppayload);
                if (plaintext == null) continue;
                success = true;
            }
        }
        String erg = "";
        if (!success) {
            plaintext = fragment ? (erg = "From: JAP-Decoder\nTo: local user\nSubject: Fragment\n\nFuer die Decodierung der Nachricht werden weitere Fragmente benoetigt.\n\n") : "From: JAP-Decoder\nTo: local user\nSubject: Fehler\n\nLeider konnte nichts decodiert werden.\n";
        } else {
            erg = "From: JAP-Decoder\n";
            reader = new LineNumberReader(new StringReader(plaintext));
            aktLine = reader.readLine();
            if (aktLine.startsWith("MIME")) {
                erg = erg + aktLine + "\n";
                aktLine = reader.readLine();
            }
            erg = erg + "To: local user\n";
            aktLine = "Subject: " + aktLine.substring(7);
            while (aktLine != null) {
                erg = erg + aktLine + "\n";
                aktLine = reader.readLine();
            }
            plaintext = erg;
        }
        return plaintext;
    }

    private int testPayload(byte[] payload) {
        byte[] hash1 = ByteArrayUtil.copy(payload, 2, 20);
        byte[] hash2 = MixMinionCryptoUtil.hash(ByteArrayUtil.copy(payload, 22, payload.length - 22));
        int l = this.byteToInt(ByteArrayUtil.copy(payload, 0, 2), 0);
        if (ByteArrayUtil.equal(hash1, hash2)) {
            return 1;
        }
        hash1 = MixMinionCryptoUtil.hash(ByteArrayUtil.copy(payload, 23, payload.length - 23));
        if (ByteArrayUtil.equal(hash1, hash2 = ByteArrayUtil.copy(payload, 3, 20))) {
            return 2;
        }
        return 0;
    }

    private String trytoReassemble(byte[] fragment) {
        String erg = null;
        Vector<FragmentContainer> fragments = null;
        if (fragments == null) {
            fragments = new Vector<FragmentContainer>();
        }
        byte[] id = ByteArrayUtil.copy(fragment, 23, 20);
        int index = this.byteToInt(ByteArrayUtil.copy(fragment, 1, 2), 0);
        double messagesize = this.byteToInt(ByteArrayUtil.copy(fragment, 43, 4), 0);
        System.out.println("MessageSize:" + messagesize + " index: " + index);
        fragment = ByteArrayUtil.copy(fragment, 47, this.PACKETSIZE);
        FragmentContainer myfc = null;
        int containerindex = -1;
        for (int i = 0; i < fragments.size(); ++i) {
            FragmentContainer fc = (FragmentContainer)fragments.elementAt(i);
            if (!ByteArrayUtil.equal(id, fc.getID())) continue;
            myfc = fc;
            containerindex = i;
            break;
        }
        if (containerindex == -1) {
            int payload_packets = (int)Math.ceil(messagesize / (double)this.PACKETSIZE);
            System.out.println("Numberof: " + payload_packets);
            myfc = new FragmentContainer(id, payload_packets);
        }
        if (myfc.addFragment(fragment, index)) {
            byte[] payload = myfc.reassembleMessage();
            payload = ByteArrayUtil.copy(payload, 0, (int)messagesize);
            payload = this.unwhiten(payload);
            int rs = this.byteToInt(ByteArrayUtil.copy(payload, 3, 1), 0);
            payload = ByteArrayUtil.copy(payload, 4 + rs, payload.length - 4 - rs);
            payload = MixMinionCryptoUtil.decompressData(payload);
            erg = new String(payload);
        }
        if (containerindex == -1) {
            fragments.addElement(myfc);
        } else {
            fragments.setElementAt(myfc, containerindex);
        }
        return erg;
    }

    private int byteToInt(byte[] b, int offset) {
        int value = 0;
        for (int i = 0; i < b.length; ++i) {
            int shift = (b.length - 1 - i) * 8;
            value += (b[i + offset] & 0xFF) << shift;
        }
        return value;
    }

    private byte[] unwhiten(byte[] m) {
        byte[] k_whiten = new byte[]{87, 72, 73, 84, 69, 78};
        byte[] valuetohash = ByteArrayUtil.conc(k_whiten, "WHITEN".getBytes());
        return MixMinionCryptoUtil.SPRP_Decrypt(MixMinionCryptoUtil.hash(valuetohash), m);
    }
}

