/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.X509Name;

public final class X509DistinguishedName {
    public static final String IDENTIFIER_CN = X509Name.CN.getId();
    public static final String IDENTIFIER_C = X509Name.C.getId();
    public static final String IDENTIFIER_ST = X509Name.ST.getId();
    public static final String IDENTIFIER_L = X509Name.L.getId();
    public static final String IDENTIFIER_O = X509Name.O.getId();
    public static final String IDENTIFIER_OU = X509Name.OU.getId();
    public static final String IDENTIFIER_E = X509Name.E.getId();
    public static final String IDENTIFIER_EmailAddress = X509Name.EmailAddress.getId();
    public static final String IDENTIFIER_SURNAME = X509Name.SURNAME.getId();
    public static final String IDENTIFIER_GIVENNAME = X509Name.GIVENNAME.getId();
    public static final String LABEL_COMMON_NAME = "CN";
    public static final String LABEL_COUNTRY = "C";
    public static final String LABEL_STATE_OR_PROVINCE = "ST";
    public static final String LABEL_LOCALITY = "L";
    public static final String LABEL_ORGANISATION = "O";
    public static final String LABEL_ORGANISATIONAL_UNIT = "OU";
    public static final String LABEL_EMAIL = "E";
    public static final String LABEL_EMAIL_ADDRESS = "EmailAddress";
    public static final String LABEL_SURNAME = "SURNAME";
    public static final String LABEL_GIVENNAME = "GIVENNAME";
    private static Vector m_sortedIdentifiers;
    private X509Name m_bcX509Name;

    public X509DistinguishedName(String a_x509distinguishedName) {
        this.m_bcX509Name = new X509Name(a_x509distinguishedName);
    }

    public X509DistinguishedName(Hashtable a_attributes) throws IllegalCharacterException {
        if (a_attributes == null) {
            throw new IllegalArgumentException("Attributes must not be null!");
        }
        Enumeration oids = a_attributes.keys();
        Vector<Object> vecOIDs = new Vector<Object>();
        Vector<String> attributes = new Vector<String>();
        while (oids.hasMoreElements()) {
            String currentAttribute;
            Object oid = oids.nextElement();
            if (a_attributes.get(oid) == null || (currentAttribute = a_attributes.get(oid).toString()).trim().length() == 0) continue;
            if (!(oid instanceof ASN1ObjectIdentifier)) {
                oid = new ASN1ObjectIdentifier(oid.toString());
            }
            if (oid.equals(X509Name.E) || oid.equals(X509Name.EmailAddress) || oid.equals(X509Name.OU)) {
                StringTokenizer tokenizer = new StringTokenizer(currentAttribute, ",");
                while (tokenizer.hasMoreTokens()) {
                    vecOIDs.addElement(oid);
                    attributes.addElement(tokenizer.nextToken().trim());
                }
                continue;
            }
            vecOIDs.addElement(oid);
            attributes.addElement(currentAttribute.trim());
        }
        if (attributes.size() == 0) {
            throw new IllegalArgumentException("Attributes are empty!");
        }
        this.m_bcX509Name = new X509Name(vecOIDs, attributes);
    }

    public X509DistinguishedName(X509Name a_bcX509Name) {
        this.m_bcX509Name = a_bcX509Name;
    }

    public X509DistinguishedName(X500Name a_bcX500Name) {
        this.m_bcX509Name = X509Name.getInstance(a_bcX500Name);
    }

    public static String getAttributeNameFromAttributeIdentifier(String a_identifier) {
        if (a_identifier == null) {
            return null;
        }
        if (a_identifier.equals(IDENTIFIER_CN)) {
            return LABEL_COMMON_NAME;
        }
        if (a_identifier.equals(IDENTIFIER_C)) {
            return LABEL_COUNTRY;
        }
        if (a_identifier.equals(IDENTIFIER_ST)) {
            return LABEL_STATE_OR_PROVINCE;
        }
        if (a_identifier.equals(IDENTIFIER_L)) {
            return LABEL_LOCALITY;
        }
        if (a_identifier.equals(IDENTIFIER_O)) {
            return LABEL_ORGANISATION;
        }
        if (a_identifier.equals(IDENTIFIER_OU)) {
            return LABEL_ORGANISATIONAL_UNIT;
        }
        if (a_identifier.equals(IDENTIFIER_E)) {
            return LABEL_EMAIL;
        }
        if (a_identifier.equals(IDENTIFIER_EmailAddress)) {
            return LABEL_EMAIL_ADDRESS;
        }
        if (a_identifier.equals(IDENTIFIER_SURNAME)) {
            return LABEL_SURNAME;
        }
        if (a_identifier.equals(IDENTIFIER_GIVENNAME)) {
            return LABEL_GIVENNAME;
        }
        return a_identifier;
    }

    public String getCommonName() {
        return this.getAttributeValue(IDENTIFIER_CN);
    }

    public String getSurname() {
        return this.getAttributeValue(IDENTIFIER_SURNAME);
    }

    public String getGivenName() {
        return this.getAttributeValue(IDENTIFIER_GIVENNAME);
    }

    public String getCountryCode() {
        return this.getAttributeValue(IDENTIFIER_C);
    }

    public String getStateOrProvince() {
        return this.getAttributeValue(IDENTIFIER_ST);
    }

    public String getLocalityName() {
        return this.getAttributeValue(IDENTIFIER_L);
    }

    public String getOrganisation() {
        return this.getAttributeValue(IDENTIFIER_O);
    }

    public String getOrganisationalUnit() {
        return this.getAttributeValue(IDENTIFIER_OU);
    }

    public String getE_EmailAddress() {
        return this.getAttributeValue(IDENTIFIER_E);
    }

    public String getEmailAddress() {
        return this.getAttributeValue(IDENTIFIER_EmailAddress);
    }

    public String getAttributeValue(String a_identifier) {
        if (a_identifier == null || a_identifier.trim().length() == 0) {
            return null;
        }
        String attribute = null;
        ASN1ObjectIdentifier identifier = new ASN1ObjectIdentifier(a_identifier);
        Vector values = this.m_bcX509Name.getValues();
        Vector OIDs = this.m_bcX509Name.getOIDs();
        int index = OIDs.indexOf(identifier);
        if (index < 0) {
            return null;
        }
        attribute = (String)values.elementAt(index);
        if (attribute != null) {
            for (int i = index + 1; i < OIDs.size(); ++i) {
                if (!OIDs.elementAt(i).equals(identifier)) continue;
                if ((attribute = attribute.trim()).length() > 0) {
                    attribute = attribute + ", ";
                }
                attribute = attribute + (String)values.elementAt(i);
            }
            attribute = attribute.trim();
        }
        return attribute;
    }

    public Vector getAttributeIdentifiers() {
        Vector<String> oids = new Vector<String>();
        Vector unsortedOIDs = this.m_bcX509Name.getOIDs();
        Enumeration identifiers = X509DistinguishedName.getSortedIdentifiers();
        while (identifiers.hasMoreElements()) {
            int index = unsortedOIDs.indexOf(identifiers.nextElement());
            if (index < 0) continue;
            oids.addElement(((ASN1ObjectIdentifier)unsortedOIDs.elementAt(index)).getId());
            unsortedOIDs.removeElementAt(index);
        }
        for (int i = 0; i < unsortedOIDs.size(); ++i) {
            oids.addElement(((ASN1ObjectIdentifier)unsortedOIDs.elementAt(i)).getId());
        }
        return oids;
    }

    public Vector getAttributeValues() {
        Vector unsortedOIDs = this.m_bcX509Name.getOIDs();
        Vector unsortedAttributes = this.m_bcX509Name.getValues();
        Vector attributes = new Vector();
        Enumeration identifiers = X509DistinguishedName.getSortedIdentifiers();
        while (identifiers.hasMoreElements()) {
            int index = unsortedOIDs.indexOf(identifiers.nextElement());
            if (index < 0) continue;
            attributes.addElement(unsortedAttributes.elementAt(index));
            unsortedOIDs.removeElementAt(index);
            unsortedAttributes.removeElementAt(index);
        }
        for (int i = 0; i < unsortedAttributes.size(); ++i) {
            attributes.addElement(unsortedAttributes.elementAt(i));
        }
        return attributes;
    }

    public Hashtable getDistinguishedName() {
        Hashtable name = new Hashtable();
        Vector identifiers = this.getAttributeIdentifiers();
        Vector attributes = this.getAttributeValues();
        for (int i = 0; i < identifiers.size(); ++i) {
            name.put(identifiers.elementAt(i), attributes.elementAt(i));
        }
        return name;
    }

    public int hashCode() {
        return this.m_bcX509Name.hashCode();
    }

    public boolean equals(Object a_object) {
        if (a_object == null) {
            return false;
        }
        if (a_object instanceof X509DistinguishedName) {
            return this.m_bcX509Name.equals(((X509DistinguishedName)a_object).m_bcX509Name);
        }
        if (a_object instanceof X509Name) {
            return this.m_bcX509Name.equals((X509Name)a_object);
        }
        if (a_object instanceof X500Name) {
            this.getX500Name().equals(a_object);
        }
        return false;
    }

    public String toString() {
        Vector identifiers = this.getAttributeIdentifiers();
        Vector attributes = this.getAttributeValues();
        String name = "";
        for (int i = 0; i < identifiers.size(); ++i) {
            name = name + X509DistinguishedName.getAttributeNameFromAttributeIdentifier((String)identifiers.elementAt(i)) + "=" + attributes.elementAt(i);
            if (i + 1 >= identifiers.size()) continue;
            name = name + ", ";
        }
        return name;
    }

    X500Name getX500Name() {
        ASN1Primitive a = this.m_bcX509Name.toASN1Primitive();
        return X500Name.getInstance(a);
    }

    private static Enumeration getSortedIdentifiers() {
        if (m_sortedIdentifiers == null) {
            m_sortedIdentifiers = new Vector();
            m_sortedIdentifiers.addElement(X509Name.CN);
            m_sortedIdentifiers.addElement(X509Name.SURNAME);
            m_sortedIdentifiers.addElement(X509Name.GIVENNAME);
            m_sortedIdentifiers.addElement(X509Name.O);
            m_sortedIdentifiers.addElement(X509Name.OU);
            m_sortedIdentifiers.addElement(X509Name.L);
            m_sortedIdentifiers.addElement(X509Name.ST);
            m_sortedIdentifiers.addElement(X509Name.C);
            m_sortedIdentifiers.addElement(X509Name.E);
            m_sortedIdentifiers.addElement(X509Name.EmailAddress);
        }
        return m_sortedIdentifiers.elements();
    }

    public class IllegalCharacterException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private char m_character;
        private String m_attribute;

        private IllegalCharacterException(ASN1ObjectIdentifier a_identifier, char a_character) {
            super("'" + a_character + "' characters are not allowed!");
            this.m_attribute = X509DistinguishedName.getAttributeNameFromAttributeIdentifier(a_identifier.getId());
            this.m_character = a_character;
        }

        public char getCharacter() {
            return this.m_character;
        }

        public String getAttribute() {
            return this.m_attribute;
        }
    }
}

