/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.CertPath;
import anon.crypto.CertificateContainer;
import anon.crypto.CertificateInfoStructure;
import anon.crypto.JAPCertificate;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CertificateStore
extends Observable
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "TrustedCertificates";
    private Hashtable m_trustedCertificates = new Hashtable();
    private Hashtable m_lockTable = new Hashtable();
    private int m_lockIdPointer = 0;

    public static String getXmlSettingsRootNodeName() {
        return XML_ELEMENT_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAllCertificates() {
        Vector<CertificateInfoStructure> returnedCertificates = new Vector<CertificateInfoStructure>();
        CertificateStore certificateStore = this;
        synchronized (certificateStore) {
            Hashtable hashtable = this.m_trustedCertificates;
            synchronized (hashtable) {
                Enumeration allCertificates = this.m_trustedCertificates.elements();
                while (allCertificates.hasMoreElements()) {
                    returnedCertificates.addElement(((CertificateContainer)allCertificates.nextElement()).getInfoStructure());
                }
            }
        }
        return returnedCertificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getUnavailableCertificatesByType(int a_certificateType) {
        Vector<CertificateInfoStructure> returnedCertificates = new Vector<CertificateInfoStructure>();
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration allCertificates = this.m_trustedCertificates.elements();
            while (allCertificates.hasMoreElements()) {
                CertificateContainer currentCertificateContainer = (CertificateContainer)allCertificates.nextElement();
                if (currentCertificateContainer.getCertificateType() != a_certificateType || currentCertificateContainer.isAvailable()) continue;
                returnedCertificates.addElement(currentCertificateContainer.getInfoStructure());
            }
        }
        return returnedCertificates;
    }

    public CertificateInfoStructure getCertificateInfoStructure(JAPCertificate a_certificate, int a_certificateType) {
        CertificateContainer container = (CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certificate, a_certificateType));
        if (container != null) {
            return container.getInfoStructure();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CertificateInfoStructure getCertificateInfoStructure(JAPCertificate a_certificate) {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration allCertificates = this.m_trustedCertificates.elements();
            while (allCertificates.hasMoreElements()) {
                CertificateContainer currentCertificateContainer = (CertificateContainer)allCertificates.nextElement();
                if (!currentCertificateContainer.getCertificate().equals(a_certificate)) continue;
                return currentCertificateContainer.getInfoStructure();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getAvailableCertificatesByType(int a_certificateType) {
        Vector<CertificateInfoStructure> returnedCertificates = new Vector<CertificateInfoStructure>();
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration allCertificates = this.m_trustedCertificates.elements();
            while (allCertificates.hasMoreElements()) {
                CertificateContainer currentCertificateContainer = (CertificateContainer)allCertificates.nextElement();
                if (currentCertificateContainer.getCertificateType() != a_certificateType || !currentCertificateContainer.isAvailable()) continue;
                returnedCertificates.addElement(currentCertificateContainer.getInfoStructure());
            }
        }
        return returnedCertificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addCertificateWithVerification(CertPath a_certificate, int a_certificateType, boolean a_onlyHardRemovable) {
        int lockId = -1;
        if (a_certificateType == 2 || a_certificateType == 3) {
            boolean bChanged = false;
            Hashtable hashtable = this.m_trustedCertificates;
            synchronized (hashtable) {
                int rootType = 1;
                if (a_certificateType == 3) {
                    rootType = 5;
                }
                CertificateContainer certificateContainerExisting = (CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certificate.getFirstCertificate(), a_certificateType));
                CertificateContainer certificateContainer = new CertificateContainer(a_certificate, a_certificateType, true);
                if (certificateContainerExisting == null || certificateContainerExisting.getCertificate().getValidity().getValidFrom().before(certificateContainer.getCertificate().getValidity().getValidFrom())) {
                    this.m_trustedCertificates.put(this.getCertificateId(a_certificate.getFirstCertificate(), a_certificateType), certificateContainer);
                    Enumeration rootCertificates = this.getAvailableCertificatesByType(rootType).elements();
                    boolean verificationSuccessful = false;
                    while (rootCertificates.hasMoreElements() && !verificationSuccessful) {
                        JAPCertificate currentRootCertificate = ((CertificateInfoStructure)rootCertificates.nextElement()).getCertificate();
                        verificationSuccessful = a_certificate.isVerifier(currentRootCertificate);
                        if (!verificationSuccessful) continue;
                        certificateContainer.setParentCertificate(currentRootCertificate);
                    }
                    bChanged = true;
                }
                if (!a_onlyHardRemovable) {
                    lockId = this.getNextAvailableLockId();
                    this.m_lockTable.put(new Integer(lockId), this.getCertificateId(a_certificate.getFirstCertificate(), a_certificateType));
                    ((CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certificate.getFirstCertificate(), a_certificateType))).getLockList().addElement(new Integer(lockId));
                } else {
                    ((CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certificate.getFirstCertificate(), a_certificateType))).enableOnlyHardRemovable();
                }
            }
            if (bChanged) {
                this.setChanged();
                this.notifyObservers(new Integer(a_certificateType));
            }
        }
        return lockId;
    }

    public synchronized int addCertificateWithoutVerification(JAPCertificate a_certificate, int a_certificateType, boolean a_onlyHardRemovable, boolean a_bNotRemovable) {
        return this.addCertificateWithoutVerification(CertPath.getRootInstance(a_certificate), a_certificateType, a_onlyHardRemovable, a_bNotRemovable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int addCertificateWithoutVerification(CertPath a_certPath, int a_certificateType, boolean a_onlyHardRemovable, boolean a_bNotRemovable) {
        int lockId = -1;
        boolean bChanged = false;
        if (a_certPath == null) {
            return lockId;
        }
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            if (!this.m_trustedCertificates.containsKey(this.getCertificateId(a_certPath.getFirstCertificate(), a_certificateType))) {
                CertificateContainer newCertificateContainer = new CertificateContainer(a_certPath, a_certificateType, false);
                this.m_trustedCertificates.put(this.getCertificateId(a_certPath.getFirstCertificate(), a_certificateType), newCertificateContainer);
                if (a_certificateType == 1 || a_certificateType == 5) {
                    this.activateAllDependentCertificates(a_certPath.getFirstCertificate());
                }
                bChanged = true;
            }
            if (!a_onlyHardRemovable) {
                lockId = this.getNextAvailableLockId();
                this.m_lockTable.put(new Integer(lockId), this.getCertificateId(a_certPath.getFirstCertificate(), a_certificateType));
                ((CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certPath.getFirstCertificate(), a_certificateType))).getLockList().addElement(new Integer(lockId));
            } else {
                ((CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certPath.getFirstCertificate(), a_certificateType))).enableOnlyHardRemovable();
            }
            if (a_bNotRemovable) {
                ((CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certPath.getFirstCertificate(), a_certificateType))).enableNotRemovable();
            }
        }
        if (bChanged) {
            this.setChanged();
            this.notifyObservers(new Integer(a_certificateType));
        }
        return lockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeCertificateLock(int a_lockId) {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            CertificateContainer lockedCertificate = null;
            try {
                lockedCertificate = (CertificateContainer)this.m_trustedCertificates.get(this.m_lockTable.get(new Integer(a_lockId)));
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.MISC, "Error while removing certificate lock. There is no lock with ID " + Integer.toString(a_lockId) + ".");
            }
            if (lockedCertificate != null) {
                lockedCertificate.getLockList().removeElement(new Integer(a_lockId));
                if (!lockedCertificate.isOnlyHardRemovable() && lockedCertificate.getLockList().size() == 0) {
                    this.removeCertificate(lockedCertificate.getInfoStructure());
                }
            }
            this.m_lockTable.remove(new Integer(a_lockId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeCertificate(CertificateInfoStructure a_certificateStructure) {
        CertificateContainer certificateToRemove = null;
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            certificateToRemove = (CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certificateStructure.getCertificate(), a_certificateStructure.getCertificateType()));
            if (certificateToRemove != null) {
                if (certificateToRemove.getCertificateType() == 1 || certificateToRemove.getCertificateType() == 5) {
                    this.deactivateAllDependentCertificates(certificateToRemove.getCertificate());
                }
                Enumeration activeLocks = certificateToRemove.getLockList().elements();
                while (activeLocks.hasMoreElements()) {
                    this.m_lockTable.put(activeLocks.nextElement(), "");
                }
                this.m_trustedCertificates.remove(this.getCertificateId(a_certificateStructure.getCertificate(), a_certificateStructure.getCertificateType()));
            }
        }
        if (certificateToRemove != null) {
            this.setChanged();
            this.notifyObservers(new Integer(certificateToRemove.getCertificateType()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCertificates() {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration activeLocks = this.m_lockTable.keys();
            while (activeLocks.hasMoreElements()) {
                this.m_lockTable.put(activeLocks.nextElement(), "");
            }
            if (this.m_trustedCertificates.size() > 0) {
                Enumeration it = this.m_trustedCertificates.keys();
                while (it.hasMoreElements()) {
                    Object key = it.nextElement();
                    CertificateContainer certcontainer = (CertificateContainer)this.m_trustedCertificates.get(key);
                    if (certcontainer.isNotRemovable()) continue;
                    this.m_trustedCertificates.remove(key);
                }
                this.setChanged();
            }
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration certs = this.m_trustedCertificates.elements();
            while (certs.hasMoreElements()) {
                CertificateContainer container = (CertificateContainer)certs.nextElement();
                container.setEnabled(container.isEnabled());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setEnabled(CertificateInfoStructure a_certificateStructure, boolean a_enabled) {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            CertificateContainer specifiedCertificate = (CertificateContainer)this.m_trustedCertificates.get(this.getCertificateId(a_certificateStructure.getCertificate(), a_certificateStructure.getCertificateType()));
            if (specifiedCertificate != null && specifiedCertificate.isEnabled() != a_enabled) {
                specifiedCertificate.setEnabled(a_enabled);
                if (specifiedCertificate.getCertificateType() == 1 || specifiedCertificate.getCertificateType() == 5) {
                    if (a_enabled) {
                        this.activateAllDependentCertificates(specifiedCertificate.getCertificate());
                    } else {
                        this.deactivateAllDependentCertificates(specifiedCertificate.getCertificate());
                    }
                }
                this.setChanged();
            }
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document a_doc) {
        Element trustedCertificatesNode = a_doc.createElement(XML_ELEMENT_NAME);
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration allCertificates = this.m_trustedCertificates.elements();
            while (allCertificates.hasMoreElements()) {
                CertificateContainer currentCertificateContainer = (CertificateContainer)allCertificates.nextElement();
                if (!currentCertificateContainer.isOnlyHardRemovable() || currentCertificateContainer.isNotRemovable()) continue;
                trustedCertificatesNode.appendChild(currentCertificateContainer.toXmlElement(a_doc));
            }
        }
        return trustedCertificatesNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettingsFromXml(Element a_trustedCertificatesNode) {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            this.removeAllCertificates();
            NodeList certificateContainerNodes = a_trustedCertificatesNode.getElementsByTagName("CertificateContainer");
            for (int i = 0; i < certificateContainerNodes.getLength(); ++i) {
                Element certificateContainerNode = (Element)certificateContainerNodes.item(i);
                try {
                    CertificateContainer currentCertificateContainer = new CertificateContainer(certificateContainerNode);
                    if (currentCertificateContainer.getCertificateNeedsVerification()) {
                        this.addCertificateWithVerification(currentCertificateContainer.getCertPath(), currentCertificateContainer.getCertificateType(), true);
                    } else {
                        this.addCertificateWithoutVerification(currentCertificateContainer.getCertPath(), currentCertificateContainer.getCertificateType(), true, currentCertificateContainer.isNotRemovable());
                    }
                    this.setEnabled(currentCertificateContainer.getInfoStructure(), currentCertificateContainer.isEnabled());
                    continue;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, "Error while loading a CertificateContainer. Skipping this entry. Error: " + e.toString() + " - Invalid container was: " + XMLUtil.toString(certificateContainerNode));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateAllDependentCertificates(JAPCertificate a_certificate) {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration allCertificates = this.m_trustedCertificates.elements();
            while (allCertificates.hasMoreElements()) {
                JAPCertificate parentCertificate;
                CertificateContainer currentCertificateContainer = (CertificateContainer)allCertificates.nextElement();
                if (!currentCertificateContainer.getCertificateNeedsVerification() || (parentCertificate = currentCertificateContainer.getParentCertificate()) != null || !currentCertificateContainer.getCertPath().isVerifier(a_certificate)) continue;
                currentCertificateContainer.setParentCertificate(a_certificate);
                currentCertificateContainer.setEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivateAllDependentCertificates(JAPCertificate a_certificate) {
        Hashtable hashtable = this.m_trustedCertificates;
        synchronized (hashtable) {
            Enumeration allCertificates = this.m_trustedCertificates.elements();
            while (allCertificates.hasMoreElements()) {
                JAPCertificate currentParentCertificate;
                CertificateContainer currentCertificateContainer = (CertificateContainer)allCertificates.nextElement();
                if (!currentCertificateContainer.getCertificateNeedsVerification() || (currentParentCertificate = currentCertificateContainer.getParentCertificate()) == null || !currentParentCertificate.equals(a_certificate)) continue;
                currentCertificateContainer.setParentCertificate(null);
                currentCertificateContainer.setEnabled(false);
            }
        }
    }

    private int getNextAvailableLockId() {
        while (this.m_lockTable.containsKey(new Integer(this.m_lockIdPointer)) || this.m_lockIdPointer == -1) {
            ++this.m_lockIdPointer;
        }
        return this.m_lockIdPointer;
    }

    private String getCertificateId(JAPCertificate a_certificate, int a_certificateType) {
        return a_certificate.getId() + Integer.toString(a_certificateType);
    }
}

