/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage;

import anon.anonudp.mixmessage.Util;

class Padding {
    private static final int END_BIT = 128;
    private static final int VALUE_MASK = 127;
    private byte[] byte_representation;
    private int internal_padding_length;

    public Padding(int padding_length) {
        if (padding_length <= 0) {
            this.internal_padding_length = 0;
            this.byte_representation = new byte[0];
        } else if (padding_length == 1) {
            this.internal_padding_length = 0;
            this.byte_representation = new byte[]{-128};
        } else {
            int padding_bytes_needed = (int)Math.ceil(Util.log2(padding_length) / 7.0);
            this.internal_padding_length = padding_length -= padding_bytes_needed;
            this.byte_representation = new byte[padding_bytes_needed];
            int padding_byte_index = 1;
            while (padding_length > 0) {
                this.byte_representation[this.byte_representation.length - padding_byte_index] = (byte)(padding_length & 0x7F);
                padding_length >>= 7;
                ++padding_byte_index;
            }
            int n = this.byte_representation.length - 1;
            this.byte_representation[n] = (byte)(this.byte_representation[n] | 0x80);
        }
    }

    public Padding(byte[] padding_byte_representation) {
        this(padding_byte_representation, 0);
    }

    Padding(byte[] padding_byte_representation, int offset) {
        if (padding_byte_representation.length == 0) {
            throw new IllegalArgumentException("No padding bytes given as argument.");
        }
        int padding_end_mask = 128;
        int padding_value_mask = 127;
        this.internal_padding_length = 0;
        int bytes_read = 0;
        for (int i = offset; i < padding_byte_representation.length; ++i) {
            this.internal_padding_length += padding_byte_representation[i] & padding_value_mask;
            ++bytes_read;
            if ((padding_byte_representation[i] & padding_end_mask) == padding_end_mask) break;
            this.internal_padding_length <<= 7;
        }
        this.byte_representation = Util.copyOfRange(padding_byte_representation, offset, offset + bytes_read);
    }

    public byte[] getLengthAsBytes() {
        return this.byte_representation;
    }

    public byte[] getPaddingBytes() {
        return Util.randomBytes(this.internal_padding_length);
    }

    public int getLength() {
        return this.internal_padding_length;
    }
}

