/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.HTTPConnection;
import HTTPClient.HttpClientUtil;
import HTTPClient.HttpHeaderElement;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.RoRequest;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class Cookie2
extends Cookie {
    protected int version;
    protected boolean discard;
    protected String comment;
    protected URL comment_url;
    protected int[] port_list;
    protected String port_list_str;
    protected boolean path_set;
    protected boolean port_set;
    protected boolean domain_set;

    public Cookie2(String name, String value, String domain, int[] port_list, String path, Date expires, boolean discard, boolean secure, boolean httponly, String comment, URL comment_url) {
        super(name, value, domain, path, expires, secure, httponly);
        this.discard = discard;
        this.port_list = port_list;
        this.comment = comment;
        this.comment_url = comment_url;
        this.path_set = true;
        this.domain_set = true;
        if (port_list != null && port_list.length > 0) {
            StringBuffer tmp = new StringBuffer();
            tmp.append(port_list[0]);
            for (int idx = 1; idx < port_list.length; ++idx) {
                tmp.append(',');
                tmp.append(port_list[idx]);
            }
            this.port_list_str = tmp.toString();
            this.port_set = true;
        }
        this.version = 1;
    }

    protected Cookie2(RoRequest req) {
        super(req);
        int slash = this.path.lastIndexOf(47);
        if (slash != -1) {
            this.path = this.path.substring(0, slash + 1);
        }
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.version = -1;
        this.discard = false;
        this.comment = null;
        this.comment_url = null;
        this.port_list = null;
        this.port_list_str = null;
        this.path_set = false;
        this.port_set = false;
        this.domain_set = false;
    }

    protected static Cookie[] parse(String set_cookie, RoRequest req) throws ProtocolException {
        Vector cookies;
        try {
            cookies = HttpClientUtil.parseHeader(set_cookie);
        }
        catch (ParseException pe) {
            throw new ProtocolException(pe.getMessage());
        }
        Cookie[] cookie_arr = new Cookie[cookies.size()];
        int cidx = 0;
        for (int idx = 0; idx < cookie_arr.length; ++idx) {
            HttpHeaderElement c_elem = (HttpHeaderElement)cookies.elementAt(idx);
            if (c_elem.getValue() == null) {
                throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nMissing value " + "for cookie '" + c_elem.getName() + "'");
            }
            Cookie2 curr = new Cookie2(req);
            curr.name = c_elem.getName();
            curr.value = c_elem.getValue();
            NVPair[] params = c_elem.getParams();
            boolean discard_set = false;
            boolean secure_set = false;
            for (int idx2 = 0; idx2 < params.length; ++idx2) {
                String name = params[idx2].getName().toLowerCase();
                if ((name.equals("version") || name.equals("max-age") || name.equals("domain") || name.equals("path") || name.equals("comment") || name.equals("commenturl")) && params[idx2].getValue() == null) {
                    throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nMissing value " + "for " + params[idx2].getName() + " attribute in cookie '" + c_elem.getName() + "'");
                }
                if (name.equals("version")) {
                    if (curr.version != -1) continue;
                    try {
                        curr.version = Integer.parseInt(params[idx2].getValue());
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nVersion '" + params[idx2].getValue() + "' not a number");
                    }
                }
                if (name.equals("path")) {
                    if (curr.path_set) continue;
                    curr.path = params[idx2].getValue();
                    curr.path_set = true;
                    continue;
                }
                if (name.equals("domain")) {
                    if (curr.domain_set) continue;
                    String d = params[idx2].getValue().toLowerCase();
                    curr.domain = d.charAt(0) != '.' && !d.equals(curr.domain) ? "." + d : d;
                    curr.domain_set = true;
                    continue;
                }
                if (name.equals("max-age")) {
                    int age;
                    if (curr.expires != null) continue;
                    try {
                        age = Integer.parseInt(params[idx2].getValue());
                    }
                    catch (NumberFormatException nfe) {
                        throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nMax-Age '" + params[idx2].getValue() + "' not a number");
                    }
                    curr.expires = new Date(System.currentTimeMillis() + (long)age * 1000L);
                    continue;
                }
                if (name.equals("port")) {
                    if (curr.port_set) continue;
                    if (params[idx2].getValue() == null) {
                        curr.port_list = new int[1];
                        curr.port_list[0] = req.getConnection().getPort();
                        curr.port_set = true;
                        continue;
                    }
                    curr.port_list_str = params[idx2].getValue();
                    StringTokenizer tok = new StringTokenizer(params[idx2].getValue(), ",");
                    curr.port_list = new int[tok.countTokens()];
                    for (int idx3 = 0; idx3 < curr.port_list.length; ++idx3) {
                        String port = tok.nextToken().trim();
                        try {
                            curr.port_list[idx3] = Integer.parseInt(port);
                            continue;
                        }
                        catch (NumberFormatException nfe) {
                            throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nPort '" + port + "' not a number");
                        }
                    }
                    curr.port_set = true;
                    continue;
                }
                if (name.equals("discard")) {
                    if (discard_set) continue;
                    curr.discard = true;
                    discard_set = true;
                    continue;
                }
                if (name.equals("secure")) {
                    if (secure_set) continue;
                    curr.secure = true;
                    secure_set = true;
                    continue;
                }
                if (name.equals("comment")) {
                    if (curr.comment != null) continue;
                    curr.comment = params[idx2].getValue();
                    continue;
                }
                if (!name.equals("commenturl") || curr.comment_url != null) continue;
                try {
                    curr.comment_url = new URL(params[idx2].getValue());
                    continue;
                }
                catch (MalformedURLException mue) {
                    throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nCommentURL '" + params[idx2].getValue() + "' not a valid URL");
                }
            }
            if (curr.version == -1) {
                throw new ProtocolException("Bad Set-Cookie2 header: " + set_cookie + "\nMissing Version " + "attribute");
            }
            if (curr.version != 1) continue;
            if (curr.expires == null) {
                curr.discard = true;
            }
            if (!HttpClientUtil.getPath(req.getRequestURI()).startsWith(curr.path)) continue;
            String eff_host = req.getConnection().getHost();
            if (eff_host.indexOf(46) == -1) {
                eff_host = eff_host + ".local";
            }
            if (!curr.domain.equals(".local") && curr.domain.indexOf(46, 1) == -1 || !eff_host.endsWith(curr.domain) || eff_host.substring(0, eff_host.length() - curr.domain.length()).indexOf(46) != -1) continue;
            if (curr.port_set) {
                int idx2 = 0;
                for (idx2 = 0; idx2 < curr.port_list.length && curr.port_list[idx2] != req.getConnection().getPort(); ++idx2) {
                }
                if (idx2 == curr.port_list.length) continue;
            }
            cookie_arr[cidx++] = curr;
        }
        if (cidx < cookie_arr.length) {
            cookie_arr = HttpClientUtil.resizeArray(cookie_arr, cidx);
        }
        return cookie_arr;
    }

    public int getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public URL getCommentURL() {
        return this.comment_url;
    }

    public int[] getPorts() {
        return this.port_list;
    }

    public boolean discard() {
        return this.discard;
    }

    protected boolean sendWith(RoRequest req) {
        String eff_host;
        boolean port_match;
        HTTPConnection con = req.getConnection();
        boolean bl = port_match = !this.port_set;
        if (this.port_set) {
            for (int idx = 0; idx < this.port_list.length; ++idx) {
                if (this.port_list[idx] != con.getPort()) continue;
                port_match = true;
                break;
            }
        }
        if ((eff_host = con.getHost()).indexOf(46) == -1) {
            eff_host = eff_host + ".local";
        }
        return (this.domain.charAt(0) == '.' && eff_host.endsWith(this.domain) || this.domain.charAt(0) != '.' && eff_host.equals(this.domain)) && port_match && HttpClientUtil.getPath(req.getRequestURI()).startsWith(this.path) && (!this.secure || con.getProtocol().equals("https") || con.getProtocol().equals("shttp"));
    }

    protected String toExternalForm() {
        StringBuffer cookie = new StringBuffer();
        if (this.version == 1) {
            cookie.append(this.name);
            cookie.append("=");
            cookie.append(this.value);
            if (this.path_set) {
                cookie.append("; ");
                cookie.append("$Path=");
                cookie.append(this.path);
            }
            if (this.domain_set) {
                cookie.append("; ");
                cookie.append("$Domain=");
                cookie.append(this.domain);
            }
            if (this.port_set) {
                cookie.append("; ");
                cookie.append("$Port");
                if (this.port_list_str != null) {
                    cookie.append("=\"");
                    cookie.append(this.port_list_str);
                    cookie.append('\"');
                }
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return cookie.toString();
    }

    public String toString() {
        String string = this.name + "=" + this.value;
        if (this.version == 1) {
            string = string + "; Version=" + this.version;
            string = string + "; Path=" + this.path;
            string = string + "; Domain=" + this.domain;
            if (this.port_set) {
                string = string + "; Port=\"" + this.port_list[0];
                for (int idx = 1; idx < this.port_list.length; ++idx) {
                    string = string + "," + this.port_list[idx];
                }
                string = string + "\"";
            }
            if (this.expires != null) {
                string = string + "; Max-Age=" + (this.expires.getTime() - new Date().getTime()) / 1000L;
            }
            if (this.discard) {
                string = string + "; Discard";
            }
            if (this.secure) {
                string = string + "; Secure";
            }
            if (this.comment != null) {
                string = string + "; Comment=\"" + this.comment + "\"";
            }
            if (this.comment_url != null) {
                string = string + "; CommentURL=\"" + this.comment_url + "\"";
            }
        } else {
            throw new Error("Internal Error: unknown version " + this.version);
        }
        return string;
    }
}

