/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central.server;

import infoservice.mailsystem.central.server.ConnectionHandle;
import infoservice.mailsystem.central.server.IServerImplementationFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import logging.LogHolder;
import logging.LogType;

public class GenericServer
implements Runnable {
    private InetAddress m_serverAddress;
    private int m_serverPort;
    private ServerSocket m_serverSocket;
    private Thread m_serverSocketThread;
    private Object m_synchronizer;
    private IServerImplementationFactory m_serverImplementationFactory;

    public GenericServer(int a_serverPort, InetAddress a_serverAddress) {
        this.m_serverPort = a_serverPort;
        this.m_serverAddress = a_serverAddress;
        this.m_synchronizer = new Object();
        this.m_serverImplementationFactory = null;
        this.m_serverSocketThread = null;
        this.m_serverSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer() throws IOException {
        GenericServer genericServer = this;
        synchronized (genericServer) {
            if (this.m_serverSocket == null) {
                this.m_serverSocket = new ServerSocket(this.m_serverPort, 50, this.m_serverAddress);
                try {
                    this.m_serverSocket.setSoTimeout(0);
                }
                catch (IOException e) {
                    this.m_serverSocket = null;
                    throw e;
                }
                if (this.m_serverAddress != null) {
                    LogHolder.log(7, LogType.NET, "GenericServer: startServer: Server is listening at port " + Integer.toString(this.m_serverSocket.getLocalPort()) + " on interface " + this.m_serverAddress.toString() + ".");
                } else {
                    LogHolder.log(7, LogType.NET, "GenericServer: startServer: Server is listening at port " + Integer.toString(this.m_serverSocket.getLocalPort()) + " on all local interfaces.");
                }
                this.m_serverSocketThread = new Thread((Runnable)this, "GernericServer");
                this.m_serverSocketThread.setDaemon(true);
                this.m_serverSocketThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        GenericServer genericServer = this;
        synchronized (genericServer) {
            if (this.m_serverSocket != null) {
                try {
                    this.m_serverSocket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_serverSocketThread.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_serverSocket = null;
                this.m_serverSocketThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionHandlerFactory(IServerImplementationFactory a_serverImplementationFactory) {
        Object object = this.m_synchronizer;
        synchronized (object) {
            this.m_serverImplementationFactory = a_serverImplementationFactory;
        }
    }

    @Override
    public void run() {
        boolean shutdown = false;
        LogHolder.log(7, LogType.NET, "GenericServer: run: Starting the server-socket management thread.");
        while (!shutdown) {
            Socket newConnection = null;
            try {
                newConnection = this.m_serverSocket.accept();
            }
            catch (Exception e) {
                shutdown = true;
            }
            if (shutdown) continue;
            LogHolder.log(7, LogType.NET, "GenericServer: run: New connection accepted. Request handling is started...");
            ConnectionHandle connectionHandle = new ConnectionHandle(newConnection, this.getServerImplementationFactory());
        }
        LogHolder.log(7, LogType.NET, "GenericServer: run: Server-socket management thread finished.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServerImplementationFactory getServerImplementationFactory() {
        IServerImplementationFactory currentFactory = null;
        Object object = this.m_synchronizer;
        synchronized (object) {
            currentFactory = this.m_serverImplementationFactory;
        }
        return currentFactory;
    }
}

