/*
 * Decompiled with CFR 0.152.
 */
package infoservice.japforwarding;

import anon.util.XMLUtil;
import infoservice.japforwarding.VerificationLock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ServerVerifier {
    private static final byte[] MESSAGE_START_SIGNATURE = new byte[]{-1, 0, -16, 15};
    private static final byte[] MESSAGE_END_SIGNATURE = new byte[]{-1, 0, -31, 30};
    private static final int MAXIMUM_PROTOCOLMESSAGE_SIZE = 100000;
    private InetAddress m_serverAddress;
    private int m_serverPort;
    private static long ms_lastServerVerifierThreadID = 0L;

    public ServerVerifier(InetAddress a_serverAddress, int a_serverPort) {
        this.m_serverAddress = a_serverAddress;
        this.m_serverPort = a_serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyServer() {
        final long verifyStartTime = System.currentTimeMillis();
        final VerificationLock verificationLock = new VerificationLock();
        Thread verifyThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Socket serverConnection = null;
                try {
                    serverConnection = new Socket(ServerVerifier.this.m_serverAddress, ServerVerifier.this.m_serverPort);
                    serverConnection.setSoTimeout(20000 - (int)(System.currentTimeMillis() - verifyStartTime));
                    ServerVerifier.this.sendProtocolMessage(ServerVerifier.this.xmlToProtocolPacket(ServerVerifier.this.generateConnectionVerify()), serverConnection);
                    byte[] message = ServerVerifier.this.readProtocolMessage(serverConnection);
                    Document doc = XMLUtil.toXMLDocument(message);
                    NodeList japRoutingNodes = doc.getElementsByTagName("JAPRouting");
                    if (japRoutingNodes.getLength() == 0) {
                        throw new Exception("Error in XML structure (JAPRouting node).");
                    }
                    Element japRoutingNode = (Element)japRoutingNodes.item(0);
                    NodeList requestNodes = japRoutingNode.getElementsByTagName("Request");
                    if (requestNodes.getLength() == 0) {
                        throw new Exception("Error in XML structure (Request node).");
                    }
                    Element requestNode = (Element)requestNodes.item(0);
                    String subject = requestNode.getAttribute("subject");
                    if (!subject.equals("connection")) {
                        throw new Exception("Error in XML structure (Request node, wrong subject).");
                    }
                    String msg = requestNode.getAttribute("msg");
                    if (!msg.equals("acknowledge")) {
                        throw new Exception("Error in XML structure (Request node, wrong msg).");
                    }
                    serverConnection.close();
                    VerificationLock verificationLock2 = verificationLock;
                    synchronized (verificationLock2) {
                        verificationLock.setSuccess(true);
                        verificationLock.notify();
                    }
                }
                catch (Exception e) {
                    try {
                        serverConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LogHolder.log(6, LogType.NET, "Error while verifying the JAP forwarding server " + ServerVerifier.this.m_serverAddress.toString() + ":" + Integer.toString(ServerVerifier.this.m_serverPort) + ": " + e.toString());
                    VerificationLock verificationLock3 = verificationLock;
                    synchronized (verificationLock3) {
                        verificationLock.notify();
                    }
                }
            }
        });
        verifyThread.setName("infoservice.japforwarding.ServerVerifier - " + ms_lastServerVerifierThreadID++);
        verifyThread.setDaemon(true);
        boolean verificationSuccess = false;
        VerificationLock verificationLock2 = verificationLock;
        synchronized (verificationLock2) {
            verifyThread.start();
            try {
                verificationLock.wait(20000L);
                verificationSuccess = verificationLock.getSuccess();
                verifyThread.interrupt();
                verifyThread.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (verificationSuccess) {
            LogHolder.log(7, LogType.NET, "ServerVerifier: verifyServer: Verification of the JAP forwarding server " + this.m_serverAddress.toString() + ":" + Integer.toString(this.m_serverPort) + " was successful.");
        } else {
            LogHolder.log(6, LogType.NET, "Verification of the JAP forwarding server " + this.m_serverAddress.toString() + ":" + Integer.toString(this.m_serverPort) + " failed.");
        }
        return verificationSuccess;
    }

    private boolean checkSignature(byte[] a_signature1, byte[] a_signature2) {
        boolean identical = false;
        try {
            if (a_signature1.length == a_signature2.length) {
                identical = true;
                for (int i = 0; i < a_signature1.length && identical; ++i) {
                    if (a_signature1[i] == a_signature2[i]) continue;
                    identical = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return identical;
    }

    private byte[] readProtocolMessage(Socket a_connection) throws Exception {
        byte[] messageHeader = new byte[MESSAGE_START_SIGNATURE.length + 4];
        byte[] currentMessage = null;
        int readBytes = 0;
        while (readBytes < messageHeader.length) {
            int lastRead = a_connection.getInputStream().read(messageHeader, readBytes, messageHeader.length - readBytes);
            if (lastRead == -1) {
                throw new Exception("ServerVerifier: readProtocolMessage: Read error - connection was closed.");
            }
            readBytes = lastRead + readBytes;
        }
        byte[] messageStart = new byte[MESSAGE_START_SIGNATURE.length];
        System.arraycopy(messageHeader, 0, messageStart, 0, MESSAGE_START_SIGNATURE.length);
        if (!this.checkSignature(messageStart, MESSAGE_START_SIGNATURE)) {
            throw new Exception("ServerVerifier: readProtocolMessage: Protocol error (invalid start signature).");
        }
        byte[] netLength = new byte[4];
        System.arraycopy(messageHeader, MESSAGE_START_SIGNATURE.length, netLength, 0, 4);
        int incomingMessageLength = 0;
        incomingMessageLength = new DataInputStream(new ByteArrayInputStream(netLength)).readInt();
        if (incomingMessageLength < 0 || incomingMessageLength > 100000) {
            throw new Exception("ServerVerifier: readProtocolMessage: Protocol error (invalid length).");
        }
        byte[] remainingMessage = new byte[incomingMessageLength + MESSAGE_END_SIGNATURE.length];
        readBytes = 0;
        while (readBytes < remainingMessage.length) {
            int lastRead = a_connection.getInputStream().read(remainingMessage, readBytes, remainingMessage.length - readBytes);
            if (lastRead == -1) {
                throw new Exception("ServerVerifier: readProtocolMessage: Read error - connection was closed.");
            }
            readBytes = lastRead + readBytes;
        }
        byte[] messageEnd = new byte[MESSAGE_END_SIGNATURE.length];
        System.arraycopy(remainingMessage, incomingMessageLength, messageEnd, 0, MESSAGE_END_SIGNATURE.length);
        if (!this.checkSignature(messageEnd, MESSAGE_END_SIGNATURE)) {
            throw new Exception("ServerVerifier: readProtocolMessage: Protocol error (invalid end signature).");
        }
        currentMessage = new byte[incomingMessageLength];
        System.arraycopy(remainingMessage, 0, currentMessage, 0, incomingMessageLength);
        return currentMessage;
    }

    private void sendProtocolMessage(byte[] a_message, Socket a_connection) throws IOException {
        a_connection.getOutputStream().write(a_message);
    }

    private Document generateConnectionVerify() throws Exception {
        Document doc = XMLUtil.createDocument();
        Element japRoutingNode = doc.createElement("JAPRouting");
        Element requestNode = doc.createElement("Request");
        requestNode.setAttribute("subject", "connection");
        requestNode.setAttribute("msg", "verify");
        japRoutingNode.appendChild(requestNode);
        doc.appendChild(japRoutingNode);
        return doc;
    }

    private byte[] xmlToProtocolPacket(Document a_doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        StreamResult r = new StreamResult(out);
        DOMSource s = new DOMSource(a_doc);
        t.transform(s, r);
        return this.createProtocolPacket(out.toByteArray());
    }

    private byte[] createProtocolPacket(byte[] a_data) {
        byte[] protocolPacket = new byte[MESSAGE_START_SIGNATURE.length + 4 + a_data.length + MESSAGE_END_SIGNATURE.length];
        System.arraycopy(MESSAGE_START_SIGNATURE, 0, protocolPacket, 0, MESSAGE_START_SIGNATURE.length);
        ByteArrayOutputStream dataLength = new ByteArrayOutputStream(4);
        try {
            new DataOutputStream(dataLength).writeInt(a_data.length);
            System.arraycopy(dataLength.toByteArray(), 0, protocolPacket, MESSAGE_START_SIGNATURE.length, 4);
        }
        catch (Exception e) {
            byte[] dummyLength = new byte[]{-1, -1, -1, -1};
            System.arraycopy(dummyLength, 0, protocolPacket, MESSAGE_START_SIGNATURE.length, 4);
        }
        System.arraycopy(a_data, 0, protocolPacket, MESSAGE_START_SIGNATURE.length + 4, a_data.length);
        System.arraycopy(MESSAGE_END_SIGNATURE, 0, protocolPacket, MESSAGE_START_SIGNATURE.length + 4 + a_data.length, MESSAGE_END_SIGNATURE.length);
        return protocolPacket;
    }
}

