/*
 * Decompiled with CFR 0.152.
 */
package infoservice.dynamic;

import anon.crypto.SignatureCreator;
import anon.crypto.SignatureVerifier;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.HttpResponseStructure;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import infoservice.Configuration;
import infoservice.dynamic.VirtualCascade;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DynamicCommandsExtension {
    public static HttpResponseStructure cascadePostHelo(byte[] a_postData, int a_encoding) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            MixCascade mixCascadeEntry;
            byte[] b;
            if (LogHolder.isLogged(7, LogType.NET)) {
                String msg = null;
                if (a_encoding == 1) {
                    b = ZLibTools.decompress(a_postData);
                    msg = b == null ? "ZLIB ENCODING ERROR!" : new String(b);
                } else {
                    msg = new String(a_postData);
                    if (!msg.startsWith("<")) {
                        b = ZLibTools.decompress(a_postData);
                        msg = b == null ? "ZLIB ENCODING ERROR!" : "WARNING: FAULTY REPORTED A PLAIN - BUT WAS ZLIB ENCODED: " + new String(b);
                    }
                }
                msg = msg.replace('\n', ' ');
                msg = msg.replace('\r', ' ');
                LogHolder.log(7, LogType.NET, "MixCascade HELO received (encoding was: " + a_encoding + "): XML : " + msg);
            }
            if (a_encoding == 1) {
                mixCascadeEntry = new MixCascade(a_postData);
            } else if (a_encoding == 0) {
                if (a_postData[0] != 60 && (b = ZLibTools.decompress(a_postData)) != null) {
                    a_postData = b;
                }
                Element mixCascadeNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "MixCascade");
                mixCascadeEntry = new MixCascade(mixCascadeNode);
            } else {
                throw new Exception("Unsupported post encoding:" + a_encoding);
            }
            VirtualCascade temporaryCascade = (VirtualCascade)Database.getInstance(VirtualCascade.class).getEntryById(mixCascadeEntry.getId());
            if (temporaryCascade != null && temporaryCascade.getRealCascade().getMixIDsAsString().equals(mixCascadeEntry.getMixIDsAsString())) {
                Database.getInstance(VirtualCascade.class).remove(temporaryCascade);
            }
            if (mixCascadeEntry.isVerified() && mixCascadeEntry.isValid()) {
                Database.getInstance(MixCascade.class).update(mixCascadeEntry);
            } else {
                LogHolder.log(5, LogType.NET, "Security check failed for mix cascade entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, "Error while receiving Cascade info!!", e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    public HttpResponseStructure isNewCascadeAvailable(String a_strMixId) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(404);
        if (!this.haveNewCascadeInformation(a_strMixId)) {
            return httpResponse;
        }
        httpResponse = new HttpResponseStructure(200);
        return httpResponse;
    }

    public HttpResponseStructure reconfigureMix(String a_strMixId) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(500);
        MixCascade cascade = this.getTemporaryCascade(a_strMixId);
        if (cascade != null) {
            Element doc = cascade.getXmlStructure();
            SignatureCreator.getInstance().signXml(2, doc);
            httpResponse = new HttpResponseStructure(2, 0, XMLUtil.toString(doc));
        }
        return httpResponse;
    }

    private boolean haveNewCascadeInformation(String a_strMixId) {
        MixCascade assignedCascade = this.getCurrentCascade(a_strMixId);
        MixCascade assignedTemporaryCascade = this.getTemporaryCascade(a_strMixId);
        if (assignedTemporaryCascade == null) {
            return false;
        }
        return !assignedTemporaryCascade.compareMixIDs(assignedCascade);
    }

    private MixCascade getTemporaryCascade(String a_mixId) {
        Enumeration knownTemporaryMixCascades = Database.getInstance(VirtualCascade.class).getEntryList().elements();
        MixCascade assignedTemporaryCascade = null;
        while (knownTemporaryMixCascades.hasMoreElements() && assignedTemporaryCascade == null) {
            MixCascade currentCascade = ((VirtualCascade)knownTemporaryMixCascades.nextElement()).getRealCascade();
            if (!currentCascade.getMixIds().contains(a_mixId)) continue;
            assignedTemporaryCascade = currentCascade;
            break;
        }
        return assignedTemporaryCascade;
    }

    private MixCascade getCurrentCascade(String a_mixId) {
        Enumeration knownMixCascades = Database.getInstance(MixCascade.class).getEntryList().elements();
        MixCascade assignedCascade = null;
        while (knownMixCascades.hasMoreElements() && assignedCascade == null) {
            MixCascade currentCascade = (MixCascade)knownMixCascades.nextElement();
            if (!currentCascade.getMixIds().contains(a_mixId)) continue;
            assignedCascade = currentCascade;
            break;
        }
        return assignedCascade;
    }

    public HttpResponseStructure lastMixPostDynaCascade(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "LastMixPostDynaCascade: MixCascade HELO received: XML: " + new String(a_postData));
            Element mixCascadeNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "MixCascade");
            if (SignatureVerifier.getInstance().verifyXml(mixCascadeNode, 1)) {
                MixCascade mixCascadeEntry = new MixCascade(mixCascadeNode);
                VirtualCascade tmp = new VirtualCascade(mixCascadeEntry);
                Database.getInstance(VirtualCascade.class).update(tmp);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for MixCascade entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    public HttpResponseStructure mixPostConnectivityTest(InetAddress a_sourceAddress, byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(500);
        int port = this.extractPort(a_postData);
        LogHolder.log(0, LogType.MISC, "Port: " + port);
        if (port == -1) {
            LogHolder.log(7, LogType.MISC, "connectivityTest: No Port given");
            return httpResponse;
        }
        Document docConnectivity = null;
        docConnectivity = this.isReachable(a_sourceAddress, port) ? this.constructAnswer("OK") : this.constructAnswer("Failed");
        httpResponse = new HttpResponseStructure(2, 0, XMLUtil.toString(docConnectivity));
        return httpResponse;
    }

    private Document constructAnswer(String response) {
        Document result = XMLUtil.createDocument();
        Element nodeConnectivity = result.createElement("Connectivity");
        Element nodeResult = result.createElement("Result");
        result.appendChild(nodeConnectivity);
        nodeConnectivity.appendChild(nodeResult);
        XMLUtil.setValue((Node)nodeResult, response);
        return result;
    }

    private boolean isReachable(InetAddress a_Address, int port) {
        Random rand = new Random();
        long echoRequest = Math.abs(rand.nextLong());
        LogHolder.log(0, LogType.ALL, "Echo request is: " + echoRequest);
        String result = this.doPing(a_Address, port, echoRequest);
        if (result == null) {
            return false;
        }
        long echoResponse = Long.parseLong(result);
        return echoResponse == echoRequest;
    }

    private String doPing(InetAddress a_Address, int port, long echoRequest) {
        StringBuffer result = new StringBuffer();
        try {
            Socket socket = new Socket(a_Address, port);
            socket.setSoTimeout(5000);
            BufferedOutputStream str = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
            byte[] content = Long.toString(echoRequest).getBytes();
            str.write(content);
            str.flush();
            byte[] buff = new byte[content.length];
            int bytes = -1;
            while ((bytes = in.read(buff)) != -1) {
                byte[] real = new byte[bytes];
                System.arraycopy(buff, 0, real, 0, bytes);
                result.append(new String(real));
            }
            in.close();
            socket.close();
        }
        catch (Exception e) {
            return null;
        }
        LogHolder.log(7, LogType.NET, "Answer from Mix was:  " + result);
        return result.toString();
    }

    private int extractPort(byte[] a_postData) {
        int port = -1;
        try {
            Document doc = XMLUtil.toXMLDocument(a_postData);
            Node rootNode = doc.getFirstChild();
            Element portNode = (Element)XMLUtil.getFirstChildByName(rootNode, "Port");
            port = XMLUtil.parseValue((Node)portNode, -1);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        return port;
    }

    public HttpResponseStructure virtualCascadeStatus() {
        HttpResponseStructure httpResponse;
        try {
            String virtualCascades = this.getCascadeHtmlTable(VirtualCascade.class);
            String realCascades = this.getCascadeHtmlTable(MixCascade.class);
            String htmlData = "<HTML>\n  <HEAD>\n    <TITLE>INFOSERVICE - Virtual-Cascades Status</TITLE>\n    <STYLE TYPE=\"text/css\">\n      <!--\n        h1 {color:blue; text-align:center;}\n        b,h3,h4,h5 {font-weight:bold; color:maroon;}\n        body {margin-top:0px; margin-left:0px; margin-width:0px; margin-height:0px; background-color:white; color:black;}\n        h1,h2,h3,h4,h5,p,address,ol,ul,tr,td,th,blockquote,body,.smalltext,.leftcol {font-family:geneva,arial,helvetica,sans-serif;}\n        p,address,ol,ul,tr,td,th,blockquote {font-size:11pt;}\n        .leftcol,.smalltext {font-size: 10px;}\n        h1 {font-size:17px;}\n        h2 {font-size:16px;}\n        h3 {font-size:15px;}\n        h4 {font-size:14px;}\n        h5 {font-size:13px;}\n        address {font-style:normal;}\n        hr {color:#cccccc;}\n        h2,.leftcol {font-weight:bold; color:#006699;}\n        a:link {color:#006699; font-weight:bold; text-decoration:none;}\n        a:visited {color:#666666; font-weight:bold; text-decoration:none;}\n        a:active {color:#006699; font-weight:bold; text-decoration:none;}\n        a:hover {color:#006699; font-weight:bold; text-decoration:underline;}\n        th {color:white; background:#006699; font-weight:bold; text-align:left;}\n        td.name {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699; background:#eeeeff;}\n        td.status {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699;}\n      -->\n    </STYLE>\n    <META HTTP-EQUIV=\"refresh\" CONTENT=\"10\">\n  </HEAD>\n  <BODY BGCOLOR=\"#FFFFFF\">\n    <P ALIGN=\"right\">" + new Date().toString() + "</P>\n    <H2>INFOSERVICE - Virtual-Cascades Status</H2><BR><BR>\n<h3>Real cascades</h3>";
            htmlData = htmlData + realCascades;
            htmlData = htmlData + "<br/><h3>Virtual cascades</h3>";
            htmlData = htmlData + virtualCascades;
            htmlData = htmlData + "<h3>Unused mixes</h3>";
            htmlData = htmlData + "    <TABLE ALIGN=\"center\" BORDER=\"0\" width=\"100%\">\n";
            htmlData = htmlData + "      <COLGROUP>\n";
            htmlData = htmlData + "        <COL>\n";
            htmlData = htmlData + "        <COL>\n";
            htmlData = htmlData + "        <COL>\n";
            htmlData = htmlData + "        <COL>\n";
            htmlData = htmlData + "        </COLGROUP>\n";
            htmlData = htmlData + "      <TR>\n";
            htmlData = htmlData + "        <TH>Mix Id</TH>\n";
            htmlData = htmlData + "        <TH>Mix Host</TH>\n";
            htmlData = htmlData + "        <TH>Mix Port</TH>\n";
            htmlData = htmlData + "        <TH>Mix Type</TH>\n";
            htmlData = htmlData + "      </TR>\n";
            Vector unusedMixes = this.getUnusedMixex();
            Enumeration mixes = unusedMixes.elements();
            while (mixes.hasMoreElements()) {
                MixInfo mixInfo2 = (MixInfo)mixes.nextElement();
                htmlData = htmlData + "<TR>\n";
                htmlData = htmlData + "<TD>" + mixInfo2.getId() + "</TD>\n";
                htmlData = htmlData + "<TD>" + mixInfo2.getFirstHostName() + "</TD>\n";
                htmlData = htmlData + "<TD>" + mixInfo2.getFirstPort() + "</TD>\n";
                htmlData = htmlData + "<TD>" + mixInfo2.getTypeAsString() + "</TD>\n";
                htmlData = htmlData + "</TR>\n";
            }
            htmlData = htmlData + "    </TABLE><BR><BR><BR><BR>\n";
            htmlData = htmlData + "    <P>Infoservice [" + "IS.09.010" + "] Startup Time: " + Configuration.getInstance().getStartupTime() + "</P>\n    <HR noShade SIZE=\"1\">\n    <ADDRESS>&copy; 2000 - 2006 The JAP Team</ADDRESS>\n  </BODY>\n</HTML>\n";
            httpResponse = new HttpResponseStructure(1, 0, htmlData);
        }
        catch (Exception e) {
            String htmlData = "<HTML>\n  <HEAD>\n    <TITLE>INFOSERVICE - Virtual-Cascades Status</TITLE>\n    <STYLE TYPE=\"text/css\">\n      <!--\n        h1 {color:blue; text-align:center;}\n        b,h3,h4,h5 {font-weight:bold; color:maroon;}\n        body {margin-top:0px; margin-left:0px; margin-width:0px; margin-height:0px; background-color:white; color:black;}\n        h1,h2,h3,h4,h5,p,address,ol,ul,tr,td,th,blockquote,body,.smalltext,.leftcol {font-family:geneva,arial,helvetica,sans-serif;}\n        p,address,ol,ul,tr,td,th,blockquote {font-size:11pt;}\n        .leftcol,.smalltext {font-size: 10px;}\n        h1 {font-size:17px;}\n        h2 {font-size:16px;}\n        h3 {font-size:15px;}\n        h4 {font-size:14px;}\n        h5 {font-size:13px;}\n        address {font-style:normal;}\n        hr {color:#cccccc;}\n        h2,.leftcol {font-weight:bold; color:#006699;}\n        a:link {color:#006699; font-weight:bold; text-decoration:none;}\n        a:visited {color:#666666; font-weight:bold; text-decoration:none;}\n        a:active {color:#006699; font-weight:bold; text-decoration:none;}\n        a:hover {color:#006699; font-weight:bold; text-decoration:underline;}\n        th {color:white; background:#006699; font-weight:bold; text-align:left;}\n        td.name {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699; background:#eeeeff;}\n        td.status {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699;}\n      -->\n    </STYLE>\n    <META HTTP-EQUIV=\"refresh\" CONTENT=\"10\">\n  </HEAD>\n  <BODY BGCOLOR=\"#FFFFFF\">\n    <P ALIGN=\"right\"><h3>Updating status, please wait...</h3></p><br/> <P>Infoservice [IS.09.010] Startup Time: " + Configuration.getInstance().getStartupTime() + "</P>\n    <HR noShade SIZE=\"1\">\n    <ADDRESS>&copy; 2000 - 2006 The JAP Team</ADDRESS>\n  </BODY>\n</HTML>\n";
            httpResponse = new HttpResponseStructure(1, 0, htmlData);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private Vector getUnusedMixex() {
        Vector<AbstractDatabaseEntry> result = new Vector<AbstractDatabaseEntry>();
        Enumeration enumer2 = Database.getInstance(VirtualCascade.class).getEntrySnapshotAsEnumeration();
        MixCascade mixCascade2 = null;
        while (enumer2.hasMoreElements()) {
            mixCascade2 = ((VirtualCascade)enumer2.nextElement()).getRealCascade();
            if (mixCascade2.getNumberOfMixes() != 1) continue;
            Enumeration enumMixID2 = mixCascade2.getMixIds().elements();
            String mixId = "";
            if (!enumMixID2.hasMoreElements()) continue;
            mixId = (String)enumMixID2.nextElement();
            result.add(Database.getInstance(MixInfo.class).getEntryById(mixId));
        }
        Enumeration en = Database.getInstance(MixInfo.class).getEntrySnapshotAsEnumeration();
        while (en.hasMoreElements()) {
            MixInfo mix = (MixInfo)en.nextElement();
            if (!mix.isDynamic() || this.getTemporaryCascade(mix.getId()) != null || this.getCurrentCascade(mix.getId()) != null) continue;
            result.add(mix);
        }
        return result;
    }

    private String getCascadeHtmlTable(Class a_clazz) throws Exception {
        String htmlData = "    <TABLE ALIGN=\"center\" BORDER=\"0\" width=\"100%\">\n      <COLGROUP>\n        <COL>\n        <COL>\n        <COL>\n        <COL>\n        <COL>\n        </COLGROUP>\n      <TR>\n        <TH>Cascade ID&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TH>\n        <TH>Mix Host</TH>\n        <TH>Mix Port</TH>\n        <TH>Mix Type</TH>\n        <TH>Mix Id</TH>\n      </TR>\n";
        Enumeration enumer = Database.getInstance(a_clazz).getEntrySnapshotAsEnumeration();
        MixCascade mixCascade = null;
        while (enumer.hasMoreElements()) {
            mixCascade = a_clazz.equals(VirtualCascade.class) ? ((VirtualCascade)enumer.nextElement()).getRealCascade() : (MixCascade)enumer.nextElement();
            if (mixCascade.getNumberOfMixes() == 1) continue;
            Enumeration enumMixID = mixCascade.getMixIds().elements();
            String mixId = "";
            if (enumMixID.hasMoreElements()) {
                mixId = (String)enumMixID.nextElement();
            }
            MixInfo mixInfo = (MixInfo)Database.getInstance(MixInfo.class).getEntryById(mixId);
            htmlData = htmlData + "<TR>\n";
            htmlData = htmlData + "<TD>" + mixCascade.getId() + "</TD>\n";
            htmlData = htmlData + "<TD>" + mixInfo.getFirstHostName() + "</TD>\n";
            htmlData = htmlData + "<TD>" + mixInfo.getFirstPort() + "</TD>\n";
            htmlData = htmlData + "<TD>" + mixInfo.getTypeAsString() + "</TD>\n";
            htmlData = htmlData + "<TD>" + mixInfo.getId() + "</TD>\n";
            htmlData = htmlData + "</TR>\n";
            for (int i = 1; i < mixCascade.getNumberOfMixes() && enumMixID.hasMoreElements(); ++i) {
                mixId = (String)enumMixID.nextElement();
                mixInfo = (MixInfo)Database.getInstance(MixInfo.class).getEntryById(mixId);
                htmlData = htmlData + "<TR>\n";
                htmlData = htmlData + "<TD></TD>\n";
                htmlData = htmlData + "<TD>" + mixInfo.getFirstHostName() + "</TD>\n";
                htmlData = htmlData + "<TD>" + mixInfo.getFirstPort() + "</TD>\n";
                htmlData = htmlData + "<TD>" + mixInfo.getTypeAsString() + "</TD>\n";
                htmlData = htmlData + "<TD>" + mixInfo.getId() + "</TD>\n";
                htmlData = htmlData + "</TR>\n";
            }
            htmlData = htmlData + "<TR>\n";
            htmlData = htmlData + "<TD colspann=\"6\">&nbsp;</TD>\n";
            htmlData = htmlData + "</TR>\n";
        }
        htmlData = htmlData + "    </TABLE><BR><BR>\n";
        return htmlData;
    }
}

